/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfsc.api.busi.BusiCancelBillApplyInfoService;
import com.tydic.pfsc.api.busi.bo.BusiCancelBillApplyInfoReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.OrderInfoCancelHisMapper;
import com.tydic.pfsc.dao.SaleItemApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.OrderInfoCancelHisPO;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.BillApplyInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemApplyInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleItemApplyInfoStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiCancelBillApplyInfoService"})
public class BusiCancelBillApplyInfoServiceImpl
implements BusiCancelBillApplyInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiCancelBillApplyInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelBillApplyInfoServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private OrderInfoCancelHisMapper orderInfoCancelHisMapper;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"update"})
    public PfscExtRspBaseBO update(@RequestBody BusiCancelBillApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List applyNoList = reqBO.getApplyNoList();
        if (applyNoList == null || applyNoList.isEmpty()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u7533\u8bf7\u5355\u53f7\u3010applyNoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        ArrayList<String> billStatusNotIn = new ArrayList<String>();
        billStatusNotIn.add(BillStatus.NO_APPLY.getCode());
        billStatusNotIn.add(BillStatus.REJECTION_APPLY.getCode());
        billApplyInfoVO.setBillStatusNotIn(billStatusNotIn);
        int count = this.billApplyInfoMapper.selectCount(billApplyInfoVO);
        if (count > 0) {
            log.debug("\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u670d\u52a1--\u5f00\u7968\u7533\u8bf7\u5355\u7684\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f 00-\u5df2\u63d0\u4ea4 or 98-\u5df2\u9a73\u56de");
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u7684\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f [" + BillStatus.NO_APPLY.getDescr() + "] \u6216 [" + BillStatus.REJECTION_APPLY.getDescr() + "]");
        }
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        HashSet<String> billStatusSet = new HashSet<String>();
        billStatusSet.add(BillStatus.NO_APPLY.getCode());
        billStatusSet.add(BillStatus.REJECTION_APPLY.getCode());
        billApplyInfoVO.setBillStatusSet(billStatusSet);
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setBillStatus(BillStatus.CANCEL_APPLY.getCode());
        try {
            this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PfscExtBusinessException("18000", "\u5931\u8d25");
        }
        ArrayList<String> oldApplyNoList = new ArrayList<String>();
        ArrayList<String> newApplyNoList = new ArrayList<String>();
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getList(billApplyInfoVO);
        if (billApplyInfoList != null) {
            for (BillApplyInfo billApplyBO : billApplyInfoList) {
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyBO.getApplyType())) {
                    newApplyNoList.add(billApplyBO.getApplyNo());
                    continue;
                }
                oldApplyNoList.add(billApplyBO.getApplyNo());
            }
        }
        try {
            if (!CollectionUtils.isEmpty(oldApplyNoList)) {
                this.insertIntoOrderInfoCancelHis(oldApplyNoList);
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setApplyNoList(oldApplyNoList);
                saleOrderInfoVO.setOrderStatus(OrderStatus.APPLIED.getCode());
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setApplyNo(null);
                saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.saleOrderInfoMapper.cancelBillApplyInfo(saleOrderInfoVO, saleOrderInfo);
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNoList(oldApplyNoList);
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setApplyNo(null);
                saleItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
                this.saleItemInfoMapper.cancelBillApplyInfo(saleItemInfoVO, saleItemInfo);
            }
            if (!CollectionUtils.isEmpty(newApplyNoList)) {
                SaleItemApplyInfoVO updateInfoVO = new SaleItemApplyInfoVO();
                updateInfoVO.setStatus(SaleItemApplyInfoStatus.INVALID.getCode());
                updateInfoVO.setOldStatus(SaleItemApplyInfoStatus.VALID.getCode());
                updateInfoVO.setApplyNoList(newApplyNoList);
                this.saleItemApplyInfoMapper.updateByVO(updateInfoVO);
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNoList(newApplyNoList);
                saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
                this.saleItemInfoMapper.updateByItemApplyInfo(saleItemInfoVO);
                SaleOrderInfoVO updateOrderBO = new SaleOrderInfoVO();
                updateOrderBO.setApplyNoList(newApplyNoList);
                updateOrderBO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.saleOrderInfoMapper.updateOrderStatusByCondition(updateOrderBO);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PfscExtBusinessException("18000", "\u5931\u8d25");
        }
        return new PfscExtRspBaseBO();
    }

    private void insertIntoOrderInfoCancelHis(List<String> applyNoList) {
        List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getListByApplyInfo(applyNoList);
        log.debug("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(saleOrderInfos));
        if (saleOrderInfos != null && saleOrderInfos.size() > 0) {
            for (SaleOrderInfo soi : saleOrderInfos) {
                OrderInfoCancelHisPO orderInfoCancelHisPO = new OrderInfoCancelHisPO();
                orderInfoCancelHisPO.setOrderId(soi.getOrderId());
                orderInfoCancelHisPO.setInspectionId(soi.getInspectionId());
                orderInfoCancelHisPO.setApplyNo(soi.getApplyNo());
                orderInfoCancelHisPO.setCreateTime(new Date());
                this.orderInfoCancelHisMapper.insert(orderInfoCancelHisPO);
                Long seq = orderInfoCancelHisPO.getSeq();
                if (seq == null || seq <= 0L) continue;
                log.debug("\u7533\u8bf7\u5355\u4e0e\u8ba2\u5355\u5173\u7cfb\u6301\u4e45\u5316\u8bb0\u5f55\u6210\u529f.{}", applyNoList);
            }
        }
    }
}

