/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfsc.aop.annotation.FscDuplicateCommitLimit;
import com.tydic.pfsc.api.busi.BusiCancelNotificationService;
import com.tydic.pfsc.api.busi.bo.BusiCancelNotificationReqBO;
import com.tydic.pfsc.api.busi.bo.BusiCancelNotificationRspBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.OrderInfoCancelHisMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoHisMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.OrderInfoCancelHisPO;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.po.PayInvoiceInfoHisPO;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.api.BusiGetInvoiceDataService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiCancelNotificationService"})
public class BusiCancelNotificationServiceImpl
implements BusiCancelNotificationService {
    private static final Logger log = LoggerFactory.getLogger(BusiCancelNotificationServiceImpl.class);
    private PayItemInfoMapper payItemInfoMapper;
    private BillNotificationInfoMapper billNotificationInfoMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceInfoHisMapper payInvoiceInfoHisMapper;
    @Autowired
    private OrderInfoCancelHisMapper orderInfoCancelHisMapper;

    @Autowired
    public BusiCancelNotificationServiceImpl(PayItemInfoMapper payItemInfoMapper, BillNotificationInfoMapper billNotificationInfoMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, BusiGetInvoiceDataService apiGetInvoiceDataService, PayInvoiceInfoMapper payInvoiceInfoMapper) {
        this.payItemInfoMapper = payItemInfoMapper;
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.apiGetInvoiceDataService = apiGetInvoiceDataService;
        this.payInvoiceInfoMapper = payInvoiceInfoMapper;
    }

    @FscDuplicateCommitLimit(toast="\u8bf7\u5237\u65b0\u9875\u9762\uff0c\u4e0d\u8981\u91cd\u590d\u53d6\u6d88\u5f00\u7968")
    @PostMapping(value={"cancelNotification"})
    public BusiCancelNotificationRspBO cancelNotification(@RequestBody BusiCancelNotificationReqBO reqBO) {
        List<PayInvoiceInfo> payInvoiceInfoList;
        log.info("\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        String notificationNo = reqBO.getNotificationNo();
        Long companyId = reqBO.getCompanyId();
        if (!StringUtils.hasText((String)notificationNo)) {
            log.debug("\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u5fc5\u987b\u8f93\u5165:{}", (Object)notificationNo);
            throw new PfscExtBusinessException("0001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u5fc5\u987b\u8f93\u5165");
        }
        if (null == reqBO.getConfirmFlag()) {
            log.debug("\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u786e\u8ba4\u6807\u8bc6[confirmFlag]\u5fc5\u987b\u8f93\u5165:{}", (Object)reqBO.getConfirmFlag());
            throw new PfscExtBusinessException("0001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u786e\u8ba4\u6807\u8bc6[confirmFlag]\u5fc5\u987b\u8f93\u5165");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryAndCompany(notificationNo, companyId);
        if (null == bill) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        }
        String source = bill.getSource();
        if (NotificationInvoiceStatus.HAS_CANCEL.getCode().equals(bill.getInvoiceStatus())) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355[" + notificationNo + "]\u5df2\u53d6\u6d88\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\uff0c\u91cd\u65b0\u751f\u6210\u901a\u77e5\u5355\uff01");
        }
        if (NotificationInvoiceStatus.SUBMITED_FAIL.getCode().equals(bill.getInvoiceStatus())) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355[" + notificationNo + "]\u5df2\u9a73\u56de\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\uff0c\u66f4\u65b0\u53d1\u7968\u4fe1\u606f\uff01");
        }
        if (NotificationInvoiceStatus.RECEIVED.getCode().equals(bill.getInvoiceStatus())) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355[" + notificationNo + "]\u5df2\u7b7e\u6536\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u67e5\u770b");
        }
        if (NotificationInvoiceStatus.RECEIVED.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.RETURN_BACK.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.HAS_CANCEL.getCode().equals(bill.getInvoiceStatus())) {
            throw new PfscExtBusinessException("0001", "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        BusiCancelNotificationRspBO rsp = new BusiCancelNotificationRspBO();
        if (NotificationInvoiceStatus.SUBMITED.getCode().equals(bill.getInvoiceStatus())) {
            BillNotificationInfo updBill = new BillNotificationInfo();
            updBill.setNotificationNo(notificationNo);
            updBill.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
            int update = this.billNotificationInfoMapper.updateByPrimaryKeySelective(updBill);
            if (update < 1) {
                throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
            List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
            for (PayPurchaseOrderInfo singleOrder : orders) {
                this.insertIntoOrderInfoCancelHis(singleOrder);
                int update1 = this.payPurchaseOrderInfoMapper.updateByReset(singleOrder);
                if (update1 < 1) {
                    throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
                }
                PayItemInfo item = new PayItemInfo();
                item.setOrderId(singleOrder.getOrderId());
                item.setInspectionId(singleOrder.getInspectionId());
                int update2 = this.payItemInfoMapper.updateByReset(item);
                if (update2 >= 1) continue;
                throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
        }
        if ((payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo)) != null && payInvoiceInfoList.size() > 0) {
            for (PayInvoiceInfo pii : payInvoiceInfoList) {
                PayInvoiceInfoHisPO payInvoiceInfoHisPO = new PayInvoiceInfoHisPO();
                BeanUtils.copyProperties((Object)pii, (Object)payInvoiceInfoHisPO);
                this.payInvoiceInfoHisMapper.insert(payInvoiceInfoHisPO);
                this.payInvoiceInfoMapper.deleteByPrimaryKey(pii.getInvoiceCode(), pii.getInvoiceNo(), pii.getInvoiceDate());
            }
        }
        if (NotificationInvoiceStatus.HAS_CANCEL.getCode().equals(bill.getInvoiceStatus())) {
            log.debug("\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u901a\u77e5\u5355\u72b6\u6001\u4e3a\u5df2\u53d6\u6d88-billJson\uff1a{}", (Object)JSON.toJSONString((Object)bill));
            throw new PfscExtBusinessException("0001", "\u8be5\u901a\u77e5\u5355\u5df2\u88ab\u53d6\u6d88\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u6210\u529f");
        return rsp;
    }

    private void insertIntoOrderInfoCancelHis(PayPurchaseOrderInfo singleOrder) {
        OrderInfoCancelHisPO orderInfoCancelHisPO = new OrderInfoCancelHisPO();
        orderInfoCancelHisPO.setOrderId(singleOrder.getOrderId());
        orderInfoCancelHisPO.setInspectionId(singleOrder.getInspectionId());
        orderInfoCancelHisPO.setCreateTime(new Date());
        orderInfoCancelHisPO.setNotificationNo(singleOrder.getNotificationNo());
        this.orderInfoCancelHisMapper.insert(orderInfoCancelHisPO);
        if (orderInfoCancelHisPO.getSeq() == null) {
            log.debug("\u901a\u77e5\u5355\u4e0e\u8ba2\u5355\u5173\u7cfb\u6301\u4e45\u5316\u8bb0\u5f55\uff1a\u901a\u77e5\u5355[{}]\u7f13\u5b58\u5931\u8d25", (Object)singleOrder.getNotificationNo());
        }
    }
}

