/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfsc.api.busi.BusiPushSaleOrderInfoOnlyPushService;
import com.tydic.pfsc.api.busi.bo.BusiPushSaleOrderInfoItemReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPushSaleOrderInfoOrderReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPushSaleOrderInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPushSaleOrderInfoReqBOSelectRspBO;
import com.tydic.pfsc.api.busi.bo.DeptBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.DicDictionaryMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.ReceivableBillUpMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.bo.DicDictionaryPO;
import com.tydic.pfsc.dao.po.ReceivableBillUpPO;
import com.tydic.pfsc.dao.po.ReceivableBillUpPOKey;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleOrderPayType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.nc.api.NcReceivableBillUpService;
import com.tydic.pfsc.external.nc.api.bo.NcReceivableBillUpRecBillBO;
import com.tydic.pfsc.external.nc.api.bo.NcReceivableBillUpRecItemBO;
import com.tydic.pfsc.external.nc.api.bo.NcReceivableBillUpReqBO;
import com.tydic.pfsc.external.nc.api.bo.NcReceivableBillUpRspBO;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.MidDataPool;
import com.tydic.umcext.ability.org.UmcYdEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgQueryAbilityReqBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiPushSaleOrderInfoOnlyPushService"})
public class BusiPushSaleOrderInfoOlnyPushServiceImpl
implements BusiPushSaleOrderInfoOnlyPushService {
    private static final Logger log = LoggerFactory.getLogger(BusiPushSaleOrderInfoOlnyPushServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiPushSaleOrderInfoOlnyPushServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private UmcYdEnterpriseOrgQueryAbilityService umcYdEnterpriseOrgQueryAbilityService;
    @Autowired
    private NcReceivableBillUpService ncReceivableBillUpService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;
    @Autowired
    private ReceivableBillUpMapper receivableBillUpMapper;

    @PostMapping(value={"getBusiPushSaleOrderInfoReqBOByInspectionId"})
    public BusiPushSaleOrderInfoReqBOSelectRspBO getBusiPushSaleOrderInfoReqBOByInspectionId(@RequestBody Long inspectionId) {
        if (inspectionId == null || 0L == inspectionId) {
            throw new PfscExtBusinessException("0001", "id\u4e3a\u7a7a:{}" + inspectionId);
        }
        BusiPushSaleOrderInfoReqBOSelectRspBO busiPushSaleOrderInfoReqBO = new BusiPushSaleOrderInfoReqBOSelectRspBO();
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.selectByInspectionId(inspectionId);
        List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.selectByInspectionId(inspectionId);
        SaleOrderInfo saleOrderInfo = null;
        if (saleOrderInfoList.size() > 0) {
            saleOrderInfo = saleOrderInfoList.get(0);
            busiPushSaleOrderInfoReqBO.setOrderInfo((BusiPushSaleOrderInfoOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)saleOrderInfo), BusiPushSaleOrderInfoOrderReqBO.class));
            List busiPushSaleOrderInfoItemReqBOS = new ArrayList();
            if (saleItemInfoList.size() > 0) {
                String jsonString = JSON.toJSONString(saleItemInfoList);
                busiPushSaleOrderInfoItemReqBOS = JSON.parseArray((String)jsonString, BusiPushSaleOrderInfoItemReqBO.class);
            }
            busiPushSaleOrderInfoReqBO.setItemList(busiPushSaleOrderInfoItemReqBOS);
        }
        return busiPushSaleOrderInfoReqBO;
    }

    @PostMapping(value={"add"})
    public PfscExtRspBaseBO add(@RequestBody BusiPushSaleOrderInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiPushSaleOrderInfoOrderReqBO orderInfo = reqBO.getOrderInfo();
        if (orderInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = orderInfo.getOrderId();
        Long inspectionId = orderInfo.getInspectionId();
        Long purchaseOrderId = orderInfo.getPurchaseOrderId();
        if (orderId == null || orderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inspectionId == null || inspectionId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseOrderId == null || purchaseOrderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList itemList = reqBO.getItemList();
        if (itemList == null || itemList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u5546\u54c1\u4fe1\u606f\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, BusiPushSaleOrderInfoItemReqBO> itemMap = new HashMap<Long, BusiPushSaleOrderInfoItemReqBO>(itemList.size() + 1);
        for (BusiPushSaleOrderInfoItemReqBO itemInfo : itemList) {
            if (!itemMap.containsKey(itemInfo.getItemNo())) {
                itemMap.put(itemInfo.getItemNo(), itemInfo);
                continue;
            }
            BusiPushSaleOrderInfoItemReqBO itemInMap = (BusiPushSaleOrderInfoItemReqBO)itemMap.get(itemInfo.getItemNo());
            itemInMap.setQuantity(itemInMap.getQuantity().add(itemInfo.getQuantity()));
            itemInMap.setAmount(itemInMap.getAmount().add(itemInfo.getAmount()));
        }
        itemList = new ArrayList(itemMap.values());
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setInspectionId(inspectionId);
        saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        BigDecimal orderAmt = saleOrderInfo.getOrderAmt();
        if (orderAmt == null || orderAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a0");
        }
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setInspectionId(inspectionId);
        ArrayList<String> itemStatusNotIn = new ArrayList<String>();
        itemStatusNotIn.add(OrderStatus.NO_APPLY.getCode());
        saleItemInfoVO.setItemStatusNotIn(itemStatusNotIn);
        int count = this.saleItemInfoMapper.selectCount(saleItemInfoVO);
        if (saleOrderInfo != null) {
            if (count > 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002");
                throw new PfscExtBusinessException("18000", "\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002");
            }
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setInspectionId(inspectionId);
            saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionId(inspectionId);
        }
        String source = orderInfo.getSource();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setOrderId(orderId);
            saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
            if (saleOrderInfo != null) {
                saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setOrderId(orderId);
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setOrderId(orderId);
            }
        }
        saleOrderInfo = new SaleOrderInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)saleOrderInfo);
        String orgName = this.organizationInfoService.queryOrgName(saleOrderInfo.getPurchaseNo());
        saleOrderInfo.setPurchaseName(orgName);
        orgName = this.organizationInfoService.queryOrgName(saleOrderInfo.getOperUnitNo());
        saleOrderInfo.setOperUnitName(orgName);
        saleOrderInfo.setApplyNo(null);
        saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            Object branchCompany = this.organizationInfoService.queryBranchCompanyByAccountId(saleOrderInfo.getPurchaseProjectId());
            saleOrderInfo.setBranchCompany((Long)branchCompany);
        }
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            saleOrderInfo.setIsPayFlag("0");
        } else {
            saleOrderInfo.setIsPayFlag("2");
        }
        if (null != saleOrderInfo.getPayType()) {
            switch (saleOrderInfo.getPayType()) {
                case "0": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BANK_RECEIVE.getCode());
                    break;
                }
                case "1": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BILL_AGREEMENT.getCode());
                    break;
                }
                case "2": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BILL_RECEIVE.getCode());
                }
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3010payType\u3011");
        }
        ArrayList<SaleItemInfo> saleItemInfoList = new ArrayList<SaleItemInfo>();
        for (BusiPushSaleOrderInfoItemReqBO itemInfo : itemList) {
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            BeanUtils.copyProperties((Object)itemInfo, (Object)saleItemInfo);
            saleItemInfo.setOrderId(orderId);
            saleItemInfo.setSaleOrderCode(saleOrderInfo.getSaleOrderCode());
            saleItemInfo.setInspectionId(inspectionId);
            saleItemInfo.setPurchaseOrderId(purchaseOrderId);
            saleItemInfo.setApplyNo(null);
            saleItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
            if (!StringUtils.hasText((String)saleItemInfo.getUnitName())) {
                saleItemInfo.setUnitName("\u4e2a");
            }
            if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source)) {
                saleItemInfo.setAmount(itemInfo.getSaleUnitPrice().multiply(itemInfo.getQuantity()));
                saleItemInfo.setUntaxAmt(saleItemInfo.getAmount().divide(BigDecimal.ONE.add(itemInfo.getTaxRate()), 6, 4));
                saleItemInfo.setTaxAmt(saleItemInfo.getAmount().subtract(saleItemInfo.getUntaxAmt()));
            }
            if (StringUtils.hasText((String)saleItemInfo.getSkuName()) && saleItemInfo.getSkuName().length() > 100) {
                saleItemInfo.setSkuName(saleItemInfo.getSkuName().substring(0, 100));
            }
            if (saleItemInfo.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (StringUtils.hasText((String)itemInfo.getTaxId())) {
                try {
                    saleItemInfo.setTaxCatCode(Long.parseLong(itemInfo.getTaxId()));
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25,\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a:" + itemInfo.getTaxId());
                }
            }
            if (null == saleItemInfo.getTaxRate()) {
                saleItemInfo.setTaxRate(this.enumsService.queryDefaultTaxRate());
            }
            if (null != saleItemInfo.getSettleRate() && saleItemInfo.getSettleRate().intValue() == 0) {
                saleItemInfo.setSettleRate(null);
            }
            if (null != saleItemInfo.getSettleRate()) {
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                    saleItemInfo.setQuantitySale(itemInfo.getQuantity());
                    BigDecimal quantity = itemInfo.getQuantity().multiply(itemInfo.getSettleRate()).setScale(6, 4);
                    saleItemInfo.setQuantity(quantity);
                    saleItemInfo.setSaleUnitPriceSale(itemInfo.getSaleUnitPrice());
                    saleItemInfo.setSaleUnitPrice(itemInfo.getAmount().divide(quantity, 2, 4));
                    saleItemInfo.setUnitNameSale(itemInfo.getUnitName());
                    if (!StringUtils.hasText((String)saleItemInfo.getUnitNameSale())) {
                        saleItemInfo.setUnitNameSale("\u4e2a");
                    }
                    saleItemInfo.setUnitName(itemInfo.getSettleUnit());
                    if (!StringUtils.hasText((String)saleItemInfo.getUnitName())) {
                        saleItemInfo.setUnitName("\u4e2a");
                    }
                } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                    // empty if block
                }
            }
            saleItemInfoList.add(saleItemInfo);
        }
        if (saleItemInfoList.isEmpty()) {
            logger.error("\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
        }
        try {
            this.receivableBillUp(saleOrderInfo, saleItemInfoList);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5e94\u6536\u5355\u62a5\u9519");
        }
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void receivableBillUp(SaleOrderInfo saleOrderInfo, List<SaleItemInfo> saleItemInfoList) {
        String saleOrderInfoJson = JSONArray.toJSON((Object)saleOrderInfo).toString();
        log.error("saleOrderInfoJson==" + saleOrderInfoJson);
        String saleItemInfoListJson = JSONArray.toJSON(saleItemInfoList).toString();
        log.error("saleItemInfoListJson==" + saleItemInfoListJson);
        NcReceivableBillUpReqBO ncReceivableBillUpReqBO = new NcReceivableBillUpReqBO();
        NcReceivableBillUpRecBillBO ncReceivableBillUpRecBillBO = new NcReceivableBillUpRecBillBO();
        ArrayList<NcReceivableBillUpRecItemBO> ncReceivableBillUpRecItemBOS = new ArrayList<NcReceivableBillUpRecItemBO>();
        String pk_deptid = null;
        String saleCompanyCode = "";
        String saleCompanyId = String.valueOf(saleOrderInfo.getSaleCompanyId());
        UmcYdEnterpriseOrgQueryAbilityReqBO umcYdEnterpriseOrgQueryAbilityReqBO = new UmcYdEnterpriseOrgQueryAbilityReqBO();
        umcYdEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(saleOrderInfo.getPurchaseNo());
        log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u5165\u53c2" + umcYdEnterpriseOrgQueryAbilityReqBO);
        UmcYdEnterpriseOrgDetailAbilityRspBO umcYdEnterpriseOrgDetailAbilityRspBO = this.umcYdEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcYdEnterpriseOrgQueryAbilityReqBO);
        log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2" + umcYdEnterpriseOrgDetailAbilityRspBO);
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode("ATOUR_COMPANY_INFO");
        dicDictionaryPO.setCode(saleCompanyId);
        DicDictionaryPO dicDictionaryPOResult = this.dicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (null != dicDictionaryPOResult) {
            saleCompanyCode = dicDictionaryPOResult.getTitle();
        }
        log.error("\u8c03\u7528nc\u89c6\u56fe\u5f00\u59cb======================");
        log.error("\u7532\u65b9\u62ac\u5934\u7f16\u7801saleCompanyCode==" + saleCompanyCode);
        List saleCompanyIdList = MidDataPool.getJdbcTemplatePre().query("select orgcode,orgname,deptcode,deptname from v_b2b_dept where orgcode ='" + saleCompanyCode + "';", (RowMapper)new BeanPropertyRowMapper(DeptBO.class));
        if (saleCompanyIdList != null && saleCompanyIdList.size() > 0) {
            log.error("saleCompanyIdList.size" + saleCompanyIdList.size());
            for (DeptBO dbo : saleCompanyIdList) {
                if (!dbo.getDeptcode().equals(dicDictionaryPOResult.getDescrip())) continue;
                pk_deptid = dbo.getDeptcode();
            }
        }
        log.error("\u8c03\u7528nc\u89c6\u56fe\u7ed3\u675f======================");
        log.debug("--\u5ba2\u6237\u7f16\u7801\uff0c\u4f20\u9012\u524d\uff0c\u786e\u8ba4\u5728PMS\u548cNC\u89c6\u56fe\u4e2d------------2021-04-06-NC\u89c6\u56fe\u4e0ePMS\u89c6\u56fe\u5bf9\u6bd4----\u5f00\u59cb---");
        boolean isInNC = true;
        if (umcYdEnterpriseOrgDetailAbilityRspBO == null || umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            log.debug("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7purchaseNo={}\u67e5PMS\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8be6\u60c5\u89c1\u4e0a\u4e00\u4e2alog\uff1a\u300a\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2JSON\u300b");
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4dpurchaseNo=" + saleOrderInfo.getPurchaseNo() + "\u672a\u5728PMS\u4e2d\u67e5\u8be2\u5230");
        }
        UmcYdEnterpriseOrgAbilityBO umcEnterpriseOrgAbilityBO = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO();
        if (!StringUtils.hasText((String)umcEnterpriseOrgAbilityBO.getOrgCode())) {
            log.debug("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7purchaseNo={}\u67e5PMS\uff0c\u8fd4\u56de\u7ed3\u679c\u4e2dorgCode\u4e3a\u7a7a\u3002orgCode={}", (Object)umcEnterpriseOrgAbilityBO.getOrgCode());
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4dpurchaseNo=" + saleOrderInfo.getPurchaseNo() + "\u5728PMS\u4e2d\u67e5\u8be2\u7ed3\u679c\u4e2d\uff0ccode\u6ca1\u6709\u503c\u3002OrgCode=" + umcEnterpriseOrgAbilityBO.getOrgCode());
        }
        String pmsOrgCode = umcEnterpriseOrgAbilityBO.getOrgCode();
        String replaceCode = pmsOrgCode.replace("PMS-", "");
        List ncOrgCodeList = MidDataPool.getJdbcTemplatePre().query("select orgcode,orgname,deptcode,deptname from v_b2b_dept where orgcode ='" + replaceCode + "';", (RowMapper)new BeanPropertyRowMapper(DeptBO.class));
        if (CollectionUtils.isEmpty((Collection)ncOrgCodeList)) {
            log.debug("PMS\u5b58\u5728\uff0c\u4f46NC\u4e0d\u5b58\u5728\u3002orgCode={}", (Object)umcEnterpriseOrgAbilityBO.getOrgCode());
            isInNC = false;
        } else {
            log.debug("NC \u67e5\u8be2\u7ed3\u679cJSON\uff1a{}", (Object)JSON.toJSONString((Object)ncOrgCodeList));
        }
        log.debug("--\u5ba2\u6237\u7f16\u7801\uff0c\u4f20\u9012\u524d\uff0c\u786e\u8ba4\u5728PMS\u548cNC\u89c6\u56fe\u4e2d------------2021-04-06-NC\u89c6\u56fe\u4e0ePMS\u89c6\u56fe\u5bf9\u6bd4--end-----");
        String orgTypeNC = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTypeNc();
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateNowStr = sdf.format(d);
        ncReceivableBillUpRecBillBO.setBilldate(dateNowStr);
        ncReceivableBillUpRecBillBO.setBillmaker("B2B");
        ncReceivableBillUpRecBillBO.setCreator("B2B");
        ncReceivableBillUpRecBillBO.setIsflowbill("N");
        ncReceivableBillUpRecBillBO.setIsinit("N");
        ncReceivableBillUpRecBillBO.setIsreded("N");
        ncReceivableBillUpRecBillBO.setLocal_money(saleOrderInfo.getOrderAmt());
        ncReceivableBillUpRecBillBO.setMoney(saleOrderInfo.getOrderAmt());
        ncReceivableBillUpRecBillBO.setObjtype(0);
        ncReceivableBillUpRecBillBO.setSrc_syscode(0);
        ncReceivableBillUpRecBillBO.setSyscode(0);
        ncReceivableBillUpRecBillBO.setPk_currtype("CNY");
        ncReceivableBillUpRecBillBO.setPk_deptid(pk_deptid);
        ncReceivableBillUpRecBillBO.setPk_group("000");
        ncReceivableBillUpRecBillBO.setPk_org(saleCompanyCode);
        if (saleOrderInfo.getRemark() != null) {
            ncReceivableBillUpRecBillBO.setScomment(StringEscapeUtils.escapeJava((String)this.subScomment(saleOrderInfo.getRemark())));
        } else {
            ncReceivableBillUpRecBillBO.setScomment("");
        }
        ncReceivableBillUpRecBillBO.setSett_org(saleCompanyCode);
        if (umcYdEnterpriseOrgDetailAbilityRspBO != null && umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            ncReceivableBillUpRecBillBO.setCustomer(replaceCode);
        }
        ncReceivableBillUpRecBillBO.setPk_tradetype("F0-Cxx-01");
        ncReceivableBillUpRecBillBO.setPk_billtype("F0");
        ncReceivableBillUpRecBillBO.setDef1(String.valueOf(saleOrderInfo.getInspectionId()));
        Object ncCollectionBillUpGatherItemBOS = null;
        for (SaleItemInfo brbo : saleItemInfoList) {
            NcReceivableBillUpRecItemBO ncReceivableBillUpRecItemBO = new NcReceivableBillUpRecItemBO();
            ncReceivableBillUpRecItemBO.setBuysellflag(1);
            ncReceivableBillUpRecItemBO.setContractno(null);
            if (umcYdEnterpriseOrgDetailAbilityRspBO != null && umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                ncReceivableBillUpRecItemBO.setCustomer(replaceCode);
            }
            ncReceivableBillUpRecItemBO.setInvoiceno("");
            ncReceivableBillUpRecItemBO.setLocal_money_bal(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setLocal_money_de(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setLocal_notax_de(brbo.getUntaxAmt());
            ncReceivableBillUpRecItemBO.setLocal_tax_de(brbo.getTaxAmt());
            ncReceivableBillUpRecItemBO.setMoney_bal(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setMoney_de(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setNotax_de(brbo.getUntaxAmt());
            ncReceivableBillUpRecItemBO.setOccupationmny(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setObjtype(0);
            ncReceivableBillUpRecItemBO.setPk_currtype("CNY");
            ncReceivableBillUpRecItemBO.setPk_deptid(pk_deptid);
            ncReceivableBillUpRecItemBO.setPk_org(saleCompanyCode);
            ncReceivableBillUpRecItemBO.setPurchaseorder("");
            if (saleOrderInfo.getRemark() != null) {
                ncReceivableBillUpRecItemBO.setScomment(StringEscapeUtils.escapeJava((String)this.subScomment(saleOrderInfo.getRemark())));
            } else {
                ncReceivableBillUpRecItemBO.setScomment("");
            }
            ncReceivableBillUpRecItemBO.setSett_org(saleCompanyCode);
            ncReceivableBillUpRecItemBO.setTaxrate(brbo.getTaxRate());
            ncReceivableBillUpRecItemBO.setDef30(orgTypeNC);
            if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.16)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM015");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.11)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM016");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.1)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM017");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.06)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM018");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.05)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM019");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.03)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM020");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.17)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM021");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.13)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM022");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.09)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM023");
            } else {
                ncReceivableBillUpRecItemBO.setDef1("");
            }
            ncReceivableBillUpRecItemBO.setDef2(saleOrderInfo.getPurchaseName());
            ncReceivableBillUpRecItemBO.setDef3(saleOrderInfo.getSaleOrderCode());
            ncReceivableBillUpRecItemBO.setDef4("");
            ncReceivableBillUpRecItemBO.setDef5("");
            ncReceivableBillUpRecItemBO.setDef6("");
            ncReceivableBillUpRecItemBO.setDef25("");
            ncReceivableBillUpRecItemBO.setDef24("");
            ncReceivableBillUpRecItemBOS.add(ncReceivableBillUpRecItemBO);
        }
        ncReceivableBillUpReqBO.setBillHead(ncReceivableBillUpRecBillBO);
        ncReceivableBillUpReqBO.setItem(ncReceivableBillUpRecItemBOS);
        ncReceivableBillUpReqBO.setId(String.valueOf(saleOrderInfo.getInspectionId()));
        ncReceivableBillUpReqBO.setInspectionVoucherId(saleOrderInfo.getInspectionId());
        ncReceivableBillUpReqBO.setOrderId(saleOrderInfo.getOrderId());
        String ncReceivableBillUpReqBOJson = JSONArray.toJSON((Object)ncReceivableBillUpReqBO).toString();
        log.error("\u5e94\u6536\u5355json=====" + ncReceivableBillUpReqBOJson);
        BigDecimal orderAmt = saleOrderInfo.getOrderAmt();
        if (orderAmt != null && orderAmt.compareTo(BigDecimal.ZERO) != 0) {
            NcReceivableBillUpRspBO ncReceivableBillUpRspBO = this.ncReceivableBillUpService.receivableBillUp(ncReceivableBillUpReqBO);
            this.resultCacheFaill(ncReceivableBillUpReqBO, isInNC ? "" : "\u5ba2\u6237\u7f16\u7801orgCode=" + replaceCode + "\u5728NC\u4e2d\u67e5\u8be2\u4e3a\u7a7a\u3002", ncReceivableBillUpRspBO);
        } else {
            log.debug("\u8ba2\u5355\u91d1\u989d\u4e3a0\uff0c\u672a\u63a8\u9001nc\uff0c\u5185\u5bb9\u4e3a:{}", (Object)JSON.toJSONString((Object)ncReceivableBillUpReqBO));
        }
    }

    private void resultCacheFaill(NcReceivableBillUpReqBO ncReceivableBillUpReqBO, String isInNCMiniMsg, NcReceivableBillUpRspBO ncReceivableBillUpRspBO) {
        String ncReceivableBillUpReqBOJson = JSON.toJSONString((Object)ncReceivableBillUpReqBO);
        ReceivableBillUpPO receivableBillUpPO = new ReceivableBillUpPO();
        receivableBillUpPO.setOrderId(ncReceivableBillUpReqBO.getOrderId());
        receivableBillUpPO.setInspectionId(ncReceivableBillUpReqBO.getInspectionVoucherId());
        receivableBillUpPO.setCreateTime(new Date());
        receivableBillUpPO.setTag("00");
        receivableBillUpPO.setPushStatus("2");
        receivableBillUpPO.setNcReceivableBillUpJson(JSON.toJSONString((Object)ncReceivableBillUpReqBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        ReceivableBillUpPOKey vo = new ReceivableBillUpPOKey();
        vo.setOrderId(receivableBillUpPO.getOrderId());
        vo.setInspectionId(receivableBillUpPO.getInspectionId());
        vo.setTag(receivableBillUpPO.getTag());
        ReceivableBillUpPO billUpPO = this.receivableBillUpMapper.selectByPrimaryKey(vo);
        if (ncReceivableBillUpRspBO.getRespCode().equals("8888")) {
            log.debug("\u63a8\u9001NC\u5931\u8d25\uff0c\u8fde\u63a5NC\u975e200\u3002\u63cf\u8ff0\uff1a{}\u3002\u63a8\u9001Json\uff1a{}", (Object)ncReceivableBillUpRspBO.getRespDesc(), (Object)ncReceivableBillUpReqBOJson);
            receivableBillUpPO.setResultMessage("\u8fde\u63a5nc\u5931\u8d25\uff1a" + ncReceivableBillUpRspBO.getRespDesc());
            if (billUpPO != null) {
                int i = this.receivableBillUpMapper.updateByPrimaryKeySelective(receivableBillUpPO);
                log.debug("\u66f4\u65b0count\uff1a{}", (Object)i);
            } else {
                int count = this.receivableBillUpMapper.insert(receivableBillUpPO);
                log.debug("\u63d2\u5165count\uff1a{}", (Object)count);
            }
        } else if (ncReceivableBillUpRspBO.getRespCode().equals("-31202")) {
            if (billUpPO != null) {
                int i = this.receivableBillUpMapper.updateByPrimaryKeySelective(receivableBillUpPO);
                log.debug("\u66f4\u65b0count\uff1a{}", (Object)i);
            } else {
                receivableBillUpPO.setResultMessage("\u5355\u72ec\u63a8\u9001\u5931\u8d25\u7f13\u5b58\uff1a" + isInNCMiniMsg + JSON.toJSONString((Object)ncReceivableBillUpRspBO));
                int count = this.receivableBillUpMapper.insert(receivableBillUpPO);
                log.debug("\u63d2\u5165count\uff1a{}", (Object)count);
            }
            log.debug("======================================================");
            log.debug("\u5355\u72ec\u63a8\u9001\u5e94\u6536\u5355\u518d\u6b21\u63a8\u9001\u5931\u8d25\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)ncReceivableBillUpReqBO));
            log.debug("\u5355\u72ec\u63a8\u9001\u5e94\u6536\u5355\u518d\u6b21\u63a8\u9001\u5931\u8d25\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)ncReceivableBillUpRspBO));
            log.debug("======================================================");
        } else if (ncReceivableBillUpRspBO.getRespCode().equals("1")) {
            log.debug("\u63a8\u9001\u6210\u529f\uff01{}", (Object)ncReceivableBillUpRspBO.getResultdescription());
            if (billUpPO != null) {
                receivableBillUpPO.setPushStatus("1");
                int i = this.receivableBillUpMapper.updateByPrimaryKeySelective(receivableBillUpPO);
                log.debug("\u66f4\u65b0\u4e3a\u5df2\u63a8\u9001count\uff1a{}", (Object)i);
            }
        } else {
            log.debug("\u672a\u5904\u7406\u72b6\u6001\u7801,\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)ncReceivableBillUpRspBO));
        }
    }

    private String subScomment(String remark) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < remark.length(); ++i) {
            String temp = remark.substring(i, i + 1);
            valueLength = temp.matches(chinese) ? (valueLength += 2) : ++valueLength;
            if (i >= 39) break;
        }
        int maxLen = valueLength;
        valueLength = 0;
        int len = 0;
        for (int i = 0; i < remark.length(); ++i) {
            String temp = remark.substring(i, i + 1);
            valueLength = temp.matches(chinese) ? (valueLength += 3) : ++valueLength;
            if (valueLength <= maxLen) continue;
            len = i - 1;
            break;
        }
        String substring = remark.substring(0, len);
        return substring;
    }
}

