/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.order.extend.ability.saleorder.PebExtOrderPayCallBackAbilityService;
import com.tydic.order.extend.bo.saleorder.PebExtOrderPayCallBackReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtOrderPayCallBackRspBO;
import com.tydic.pfsc.api.busi.FscZjptBankReveiveDetailService;
import com.tydic.pfsc.api.busi.bo.FscZjptBankReveiveDetailReqBO;
import com.tydic.pfsc.api.busi.bo.FscZjptBankReveiveDetailRspBO;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.PaymentFlowInfoMapper;
import com.tydic.pfsc.dao.PaymentLogMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.PaymentFlowInfo;
import com.tydic.pfsc.dao.po.PaymentLog;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.ApplyPayStatus2;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.FscZjptBankReveiveDetailService"})
public class FscZjptBankReveiveDetailServiceImpl
implements FscZjptBankReveiveDetailService {
    private static final Logger log = LoggerFactory.getLogger(FscZjptBankReveiveDetailServiceImpl.class);
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PebExtOrderPayCallBackAbilityService pebExtOrderPayCallBackAbilityService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @PostMapping(value={"dealZjptBankReceiveDetail"})
    public FscZjptBankReveiveDetailRspBO dealZjptBankReceiveDetail(@RequestBody FscZjptBankReveiveDetailReqBO reqBO) {
        FscZjptBankReveiveDetailRspBO rspBO = new FscZjptBankReveiveDetailRspBO();
        try {
            String payNo;
            ApplyPayInfoPO applyPayInfoResult;
            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
            paymentFlowInfo.setPaymentFlowId(reqBO.getDtlId());
            paymentFlowInfo.setRecAcctNo(reqBO.getBankAcc());
            paymentFlowInfo.setRecAcctName(reqBO.getBankName());
            paymentFlowInfo.setOrderAmt(reqBO.getAmt());
            paymentFlowInfo.setPayAcctNo(reqBO.getOppAccNo());
            paymentFlowInfo.setPayAcctName(reqBO.getOppAccName());
            paymentFlowInfo.setPayTime(reqBO.getTransTime());
            paymentFlowInfo.setOrderDesc(reqBO.getAbs());
            paymentFlowInfo.setBusiCode("BFS");
            paymentFlowInfo.setExtJson(reqBO.getCorpCode());
            this.paymentFlowInfoMapper.insertSelective(paymentFlowInfo);
            if (!StringUtils.isEmpty((Object)reqBO.getAbs()) && (applyPayInfoResult = this.applyPayInfoMapper.getModelById(payNo = reqBO.getAbs().trim())) != null && reqBO.getAmt().compareTo(applyPayInfoResult.getPayAmt()) == 0) {
                ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
                applyPayInfoPO.setPayno(payNo);
                applyPayInfoPO.setPayStatus(ApplyPayStatus2.YESPAID.getCode());
                applyPayInfoPO.setPaySerialNo(reqBO.getDtlId());
                int updateStatus = this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                if (updateStatus < 1) {
                    throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u652f\u4ed8\u5355\u72b6\u6001\u4fe1\u606f\u5f02\u5e38");
                }
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setPayno(payNo);
                log.error("saleOrderInfoVO==" + saleOrderInfoVO);
                List<SaleOrderInfo> list = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                if (!CollectionUtils.isEmpty(list)) {
                    for (SaleOrderInfo sif : list) {
                        String sifPayType;
                        PebExtOrderPayCallBackReqBO pebExtOrderPayCallBackReqBO = new PebExtOrderPayCallBackReqBO();
                        pebExtOrderPayCallBackReqBO.setOrderId(sif.getOrderId());
                        pebExtOrderPayCallBackReqBO.setPaySerialNumber(reqBO.getDtlId());
                        String string = sifPayType = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sif.getOldPayType()) ? sif.getPayType() : sif.getOldPayType();
                        if (sif.getLatestPayDate() != null || "04".equals(sifPayType)) {
                            if ("2".equals(applyPayInfoResult.getPayMode())) {
                                pebExtOrderPayCallBackReqBO.setPayType(Integer.valueOf(5));
                            } else {
                                pebExtOrderPayCallBackReqBO.setPayType(Integer.valueOf(1));
                            }
                        } else if ("05".equals(sif.getPayType())) {
                            pebExtOrderPayCallBackReqBO.setPayType(Integer.valueOf(2));
                        } else if ("06".equals(sif.getPayType())) {
                            pebExtOrderPayCallBackReqBO.setPayType(Integer.valueOf(3));
                        } else if ("07".equals(sif.getPayType())) {
                            pebExtOrderPayCallBackReqBO.setPayType(Integer.valueOf(4));
                        }
                        pebExtOrderPayCallBackReqBO.setDealType(Integer.valueOf(1));
                        pebExtOrderPayCallBackReqBO.setCancelReason("");
                        pebExtOrderPayCallBackReqBO.setPayVoucherNo(payNo);
                        log.error("\u8d44\u91d1\u5e73\u53f0\u7ebf\u4e0b\u4ed8\u6b3e\u94f6\u884c\u6536\u6b3e\u660e\u7ec6\u63a5\u53e3\u56de\u8c03\u8ba2\u5355\u670d\u52a1\u5165\u53c2" + pebExtOrderPayCallBackReqBO);
                        PebExtOrderPayCallBackRspBO pebExtOrderPayCallBackRspBO = this.pebExtOrderPayCallBackAbilityService.payCallBack(pebExtOrderPayCallBackReqBO);
                        log.error("\u8d44\u91d1\u5e73\u53f0\u7ebf\u4e0b\u4ed8\u6b3e\u94f6\u884c\u6536\u6b3e\u660e\u7ec6\u63a5\u53e3\u56de\u8c03\u8ba2\u5355\u670d\u52a1\u8fd4\u56de" + pebExtOrderPayCallBackRspBO);
                    }
                }
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setPayno(payNo);
                saleOrderInfo.setPayStatus("02");
                saleOrderInfo.setRecvDate(new Date());
                this.saleOrderInfoMapper.updateByPrimaryKeyByPayNo(saleOrderInfo);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u94f6\u884c\u6536\u6b3e\u660e\u7ec6\u5904\u7406\u6210\u529f");
            rspBO.setDtlId(reqBO.getDtlId());
            this.savelog("FscZjptBankReveiveDetailService-1", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u8d44\u91d1\u5e73\u53f0\u63a8\u9001\u94f6\u884c\u6536\u6b3e\u660e\u7ec6\u5931\u8d25,\uff1a" + e);
            this.savelog("FscZjptBankReveiveDetailService-1", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", "\u5904\u7406\u8d44\u91d1\u5e73\u53f0\u63a8\u9001\u94f6\u884c\u6536\u6b3e\u660e\u7ec6\u5931\u8d25:" + e);
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

