/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfsc.api.busi.FscZjptPayBillResultService;
import com.tydic.pfsc.api.busi.bo.DeptBO;
import com.tydic.pfsc.api.busi.bo.FscZjptPayBillResultReqBO;
import com.tydic.pfsc.api.busi.bo.FscZjptPayBillResultRspBO;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.DicDictionaryMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.PaymentLogMapper;
import com.tydic.pfsc.dao.ReceivableBillUpMapper;
import com.tydic.pfsc.dao.bo.DicDictionaryPO;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.BillNotificationInfoExt;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.PaymentLog;
import com.tydic.pfsc.dao.po.ReceivableBillUpPO;
import com.tydic.pfsc.enums.ApplyPayStatus2;
import com.tydic.pfsc.enums.PayChannel;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.nc.api.NcPaymentNoteBillUpService;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpItemBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpReqBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpRspBO;
import com.tydic.pfsc.utils.MidDataPool;
import com.tydic.umcext.ability.org.UmcACompanyInfoDetailAbilityService;
import com.tydic.umcext.ability.org.UmcYdEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceReqBO;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.FscZjptPayBillResultService"})
public class FscZjptPayBillResultServiceImpl
implements FscZjptPayBillResultService {
    private static final Logger log = LoggerFactory.getLogger(FscZjptPayBillResultServiceImpl.class);
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private NcPaymentNoteBillUpService ncPaymentNoteBillUpService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private UmcYdEnterpriseOrgQueryAbilityService umcYdEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcACompanyInfoDetailAbilityService umcACompanyInfoDetailAbilityService;
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;
    @Autowired
    private ReceivableBillUpMapper receivableBillUpMapper;

    @PostMapping(value={"dealZjptPayBillResult"})
    public FscZjptPayBillResultRspBO dealZjptPayBillResult(@RequestBody FscZjptPayBillResultReqBO reqBO) {
        FscZjptPayBillResultRspBO rspBO = new FscZjptPayBillResultRspBO();
        try {
            String payNo = reqBO.getSerialNoErp().trim();
            ApplyPayInfoPO applyPayInfoResult = this.applyPayInfoMapper.getModelById(payNo);
            if (applyPayInfoResult == null) {
                rspBO.setRespCode("18001");
                rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                rspBO.setSerialNoErp(reqBO.getSerialNoErp());
                return rspBO;
            }
            ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
            applyPayInfoPO.setPayno(payNo);
            if ("0".equals(reqBO.getVoucherStat())) {
                applyPayInfoPO.setPayStatus(ApplyPayStatus2.PAID.getCode());
            } else if ("-1".equals(reqBO.getVoucherStat())) {
                applyPayInfoPO.setPayStatus(ApplyPayStatus2.PAY_FAILED.getCode());
                applyPayInfoPO.setReasons(reqBO.getReturnMsg());
            }
            int updateStatus = this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
            if (updateStatus < 1) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u5f02\u5e38");
            }
            if ("0".equals(reqBO.getVoucherStat()) && PayChannel.NC.getCode().equals(applyPayInfoResult.getPayChannel())) {
                this.paymentNoteBillUp(applyPayInfoResult);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4ed8\u6b3e\u7ed3\u679c\u5904\u7406\u6210\u529f");
            rspBO.setSerialNoErp(reqBO.getSerialNoErp());
            this.savelog("FscZjptPayBillResultService-1", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u8d44\u91d1\u5e73\u53f0\u63a8\u9001\u4ed8\u6b3e\u4ea4\u6613\u7ed3\u679c\u5931\u8d25,\uff1a" + e);
            this.savelog("FscZjptPayBillResultService-1", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", "\u5904\u7406\u8d44\u91d1\u5e73\u53f0\u63a8\u9001\u4ed8\u6b3e\u4ea4\u6613\u7ed3\u679c\u5931\u8d25:" + e);
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void paymentNoteBillUp(ApplyPayInfoPO appo) {
        log.error("\u751f\u6210\u4ed8\u6b3e\u5355");
        BillNotificationInfoExt billNotificationInfoExt = new BillNotificationInfoExt();
        billNotificationInfoExt.setPayNo(appo.getPayno());
        List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.selectForPage(billNotificationInfoExt);
        if (billNotificationInfos != null && billNotificationInfos.size() > 0) {
            for (BillNotificationInfo bio : billNotificationInfos) {
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setNotificationNo(bio.getNotificationNo());
                log.error(payPurchaseOrderInfo.toString());
                List<PayPurchaseOrderInfo> payPurchaseOrderInfoList2 = this.payPurchaseOrderInfoMapper.getList2(payPurchaseOrderInfo);
                if (payPurchaseOrderInfoList2 == null || payPurchaseOrderInfoList2.size() <= 0) continue;
                for (PayPurchaseOrderInfo poo : payPurchaseOrderInfoList2) {
                    UmcACompanyInfoDetailAbilityServiceReqBO umcACompanyInfoDetailAbilityServiceReqBO = new UmcACompanyInfoDetailAbilityServiceReqBO();
                    umcACompanyInfoDetailAbilityServiceReqBO.setCompanyId(poo.getPurchaseCompanyId());
                    log.error("getDetailACompanyInfo\u65b9\u6cd5\u5165\u53c2==" + umcACompanyInfoDetailAbilityServiceReqBO);
                    UmcACompanyInfoDetailAbilityServiceRspBO detailACompanyInfo = this.umcACompanyInfoDetailAbilityService.getDetailACompanyInfo(umcACompanyInfoDetailAbilityServiceReqBO);
                    log.error("detailACompanyInfo\u65b9\u6cd5\u51fa\u53c2==" + detailACompanyInfo);
                    NcPaymentNoteBillUpReqBO ncPaymentNoteBillUpReqBO = new NcPaymentNoteBillUpReqBO();
                    NcPaymentNoteBillUpBO ncPaymentNoteBillUpBO = new NcPaymentNoteBillUpBO();
                    ArrayList<NcPaymentNoteBillUpItemBO> ncPaymentNoteBillUpItemBOS = new ArrayList<NcPaymentNoteBillUpItemBO>();
                    ncPaymentNoteBillUpReqBO.setId(appo.getPayno());
                    UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = new UmcQrySupplierInfoDetailAbilityRspBO();
                    String supplierCode = "";
                    String outsideOnlineRetailersPower = "";
                    String replaceSupplierCode = "";
                    try {
                        UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
                        umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(poo.getSupplierNo());
                        log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u8be6\u60c5\u5165\u53c2" + umcQrySupplierInfoDetailAbilityReqBO);
                        umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
                        log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u8be6\u60c5\u51fa\u53c2" + umcQrySupplierInfoDetailAbilityRspBO);
                        supplierCode = umcQrySupplierInfoDetailAbilityRspBO.getSupplierCode();
                        outsideOnlineRetailersPower = umcQrySupplierInfoDetailAbilityRspBO.getOutsideOnlineRetailersPower();
                        replaceSupplierCode = null;
                        if (supplierCode != null) {
                            replaceSupplierCode = supplierCode.replace("NC-", "");
                        }
                    }
                    catch (Exception e) {
                        log.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u8be6\u60c5\u62a5\u9519===================================");
                    }
                    UmcYdEnterpriseOrgQueryAbilityReqBO umcYdEnterpriseOrgQueryAbilityReqBO = new UmcYdEnterpriseOrgQueryAbilityReqBO();
                    umcYdEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(poo.getPurchaseNo());
                    log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u5165\u53c2" + umcYdEnterpriseOrgQueryAbilityReqBO);
                    UmcYdEnterpriseOrgDetailAbilityRspBO umcYdEnterpriseOrgDetailAbilityRspBO = this.umcYdEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcYdEnterpriseOrgQueryAbilityReqBO);
                    log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2" + umcYdEnterpriseOrgDetailAbilityRspBO);
                    String orgTypeNC = "";
                    if (umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                        orgTypeNC = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTypeNc();
                    }
                    String pk_deptid = null;
                    String saleCompanyCode = "";
                    String saleCompanyId = String.valueOf(poo.getPurchaseCompanyId());
                    DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
                    dicDictionaryPO.setCode(saleCompanyId);
                    dicDictionaryPO.setPCode("ATOUR_COMPANY_INFO");
                    DicDictionaryPO dicDictionaryPOResult = this.dicDictionaryMapper.getModelByCondition(dicDictionaryPO);
                    if (null != dicDictionaryPOResult) {
                        saleCompanyCode = dicDictionaryPOResult.getTitle();
                    }
                    log.error("\u8c03\u7528nc\u89c6\u56fe\u5f00\u59cb======================");
                    log.error("\u7532\u65b9\u62ac\u5934\u7f16\u7801saleCompanyCode==" + saleCompanyCode);
                    List saleCompanyIdList = MidDataPool.getJdbcTemplatePre().query("select orgcode,orgname,deptcode,deptname from v_b2b_dept where orgcode ='" + saleCompanyCode + "';", (RowMapper)new BeanPropertyRowMapper(DeptBO.class));
                    if (saleCompanyIdList != null && saleCompanyIdList.size() > 0) {
                        log.error("saleCompanyIdList.size" + saleCompanyIdList.size());
                        for (DeptBO dbo : saleCompanyIdList) {
                            if (!dbo.getDeptcode().equals(dicDictionaryPOResult.getDescrip())) continue;
                            pk_deptid = dbo.getDeptcode();
                        }
                    }
                    log.error("\u8c03\u7528nc\u89c6\u56fe\u7ed3\u675f======================");
                    log.debug("--\u5ba2\u6237\u7f16\u7801\uff0c\u4f20\u9012\u524d\uff0c\u786e\u8ba4\u5728PMS\u548cNC\u89c6\u56fe\u4e2d------------2021-04-06-NC\u89c6\u56fe\u4e0ePMS\u89c6\u56fe\u5bf9\u6bd4----\u5f00\u59cb---");
                    boolean isInNC = true;
                    if (umcYdEnterpriseOrgDetailAbilityRspBO == null || umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
                        log.debug("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7purchaseNo={}\u67e5PMS\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8be6\u60c5\u89c1\u4e0a\u4e00\u4e2alog\uff1a\u300a\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2JSON\u300b");
                        throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4dpurchaseNo=" + poo.getPurchaseNo() + "\u672a\u5728PMS\u4e2d\u67e5\u8be2\u5230");
                    }
                    UmcYdEnterpriseOrgAbilityBO umcEnterpriseOrgAbilityBO = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO();
                    if (!StringUtils.hasText((String)umcEnterpriseOrgAbilityBO.getOrgCode())) {
                        log.debug("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7purchaseNo={}\u67e5PMS\uff0c\u8fd4\u56de\u7ed3\u679c\u4e2dorgCode\u4e3a\u7a7a\u3002orgCode={}", (Object)umcEnterpriseOrgAbilityBO.getOrgCode());
                        throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4dpurchaseNo=" + poo.getPurchaseNo() + "\u5728PMS\u4e2d\u67e5\u8be2\u7ed3\u679c\u4e2d\uff0ccode\u6ca1\u6709\u503c\u3002OrgCode=" + umcEnterpriseOrgAbilityBO.getOrgCode());
                    }
                    String pmsOrgCode = umcEnterpriseOrgAbilityBO.getOrgCode();
                    String replaceCode = pmsOrgCode.replace("PMS-", "");
                    List ncOrgCodeList = MidDataPool.getJdbcTemplatePre().query("select orgcode,orgname,deptcode,deptname from v_b2b_dept where orgcode ='" + replaceCode + "';", (RowMapper)new BeanPropertyRowMapper(DeptBO.class));
                    if (CollectionUtils.isEmpty((Collection)ncOrgCodeList)) {
                        log.debug("\u4f1a\u5458\u5b58\u5728\uff0c\u4f46NC\u4e0d\u5b58\u5728\u3002orgCode={}", (Object)umcEnterpriseOrgAbilityBO.getOrgCode());
                        isInNC = false;
                    } else {
                        log.debug("NC \u67e5\u8be2\u7ed3\u679cJSON\uff1a{}", (Object)JSON.toJSONString((Object)ncOrgCodeList));
                    }
                    log.debug("--\u5ba2\u6237\u7f16\u7801\uff0c\u4f20\u9012\u524d\uff0c\u786e\u8ba4\u5728PMS\u548cNC\u89c6\u56fe\u4e2d------------2021-04-06-NC\u89c6\u56fe\u4e0ePMS\u89c6\u56fe\u5bf9\u6bd4--end-----");
                    Date d = new Date();
                    System.out.println(d);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String dateNowStr = sdf.format(d);
                    ncPaymentNoteBillUpBO.setBilldate(dateNowStr);
                    ncPaymentNoteBillUpBO.setBillmaker("B2B");
                    ncPaymentNoteBillUpBO.setCreator("B2B");
                    ncPaymentNoteBillUpBO.setBillstatus(0);
                    ncPaymentNoteBillUpBO.setIsinit("N");
                    ncPaymentNoteBillUpBO.setIsreded("N");
                    ncPaymentNoteBillUpBO.setLocal_money(poo.getOrderAmt());
                    ncPaymentNoteBillUpBO.setMoney(poo.getOrderAmt());
                    ncPaymentNoteBillUpBO.setObjtype(1);
                    ncPaymentNoteBillUpBO.setPk_tradetype("F3-Cxx-03");
                    ncPaymentNoteBillUpBO.setPk_billtype("F3");
                    ncPaymentNoteBillUpBO.setPk_balatype("3");
                    ncPaymentNoteBillUpBO.setPk_currtype("CNY");
                    ncPaymentNoteBillUpBO.setPk_deptid(pk_deptid);
                    ncPaymentNoteBillUpBO.setPk_group("000");
                    ncPaymentNoteBillUpBO.setPk_org(saleCompanyCode);
                    ncPaymentNoteBillUpBO.setSrc_syscode(0);
                    ncPaymentNoteBillUpBO.setSyscode(0);
                    ncPaymentNoteBillUpBO.setPayaccount(detailACompanyInfo.getBankAccount());
                    ncPaymentNoteBillUpBO.setRecaccount(appo.getReceiptAcctNo());
                    if (appo.getRemark() != null) {
                        ncPaymentNoteBillUpBO.setDef10(appo.getRemark());
                    } else {
                        ncPaymentNoteBillUpBO.setDef10("");
                    }
                    ncPaymentNoteBillUpBO.setDef6(appo.getPayno());
                    ncPaymentNoteBillUpBO.setSupplier(replaceSupplierCode);
                    List<PayItemInfo> payItemInfoList = this.payItemInfoMapper.selectByNotifNoAndOrderId(bio.getNotificationNo(), poo.getOrderId(), poo.getInspectionId());
                    if (payItemInfoList != null && payItemInfoList.size() > 0) {
                        for (PayItemInfo pif : payItemInfoList) {
                            NcPaymentNoteBillUpItemBO ncPaymentNoteBillUpItemBO = new NcPaymentNoteBillUpItemBO();
                            ncPaymentNoteBillUpItemBO.setLocal_money_bal(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setLocal_money_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setLocal_notax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setMoney_bal(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setMoney_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setObjtype(1);
                            ncPaymentNoteBillUpItemBO.setGlobaldebit(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGlobalnotax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGroupdebit(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGroupnotax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setPk_currtype("CNY");
                            ncPaymentNoteBillUpItemBO.setPk_deptid(pk_deptid);
                            ncPaymentNoteBillUpItemBO.setPk_org(saleCompanyCode);
                            ncPaymentNoteBillUpItemBO.setPk_tradetype("F3-Cxx-03");
                            ncPaymentNoteBillUpItemBO.setSett_org(saleCompanyCode);
                            ncPaymentNoteBillUpItemBO.setPrepay("0");
                            ncPaymentNoteBillUpItemBO.setPk_balatype("3");
                            if (umcQrySupplierInfoDetailAbilityRspBO != null) {
                                ncPaymentNoteBillUpItemBO.setSupplier(replaceSupplierCode);
                            } else {
                                ncPaymentNoteBillUpItemBO.setSupplier("");
                            }
                            ncPaymentNoteBillUpItemBO.setPayaccount(detailACompanyInfo.getBankAccount());
                            ncPaymentNoteBillUpItemBO.setRecaccount(appo.getReceiptAcctNo());
                            ncPaymentNoteBillUpItemBO.setScomment(appo.getPayno());
                            ncPaymentNoteBillUpItemBO.setPk_recpaytype("01");
                            ncPaymentNoteBillUpItemBO.setDef2(poo.getInspectionCode());
                            if (outsideOnlineRetailersPower != null) {
                                if (outsideOnlineRetailersPower.equals("1")) {
                                    ncPaymentNoteBillUpItemBO.setDef27("02");
                                } else if (outsideOnlineRetailersPower.equals("2")) {
                                    ncPaymentNoteBillUpItemBO.setDef27("01");
                                }
                            }
                            if ("03".equals(orgTypeNC)) {
                                ncPaymentNoteBillUpItemBO.setDef28("02");
                            } else {
                                ncPaymentNoteBillUpItemBO.setDef28(orgTypeNC);
                            }
                            ncPaymentNoteBillUpItemBOS.add(ncPaymentNoteBillUpItemBO);
                        }
                    }
                    ncPaymentNoteBillUpReqBO.setBillHead(ncPaymentNoteBillUpBO);
                    ncPaymentNoteBillUpReqBO.setItem(ncPaymentNoteBillUpItemBOS);
                    String ncPaymentNoteBillUpReqBOJson = JSONArray.toJSON((Object)ncPaymentNoteBillUpReqBO).toString();
                    log.error("\u4ed8\u6b3e\u5355json=====" + ncPaymentNoteBillUpReqBOJson);
                    BigDecimal orderAmt = poo.getOrderAmt();
                    if (orderAmt != null && orderAmt.compareTo(BigDecimal.ZERO) != 0) {
                        NcPaymentNoteBillUpRspBO ncPaymentNoteBillUpRspBO = this.ncPaymentNoteBillUpService.paymentNoteBillUp(ncPaymentNoteBillUpReqBO);
                        this.resultCacheFaill(ncPaymentNoteBillUpReqBO, isInNC ? "" : "\u5ba2\u6237\u7f16\u7801orgCode=" + replaceCode + "\u5728NC\u4e2d\u67e5\u8be2\u4e3a\u7a7a\u3002", ncPaymentNoteBillUpRspBO);
                        continue;
                    }
                    log.debug("\u8ba2\u5355\u91d1\u989d\u4e3a0\uff0c\u672a\u63a8\u9001nc\uff0c\u5185\u5bb9\u4e3a:{}", (Object)JSON.toJSONString((Object)ncPaymentNoteBillUpReqBO));
                }
            }
        }
    }

    private void resultCacheFaill(NcPaymentNoteBillUpReqBO ncPaymentNoteBillUpReqBO, String isInNCMsg, NcPaymentNoteBillUpRspBO ncPaymentNoteBillUpRspBO) {
        String ncReceivableBillUpReqBOJson = JSON.toJSONString((Object)ncPaymentNoteBillUpReqBO);
        ReceivableBillUpPO receivableBillUpPO = new ReceivableBillUpPO();
        receivableBillUpPO.setOrderId(System.currentTimeMillis());
        receivableBillUpPO.setInspectionId(System.currentTimeMillis() * 100L);
        receivableBillUpPO.setCreateTime(new Date());
        receivableBillUpPO.setTag("30");
        receivableBillUpPO.setPushStatus("0");
        receivableBillUpPO.setNcReceivableBillUpJson(JSON.toJSONString((Object)ncPaymentNoteBillUpReqBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        if (ncPaymentNoteBillUpRspBO.getRespCode().equals("8888")) {
            log.debug("\u63a8\u9001NC\u5931\u8d25\uff0c\u8fde\u63a5NC\u975e200\u3002\u63cf\u8ff0\uff1a{}\u3002\u63a8\u9001Json\uff1a{}", (Object)ncPaymentNoteBillUpRspBO.getRespDesc(), (Object)ncReceivableBillUpReqBOJson);
            receivableBillUpPO.setResultMessage("\u8fde\u63a5nc\u5931\u8d25\uff1a" + ncPaymentNoteBillUpRspBO.getRespDesc());
            int count = this.receivableBillUpMapper.insert(receivableBillUpPO);
            log.debug("\u63d2\u5165count\uff1a{}", (Object)count);
        } else if (ncPaymentNoteBillUpRspBO.getRespCode().equals("-31202")) {
            receivableBillUpPO.setResultMessage(isInNCMsg + JSON.toJSONString((Object)ncPaymentNoteBillUpRspBO));
            int count = this.receivableBillUpMapper.insert(receivableBillUpPO);
            log.debug("\u63d2\u5165count\uff1a{}", (Object)count);
        } else if (ncPaymentNoteBillUpRspBO.getRespCode().equals("1")) {
            log.debug("\u63a8\u9001\u6210\u529f\uff01{}", (Object)ncPaymentNoteBillUpRspBO.getResultdescription());
        } else {
            log.debug("\u672a\u5904\u7406\u72b6\u6001\u7801,\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)ncPaymentNoteBillUpRspBO));
        }
    }
}

