/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfsc.aop.annotation.FscDuplicateCommitLimit;
import com.tydic.pfsc.api.deal.AdjustClosingServiceFeeService;
import com.tydic.pfsc.api.deal.bo.PayOrderInfoDetailReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.PayOrderInfoMapper;
import com.tydic.pfsc.dao.po.PayOrderInfoPO;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.deal.AdjustClosingServiceFeeService"})
public class AdjustClosingServiceFeeServiceImpl
implements AdjustClosingServiceFeeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdjustClosingServiceFeeServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;

    @FscDuplicateCommitLimit(toast="\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\uff0c\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5")
    @PostMapping(value={"adjustClosingService"})
    public PfscExtRspBaseBO adjustClosingService(@RequestBody PayOrderInfoDetailReqBO payOrderInfoDetailReqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)payOrderInfoDetailReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        if (payOrderInfoDetailReqBO.getPayOrderIds() == null || payOrderInfoDetailReqBO.getPayOrderIds().size() == 0) {
            pfscExtRspBaseBO.setRespDesc("\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            pfscExtRspBaseBO.setRespCode("18000");
            return pfscExtRspBaseBO;
        }
        List payOrderIds = payOrderInfoDetailReqBO.getPayOrderIds();
        if (payOrderIds != null && payOrderIds.size() > 0) {
            List collect;
            LOGGER.debug("\u6839\u636e\u8ba2\u5355list\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)payOrderIds));
            List<PayOrderInfoPO> payOrderInfoPOS = this.payOrderInfoMapper.selectListByIds(payOrderIds);
            LOGGER.debug("\u6839\u636e\u8ba2\u5355list\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(payOrderInfoPOS));
            if ("4".equals(payOrderInfoDetailReqBO.getPayOrderStatus())) {
                collect = payOrderInfoPOS.stream().filter(po -> po.getPayOrderStatus().equals("4")).collect(Collectors.toList());
                LOGGER.debug("\u5b58\u5728\u5df2\u88ab\u786e\u8ba4\u7684\u5355\u636e:{}", collect);
                if (collect.size() > 0) {
                    pfscExtRspBaseBO.setRespCode("18000");
                    pfscExtRspBaseBO.setRespDesc("\u5b58\u5728\u5df2\u88ab\u786e\u8ba4\u7684\u5355\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
                    return pfscExtRspBaseBO;
                }
            }
            if ("1".equals(payOrderInfoDetailReqBO.getPayOrderStatus()) && (collect = payOrderInfoPOS.stream().filter(po -> po.getPayOrderType().equals("1")).collect(Collectors.toList())).size() > 0) {
                pfscExtRspBaseBO.setRespCode("18000");
                pfscExtRspBaseBO.setRespDesc("\u5b58\u5728\u5df2\u88ab\u8c03\u6574\u91d1\u989d\u7684\u5355\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
                return pfscExtRspBaseBO;
            }
        }
        try {
            if (payOrderInfoDetailReqBO.getPayOrderIds().size() > 0) {
                PayOrderInfoPO payOrderInfoPO = new PayOrderInfoPO();
                BeanUtils.copyProperties((Object)payOrderInfoDetailReqBO, (Object)payOrderInfoPO);
                if ("1".equals(payOrderInfoDetailReqBO.getPayOrderStatus())) {
                    payOrderInfoPO.setDeductionUserId(payOrderInfoDetailReqBO.getUserId());
                    payOrderInfoPO.setDeductionUserName(payOrderInfoDetailReqBO.getName());
                    payOrderInfoPO.setDeductionTime(new Date());
                    if (payOrderInfoDetailReqBO.getMemNickName() != null) {
                        payOrderInfoPO.setOperatorAlias(payOrderInfoDetailReqBO.getMemNickName());
                    }
                }
                if ("4".equals(payOrderInfoDetailReqBO.getPayOrderStatus())) {
                    payOrderInfoPO.setConfirmUserId(payOrderInfoDetailReqBO.getUserId());
                    payOrderInfoPO.setConfirmUserName(payOrderInfoDetailReqBO.getName());
                    payOrderInfoPO.setConfirmTime(new Date());
                    if (payOrderInfoDetailReqBO.getMemNickName() != null) {
                        payOrderInfoPO.setComfirmerAlias(payOrderInfoDetailReqBO.getMemNickName());
                    }
                }
                LOGGER.debug("update \u53c2\u6570\uff1a{}----{}", (Object)JSON.toJSONString((Object)payOrderInfoDetailReqBO.getPayOrderIds()), (Object)JSON.toJSONString((Object)payOrderInfoPO));
                this.payOrderInfoMapper.updateBatchInfo(payOrderInfoDetailReqBO.getPayOrderIds(), payOrderInfoPO);
                pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
                pfscExtRspBaseBO.setRespCode("0000");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u6574\u670d\u52a1\u8d39\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u8c03\u6574\u670d\u52a1\u8d39\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }

    private void checkAdjustClosingService(PayOrderInfoDetailReqBO payOrderInfoDetailReqBO) {
        List payOrderIds = payOrderInfoDetailReqBO.getPayOrderIds();
        if (payOrderIds != null && payOrderIds.size() > 0) {
            List collect;
            LOGGER.debug("\u6839\u636e\u8ba2\u5355list\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)payOrderIds));
            List<PayOrderInfoPO> payOrderInfoPOS = this.payOrderInfoMapper.selectListByIds(payOrderIds);
            LOGGER.debug("\u6839\u636e\u8ba2\u5355list\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(payOrderInfoPOS));
            if ("4".equals(payOrderInfoDetailReqBO.getPayOrderStatus())) {
                collect = payOrderInfoPOS.stream().filter(po -> po.getPayOrderStatus().equals("4")).collect(Collectors.toList());
                LOGGER.debug("\u5b58\u5728\u5df2\u88ab\u786e\u8ba4\u7684\u5355\u636e:{}", collect);
                if (collect.size() > 0) {
                    throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5df2\u88ab\u786e\u8ba4\u7684\u5355\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
                }
            }
            if ("1".equals(payOrderInfoDetailReqBO.getPayOrderStatus()) && (collect = payOrderInfoPOS.stream().filter(po -> po.getPayOrderType().equals("1")).collect(Collectors.toList())).size() > 0) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5df2\u88ab\u8c03\u6574\u91d1\u989d\u7684\u5355\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
            }
        }
    }

    @PostMapping(value={"updatePayOrderStatus"})
    public PfscExtRspBaseBO updatePayOrderStatus(@RequestBody PayOrderInfoDetailReqBO payOrderInfoDetailReqBO) {
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, -3);
            Date orderTime = c.getTime();
            PayOrderInfoPO payOrderInfo = new PayOrderInfoPO();
            payOrderInfo.setPayOrderStatus("0");
            payOrderInfo.setCreateTime(orderTime);
            List<Long> list = this.payOrderInfoMapper.selectByDate(payOrderInfo);
            if (list.size() > 0) {
                PayOrderInfoPO payOrderInfoPO = new PayOrderInfoPO();
                payOrderInfoPO.setDeductionTime(new Date());
                payOrderInfoPO.setDeductionUserName("\u7cfb\u7edf\u9ed8\u8ba4");
                this.payOrderInfoMapper.updatePayOrderStatus(list, payOrderInfoPO);
                pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
                pfscExtRspBaseBO.setRespCode("0000");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d8\u66f4\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u72b6\u6001\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }
}

