/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BatchApprovalApplyPayService;
import com.tydic.pfsc.api.busi.bo.BatchApprovalApplyPayReqBO;
import com.tydic.pfsc.api.busi.bo.BatchApprovalApplyPayRspBO;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.enums.ApplyPayStatus2;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BatchApprovalApplyPayService"})
public class BatchApprovalApplyPayServiceImpl
implements BatchApprovalApplyPayService {
    private static final Logger logger = LoggerFactory.getLogger(BatchApprovalApplyPayServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    @PostMapping(value={"batchApprovalApplyPay"})
    public BatchApprovalApplyPayRspBO batchApprovalApplyPay(@RequestBody BatchApprovalApplyPayReqBO reqBO) {
        BatchApprovalApplyPayRspBO rspBO = new BatchApprovalApplyPayRspBO();
        if (null == reqBO.getFlag()) {
            throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPayNos())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ApplyPayInfoPO> list = this.applyPayInfoMapper.getModelByIds(reqBO.getPayNos());
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u672a\u67e5\u627e\u5230\u76f8\u5173\u4ed8\u6b3e\u7533\u8bf7\u5355");
            return rspBO;
        }
        List payStatus = list.stream().map(ApplyPayInfoPO::getPayStatus).collect(Collectors.toList());
        long count = payStatus.stream().distinct().count();
        logger.debug("222======" + count);
        if (count > 1L) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e0d\u4e00\u81f4");
        }
        try {
            Integer flag = reqBO.getFlag();
            logger.debug("\u5ba1\u6279\u6807\u8bc6\uff1a" + flag);
            logger.debug("\u9a73\u56de\u539f\u56e0=====" + reqBO.getReason());
            ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
            applyPayInfoPO.setPayNos(reqBO.getPayNos());
            if (0 == flag) {
                if (StringUtils.isEmpty((Object)reqBO.getReason())) {
                    throw new PfscExtBusinessException("18000", "\u9a73\u56de\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                applyPayInfoPO.setPayStatus(ApplyPayStatus2.REJECT.getCode());
                applyPayInfoPO.setReasons(reqBO.getReason());
            } else if (1 == flag) {
                applyPayInfoPO.setPayStatus(ApplyPayStatus2.APPROVED.getCode());
            } else if (2 == flag) {
                applyPayInfoPO.setPayStatus(ApplyPayStatus2.PENDING_APPROVAL.getCode());
                applyPayInfoPO.setReasons("");
            }
            this.applyPayInfoMapper.updateStatusBatch(applyPayInfoPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6279\u5931\u8d25\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6279/\u9a73\u56de\u6210\u529f\uff01");
        return null;
    }
}

