/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiBackInvoiceAtourService;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceAtourReqBO;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceAtourRspBO;
import com.tydic.pfsc.api.busi.bo.InvoiceDetailsBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.PayOrderInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.SaleInvoiceDetailVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemApplyInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BusiOutstockService;
import com.tydic.pfsc.service.atom.InvoiceReturnAtomService;
import com.tydic.pfsc.service.busi.impl.BusiBackInvoiceDzcsInvoiceReturnService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiBackInvoiceAtourService"})
public class BusiBackInvoiceAtourServiceImpl
implements BusiBackInvoiceAtourService {
    private static final Logger log = LoggerFactory.getLogger(BusiBackInvoiceAtourServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired(required=false)
    private BusiOutstockService busiOutstockService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private InvoiceReturnAtomService invoiceReturnAtomService;
    @Autowired(required=false)
    private BusiBackInvoiceDzcsInvoiceReturnService busiBackInvoiceDzcsInvoiceReturnService;

    @PostMapping(value={"busiBackInvoiceAtour"})
    public BusiBackInvoiceAtourRspBO busiBackInvoiceAtour(@RequestBody BusiBackInvoiceAtourReqBO reqBO) {
        BusiBackInvoiceAtourRspBO rspBO = new BusiBackInvoiceAtourRspBO();
        if (reqBO == null && reqBO.getInvoiceMain() == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u53d1\u7968\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getInvoiceMain().getSalesbillNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7[bill_no]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getInvoiceMain().getInvoiceCode())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4ee3\u7801[invoiceCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String invoiceNo = reqBO.getInvoiceMain().getInvoiceNo();
        if (!StringUtils.hasText((String)invoiceNo)) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u53f7\u7801[invoiceNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceMain().getPaperDrewDate() == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u65e5\u671f[paperDrewDate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceMain().getAmountWithoutTax() == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09[amountWithoutTax]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceMain().getTaxRate() == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7a0e\u989d[taxRate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceMain().getStatus() == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u72b6\u6001[status]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String invoiceStatus = reqBO.getInvoiceMain().getStatus().toString();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            log.error("\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]");
        }
        String source = billApplyInfo.getSource();
        String applyType = billApplyInfo.getApplyType();
        String returnBillNo = billApplyInfo.getReturnBillNo();
        SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
        if ("0".equals(invoiceStatus)) {
            List<String> invoiceNos;
            if (saleInvoiceInfo == null) {
                log.error("\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("18000", "\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002");
            }
            SaleInvoiceInfo record = new SaleInvoiceInfo();
            record.setInvoiceNo(invoiceNo);
            record.setInvoiceStatus("2");
            this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(record);
            if (BillStatus.SEND_BILL.getCode().equals(billApplyInfo.getBillStatus()) && CollectionUtils.isEmpty(invoiceNos = this.saleInvoiceInfoMapper.getInvoiceNoByApplyNo(applyNo))) {
                BillApplyInfo billApply = new BillApplyInfo();
                billApply.setApplyNo(applyNo);
                billApply.setBillStatus(BillStatus.INVOICE_INVALID.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
            }
            return rspBO;
        }
        if (saleInvoiceInfo != null) {
            log.error("\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u63a8\u9001\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18000", "\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u63a8\u9001\u3002");
        }
        BigDecimal sumUntaxAmt = BigDecimal.ZERO;
        BigDecimal sumTaxAmt = BigDecimal.ZERO;
        for (InvoiceDetailsBO detailReqBO : reqBO.getInvoiceDetails()) {
            if (null == detailReqBO.getAmountWithoutTax()) {
                throw new PfscExtBusinessException("0001", "\u91d1\u989d(\u4e0d\u542b\u7a0e) [amountWithoutTax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == detailReqBO.getTaxAmount()) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u989d [taxAmount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == detailReqBO.getTaxRate()) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u7387 [taxRate]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)detailReqBO.getGoodsTaxNo())) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801 [goodsTaxNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)detailReqBO.getSalesbillItemNo())) {
                throw new PfscExtBusinessException("0001", "\u660e\u7ec6\u7f16\u53f7 [salesbillItemNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sumUntaxAmt = sumUntaxAmt.add(detailReqBO.getAmountWithoutTax());
            sumTaxAmt = sumTaxAmt.add(detailReqBO.getTaxAmount());
        }
        if (sumUntaxAmt.compareTo(reqBO.getInvoiceMain().getAmountWithoutTax()) != 0) {
            log.error("\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (sumTaxAmt.compareTo(reqBO.getInvoiceMain().getTaxAmount()) != 0) {
            log.error("\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        saleInvoiceInfo = new SaleInvoiceInfo();
        saleInvoiceInfo.setInvoiceNo(invoiceNo);
        saleInvoiceInfo.setInvoiceCode(reqBO.getInvoiceMain().getInvoiceCode());
        saleInvoiceInfo.setInvoiceDate(reqBO.getInvoiceMain().getPaperDrewDate());
        saleInvoiceInfo.setApplyNo(applyNo);
        saleInvoiceInfo.setUntaxAmt(reqBO.getInvoiceMain().getAmountWithoutTax());
        saleInvoiceInfo.setTaxAmt(reqBO.getInvoiceMain().getTaxAmount());
        saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
        saleInvoiceInfo.setInvoiceStatus("1");
        if ("s".equals(reqBO.getInvoiceMain().getInvoiceType())) {
            saleInvoiceInfo.setInvoiceType(2);
        } else {
            saleInvoiceInfo.setInvoiceType(1);
        }
        saleInvoiceInfo.setMailStatus("01");
        saleInvoiceInfo.setName(reqBO.getInvoiceMain().getSellerName());
        saleInvoiceInfo.setTaxNo(reqBO.getInvoiceMain().getSellerTaxNo());
        saleInvoiceInfo.setAddress(reqBO.getInvoiceMain().getSellerAddress());
        saleInvoiceInfo.setPhone(reqBO.getInvoiceMain().getSellerTel());
        saleInvoiceInfo.setBankName(reqBO.getInvoiceMain().getSellerBankName());
        saleInvoiceInfo.setBankAcNo(reqBO.getInvoiceMain().getSellerBankAccount());
        saleInvoiceInfo.setOrderId(reqBO.getInvoiceMain().getId().intValue());
        this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
        for (InvoiceDetailsBO detailBO : reqBO.getInvoiceDetails()) {
            Long itemNo = Long.parseLong(detailBO.getSalesbillItemNo());
            BigDecimal taxAmt = detailBO.getTaxAmount();
            BigDecimal untaxAmt = detailBO.getAmountWithoutTax();
            BigDecimal amount = taxAmt.add(untaxAmt);
            SaleItemInfoVO saleItemInfoVO = null;
            if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNo(applyNo);
                saleItemInfoVO.setItemNo(itemNo);
                saleItemInfoVO = this.saleItemInfoMapper.selectVOJoinSaleItemApplyInfo(saleItemInfoVO);
            } else {
                saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setItemNo(itemNo);
                saleItemInfoVO = this.saleItemInfoMapper.selectVO(saleItemInfoVO);
            }
            SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
            saleInvoiceDetail.setItemName(detailBO.getCargoName());
            saleInvoiceDetail.setSpecModel(detailBO.getItemSpec());
            saleInvoiceDetail.setUnitName(detailBO.getQuantityUnit());
            saleInvoiceDetail.setQuantity(detailBO.getQuantity());
            saleInvoiceDetail.setUntaxAmt(untaxAmt);
            saleInvoiceDetail.setTaxAmt(taxAmt);
            saleInvoiceDetail.setAmount(amount);
            saleInvoiceDetail.setTaxRate(detailBO.getTaxRate());
            saleInvoiceDetail.setTaxClassCode(detailBO.getGoodsTaxNo());
            saleInvoiceDetail.setItemNo(itemNo);
            saleInvoiceDetail.setInvoiceNo(invoiceNo);
            saleInvoiceDetail.setSaleUnitPrice(saleItemInfoVO.getSaleUnitPrice());
            this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
            SaleInvoiceDetailVO saleInvoiceDetailVO = new SaleInvoiceDetailVO();
            saleInvoiceDetailVO.setApplyNo(applyNo);
            saleInvoiceDetailVO.setItemNo(itemNo);
            saleInvoiceDetail = this.saleInvoiceDetailMapper.selectSumOfItem(saleInvoiceDetailVO);
            if ("2".equals(billApplyInfo.getPayFeeType())) continue;
            if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                SaleItemApplyInfoVO saleItemApplyInfoVO = new SaleItemApplyInfoVO();
                saleItemApplyInfoVO.setApplyNo(applyNo);
                saleItemApplyInfoVO.setSeq(saleItemInfoVO.getSeq());
                saleItemApplyInfoVO.setTaxAmt(saleInvoiceDetail.getTaxAmt());
                saleItemApplyInfoVO.setUntaxAmt(saleInvoiceDetail.getUntaxAmt());
                this.saleItemApplyInfoMapper.updateByVO(saleItemApplyInfoVO);
                continue;
            }
            this.saleItemInfoMapper.updateByConditions(saleInvoiceDetail.getTaxAmt(), saleInvoiceDetail.getUntaxAmt(), saleInvoiceDetail.getAmount(), saleItemInfoVO.getSeq());
        }
        if (BillStatus.SENDING_BILL.getCode().equals(billApplyInfo.getBillStatus())) {
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo);
            saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
            saleInvoiceInfo = this.saleInvoiceInfoMapper.selectSum(saleInvoiceInfoVO);
            if (saleInvoiceInfo.getAmt().compareTo(billApplyInfo.getAmt()) >= 0) {
                BillApplyInfo billApplyInfo1 = new BillApplyInfo();
                billApplyInfo1.setApplyNo(applyNo);
                billApplyInfo1.setBillStatus(BillStatus.SEND_BILL.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
            }
        }
        if ("2".equals(billApplyInfo.getPayFeeType())) {
            this.payOrderInfoMapper.updateBillStatus("6", applyNo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

