/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQryNotificationListService;
import com.tydic.pfsc.api.busi.bo.BusiQryNotificationListReqBO;
import com.tydic.pfsc.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfsc.api.busi.vo.InvoiceAttchVO;
import com.tydic.pfsc.base.PfscExtRspPageBaseBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.vo.Statis;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.PurchaseSaleType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.AntiSqlInjectionManage;
import com.tydic.pfsc.utils.BusinessUtils;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgAbilityBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umc.ability.org.UmcEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.UmcYdEnterpriseOrgQueryAbilityService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQryNotificationListService"})
public class BusiQryNotificationListServiceImpl
implements BusiQryNotificationListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQryNotificationListServiceImpl.class);
    private BillNotificationInfoMapper billNotificationInfoMapper;
    private EnumsService enumsService;
    private OrganizationInfoService organizationInfoService;
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcYdEnterpriseOrgQueryAbilityService UmcYdEnterpriseOrgQueryAbilityService;

    @Autowired
    public BusiQryNotificationListServiceImpl(BillNotificationInfoMapper billNotificationInfoMapper, EnumsService enumsService, OrganizationInfoService organizationInfoService, PayInvoiceInfoMapper payInvoiceInfoMapper) {
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.enumsService = enumsService;
        this.organizationInfoService = organizationInfoService;
        this.payInvoiceInfoMapper = payInvoiceInfoMapper;
    }

    @PostMapping(value={"qryNotifyList"})
    public PfscExtRspPageBaseBO<BillNotificationInfoVO> qryNotifyList(@RequestBody BusiQryNotificationListReqBO reqBO) {
        String invoiceNo;
        String orderBy;
        LOGGER.info("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-Session\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBO.getSupId()) {
            reqBO.setOperUnitNo(null);
        } else {
            Long operUnitNo = reqBO.getOperUnitNo();
            operUnitNo = BusinessUtils.judgeOperUnitNo(operUnitNo, reqBO.getCompanyId(), false);
            reqBO.setOperUnitNo(operUnitNo);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                LOGGER.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " APPLY_DATE desc,NOTIFICATION_NO desc";
        }
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        LinkedList<BillNotificationInfoVO> result = new LinkedList<BillNotificationInfoVO>();
        if (OrderSource.ELECTRIC_MARKET.equals((Object)reqBO.getSource())) {
            reqBO.setPurchaseSaleType(PurchaseSaleType.MINMARKET.getCode());
        }
        if (null != reqBO.getSupId()) {
            reqBO.setSupplierNo(reqBO.getSupId());
        }
        if (StringUtils.hasText((String)(invoiceNo = reqBO.getInvoiceNo()))) {
            List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByInvoiceNo(invoiceNo);
            if (invoices.size() > 0) {
                String notificationNo = invoices.get(0).getNotificationNo();
                reqBO.setNotificationNo(notificationNo);
            } else {
                rspPageBO.setTotal(Integer.valueOf(0));
                rspPageBO.setRecordsTotal(Integer.valueOf(0));
                rspPageBO.setPageNo(Integer.valueOf(1));
                return rspPageBO;
            }
        }
        List<BillNotificationInfo> resultPO = this.billNotificationInfoMapper.getListPage(reqBO, false, (Page<Map<String, Object>>)page, orderBy);
        for (BillNotificationInfo notifyInfo : resultPO) {
            BillNotificationInfoVO resultVO = new BillNotificationInfoVO();
            BeanUtils.copyProperties((Object)notifyInfo, (Object)resultVO);
            resultVO.setNotifInvoiceStatus(notifyInfo.getInvoiceStatus());
            NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(resultVO.getNotifInvoiceStatus());
            resultVO.setNotifInvoiceStatusStr(notifInvoiceEnum.getCodeDescr());
            String supplierStr = this.organizationInfoService.querySupplierName(resultVO.getSupplierNo());
            resultVO.setSupplierName(supplierStr);
            PurchaseSaleType purchaseSaleTypeEnum = PurchaseSaleType.getInstance(resultVO.getPurchaseSaleType());
            resultVO.setPurchaseSaleTypeStr(this.enumsService.getDescr(purchaseSaleTypeEnum));
            Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(notifyInfo.getNotificationNo());
            List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByNotifyNo(notifyInfo.getNotificationNo());
            if (invoices.size() > 0) {
                ArrayList<InvoiceAttchVO> attchVOSlist = new ArrayList<InvoiceAttchVO>();
                StringBuilder ivs = new StringBuilder();
                for (PayInvoiceInfo invoice : invoices) {
                    InvoiceAttchVO voattch = new InvoiceAttchVO();
                    voattch.setInvoiceCode(invoice.getInvoiceCode());
                    voattch.setInvoiceNo(invoice.getInvoiceNo());
                    voattch.setElectronicInvoiceName(null == invoice.getElectronicInvoiceName() ? "" : invoice.getElectronicInvoiceName());
                    voattch.setElectronicInvoiceUrl(null == invoice.getElectronicInvoiceUrl() ? "" : invoice.getElectronicInvoiceUrl());
                    attchVOSlist.add(voattch);
                }
                resultVO.setInoviceAttch(JSON.toJSONString(attchVOSlist));
            }
            if (null != ivStatis) {
                resultVO.setSumInvoiceAmt(ivStatis.getTotAmt());
            }
            if (null != resultVO.getStartOrgId() && !"".equals(resultVO.getStartOrgId())) {
                UmcEnterpriseOrgAbilityBO umcEnterpriseOrgAbilityBO;
                UmcEnterpriseOrgQueryAbilityReqBO umcEnterpriseOrgAbilityReqPageBO = new UmcEnterpriseOrgQueryAbilityReqBO();
                umcEnterpriseOrgAbilityReqPageBO.setOrgIdWeb(Long.valueOf(resultVO.getStartOrgId()));
                UmcEnterpriseOrgDetailAbilityRspBO umcEnterpriseOrgDetailAbilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcEnterpriseOrgAbilityReqPageBO);
                if (null != umcEnterpriseOrgDetailAbilityRspBO && null != (umcEnterpriseOrgAbilityBO = umcEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO())) {
                    resultVO.setStartOrgName(umcEnterpriseOrgAbilityBO.getOrgName());
                }
            }
            result.add(resultVO);
        }
        rspPageBO.setRows(result);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspPageBO.setRespCode("0000");
        rspPageBO.setRespDesc("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u6210\u529f");
        return rspPageBO;
    }
}

