/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.InvoiceReturnApplyService;
import com.tydic.pfsc.api.busi.bo.InvoiceReturnApplyReqBO;
import com.tydic.pfsc.api.busi.bo.InvoiceReturnApplyRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.InvoiceReturnApplyService"})
public class InvoiceReturnApplyServiceImpl
implements InvoiceReturnApplyService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnApplyServiceImpl.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillSNService billSNService;

    @PostMapping(value={"process"})
    public InvoiceReturnApplyRspBO process(@RequestBody InvoiceReturnApplyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        String applyNo = reqBO.getApplyNo();
        String type = reqBO.getType();
        String remark = reqBO.getRemark();
        String mailCompany = reqBO.getMailCompany();
        String mailTicketNo = reqBO.getMailTicketNo();
        String createUser = reqBO.getCreateUser();
        String createPhone = reqBO.getCreatePhone();
        String createOrg = reqBO.getCreateOrg();
        String invoiceAuth = reqBO.getInvoiceAuth();
        String saleCompanyName = reqBO.getSaleCompanyName();
        String saleCompanyId = reqBO.getSaleCompanyId();
        List invoiceNos = reqBO.getInvoiceNos();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)type)) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)invoiceAuth)) {
            throw new PfscExtBusinessException("0001", "\u4e13\u7968\u8ba4\u8bc1\u60c5\u51b5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createUser)) {
            throw new PfscExtBusinessException("0001", "\u7533\u8bf7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createPhone)) {
            throw new PfscExtBusinessException("0001", "\u7533\u8bf7\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)saleCompanyId)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)saleCompanyName)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)remark)) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)invoiceNos)) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        BillApplyInfo billApplyInfo1 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setInvoiceNoList(invoiceNos);
        List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        if (saleInvoiceInfos.size() < invoiceNos.size()) {
            throw new PfscExtBusinessException("0001", "\u52fe\u9009\u7684\u53d1\u7968\u4e0d\u5b58\u5728");
        }
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setInvoiceNo1s(invoiceNos);
        vo.setStatusNotIn(Arrays.asList(InvoiceReturnStatus.REJECTED.getCode(), InvoiceReturnStatus.CANCELED.getCode()));
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectListJoin(vo);
        if (!CollectionUtils.isEmpty(invoiceReturnDetails)) {
            ArrayList<String> invoiceNoList = new ArrayList<String>();
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                invoiceNoList.add(invoiceReturnDetail.getInvoiceNo1());
            }
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u53f7\u7801" + invoiceNoList + "\u5df2\u7ecf\u7533\u8bf7\u9000\u7968\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\u9000\u7968");
        }
        String billNo = this.billSNService.getSnAsString(BillType.INVOICE_RETURN);
        InvoiceReturn invoiceReturn = new InvoiceReturn();
        invoiceReturn.setBillNo(billNo);
        invoiceReturn.setType(type);
        invoiceReturn.setRemark(remark);
        invoiceReturn.setStatus(InvoiceReturnStatus.TO_APPROVE.getCode());
        invoiceReturn.setSupplierNo(billApplyInfo1.getSupplierNo());
        invoiceReturn.setOperUnitNo(billApplyInfo1.getOperUnitNo());
        invoiceReturn.setMailCompany(mailCompany);
        invoiceReturn.setMailTicketNo(mailTicketNo);
        invoiceReturn.setCreateUser(createUser);
        invoiceReturn.setCreatePhone(createPhone);
        invoiceReturn.setCreateOrg(createOrg);
        invoiceReturn.setCreateDate(new Date());
        invoiceReturn.setInvoiceAuth(invoiceAuth);
        invoiceReturn.setSaleCompanyName(saleCompanyName);
        invoiceReturn.setSaleCompanyId(Long.parseLong(saleCompanyId));
        invoiceReturn.setPurchaseName(billApplyInfo1.getPurchaseName());
        invoiceReturn.setPurchaseNo(billApplyInfo1.getPurchaseNo());
        invoiceReturn.setInvoiceType(billApplyInfo1.getInvoiceType());
        invoiceReturn.setApplyNo1(reqBO.getApplyNo());
        this.invoiceReturnMapper.insertSelective(invoiceReturn);
        for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
            InvoiceReturnDetail invoiceReturnDetail = new InvoiceReturnDetail();
            invoiceReturnDetail.setBillNo(billNo);
            invoiceReturnDetail.setApplyNo1(saleInvoiceInfo.getApplyNo());
            invoiceReturnDetail.setInvoiceNo1(saleInvoiceInfo.getInvoiceNo());
            this.invoiceReturnDetailMapper.insert(invoiceReturnDetail);
        }
        InvoiceReturnApplyRspBO rspBO = new InvoiceReturnApplyRspBO();
        rspBO.setBillNo(billNo);
        return rspBO;
    }
}

