/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.QryPageSaleInvoiceService;
import com.tydic.pfsc.api.busi.bo.DzcsQrySaleInvoiceDetailRspBO;
import com.tydic.pfsc.api.busi.bo.DzcsQrySaleInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.DzcsQrySaleInvoiceRspBO;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.RedBlue;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.QryPageSaleInvoiceService"})
public class QryPageSaleInvoiceServiceImpl
implements QryPageSaleInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(QryPageSaleInvoiceServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"query"})
    public DzcsQrySaleInvoiceRspBO query(@RequestBody DzcsQrySaleInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setApplyNo(reqBO.getApplyNo());
        List<SaleInvoiceInfoVO> saleInvoiceList = this.saleInvoiceInfoMapper.selectInvoiceAndBillInfoPage(saleInvoiceInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<DzcsQrySaleInvoiceDetailRspBO> rows = new ArrayList<DzcsQrySaleInvoiceDetailRspBO>();
        for (SaleInvoiceInfoVO saleInvoice : saleInvoiceList) {
            DzcsQrySaleInvoiceDetailRspBO row = new DzcsQrySaleInvoiceDetailRspBO();
            BeanUtils.copyProperties((Object)saleInvoice, (Object)row);
            row.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance((int)saleInvoice.getInvoiceType())));
            row.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(saleInvoice.getInvoiceClasses())));
            if (!StringUtils.hasText((String)saleInvoice.getRedBlue())) {
                saleInvoice.setRedBlue(RedBlue.BLUE.getCode());
            }
            row.setRedBlueDescr(this.enumsService.getDescr((BaseEnums)RedBlue.convert((String)saleInvoice.getRedBlue())));
            row.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoice.getInvoiceStatus())));
            rows.add(row);
        }
        DzcsQrySaleInvoiceRspBO rspBO = new DzcsQrySaleInvoiceRspBO();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

