/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.deal.impl;

import com.tydic.pfsc.api.busi.vo.InvoiceInfoVO;
import com.tydic.pfsc.api.deal.QueryPayInvoiceService;
import com.tydic.pfsc.api.deal.bo.BusiPayInvoiceInfoReqBO;
import com.tydic.pfsc.api.deal.bo.BusiPayInvoiceInfoRspBO;
import com.tydic.pfsc.api.deal.bo.PayInvoiceInfoBO;
import com.tydic.pfsc.api.deal.bo.PayItemInfoBO;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.deal.QueryPayInvoiceService"})
public class QueryPayInvoiceByNotifiNoServiceImpl
implements QueryPayInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayInvoiceByNotifiNoServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;

    @PostMapping(value={"selectByNotifyNo"})
    public BusiPayInvoiceInfoRspBO selectByNotifyNo(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String notificationNo = busiPayInvoiceInfoReqBO.getNotificationNo();
        ArrayList<PayInvoiceInfoBO> boList = new ArrayList<PayInvoiceInfoBO>();
        List<PayInvoiceInfo> ls = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        if (null != ls && ls.size() > 0) {
            for (PayInvoiceInfo payInvoiceInfo : ls) {
                PayInvoiceInfoBO bo = new PayInvoiceInfoBO();
                BeanUtils.copyProperties((Object)payInvoiceInfo, (Object)bo);
                boList.add(bo);
            }
        }
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        busiPayInvoiceInfoRspBO.setPayInvoiceInfoBOs(boList);
        busiPayInvoiceInfoRspBO.setRespCode("0000");
        busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        return busiPayInvoiceInfoRspBO;
    }

    @PostMapping(value={"deleteByPrimaryKey"})
    public BusiPayInvoiceInfoRspBO deleteByPrimaryKey(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO || null == busiPayInvoiceInfoReqBO.getPayInvoiceInfoBO()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayInvoiceInfoBO payInvoiceInfoBO = busiPayInvoiceInfoReqBO.getPayInvoiceInfoBO();
        try {
            this.payInvoiceInfoMapper.deleteByPrimaryKey(payInvoiceInfoBO.getInvoiceCode(), payInvoiceInfoBO.getInvoiceNo(), payInvoiceInfoBO.getInvoiceDate());
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5220\u9664\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        busiPayInvoiceInfoRspBO.setRespCode("0000");
        busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        return busiPayInvoiceInfoRspBO;
    }

    @PostMapping(value={"selectByPrimaryKey"})
    public BusiPayInvoiceInfoRspBO selectByPrimaryKey(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO || null == busiPayInvoiceInfoReqBO.getInvoiceInfoVO()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceInfoVO ivVo = busiPayInvoiceInfoReqBO.getInvoiceInfoVO();
        PayInvoiceInfoBO bo = new PayInvoiceInfoBO();
        PayInvoiceInfo payInvoiceInfo = this.payInvoiceInfoMapper.selectByPrimaryKey(ivVo.getInvoiceCode(), ivVo.getInvoiceNo(), ivVo.getInvoiceDate());
        if (payInvoiceInfo != null) {
            BeanUtils.copyProperties((Object)payInvoiceInfo, (Object)bo);
        }
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        busiPayInvoiceInfoRspBO.setPayInvoiceInfoBO(bo);
        busiPayInvoiceInfoRspBO.setRespCode("0000");
        busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        return busiPayInvoiceInfoRspBO;
    }

    @PostMapping(value={"batchInsert"})
    public BusiPayInvoiceInfoRspBO batchInsert(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO || null == busiPayInvoiceInfoReqBO.getNewIvDetails()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List newIvDetails = busiPayInvoiceInfoReqBO.getNewIvDetails();
        ArrayList<PayInvoiceInfo> list = new ArrayList<PayInvoiceInfo>();
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        try {
            if (null != newIvDetails && newIvDetails.size() > 0) {
                for (PayInvoiceInfoBO bo : newIvDetails) {
                    logger.error("bo" + bo);
                    PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
                    BeanUtils.copyProperties((Object)bo, (Object)invoiceInfo);
                    logger.error("invoiceInfo" + invoiceInfo);
                    list.add(invoiceInfo);
                }
            }
            this.payInvoiceInfoMapper.batchInsert(list);
            busiPayInvoiceInfoRspBO.setRespCode("0000");
            busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u65b0\u589e\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
        return busiPayInvoiceInfoRspBO;
    }

    @PostMapping(value={"updateByPrimaryKeySelective"})
    public BusiPayInvoiceInfoRspBO updateByPrimaryKeySelective(@RequestBody BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO) {
        if (null == busiPayInvoiceInfoReqBO || null == busiPayInvoiceInfoReqBO.getPayItemInfoBO()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            PayItemInfo payItemInfo = new PayItemInfo();
            PayItemInfoBO payItemInfoBO = busiPayInvoiceInfoReqBO.getPayItemInfoBO();
            BeanUtils.copyProperties((Object)payItemInfoBO, (Object)payItemInfo);
            int cnt = this.payItemInfoMapper.updateByPrimaryKeySelective(payItemInfo);
            if (cnt < 0) {
                throw new PfscExtBusinessException("0001", "\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = new BusiPayInvoiceInfoRspBO();
        busiPayInvoiceInfoRspBO.setRespCode("0000");
        busiPayInvoiceInfoRspBO.setRespDesc("\u6210\u529f");
        return busiPayInvoiceInfoRspBO;
    }
}

