/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.pay.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.pfsc.api.pay.CreatePayOrderService;
import com.tydic.pfsc.api.pay.bo.CreatePayOrderReqBO;
import com.tydic.pfsc.api.pay.bo.CreatePayOrderRspBO;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.OrgMerchantConfigMapper;
import com.tydic.pfsc.dao.PaymentFlowInfoMapper;
import com.tydic.pfsc.dao.PaymentLogMapper;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.OrgMerchantConfigPO;
import com.tydic.pfsc.dao.po.PaymentFlowInfo;
import com.tydic.pfsc.dao.po.PaymentLog;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.pay.CreatePayOrderService"})
public class CreatePayOrderServiceImpl
implements CreatePayOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CreatePayOrderServiceImpl.class);
    @Autowired
    private PayProOrderAbilityService payProOrderAbilityService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Value(value="${service_url}")
    private String service_url;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;

    @PostMapping(value={"createPayOrder"})
    public CreatePayOrderRspBO createPayOrder(@RequestBody CreatePayOrderReqBO reqBO) {
        CreatePayOrderRspBO rspBO = new CreatePayOrderRspBO();
        if (null == reqBO.getId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderNo = reqBO.getId();
        try {
            ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(orderNo);
            if (null == applyPayInfoPO.getPayAmt()) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0");
            }
            BigDecimal payAmtB = applyPayInfoPO.getPayAmt().multiply(new BigDecimal(100));
            BigDecimal payAmt = payAmtB.setScale(0, 1);
            OrgMerchantConfigPO orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(applyPayInfoPO.getCompanyId());
            String busiCode = orgMerchantConfigPO.getBusiCode();
            Long merchantId = orgMerchantConfigPO.getMerchantId();
            PaymentFlowInfo paymentFlowInfoPO = this.paymentFlowInfoMapper.selectByOutOrderId(orderNo);
            if (null != paymentFlowInfoPO && "SUCCESS".equals(paymentFlowInfoPO.getPaymentStatus())) {
                logger.error("\u8ba2\u5355[" + paymentFlowInfoPO.getOutOrderId() + "]\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u8ba2\u5355[" + paymentFlowInfoPO.getOutOrderId() + "]\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
                return rspBO;
            }
            PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo = new PayProOrderAbilityServiceReqBo();
            payProOrderAbilityServiceReqBo.setOutOrderId(orderNo);
            payProOrderAbilityServiceReqBo.setBusiCode(busiCode);
            payProOrderAbilityServiceReqBo.setMerchantId(String.valueOf(merchantId));
            payProOrderAbilityServiceReqBo.setTotalFee(payAmt.toString());
            payProOrderAbilityServiceReqBo.setDetailName("\u652f\u4ed8\u5355\u4ed8\u6b3e");
            payProOrderAbilityServiceReqBo.setRemark("");
            payProOrderAbilityServiceReqBo.setNotifyUrl(this.service_url);
            payProOrderAbilityServiceReqBo.setReqWay("1");
            payProOrderAbilityServiceReqBo.setPayMethod(reqBO.getPayMethod());
            payProOrderAbilityServiceReqBo.setCreateIpAddress(reqBO.getIpAddress());
            payProOrderAbilityServiceReqBo.setCreateOperId(String.valueOf(reqBO.getUserId()));
            payProOrderAbilityServiceReqBo.setCreateOperIdName(reqBO.getName());
            payProOrderAbilityServiceReqBo.setRedirectUrl(reqBO.getWebUrl());
            logger.error("\u8bf7\u6c42\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo = this.payProOrderAbilityService.dealOrder(payProOrderAbilityServiceReqBo);
            if (null == payProOrderAbilityServiceRspBo.getRespCode() || !payProOrderAbilityServiceRspBo.getRespCode().equals("0000")) {
                logger.error("\u521b\u5efa\u8ba2\u5355[" + orderNo + "]\u5931\u8d25,\uff1a" + payProOrderAbilityServiceRspBo.getRespDesc());
                this.savelog("CreatePayOrderService-197", JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                throw new PfscExtBusinessException("18000", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25:");
            }
            this.savelog("CreatePayOrderService-200", JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            logger.error("\u54cd\u5e94\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (null == paymentFlowInfoPO) {
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                paymentFlowInfo.setOutOrderId(orderNo);
                paymentFlowInfo.setPaymentFlowId(payProOrderAbilityServiceRspBo.getOrderId());
                paymentFlowInfo.setMerchantId(merchantId);
                paymentFlowInfo.setOrgId(reqBO.getOrgId());
                if (null == payProOrderAbilityServiceRspBo.getPayFee()) {
                    paymentFlowInfo.setOrderAmt(BigDecimal.ZERO);
                } else {
                    BigDecimal resultAmt = new BigDecimal(payProOrderAbilityServiceRspBo.getPayFee());
                    resultAmt = resultAmt.divide(new BigDecimal(100));
                    paymentFlowInfo.setOrderAmt(resultAmt);
                }
                paymentFlowInfo.setOrderDesc("\u652f\u4ed8\u5355\u4ed8\u6b3e");
                paymentFlowInfo.setPayChannel(reqBO.getPayChannel());
                paymentFlowInfo.setPayType(reqBO.getPayMethod());
                paymentFlowInfo.setWebUrl(reqBO.getWebUrl());
                paymentFlowInfo.setAsynUrl(this.service_url);
                paymentFlowInfo.setClientIp(reqBO.getIpAddress());
                paymentFlowInfo.setOrderRemark(payProOrderAbilityServiceRspBo.getRemark());
                paymentFlowInfo.setCreateUserId(reqBO.getUserId());
                paymentFlowInfo.setCreateUserName(reqBO.getName());
                paymentFlowInfo.setBusiReqData(payProOrderAbilityServiceRspBo.getBusiRspData());
                paymentFlowInfo.setPayOrderId(payProOrderAbilityServiceRspBo.getPayOrderId());
                paymentFlowInfo.setBankUrl(payProOrderAbilityServiceRspBo.getUrl());
                paymentFlowInfo.setBankFlowId(payProOrderAbilityServiceRspBo.getPayNotifyTransId());
                if (null != payProOrderAbilityServiceRspBo.getTradeTime()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = simpleDateFormat.parse(payProOrderAbilityServiceRspBo.getTradeTime());
                    paymentFlowInfo.setPayTime(date);
                }
                paymentFlowInfo.setCreateTime(new Date());
                paymentFlowInfo.setFlowFlag("00");
                paymentFlowInfo.setBusiCode(busiCode);
                this.paymentFlowInfoMapper.insertSelective(paymentFlowInfo);
            }
            String jsonStr2 = JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            logger.error("\u521b\u5efa\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\uff1a" + jsonStr2);
            rspBO = (CreatePayOrderRspBO)JSON.parseObject((String)jsonStr2, CreatePayOrderRspBO.class);
            logger.error("\u652f\u4ed8\u6e20\u9053\u8fd4\u56de\u7ed3\u679c\uff1a" + rspBO.toString());
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr2);
            JSONObject busiRspData = jsonObject.getJSONObject("busiRspData");
            String webUrl = busiRspData.getString("htmlBody");
            rspBO.setUrl(webUrl);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            this.savelog("CreatePayOrderService-248", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\uff1a" + e);
            this.savelog("CreatePayOrderService-252", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25:" + e);
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

