/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.pec.ability.bo.PebDealOrderBO;
import com.tydic.order.pec.bo.order.PebOrderApprovalReqBO;
import com.tydic.order.pec.bo.order.PebOrderApprovalRspBO;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.pfsc.api.busi.BatchApprovalApplyPayService;
import com.tydic.pfsc.api.busi.bo.BatchApprovalApplyPayReqBO;
import com.tydic.pfsc.api.busi.bo.BatchApprovalApplyPayRspBO;
import com.tydic.pfsc.api.busi.bo.DeptBO;
import com.tydic.pfsc.constants.FscCommonConstants;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.UocOrdBusiOperRecordMapper;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.BillNotificationInfoExt;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.UocOrdBusiOperRecord;
import com.tydic.pfsc.enums.ApplyPayStatus2;
import com.tydic.pfsc.enums.PayChannel;
import com.tydic.pfsc.enums.PayableStatus2;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.nc.api.NcPaymentNoteBillUpService;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpItemBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpReqBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpRspBO;
import com.tydic.pfsc.utils.MidDataPool;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.umcext.ability.org.UmcACompanyInfoDetailAbilityService;
import com.tydic.umcext.ability.org.UmcYdEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceReqBO;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BatchApprovalApplyPayService"})
public class BatchApprovalApplyPayServiceImpl
implements BatchApprovalApplyPayService {
    private static final Logger log = LoggerFactory.getLogger(BatchApprovalApplyPayServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BatchApprovalApplyPayServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private NcPaymentNoteBillUpService ncPaymentNoteBillUpService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private UmcYdEnterpriseOrgQueryAbilityService umcYdEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcACompanyInfoDetailAbilityService umcACompanyInfoDetailAbilityService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UocOrdBusiOperRecordMapper uocOrdBusiOperRecordMapper;

    @PostMapping(value={"batchApprovalApplyPay"})
    public BatchApprovalApplyPayRspBO batchApprovalApplyPay(@RequestBody BatchApprovalApplyPayReqBO reqBO) {
        BatchApprovalApplyPayRspBO rspBO = new BatchApprovalApplyPayRspBO();
        if (null == reqBO.getFlag()) {
            throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPayNos())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ApplyPayInfoPO> list = this.applyPayInfoMapper.getModelByIds(reqBO.getPayNos());
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u672a\u67e5\u627e\u5230\u76f8\u5173\u4ed8\u6b3e\u7533\u8bf7\u5355");
            return rspBO;
        }
        List payStatus = list.stream().map(ApplyPayInfoPO::getPayStatus).collect(Collectors.toList());
        long count = payStatus.stream().distinct().count();
        logger.debug("222======" + count);
        if (count > 1L) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e0d\u4e00\u81f4");
        }
        try {
            Integer flag = reqBO.getFlag();
            logger.debug("\u5ba1\u6279\u6807\u8bc6\uff1a" + flag);
            logger.debug("\u9a73\u56de\u539f\u56e0=====" + reqBO.getReason());
            if (2 == flag) {
                String payNo = (String)reqBO.getPayNos().get(0);
                this.applyPayInfoMapper.deleteById(payNo);
                BillNotificationInfo record = new BillNotificationInfo();
                record.setPayNo(payNo);
                record.setPayableStatus(PayableStatus2.NO_APPLY.getCode());
                this.billNotificationInfoMapper.updateByPayNo(record);
            } else {
                PebOrderApprovalRspBO approvalRspBO = new PebOrderApprovalRspBO();
                PebOrderApprovalReqBO approvalReqBO = new PebOrderApprovalReqBO();
                approvalReqBO.setAuditResult(flag);
                approvalReqBO.setOperId(reqBO.getUserId().toString());
                approvalReqBO.setUserId(reqBO.getUserId());
                approvalReqBO.setOperDept(reqBO.getOrgId().toString());
                approvalReqBO.setCompanyId(reqBO.getCompanyId());
                approvalReqBO.setCompanyName(reqBO.getCompanyName());
                approvalReqBO.setUsername(reqBO.getUsername());
                approvalReqBO.setApprovalRemark(reqBO.getReason());
                ArrayList<PebDealOrderBO> orderApprovalList = new ArrayList<PebDealOrderBO>();
                for (ApplyPayInfoPO payInfoPO : list) {
                    PebDealOrderBO pebDealOrderBO = new PebDealOrderBO();
                    pebDealOrderBO.setStepId(payInfoPO.getStepId());
                    pebDealOrderBO.setOrderId(Long.valueOf(payInfoPO.getPayno()));
                    pebDealOrderBO.setSaleVoucherId(Long.valueOf(payInfoPO.getPayno()));
                    orderApprovalList.add(pebDealOrderBO);
                }
                approvalReqBO.setOrderApprovalList(orderApprovalList);
                this.audit(approvalReqBO, approvalRspBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6279\u5931\u8d25\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6279/\u9a73\u56de\u6210\u529f\uff01");
        return null;
    }

    private void paymentNoteBillUp(ApplyPayInfoPO appo) {
        log.error("\u751f\u6210\u4ed8\u6b3e\u5355");
        BillNotificationInfoExt billNotificationInfoExt = new BillNotificationInfoExt();
        billNotificationInfoExt.setPayNo(appo.getPayno());
        List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.selectForPage(billNotificationInfoExt);
        if (billNotificationInfos != null && billNotificationInfos.size() > 0) {
            for (BillNotificationInfo bio : billNotificationInfos) {
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setNotificationNo(bio.getNotificationNo());
                log.error(payPurchaseOrderInfo.toString());
                List<PayPurchaseOrderInfo> payPurchaseOrderInfoList2 = this.payPurchaseOrderInfoMapper.getList2(payPurchaseOrderInfo);
                if (payPurchaseOrderInfoList2 == null || payPurchaseOrderInfoList2.size() <= 0) continue;
                for (PayPurchaseOrderInfo poo : payPurchaseOrderInfoList2) {
                    UmcACompanyInfoDetailAbilityServiceReqBO umcACompanyInfoDetailAbilityServiceReqBO = new UmcACompanyInfoDetailAbilityServiceReqBO();
                    umcACompanyInfoDetailAbilityServiceReqBO.setCompanyId(poo.getPurchaseCompanyId());
                    log.error("getDetailACompanyInfo\u65b9\u6cd5\u5165\u53c2==" + umcACompanyInfoDetailAbilityServiceReqBO);
                    UmcACompanyInfoDetailAbilityServiceRspBO detailACompanyInfo = this.umcACompanyInfoDetailAbilityService.getDetailACompanyInfo(umcACompanyInfoDetailAbilityServiceReqBO);
                    log.error("detailACompanyInfo\u65b9\u6cd5\u51fa\u53c2==" + detailACompanyInfo);
                    NcPaymentNoteBillUpReqBO ncPaymentNoteBillUpReqBO = new NcPaymentNoteBillUpReqBO();
                    NcPaymentNoteBillUpBO ncPaymentNoteBillUpBO = new NcPaymentNoteBillUpBO();
                    ArrayList<NcPaymentNoteBillUpItemBO> ncPaymentNoteBillUpItemBOS = new ArrayList<NcPaymentNoteBillUpItemBO>();
                    ncPaymentNoteBillUpReqBO.setId(appo.getPayno());
                    UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = new UmcQrySupplierInfoDetailAbilityRspBO();
                    String supplierCode = "";
                    String outsideOnlineRetailersPower = "";
                    String replaceSupplierCode = "";
                    try {
                        UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
                        umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(poo.getSupplierNo());
                        log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u8be6\u60c5\u5165\u53c2" + umcQrySupplierInfoDetailAbilityReqBO);
                        umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
                        log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u8be6\u60c5\u51fa\u53c2" + umcQrySupplierInfoDetailAbilityRspBO);
                        supplierCode = umcQrySupplierInfoDetailAbilityRspBO.getSupplierCode();
                        outsideOnlineRetailersPower = umcQrySupplierInfoDetailAbilityRspBO.getOutsideOnlineRetailersPower();
                        replaceSupplierCode = null;
                        if (supplierCode != null) {
                            replaceSupplierCode = supplierCode.replace("NC-", "");
                        }
                    }
                    catch (Exception e) {
                        log.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u8be6\u60c5\u62a5\u9519===================================");
                    }
                    UmcYdEnterpriseOrgQueryAbilityReqBO umcYdEnterpriseOrgQueryAbilityReqBO = new UmcYdEnterpriseOrgQueryAbilityReqBO();
                    umcYdEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(poo.getPurchaseNo());
                    log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u5165\u53c2" + umcYdEnterpriseOrgQueryAbilityReqBO);
                    UmcYdEnterpriseOrgDetailAbilityRspBO umcYdEnterpriseOrgDetailAbilityRspBO = this.umcYdEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcYdEnterpriseOrgQueryAbilityReqBO);
                    log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2" + umcYdEnterpriseOrgDetailAbilityRspBO);
                    String orgType = "";
                    if (umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                        orgType = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgType();
                    }
                    String pk_deptid = null;
                    String saleCompanyCode = "";
                    String saleCompanyId = String.valueOf(poo.getPurchaseCompanyId());
                    saleCompanyCode = "522125381650792448".equals(saleCompanyId) ? "605" : "606";
                    log.error("\u8c03\u7528nc\u89c6\u56fe\u5f00\u59cb======================");
                    log.error("\u7532\u65b9\u62ac\u5934\u7f16\u7801saleCompanyCode==" + saleCompanyCode);
                    List saleCompanyIdList = MidDataPool.getJdbcTemplatePre().query("select orgcode,orgname,deptcode,deptname from v_b2b_dept where orgcode ='" + saleCompanyCode + "';", (RowMapper)new BeanPropertyRowMapper(DeptBO.class));
                    if (saleCompanyIdList != null && saleCompanyIdList.size() > 0) {
                        log.error("saleCompanyIdList.size" + saleCompanyIdList.size());
                        for (DeptBO dbo : saleCompanyIdList) {
                            if (saleCompanyCode.equals("605")) {
                                if (!dbo.getDeptcode().equals("BM0201")) continue;
                                pk_deptid = dbo.getDeptcode();
                                continue;
                            }
                            if (!dbo.getDeptcode().equals("9013")) continue;
                            pk_deptid = dbo.getDeptcode();
                        }
                    }
                    log.error("\u8c03\u7528nc\u89c6\u56fe\u7ed3\u675f======================");
                    Date d = new Date();
                    System.out.println(d);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String dateNowStr = sdf.format(d);
                    ncPaymentNoteBillUpBO.setBilldate(dateNowStr);
                    ncPaymentNoteBillUpBO.setBillmaker("B2B");
                    ncPaymentNoteBillUpBO.setCreator("B2B");
                    ncPaymentNoteBillUpBO.setBillstatus(0);
                    ncPaymentNoteBillUpBO.setIsinit("N");
                    ncPaymentNoteBillUpBO.setIsreded("N");
                    ncPaymentNoteBillUpBO.setLocal_money(poo.getOrderAmt());
                    ncPaymentNoteBillUpBO.setMoney(poo.getOrderAmt());
                    ncPaymentNoteBillUpBO.setObjtype(1);
                    ncPaymentNoteBillUpBO.setPk_tradetype("F3-Cxx-03");
                    ncPaymentNoteBillUpBO.setPk_billtype("F3");
                    ncPaymentNoteBillUpBO.setPk_balatype("3");
                    ncPaymentNoteBillUpBO.setPk_currtype("CNY");
                    ncPaymentNoteBillUpBO.setPk_deptid(pk_deptid);
                    ncPaymentNoteBillUpBO.setPk_group("000");
                    ncPaymentNoteBillUpBO.setPk_org(saleCompanyCode);
                    ncPaymentNoteBillUpBO.setSrc_syscode(0);
                    ncPaymentNoteBillUpBO.setSyscode(0);
                    ncPaymentNoteBillUpBO.setPayaccount(detailACompanyInfo.getBankAccount());
                    ncPaymentNoteBillUpBO.setRecaccount(appo.getReceiptAcctNo());
                    if (appo.getRemark() != null) {
                        ncPaymentNoteBillUpBO.setDef10(appo.getRemark());
                    } else {
                        ncPaymentNoteBillUpBO.setDef10("");
                    }
                    ncPaymentNoteBillUpBO.setDef6(appo.getPayno());
                    ncPaymentNoteBillUpBO.setSupplier(replaceSupplierCode);
                    List<PayItemInfo> payItemInfoList = this.payItemInfoMapper.selectByNotifNoAndOrderId(bio.getNotificationNo(), poo.getOrderId(), poo.getInspectionId());
                    if (payItemInfoList != null && payItemInfoList.size() > 0) {
                        for (PayItemInfo pif : payItemInfoList) {
                            NcPaymentNoteBillUpItemBO ncPaymentNoteBillUpItemBO = new NcPaymentNoteBillUpItemBO();
                            ncPaymentNoteBillUpItemBO.setLocal_money_bal(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setLocal_money_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setLocal_notax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setMoney_bal(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setMoney_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setObjtype(1);
                            ncPaymentNoteBillUpItemBO.setGlobaldebit(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGlobalnotax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGroupdebit(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGroupnotax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setPk_currtype("CNY");
                            ncPaymentNoteBillUpItemBO.setPk_deptid(pk_deptid);
                            ncPaymentNoteBillUpItemBO.setPk_org(saleCompanyCode);
                            ncPaymentNoteBillUpItemBO.setPk_tradetype("F3-Cxx-03");
                            ncPaymentNoteBillUpItemBO.setSett_org(saleCompanyCode);
                            ncPaymentNoteBillUpItemBO.setPrepay("0");
                            ncPaymentNoteBillUpItemBO.setPk_balatype("3");
                            if (umcQrySupplierInfoDetailAbilityRspBO != null) {
                                ncPaymentNoteBillUpItemBO.setSupplier(replaceSupplierCode);
                            } else {
                                ncPaymentNoteBillUpItemBO.setSupplier("");
                            }
                            ncPaymentNoteBillUpItemBO.setPayaccount(detailACompanyInfo.getBankAccount());
                            ncPaymentNoteBillUpItemBO.setRecaccount(appo.getReceiptAcctNo());
                            ncPaymentNoteBillUpItemBO.setScomment(appo.getPayno());
                            ncPaymentNoteBillUpItemBO.setPk_recpaytype("01");
                            ncPaymentNoteBillUpItemBO.setDef2(poo.getInspectionCode());
                            if (outsideOnlineRetailersPower != null) {
                                if (outsideOnlineRetailersPower.equals("1")) {
                                    ncPaymentNoteBillUpItemBO.setDef27("02");
                                } else if (outsideOnlineRetailersPower.equals("2")) {
                                    ncPaymentNoteBillUpItemBO.setDef27("01");
                                }
                            }
                            ncPaymentNoteBillUpItemBO.setDef28(orgType);
                            ncPaymentNoteBillUpItemBOS.add(ncPaymentNoteBillUpItemBO);
                        }
                    }
                    ncPaymentNoteBillUpReqBO.setBillHead(ncPaymentNoteBillUpBO);
                    ncPaymentNoteBillUpReqBO.setItem(ncPaymentNoteBillUpItemBOS);
                    String ncPaymentNoteBillUpReqBOJson = JSONArray.toJSON((Object)ncPaymentNoteBillUpReqBO).toString();
                    log.error("\u4ed8\u6b3e\u5355json=====" + ncPaymentNoteBillUpReqBOJson);
                    NcPaymentNoteBillUpRspBO ncPaymentNoteBillUpRspBO = this.ncPaymentNoteBillUpService.paymentNoteBillUp(ncPaymentNoteBillUpReqBO);
                    if (!ncPaymentNoteBillUpRspBO.getRespCode().equals("8888")) continue;
                    log.error("\u63a8\u9001\u4ed8\u6b3e\u5355\u62a5\u9519================================================");
                }
            }
        }
    }

    private void audit(PebOrderApprovalReqBO reqBO, PebOrderApprovalRspBO rspBO) {
        logger.debug("\u5ba1\u6279\u63a5\u53e3\u5165\u53c21===" + reqBO.getOrderApprovalList().toString());
        List orderApprovalList = reqBO.getOrderApprovalList();
        Map<String, List<PebDealOrderBO>> map = orderApprovalList.stream().collect(Collectors.groupingBy(PebDealOrderBO::getStepId));
        logger.debug("\u5ba1\u6279\u63a5\u53e3\u5165\u53c22===" + map.toString());
        for (String key : map.keySet()) {
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            uacNoTaskAuditOrderAuditReqBO.setStepId(key);
            uacNoTaskAuditOrderAuditReqBO.setAuditResult(reqBO.getAuditResult());
            uacNoTaskAuditOrderAuditReqBO.setOperId(reqBO.getOperId());
            uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getOperName());
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApprovalRemark());
            uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOperDept());
            uacNoTaskAuditOrderAuditReqBO.setObjType(FscCommonConstants.OBJ_TYPE.FSC_APPLY_PAY_APPROVAL);
            ArrayList<Long> objIds = new ArrayList<Long>();
            HashMap<String, BigDecimal> variables = new HashMap<String, BigDecimal>();
            for (PebDealOrderBO id : map.get(key)) {
                objIds.add(id.getSaleVoucherId());
                ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(id.getOrderId().toString());
                variables.put("amountFlag", applyPayInfoPO.getPayAmt());
            }
            uacNoTaskAuditOrderAuditReqBO.setVariables(variables);
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
            logger.debug("\u5ba1\u6279\u63a5\u53e3\u5165\u53c23===" + uacNoTaskAuditOrderAuditReqBO.toString());
            UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
            if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
                throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
            }
            this.dealSuccess(map.get(key), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish(), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId(), reqBO, rspBO);
        }
    }

    private void dealSuccess(List<PebDealOrderBO> list, boolean finish, String stepId, PebOrderApprovalReqBO reqBO, PebOrderApprovalRspBO rspBO) {
        ArrayList result = new ArrayList();
        for (PebDealOrderBO pebDealOrderBO : list) {
            ApplyPayInfoPO applyPayInfoPO;
            if (finish) {
                if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
                    applyPayInfoPO = new ApplyPayInfoPO();
                    applyPayInfoPO.setPayno(pebDealOrderBO.getOrderId().toString());
                    applyPayInfoPO.setPayStatus(ApplyPayStatus2.REJECT.getCode());
                    applyPayInfoPO.setReasons(reqBO.getApprovalRemark());
                    this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                } else {
                    applyPayInfoPO = new ApplyPayInfoPO();
                    applyPayInfoPO.setPayno(pebDealOrderBO.getOrderId().toString());
                    applyPayInfoPO.setPayStatus(ApplyPayStatus2.APPROVED.getCode());
                    this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                    ApplyPayInfoPO payInfoPO = this.applyPayInfoMapper.getModelById(pebDealOrderBO.getOrderId().toString());
                    if (ApplyPayStatus2.APPROVED.getCode().equals(payInfoPO.getPayStatus()) && PayChannel.NC.getCode().equals(payInfoPO.getPayChannel())) {
                        this.paymentNoteBillUp(payInfoPO);
                    }
                }
                BillNotificationInfo record = new BillNotificationInfo();
                record.setPayNo(pebDealOrderBO.getOrderId().toString());
                record.setPayableStatus(PayableStatus2.APPLIED.getCode());
                this.billNotificationInfoMapper.updateByPrimaryKeySelective(record);
            } else {
                applyPayInfoPO = new ApplyPayInfoPO();
                applyPayInfoPO.setPayno(pebDealOrderBO.getOrderId().toString());
                applyPayInfoPO.setStepId(stepId);
                this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
            }
            rspBO.setOrderApprovalList(result);
            this.recordProcessInfo(pebDealOrderBO, reqBO);
        }
    }

    private void recordProcessInfo(PebDealOrderBO pebDealOrderBO, PebOrderApprovalReqBO reqBO) {
        UocOrdBusiOperRecord record = new UocOrdBusiOperRecord();
        record.setRecordType(PebExtConstant.RecordType.ONE);
        record.setOrderId(pebDealOrderBO.getOrderId());
        record.setObjId(pebDealOrderBO.getOrderId());
        record.setObjType(FscCommonConstants.OBJ_TYPE.FSC_APPLY_PAY_APPROVAL);
        record.setCreateTime(new Date());
        record.setDealTime(new Date());
        record.setDealOperId(reqBO.getUserIdIn() + "");
        record.setDealOperName(reqBO.getUsername());
        record.setDealDeptId(reqBO.getOrgIdIn() + "");
        record.setDealDeptName(reqBO.getOrgName() + "");
        record.setDealCompId(reqBO.getCompanyId() + "");
        record.setDealCompName(reqBO.getCompanyName());
        record.setDealTypeId(PebExtConstant.RecordType.ONE + "");
        record.setDealName("\u8ba2\u5355\u5ba1\u6279");
        if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
            record.setDealDesc("\u5ba1\u6279\u62d2\u7edd");
            record.setDealReason(reqBO.getApprovalRemark());
        } else {
            record.setDealDesc("\u5ba1\u6279\u901a\u8fc7");
        }
        this.uocOrdBusiOperRecordMapper.insertSelective(record);
    }
}

