/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiBatMigrationService;
import com.tydic.pfsc.api.busi.bo.BusiBatMigrationReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.MigrationSubAcctMapper;
import com.tydic.pfsc.dao.po.MigrationSubAcct;
import com.tydic.pfsc.dao.po.SubAcctInfo;
import com.tydic.pfsc.enums.CompanyType;
import com.tydic.pfsc.service.atom.SubAccountService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiBatMigrationServiceImpl
implements BusiBatMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(BusiBatMigrationServiceImpl.class);
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private MigrationSubAcctMapper migrationSubAcctMapper;

    public PfscExtRspBaseBO addBatMigration(BusiBatMigrationReqBO reqBO) {
        List<MigrationSubAcct> list = this.migrationSubAcctMapper.selectAll();
        for (MigrationSubAcct msa : list) {
            SubAcctInfo subAcctInfo = new SubAcctInfo();
            subAcctInfo.setOrgId(msa.getOrgId());
            subAcctInfo.setMainAcctNo(msa.getMainAcctNo());
            subAcctInfo.setProjectId(msa.getProjectId());
            subAcctInfo.setServiceType(msa.getServiceType());
            subAcctInfo.setCompanyType(CompanyType.PURCHASER.getCode());
            subAcctInfo.setSubAcctName(msa.getSubAcctName());
            subAcctInfo.setOverdraft(BigDecimal.ZERO);
            if (msa.getServiceType() == 99 || "1".equals(msa.getFailMsg())) {
                subAcctInfo.setOverdraft(new BigDecimal("99999999999999999.99"));
            }
            MigrationSubAcct migrationSubAcct = new MigrationSubAcct();
            try {
                subAcctInfo = this.subAccountService.addSubAccount(subAcctInfo);
                migrationSubAcct.setId(msa.getId());
                migrationSubAcct.setStatus("01");
                this.migrationSubAcctMapper.updateByPrimaryKeySelective(migrationSubAcct);
                logger.info("\u521b\u5efa\u5b50\u8d26\u53f7\u6210\u529f:ORG_ID = " + subAcctInfo.getOrgId() + " PROJECT_ID = " + subAcctInfo.getProjectId() + " MAIN_ACCT_NO = " + subAcctInfo.getMainAcctNo() + " SUB_ACCT_NAME = " + subAcctInfo.getSubAcctName() + " SERVICE_TYPE = " + subAcctInfo.getServiceType());
            }
            catch (Exception e) {
                migrationSubAcct.setId(msa.getId());
                migrationSubAcct.setStatus("02");
                migrationSubAcct.setFailMsg(e.getMessage().substring(0, e.getMessage().length() < 200 ? e.getMessage().length() : 200));
                this.migrationSubAcctMapper.updateByPrimaryKeySelective(migrationSubAcct);
                logger.error("\u521b\u5efa\u5b50\u8d26\u53f7\u5931\u8d25:ORG_ID = " + subAcctInfo.getOrgId() + " PROJECT_ID = " + subAcctInfo.getProjectId() + " MAIN_ACCT_NO = " + subAcctInfo.getMainAcctNo() + " SUB_ACCT_NAME = " + subAcctInfo.getSubAcctName() + " SERVICE_TYPE = " + subAcctInfo.getServiceType() + " \u5f02\u5e38\u4fe1\u606f\uff1a" + e);
            }
        }
        return new PfscExtRspBaseBO();
    }
}

