/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfsc.api.busi.BusiPushPayPurchaseOrderInfoService;
import com.tydic.pfsc.api.busi.bo.BusiPushPayPurchaseOrderInfoItemReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPushPayPurchaseOrderInfoOrderReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPushPayPurchaseOrderInfoReqBO;
import com.tydic.pfsc.api.busi.bo.DeptBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.vo.PayItemInfoVO;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.OrderStatus2;
import com.tydic.pfsc.enums.PurchaseSaleType;
import com.tydic.pfsc.enums.ReconciliationStatus;
import com.tydic.pfsc.enums.SaleOrderPayType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.nc.api.NcAccountsPayableBillUpService;
import com.tydic.pfsc.external.nc.api.bo.NcAccountsPayableBillUpBO;
import com.tydic.pfsc.external.nc.api.bo.NcAccountsPayableBillUpItemBO;
import com.tydic.pfsc.external.nc.api.bo.NcAccountsPayableBillUpReqBO;
import com.tydic.pfsc.external.nc.api.bo.NcAccountsPayableBillUpRspBO;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.MidDataPool;
import com.tydic.umcext.ability.org.UmcYdEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiPushPayPurchaseOrderInfoService"})
public class BusiPushPayPurchaseOrderInfoServiceImpl
implements BusiPushPayPurchaseOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiPushPayPurchaseOrderInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiPushPayPurchaseOrderInfoServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private NcAccountsPayableBillUpService ncAccountsPayableBillUpService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private UmcYdEnterpriseOrgQueryAbilityService umcYdEnterpriseOrgQueryAbilityService;
    @Resource(name="frameOrderIdSeq")
    private OrderSequence frameOrderIdSeqSeqService;

    @PostMapping(value={"add"})
    public PfscExtRspBaseBO add(@RequestBody BusiPushPayPurchaseOrderInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        NcAccountsPayableBillUpReqBO ncAccountsPayableBillUpReqBO = new NcAccountsPayableBillUpReqBO();
        NcAccountsPayableBillUpBO ncAccountsPayableBillUpBO = new NcAccountsPayableBillUpBO();
        ArrayList<NcAccountsPayableBillUpItemBO> ncItemBOList = new ArrayList<NcAccountsPayableBillUpItemBO>();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiPushPayPurchaseOrderInfoOrderReqBO orderInfo = reqBO.getOrderInfo();
        if (orderInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = orderInfo.getOrderId();
        Long inspectionId = orderInfo.getInspectionId();
        String inspectionCode = orderInfo.getInspectionCode();
        if (orderId == null || orderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inspectionId == null || inspectionId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inspectionCode == null || "".equals(inspectionCode)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u9a8c\u6536\u5355\u53f7\u3010inspectionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList itemList = reqBO.getItemList();
        if (itemList == null || itemList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u5546\u54c1\u4fe1\u606f\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long purchaseCompanyId = orderInfo.getPurchaseCompanyId();
        String purchaseCompanyName = orderInfo.getPurchaseCompanyName();
        if (purchaseCompanyId == null || purchaseCompanyId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u7532\u65b9\u53d1\u7968\u53f7\u3010purchaseCompanyId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseCompanyName == null || "".equals(purchaseCompanyName)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u7532\u65b9\u53d1\u7968\u540d\u79f0\u3010purchaseCompanyName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, BusiPushPayPurchaseOrderInfoItemReqBO> itemMap = new HashMap<Long, BusiPushPayPurchaseOrderInfoItemReqBO>(itemList.size() + 1);
        BigDecimal orderDealServiceFee = BigDecimal.ZERO;
        for (BusiPushPayPurchaseOrderInfoItemReqBO itemInfo : itemList) {
            if (!itemMap.containsKey(itemInfo.getItemNo())) {
                itemMap.put(itemInfo.getItemNo(), itemInfo);
            } else {
                BusiPushPayPurchaseOrderInfoItemReqBO itemInMap = (BusiPushPayPurchaseOrderInfoItemReqBO)itemMap.get(itemInfo.getItemNo());
                itemInMap.setQuantity(itemInMap.getQuantity().add(itemInfo.getQuantity()));
                itemInMap.setAmount(itemInMap.getAmount().add(itemInfo.getAmount()));
            }
            if (null != itemInfo.getCommDealServiceFeeRate()) {
                BigDecimal commDealServiceFee = itemInfo.getAmount().multiply(itemInfo.getCommDealServiceFeeRate()).divide(new BigDecimal(100));
                itemInfo.setCommDealServiceFee(commDealServiceFee);
                orderDealServiceFee = orderDealServiceFee.add(commDealServiceFee);
                continue;
            }
            itemInfo.setCommDealServiceFee(BigDecimal.ZERO);
        }
        itemList = new ArrayList(itemMap.values());
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo.setInspectionId(inspectionId);
        payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
        PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setInspectionId(inspectionId);
        ArrayList<String> itemStatusNotIn = new ArrayList<String>();
        itemStatusNotIn.add(OrderStatus.NO_APPLY.getCode());
        payItemInfoVO.setItemStatusNotIn(itemStatusNotIn);
        int count = this.payItemInfoMapper.selectCount(payItemInfoVO);
        if (payPurchaseOrderInfo != null) {
            if (count > 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u901a\u77e5\u3002");
                throw new PfscExtBusinessException("18000", "\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u901a\u77e5\u3002");
            }
            PayItemInfo payItemInfo = new PayItemInfo();
            payItemInfo.setInspectionId(inspectionId);
            this.payItemInfoMapper.deleteBy(payItemInfo);
            payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setInspectionId(inspectionId);
            this.payPurchaseOrderInfoMapper.deleteBy(payPurchaseOrderInfo);
        }
        String source = orderInfo.getSource();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setOrderId(orderId);
            payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
            if (payPurchaseOrderInfo != null) {
                payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setOrderId(orderId);
                this.payPurchaseOrderInfoMapper.deleteBy(payPurchaseOrderInfo);
                PayItemInfo payItemInfo = new PayItemInfo();
                payItemInfo.setOrderId(orderId);
                this.payItemInfoMapper.deleteBy(payItemInfo);
            }
        }
        payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)payPurchaseOrderInfo);
        payPurchaseOrderInfo.setBusiModel(orderInfo.getBusiMode());
        String orgName = this.organizationInfoService.queryOrgName(payPurchaseOrderInfo.getOperUnitNo());
        payPurchaseOrderInfo.setOperUnitName(orgName);
        payPurchaseOrderInfo.setNotificationNo(null);
        payPurchaseOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        payPurchaseOrderInfo.setReconcilitionStatus(ReconciliationStatus.NOT_RECONCILED.getCode());
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            List<Long> childrenOrgIds = this.organizationInfoService.getChildrenOrgIds(payPurchaseOrderInfo.getOperUnitNo());
            if (childrenOrgIds != null && childrenOrgIds.contains(payPurchaseOrderInfo.getPurchaseNo())) {
                payPurchaseOrderInfo.setPurchaseSaleType(PurchaseSaleType.SELFUSE.getCode());
            } else {
                payPurchaseOrderInfo.setPurchaseSaleType(PurchaseSaleType.MINMARKET.getCode());
            }
        } else if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            Object branchCompany = this.organizationInfoService.queryBranchCompanyByAccountId(payPurchaseOrderInfo.getPurchaseProjectId());
            payPurchaseOrderInfo.setBranchCompany((Long)branchCompany);
        }
        if (null != payPurchaseOrderInfo.getPayType()) {
            switch (payPurchaseOrderInfo.getPayType()) {
                case "0": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BANK_RECEIVE.getCode());
                    break;
                }
                case "1": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BILL_AGREEMENT.getCode());
                    break;
                }
                case "2": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BILL_RECEIVE.getCode());
                }
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3010payType\u3011");
        }
        payPurchaseOrderInfo.setPayStatus("00");
        payPurchaseOrderInfo.setIsPayFlag("2");
        payPurchaseOrderInfo.setOrderDealServiceFee(orderDealServiceFee);
        this.payPurchaseOrderInfoMapper.insert(payPurchaseOrderInfo);
        Long purchaseCompanyId1 = payPurchaseOrderInfo.getPurchaseCompanyId();
        String pk_deptid = null;
        String saleCompanyCode = "";
        UmcYdEnterpriseOrgQueryAbilityReqBO umcYdEnterpriseOrgQueryAbilityReqBO = new UmcYdEnterpriseOrgQueryAbilityReqBO();
        umcYdEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(reqBO.getOrderInfo().getPurchaseNo());
        log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u5165\u53c2" + umcYdEnterpriseOrgQueryAbilityReqBO);
        UmcYdEnterpriseOrgDetailAbilityRspBO umcYdEnterpriseOrgDetailAbilityRspBO = this.umcYdEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcYdEnterpriseOrgQueryAbilityReqBO);
        log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2" + umcYdEnterpriseOrgDetailAbilityRspBO);
        String orgType = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgType();
        saleCompanyCode = "522125381650792448".equals(String.valueOf(purchaseCompanyId1)) ? "605" : "606";
        log.error("======================\u8c03\u7528nc\u89c6\u56fe\u5f00\u59cb======================");
        log.error("\u7532\u65b9\u62ac\u5934\u7f16\u7801saleCompanyCode==" + saleCompanyCode);
        List saleCompanyIdList = MidDataPool.getJdbcTemplatePre().query("select orgcode,orgname,deptcode,deptname from v_b2b_dept where orgcode ='" + saleCompanyCode + "';", (RowMapper)new BeanPropertyRowMapper(DeptBO.class));
        if (saleCompanyIdList != null && saleCompanyIdList.size() > 0) {
            log.error("saleCompanyIdList.size" + saleCompanyIdList.size());
            for (DeptBO dbo : saleCompanyIdList) {
                if (saleCompanyCode.equals("605")) {
                    if (!dbo.getDeptcode().equals("BM0201")) continue;
                    pk_deptid = dbo.getDeptcode();
                    continue;
                }
                if (!dbo.getDeptcode().equals("9013")) continue;
                pk_deptid = dbo.getDeptcode();
            }
        }
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateNowStr = sdf.format(d);
        ncAccountsPayableBillUpBO.setAccessorynum(0);
        ncAccountsPayableBillUpBO.setBilldate(dateNowStr);
        ncAccountsPayableBillUpBO.setBillmaker("B2B");
        ncAccountsPayableBillUpBO.setCreator("B2B");
        ncAccountsPayableBillUpBO.setIsflowbill("N");
        ncAccountsPayableBillUpBO.setIsinit("N");
        ncAccountsPayableBillUpBO.setIsreded("N");
        ncAccountsPayableBillUpBO.setLocal_money(payPurchaseOrderInfo.getOrderAmt());
        ncAccountsPayableBillUpBO.setMoney(payPurchaseOrderInfo.getOrderAmt());
        ncAccountsPayableBillUpBO.setObjtype(1);
        ncAccountsPayableBillUpBO.setPayaccount("");
        ncAccountsPayableBillUpBO.setPk_balatype("3");
        ncAccountsPayableBillUpBO.setPk_billtype("F1");
        ncAccountsPayableBillUpBO.setPk_currtype("CNY");
        ncAccountsPayableBillUpBO.setPk_deptid(pk_deptid);
        ncAccountsPayableBillUpBO.setPk_group("000");
        ncAccountsPayableBillUpBO.setPk_org(saleCompanyCode);
        ncAccountsPayableBillUpBO.setPk_tradetype("F1-Cxx-02");
        ncAccountsPayableBillUpBO.setRecaccount("");
        if (payPurchaseOrderInfo.getRemark() != null) {
            ncAccountsPayableBillUpBO.setScomment(payPurchaseOrderInfo.getRemark());
        } else {
            ncAccountsPayableBillUpBO.setScomment("");
        }
        ncAccountsPayableBillUpBO.setSett_org(saleCompanyCode);
        ncAccountsPayableBillUpBO.setSrc_syscode(0);
        UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
        umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(payPurchaseOrderInfo.getSupplierNo());
        log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u8be6\u60c5\u5165\u53c2" + umcQrySupplierInfoDetailAbilityReqBO);
        String supplierCode = "";
        String outsideOnlineRetailersPower = "";
        String replaceSupplierCode = "";
        try {
            UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
            log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u8be6\u60c5\u51fa\u53c2" + umcQrySupplierInfoDetailAbilityRspBO);
            supplierCode = umcQrySupplierInfoDetailAbilityRspBO.getSupplierCode();
            outsideOnlineRetailersPower = umcQrySupplierInfoDetailAbilityRspBO.getOutsideOnlineRetailersPower();
            replaceSupplierCode = supplierCode.replace("NC-", "");
            if (umcQrySupplierInfoDetailAbilityRspBO != null) {
                ncAccountsPayableBillUpBO.setSupplier(replaceSupplierCode);
            } else {
                ncAccountsPayableBillUpBO.setSupplier("");
            }
        }
        catch (Exception e) {
            log.error("======================\u8c03\u7528\u4f1a\u5458\u62a5\u9519==========================");
        }
        ncAccountsPayableBillUpBO.setSyscode(0);
        ncAccountsPayableBillUpBO.setDef1("");
        ncAccountsPayableBillUpBO.setDef2(payPurchaseOrderInfo.getInspectionCode());
        ncAccountsPayableBillUpBO.setDef3("");
        ArrayList<PayItemInfo> payItemInfoList = new ArrayList<PayItemInfo>();
        for (BusiPushPayPurchaseOrderInfoItemReqBO itemInfo : itemList) {
            PayItemInfo payItemInfo = new PayItemInfo();
            BeanUtils.copyProperties((Object)itemInfo, (Object)payItemInfo);
            payItemInfo.setOrderId(orderId);
            payItemInfo.setPurchaseOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
            payItemInfo.setInspectionId(inspectionId);
            payItemInfo.setNotificationNo(null);
            payItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
            if (!StringUtils.hasText((String)payItemInfo.getUnitName())) {
                payItemInfo.setUnitName("\u4e2a");
            }
            if (StringUtils.hasText((String)payItemInfo.getItemName()) && payItemInfo.getItemName().length() > 100) {
                payItemInfo.setItemName(payItemInfo.getItemName().substring(0, 100));
            }
            if (payItemInfo.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (null == payItemInfo.getTaxRate()) {
                payItemInfo.setTaxRate(this.enumsService.queryDefaultTaxRate());
            }
            BigDecimal taxAmt = payItemInfo.getAmount().divide(BigDecimal.ONE.add(payItemInfo.getTaxRate()), 5, 4).multiply(payItemInfo.getTaxRate()).setScale(2, 4);
            payItemInfo.setTaxAmt(taxAmt);
            payItemInfo.setUntaxAmt(payItemInfo.getAmount().subtract(payItemInfo.getTaxAmt()));
            if (null != payItemInfo.getSettleRate() && payItemInfo.getSettleRate().intValue() == 0) {
                payItemInfo.setSettleRate(null);
            }
            if (null != payItemInfo.getSettleRate()) {
                BigDecimal settleRate = null;
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                    settleRate = payItemInfo.getSettleRate();
                    payItemInfo.setQuantitySale(itemInfo.getQuantity());
                    BigDecimal quantity = itemInfo.getQuantity().multiply(settleRate).setScale(6, 4);
                    payItemInfo.setQuantity(quantity);
                    payItemInfo.setPurchaseUnitPriceSale(itemInfo.getPurchaseUnitPrice());
                    payItemInfo.setPurchaseUnitPrice(itemInfo.getAmount().divide(quantity, 2, 4));
                    payItemInfo.setUnitNameSale(itemInfo.getUnitName());
                    if (!StringUtils.hasText((String)payItemInfo.getUnitNameSale())) {
                        payItemInfo.setUnitNameSale("\u4e2a");
                    }
                    payItemInfo.setUnitName(itemInfo.getSettleUnit());
                    if (!StringUtils.hasText((String)payItemInfo.getUnitName())) {
                        payItemInfo.setUnitName("\u4e2a");
                    }
                } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                    // empty if block
                }
            }
            payItemInfoList.add(payItemInfo);
            NcAccountsPayableBillUpItemBO ncAccountsPayableBillUpItemBO = new NcAccountsPayableBillUpItemBO();
            ncAccountsPayableBillUpItemBO.setBuysellflag(2);
            ncAccountsPayableBillUpItemBO.setContractno("");
            ncAccountsPayableBillUpItemBO.setInvoiceno("");
            ncAccountsPayableBillUpItemBO.setLocal_money_bal(payItemInfo.getAmount());
            ncAccountsPayableBillUpItemBO.setLocal_money_cr(payItemInfo.getAmount());
            ncAccountsPayableBillUpItemBO.setLocal_notax_cr(payItemInfo.getUntaxAmt());
            ncAccountsPayableBillUpItemBO.setLocal_tax_cr(payItemInfo.getTaxAmt());
            ncAccountsPayableBillUpItemBO.setMoney_bal(payItemInfo.getAmount());
            ncAccountsPayableBillUpItemBO.setMoney_cr(payItemInfo.getAmount());
            ncAccountsPayableBillUpItemBO.setNotax_cr(payItemInfo.getUntaxAmt());
            ncAccountsPayableBillUpItemBO.setObjtype(1);
            ncAccountsPayableBillUpItemBO.setOccupationmny(payItemInfo.getAmount());
            ncAccountsPayableBillUpItemBO.setPayaccount("");
            ncAccountsPayableBillUpItemBO.setRecaccount("");
            ncAccountsPayableBillUpItemBO.setPk_balatype("3");
            ncAccountsPayableBillUpItemBO.setPk_currtype("CNY");
            ncAccountsPayableBillUpItemBO.setPk_deptid(pk_deptid);
            ncAccountsPayableBillUpItemBO.setPk_org(saleCompanyCode);
            ncAccountsPayableBillUpItemBO.setPurchaseorder(String.valueOf(payItemInfo.getOrderId()));
            ncAccountsPayableBillUpItemBO.setScomment(payPurchaseOrderInfo.getRemark());
            ncAccountsPayableBillUpItemBO.setSupplier(replaceSupplierCode);
            ncAccountsPayableBillUpItemBO.setTaxrate(payItemInfo.getTaxRate());
            if (outsideOnlineRetailersPower != null) {
                if (outsideOnlineRetailersPower.equals("1")) {
                    ncAccountsPayableBillUpItemBO.setDef27("02");
                } else if (outsideOnlineRetailersPower.equals("2")) {
                    ncAccountsPayableBillUpItemBO.setDef27("01");
                }
            }
            if (orgType.equals("03")) {
                ncAccountsPayableBillUpItemBO.setDef28("02");
            } else {
                ncAccountsPayableBillUpItemBO.setDef28(orgType);
            }
            ncAccountsPayableBillUpItemBO.setDef25("");
            ncAccountsPayableBillUpItemBO.setDef24("");
            if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.16)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM015");
            } else if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.11)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM016");
            } else if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.1)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM017");
            } else if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.06)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM018");
            } else if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.05)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM019");
            } else if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.03)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM020");
            } else if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.17)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM021");
            } else if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.13)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM022");
            } else if (payItemInfo.getTaxRate().compareTo(BigDecimal.valueOf(0.09)) == 0) {
                ncAccountsPayableBillUpItemBO.setDef1("JTXM023");
            }
            ncAccountsPayableBillUpItemBO.setDef2(payPurchaseOrderInfo.getInspectionCode());
            ncAccountsPayableBillUpItemBO.setDef3("");
            ncAccountsPayableBillUpItemBO.setDef4("");
            ncAccountsPayableBillUpItemBO.setDef5("");
            ncItemBOList.add(ncAccountsPayableBillUpItemBO);
        }
        ncAccountsPayableBillUpReqBO.setBillHead(ncAccountsPayableBillUpBO);
        ncAccountsPayableBillUpReqBO.setItem(ncItemBOList);
        ncAccountsPayableBillUpReqBO.setId(String.valueOf(payPurchaseOrderInfo.getInspectionCode()));
        String ncAccountsPayableBillUpReqBOJson = JSONArray.toJSON((Object)ncAccountsPayableBillUpReqBO).toString();
        log.error("\u5e94\u4ed8\u5355json=====" + ncAccountsPayableBillUpReqBOJson);
        NcAccountsPayableBillUpRspBO ncAccountsPayableBillUpRspBO = this.ncAccountsPayableBillUpService.accountsPayableBillUp(ncAccountsPayableBillUpReqBO);
        if (ncAccountsPayableBillUpRspBO.getRespCode().equals("8888")) {
            log.error(ncAccountsPayableBillUpRspBO.getRespDesc());
            throw new PfscExtBusinessException("0001", ncAccountsPayableBillUpRspBO.getRespDesc());
        }
        if (payItemInfoList.isEmpty()) {
            logger.error("\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
        }
        this.payItemInfoMapper.insertBatch(payItemInfoList);
        if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            PayPurchaseOrderInfo purchaseOrderInfo = new PayPurchaseOrderInfo();
            purchaseOrderInfo.setPurchaseOrderCode(orderInfo.getPurchaseOrderCode());
            String orderStatus2 = orderInfo.getOrderStatus2();
            if ("4".equals(orderStatus2) || "5".equals(orderStatus2)) {
                orderStatus2 = OrderStatus2.PARTIAL_ACCEPTANCE.getCode();
            } else if ("6".equals(orderStatus2)) {
                orderStatus2 = OrderStatus2.FULL_ACCEPTANCE.getCode();
            }
            purchaseOrderInfo.setOrderStatus2(orderStatus2);
            this.payPurchaseOrderInfoMapper.updateByPurchaseOrderCode(purchaseOrderInfo);
        }
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @PostMapping(value={"addDealServiceFee"})
    public PfscExtRspBaseBO addDealServiceFee(@RequestBody BusiPushPayPurchaseOrderInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u5e73\u53f0\u670d\u52a1\u8d39\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiPushPayPurchaseOrderInfoOrderReqBO orderInfo = reqBO.getOrderInfo();
        if (orderInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = orderInfo.getOrderId();
        Long inspectionId = orderInfo.getInspectionId();
        String inspectionCode = orderInfo.getInspectionCode();
        if (orderId == null || orderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inspectionId == null || inspectionId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inspectionCode == null || "".equals(inspectionCode)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u9a8c\u6536\u5355\u53f7\u3010inspectionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList itemList = reqBO.getItemList();
        if (itemList == null || itemList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u5546\u54c1\u4fe1\u606f\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long purchaseCompanyId = orderInfo.getPurchaseCompanyId();
        String purchaseCompanyName = orderInfo.getPurchaseCompanyName();
        if (purchaseCompanyId == null || purchaseCompanyId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u7532\u65b9\u53d1\u7968\u53f7\u3010purchaseCompanyId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseCompanyName == null || "".equals(purchaseCompanyName)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u7532\u65b9\u53d1\u7968\u540d\u79f0\u3010purchaseCompanyName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, BusiPushPayPurchaseOrderInfoItemReqBO> itemMap = new HashMap<Long, BusiPushPayPurchaseOrderInfoItemReqBO>(itemList.size() + 1);
        BigDecimal orderDealServiceFee = BigDecimal.ZERO;
        for (BusiPushPayPurchaseOrderInfoItemReqBO itemInfo : itemList) {
            if (!itemMap.containsKey(itemInfo.getItemNo())) {
                itemMap.put(itemInfo.getItemNo(), itemInfo);
            } else {
                BusiPushPayPurchaseOrderInfoItemReqBO itemInMap = (BusiPushPayPurchaseOrderInfoItemReqBO)itemMap.get(itemInfo.getItemNo());
                itemInMap.setQuantity(itemInMap.getQuantity().add(itemInfo.getQuantity()));
                itemInMap.setAmount(itemInMap.getAmount().add(itemInfo.getAmount()));
            }
            if (null != itemInfo.getCommDealServiceFeeRate()) {
                BigDecimal commDealServiceFee = itemInfo.getAmount().multiply(itemInfo.getCommDealServiceFeeRate()).divide(new BigDecimal(100));
                itemInfo.setCommDealServiceFee(commDealServiceFee);
                orderDealServiceFee = orderDealServiceFee.add(commDealServiceFee);
                continue;
            }
            itemInfo.setCommDealServiceFee(BigDecimal.ZERO);
        }
        itemList = new ArrayList(itemMap.values());
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo.setInspectionId(inspectionId);
        payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
        PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setInspectionId(inspectionId);
        ArrayList<String> itemStatusNotIn = new ArrayList<String>();
        itemStatusNotIn.add(OrderStatus.NO_APPLY.getCode());
        payItemInfoVO.setItemStatusNotIn(itemStatusNotIn);
        int count = this.payItemInfoMapper.selectCount(payItemInfoVO);
        if (payPurchaseOrderInfo != null) {
            if (count > 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u901a\u77e5\u3002");
                throw new PfscExtBusinessException("18000", "\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u901a\u77e5\u3002");
            }
            PayItemInfo payItemInfo = new PayItemInfo();
            payItemInfo.setInspectionId(inspectionId);
            this.payItemInfoMapper.deleteBy(payItemInfo);
            payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setInspectionId(inspectionId);
            this.payPurchaseOrderInfoMapper.deleteBy(payPurchaseOrderInfo);
        }
        String source = orderInfo.getSource();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setOrderId(orderId);
            payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
            if (payPurchaseOrderInfo != null) {
                payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setOrderId(orderId);
                this.payPurchaseOrderInfoMapper.deleteBy(payPurchaseOrderInfo);
                PayItemInfo payItemInfo = new PayItemInfo();
                payItemInfo.setOrderId(orderId);
                this.payItemInfoMapper.deleteBy(payItemInfo);
            }
        }
        payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)payPurchaseOrderInfo);
        payPurchaseOrderInfo.setBusiModel(orderInfo.getBusiMode());
        String orgName = this.organizationInfoService.queryOrgName(payPurchaseOrderInfo.getOperUnitNo());
        payPurchaseOrderInfo.setOperUnitName(orgName);
        payPurchaseOrderInfo.setNotificationNo(null);
        payPurchaseOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        payPurchaseOrderInfo.setReconcilitionStatus(ReconciliationStatus.NOT_RECONCILED.getCode());
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            List<Long> childrenOrgIds = this.organizationInfoService.getChildrenOrgIds(payPurchaseOrderInfo.getOperUnitNo());
            if (childrenOrgIds != null && childrenOrgIds.contains(payPurchaseOrderInfo.getPurchaseNo())) {
                payPurchaseOrderInfo.setPurchaseSaleType(PurchaseSaleType.SELFUSE.getCode());
            } else {
                payPurchaseOrderInfo.setPurchaseSaleType(PurchaseSaleType.MINMARKET.getCode());
            }
        } else if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            Object branchCompany = this.organizationInfoService.queryBranchCompanyByAccountId(payPurchaseOrderInfo.getPurchaseProjectId());
            payPurchaseOrderInfo.setBranchCompany((Long)branchCompany);
        }
        if (null != payPurchaseOrderInfo.getPayType()) {
            switch (payPurchaseOrderInfo.getPayType()) {
                case "0": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BANK_RECEIVE.getCode());
                    break;
                }
                case "1": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BILL_AGREEMENT.getCode());
                    break;
                }
                case "2": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BILL_RECEIVE.getCode());
                }
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3010payType\u3011");
        }
        payPurchaseOrderInfo.setPayStatus("00");
        payPurchaseOrderInfo.setIsPayFlag("0");
        payPurchaseOrderInfo.setOrderDealServiceFee(orderDealServiceFee);
        Long inspectionID = 0L;
        try {
            inspectionID = this.frameOrderIdSeqSeqService.nextId();
            payPurchaseOrderInfo.setInspectionId(inspectionID);
            this.payPurchaseOrderInfoMapper.insert(payPurchaseOrderInfo);
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8ba2\u5355\u6dfb\u52a0\u5931\u8d25:" + e.toString());
        }
        Long purchaseCompanyId1 = payPurchaseOrderInfo.getPurchaseCompanyId();
        Object pk_deptid = null;
        String saleCompanyCode = "";
        UmcYdEnterpriseOrgQueryAbilityReqBO umcYdEnterpriseOrgQueryAbilityReqBO = new UmcYdEnterpriseOrgQueryAbilityReqBO();
        umcYdEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(reqBO.getOrderInfo().getPurchaseNo());
        log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u5165\u53c2" + umcYdEnterpriseOrgQueryAbilityReqBO);
        UmcYdEnterpriseOrgDetailAbilityRspBO umcYdEnterpriseOrgDetailAbilityRspBO = this.umcYdEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcYdEnterpriseOrgQueryAbilityReqBO);
        log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2" + umcYdEnterpriseOrgDetailAbilityRspBO);
        String orgType = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgType();
        ArrayList<PayItemInfo> payItemInfoList = new ArrayList<PayItemInfo>();
        for (BusiPushPayPurchaseOrderInfoItemReqBO itemInfo : itemList) {
            PayItemInfo payItemInfo = new PayItemInfo();
            BeanUtils.copyProperties((Object)itemInfo, (Object)payItemInfo);
            payItemInfo.setOrderId(orderId);
            payItemInfo.setPurchaseOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
            payItemInfo.setInspectionId(inspectionId);
            payItemInfo.setNotificationNo(null);
            payItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
            if (!StringUtils.hasText((String)payItemInfo.getUnitName())) {
                payItemInfo.setUnitName("\u4e2a");
            }
            if (StringUtils.hasText((String)payItemInfo.getItemName()) && payItemInfo.getItemName().length() > 100) {
                payItemInfo.setItemName(payItemInfo.getItemName().substring(0, 100));
            }
            if (payItemInfo.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (null == payItemInfo.getTaxRate()) {
                payItemInfo.setTaxRate(this.enumsService.queryDefaultTaxRate());
            }
            BigDecimal taxAmt = payItemInfo.getAmount().divide(BigDecimal.ONE.add(payItemInfo.getTaxRate()), 5, 4).multiply(payItemInfo.getTaxRate()).setScale(2, 4);
            payItemInfo.setTaxAmt(taxAmt);
            payItemInfo.setUntaxAmt(payItemInfo.getAmount().subtract(payItemInfo.getTaxAmt()));
            if (null != payItemInfo.getSettleRate() && payItemInfo.getSettleRate().intValue() == 0) {
                payItemInfo.setSettleRate(null);
            }
            if (null != payItemInfo.getSettleRate()) {
                BigDecimal settleRate = null;
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                    settleRate = payItemInfo.getSettleRate();
                    payItemInfo.setQuantitySale(itemInfo.getQuantity());
                    BigDecimal quantity = itemInfo.getQuantity().multiply(settleRate).setScale(6, 4);
                    payItemInfo.setQuantity(quantity);
                    payItemInfo.setPurchaseUnitPriceSale(itemInfo.getPurchaseUnitPrice());
                    payItemInfo.setPurchaseUnitPrice(itemInfo.getAmount().divide(quantity, 2, 4));
                    payItemInfo.setUnitNameSale(itemInfo.getUnitName());
                    if (!StringUtils.hasText((String)payItemInfo.getUnitNameSale())) {
                        payItemInfo.setUnitNameSale("\u4e2a");
                    }
                    payItemInfo.setUnitName(itemInfo.getSettleUnit());
                    if (!StringUtils.hasText((String)payItemInfo.getUnitName())) {
                        payItemInfo.setUnitName("\u4e2a");
                    }
                } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                    // empty if block
                }
            }
            payItemInfoList.add(payItemInfo);
        }
        if (payItemInfoList.isEmpty()) {
            logger.error("\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
        }
        this.payItemInfoMapper.insertBatch(payItemInfoList);
        if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            PayPurchaseOrderInfo purchaseOrderInfo = new PayPurchaseOrderInfo();
            purchaseOrderInfo.setPurchaseOrderCode(orderInfo.getPurchaseOrderCode());
            String orderStatus2 = orderInfo.getOrderStatus2();
            if ("4".equals(orderStatus2) || "5".equals(orderStatus2)) {
                orderStatus2 = OrderStatus2.PARTIAL_ACCEPTANCE.getCode();
            } else if ("6".equals(orderStatus2)) {
                orderStatus2 = OrderStatus2.FULL_ACCEPTANCE.getCode();
            }
            purchaseOrderInfo.setOrderStatus2(orderStatus2);
            this.payPurchaseOrderInfoMapper.updateByPurchaseOrderCode(purchaseOrderInfo);
        }
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

