/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.tydic.pfsc.api.busi.BusiPushSaleOrderInfoService;
import com.tydic.pfsc.api.busi.bo.BusiPushSaleOrderInfoItemReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPushSaleOrderInfoOrderReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPushSaleOrderInfoReqBO;
import com.tydic.pfsc.api.busi.bo.DeptBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleOrderPayType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.nc.api.NcReceivableBillUpService;
import com.tydic.pfsc.external.nc.api.bo.NcReceivableBillUpRecBillBO;
import com.tydic.pfsc.external.nc.api.bo.NcReceivableBillUpRecItemBO;
import com.tydic.pfsc.external.nc.api.bo.NcReceivableBillUpReqBO;
import com.tydic.pfsc.external.nc.api.bo.NcReceivableBillUpRspBO;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.MidDataPool;
import com.tydic.umcext.ability.org.UmcYdEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgQueryAbilityReqBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiPushSaleOrderInfoService"})
public class BusiPushSaleOrderInfoServiceImpl
implements BusiPushSaleOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiPushSaleOrderInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiPushSaleOrderInfoServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private UmcYdEnterpriseOrgQueryAbilityService umcYdEnterpriseOrgQueryAbilityService;
    @Autowired
    private NcReceivableBillUpService ncReceivableBillUpService;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"add"})
    public PfscExtRspBaseBO add(@RequestBody BusiPushSaleOrderInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiPushSaleOrderInfoOrderReqBO orderInfo = reqBO.getOrderInfo();
        if (orderInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = orderInfo.getOrderId();
        Long inspectionId = orderInfo.getInspectionId();
        Long purchaseOrderId = orderInfo.getPurchaseOrderId();
        if (orderId == null || orderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inspectionId == null || inspectionId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseOrderId == null || purchaseOrderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList itemList = reqBO.getItemList();
        if (itemList == null || itemList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u5546\u54c1\u4fe1\u606f\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, BusiPushSaleOrderInfoItemReqBO> itemMap = new HashMap<Long, BusiPushSaleOrderInfoItemReqBO>(itemList.size() + 1);
        for (BusiPushSaleOrderInfoItemReqBO itemInfo : itemList) {
            if (!itemMap.containsKey(itemInfo.getItemNo())) {
                itemMap.put(itemInfo.getItemNo(), itemInfo);
                continue;
            }
            BusiPushSaleOrderInfoItemReqBO itemInMap = (BusiPushSaleOrderInfoItemReqBO)itemMap.get(itemInfo.getItemNo());
            itemInMap.setQuantity(itemInMap.getQuantity().add(itemInfo.getQuantity()));
            itemInMap.setAmount(itemInMap.getAmount().add(itemInfo.getAmount()));
        }
        itemList = new ArrayList(itemMap.values());
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setInspectionId(inspectionId);
        saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setInspectionId(inspectionId);
        ArrayList<String> itemStatusNotIn = new ArrayList<String>();
        itemStatusNotIn.add(OrderStatus.NO_APPLY.getCode());
        saleItemInfoVO.setItemStatusNotIn(itemStatusNotIn);
        int count = this.saleItemInfoMapper.selectCount(saleItemInfoVO);
        if (saleOrderInfo != null) {
            if (count > 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002");
                throw new PfscExtBusinessException("18000", "\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002");
            }
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setInspectionId(inspectionId);
            this.saleItemInfoMapper.deleteBy(saleItemInfo);
            saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionId(inspectionId);
            this.saleOrderInfoMapper.deleteBy(saleOrderInfo);
        }
        String source = orderInfo.getSource();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setOrderId(orderId);
            saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
            if (saleOrderInfo != null) {
                saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setOrderId(orderId);
                this.saleOrderInfoMapper.deleteBy(saleOrderInfo);
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setOrderId(orderId);
                this.saleItemInfoMapper.deleteBy(saleItemInfo);
            }
        }
        saleOrderInfo = new SaleOrderInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)saleOrderInfo);
        saleOrderInfo.setBusiModel(orderInfo.getBusiMode());
        String supplierName = this.organizationInfoService.querySupplierName(saleOrderInfo.getSupplierNo());
        saleOrderInfo.setSupplierName(supplierName);
        String orgName = this.organizationInfoService.queryOrgName(saleOrderInfo.getPurchaseNo());
        saleOrderInfo.setPurchaseName(orgName);
        orgName = this.organizationInfoService.queryOrgName(saleOrderInfo.getOperUnitNo());
        saleOrderInfo.setOperUnitName(orgName);
        saleOrderInfo.setApplyNo(null);
        saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            Object branchCompany = this.organizationInfoService.queryBranchCompanyByAccountId(saleOrderInfo.getPurchaseProjectId());
            saleOrderInfo.setBranchCompany((Long)branchCompany);
        }
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            saleOrderInfo.setIsPayFlag("0");
        } else {
            saleOrderInfo.setIsPayFlag("2");
        }
        if (null != saleOrderInfo.getPayType()) {
            switch (saleOrderInfo.getPayType()) {
                case "0": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BANK_RECEIVE.getCode());
                    break;
                }
                case "1": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BILL_AGREEMENT.getCode());
                    break;
                }
                case "2": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BILL_RECEIVE.getCode());
                }
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3010payType\u3011");
        }
        this.saleOrderInfoMapper.insert(saleOrderInfo);
        ArrayList<SaleItemInfo> saleItemInfoList = new ArrayList<SaleItemInfo>();
        for (BusiPushSaleOrderInfoItemReqBO itemInfo : itemList) {
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            BeanUtils.copyProperties((Object)itemInfo, (Object)saleItemInfo);
            saleItemInfo.setOrderId(orderId);
            saleItemInfo.setSaleOrderCode(saleOrderInfo.getSaleOrderCode());
            saleItemInfo.setInspectionId(inspectionId);
            saleItemInfo.setPurchaseOrderId(purchaseOrderId);
            saleItemInfo.setApplyNo(null);
            saleItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
            if (!StringUtils.hasText((String)saleItemInfo.getUnitName())) {
                saleItemInfo.setUnitName("\u4e2a");
            }
            if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source)) {
                saleItemInfo.setUntaxAmt(itemInfo.getSaleUnitPrice().multiply(itemInfo.getQuantity()));
                saleItemInfo.setTaxAmt(saleItemInfo.getUntaxAmt().multiply(itemInfo.getTaxRate()));
                saleItemInfo.setAmount(saleItemInfo.getUntaxAmt().add(saleItemInfo.getTaxAmt()));
            }
            if (StringUtils.hasText((String)saleItemInfo.getSkuName()) && saleItemInfo.getSkuName().length() > 100) {
                saleItemInfo.setSkuName(saleItemInfo.getSkuName().substring(0, 100));
            }
            if (saleItemInfo.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (StringUtils.hasText((String)itemInfo.getTaxId())) {
                try {
                    saleItemInfo.setTaxCatCode(Long.parseLong(itemInfo.getTaxId()));
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25,\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a:" + itemInfo.getTaxId());
                }
            }
            if (null == saleItemInfo.getTaxRate()) {
                saleItemInfo.setTaxRate(this.enumsService.queryDefaultTaxRate());
            }
            if (null != saleItemInfo.getSettleRate() && saleItemInfo.getSettleRate().intValue() == 0) {
                saleItemInfo.setSettleRate(null);
            }
            if (null != saleItemInfo.getSettleRate()) {
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                    saleItemInfo.setQuantitySale(itemInfo.getQuantity());
                    BigDecimal quantity = itemInfo.getQuantity().multiply(itemInfo.getSettleRate()).setScale(6, 4);
                    saleItemInfo.setQuantity(quantity);
                    saleItemInfo.setSaleUnitPriceSale(itemInfo.getSaleUnitPrice());
                    saleItemInfo.setSaleUnitPrice(itemInfo.getAmount().divide(quantity, 2, 4));
                    saleItemInfo.setUnitNameSale(itemInfo.getUnitName());
                    if (!StringUtils.hasText((String)saleItemInfo.getUnitNameSale())) {
                        saleItemInfo.setUnitNameSale("\u4e2a");
                    }
                    saleItemInfo.setUnitName(itemInfo.getSettleUnit());
                    if (!StringUtils.hasText((String)saleItemInfo.getUnitName())) {
                        saleItemInfo.setUnitName("\u4e2a");
                    }
                } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                    // empty if block
                }
            }
            saleItemInfoList.add(saleItemInfo);
        }
        if (saleItemInfoList.isEmpty()) {
            logger.error("\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
        }
        this.saleItemInfoMapper.insertBatch(saleItemInfoList);
        try {
            this.receivableBillUp(saleOrderInfo, saleItemInfoList);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5e94\u6536\u5355\u62a5\u9519");
        }
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void receivableBillUp(SaleOrderInfo saleOrderInfo, List<SaleItemInfo> saleItemInfoList) {
        String saleOrderInfoJson = JSONArray.toJSON((Object)saleOrderInfo).toString();
        log.error("saleOrderInfoJson==" + saleOrderInfo);
        String saleItemInfoListJson = JSONArray.toJSON(saleItemInfoList).toString();
        log.error("saleItemInfoListJson==" + saleItemInfoListJson);
        NcReceivableBillUpReqBO ncReceivableBillUpReqBO = new NcReceivableBillUpReqBO();
        NcReceivableBillUpRecBillBO ncReceivableBillUpRecBillBO = new NcReceivableBillUpRecBillBO();
        ArrayList<NcReceivableBillUpRecItemBO> ncReceivableBillUpRecItemBOS = new ArrayList<NcReceivableBillUpRecItemBO>();
        String pk_deptid = null;
        String saleCompanyCode = "";
        String saleCompanyId = String.valueOf(saleOrderInfo.getSaleCompanyId());
        UmcYdEnterpriseOrgQueryAbilityReqBO umcYdEnterpriseOrgQueryAbilityReqBO = new UmcYdEnterpriseOrgQueryAbilityReqBO();
        umcYdEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(saleOrderInfo.getPurchaseNo());
        log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u5165\u53c2" + umcYdEnterpriseOrgQueryAbilityReqBO);
        UmcYdEnterpriseOrgDetailAbilityRspBO umcYdEnterpriseOrgDetailAbilityRspBO = this.umcYdEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcYdEnterpriseOrgQueryAbilityReqBO);
        log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2" + umcYdEnterpriseOrgDetailAbilityRspBO);
        saleCompanyCode = "522125381650792448".equals(saleCompanyId) ? "605" : "606";
        log.error("\u8c03\u7528nc\u89c6\u56fe\u5f00\u59cb======================");
        log.error("\u7532\u65b9\u62ac\u5934\u7f16\u7801saleCompanyCode==" + saleCompanyCode);
        List saleCompanyIdList = MidDataPool.getJdbcTemplatePre().query("select orgcode,orgname,deptcode,deptname from v_b2b_dept where orgcode ='" + saleCompanyCode + "';", (RowMapper)new BeanPropertyRowMapper(DeptBO.class));
        if (saleCompanyIdList != null && saleCompanyIdList.size() > 0) {
            log.error("saleCompanyIdList.size" + saleCompanyIdList.size());
            for (DeptBO dbo : saleCompanyIdList) {
                if (saleCompanyCode.equals("605")) {
                    if (!dbo.getDeptcode().equals("BM0201")) continue;
                    pk_deptid = dbo.getDeptcode();
                    continue;
                }
                if (!dbo.getDeptcode().equals("9013")) continue;
                pk_deptid = dbo.getDeptcode();
            }
        }
        log.error("\u8c03\u7528nc\u89c6\u56fe\u7ed3\u675f======================");
        String orgCode = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgCode();
        String orgType = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgType();
        String replaceCode = orgCode.replace("PMS-", "");
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateNowStr = sdf.format(d);
        ncReceivableBillUpRecBillBO.setBilldate(dateNowStr);
        ncReceivableBillUpRecBillBO.setBillmaker("B2B");
        ncReceivableBillUpRecBillBO.setCreator("B2B");
        ncReceivableBillUpRecBillBO.setIsflowbill("N");
        ncReceivableBillUpRecBillBO.setIsinit("N");
        ncReceivableBillUpRecBillBO.setIsreded("N");
        ncReceivableBillUpRecBillBO.setLocal_money(saleOrderInfo.getOrderAmt());
        ncReceivableBillUpRecBillBO.setMoney(saleOrderInfo.getOrderAmt());
        ncReceivableBillUpRecBillBO.setObjtype(0);
        ncReceivableBillUpRecBillBO.setSrc_syscode(0);
        ncReceivableBillUpRecBillBO.setSyscode(0);
        ncReceivableBillUpRecBillBO.setPk_currtype("CNY");
        ncReceivableBillUpRecBillBO.setPk_deptid(pk_deptid);
        ncReceivableBillUpRecBillBO.setPk_group("000");
        ncReceivableBillUpRecBillBO.setPk_org(saleCompanyCode);
        if (saleOrderInfo.getRemark() != null) {
            ncReceivableBillUpRecBillBO.setScomment(saleOrderInfo.getRemark());
        } else {
            ncReceivableBillUpRecBillBO.setScomment("");
        }
        ncReceivableBillUpRecBillBO.setSett_org(saleCompanyCode);
        if (umcYdEnterpriseOrgDetailAbilityRspBO != null && umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            ncReceivableBillUpRecBillBO.setCustomer(replaceCode);
        }
        ncReceivableBillUpRecBillBO.setPk_tradetype("F0-Cxx-01");
        ncReceivableBillUpRecBillBO.setPk_billtype("F0");
        ncReceivableBillUpRecBillBO.setDef1(String.valueOf(saleOrderInfo.getInspectionId()));
        Object ncCollectionBillUpGatherItemBOS = null;
        for (SaleItemInfo brbo : saleItemInfoList) {
            NcReceivableBillUpRecItemBO ncReceivableBillUpRecItemBO = new NcReceivableBillUpRecItemBO();
            ncReceivableBillUpRecItemBO.setBuysellflag(1);
            ncReceivableBillUpRecItemBO.setContractno(null);
            if (umcYdEnterpriseOrgDetailAbilityRspBO != null && umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                ncReceivableBillUpRecItemBO.setCustomer(replaceCode);
            }
            ncReceivableBillUpRecItemBO.setInvoiceno("");
            ncReceivableBillUpRecItemBO.setLocal_money_bal(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setLocal_money_de(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setLocal_notax_de(brbo.getUntaxAmt());
            ncReceivableBillUpRecItemBO.setLocal_tax_de(brbo.getTaxAmt());
            ncReceivableBillUpRecItemBO.setMoney_bal(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setMoney_de(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setNotax_de(brbo.getUntaxAmt());
            ncReceivableBillUpRecItemBO.setOccupationmny(brbo.getAmount());
            ncReceivableBillUpRecItemBO.setObjtype(0);
            ncReceivableBillUpRecItemBO.setPk_currtype("CNY");
            ncReceivableBillUpRecItemBO.setPk_deptid(pk_deptid);
            ncReceivableBillUpRecItemBO.setPk_org(saleCompanyCode);
            ncReceivableBillUpRecItemBO.setPurchaseorder("");
            if (saleOrderInfo.getRemark() != null) {
                ncReceivableBillUpRecItemBO.setScomment(saleOrderInfo.getRemark());
            } else {
                ncReceivableBillUpRecItemBO.setScomment("");
            }
            ncReceivableBillUpRecItemBO.setSett_org(saleCompanyCode);
            ncReceivableBillUpRecItemBO.setTaxrate(brbo.getTaxRate());
            ncReceivableBillUpRecItemBO.setDef30(orgType);
            if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.16)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM015");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.11)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM016");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.1)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM017");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.06)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM018");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.05)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM019");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.03)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM020");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.17)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM021");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.13)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM022");
            } else if (brbo.getTaxRate().compareTo(BigDecimal.valueOf(0.09)) == 0) {
                ncReceivableBillUpRecItemBO.setDef1("JTXM023");
            } else {
                ncReceivableBillUpRecItemBO.setDef1("");
            }
            ncReceivableBillUpRecItemBO.setDef2(saleOrderInfo.getPurchaseName());
            ncReceivableBillUpRecItemBO.setDef3(saleOrderInfo.getSaleOrderCode());
            ncReceivableBillUpRecItemBO.setDef4("");
            ncReceivableBillUpRecItemBO.setDef5("");
            ncReceivableBillUpRecItemBO.setDef6("");
            ncReceivableBillUpRecItemBO.setDef25("");
            ncReceivableBillUpRecItemBO.setDef24("");
            ncReceivableBillUpRecItemBOS.add(ncReceivableBillUpRecItemBO);
        }
        ncReceivableBillUpReqBO.setBillHead(ncReceivableBillUpRecBillBO);
        ncReceivableBillUpReqBO.setItem(ncReceivableBillUpRecItemBOS);
        ncReceivableBillUpReqBO.setId(String.valueOf(saleOrderInfo.getInspectionId()));
        String ncReceivableBillUpReqBOJson = JSONArray.toJSON((Object)ncReceivableBillUpReqBO).toString();
        log.error("\u5e94\u6536\u5355json=====" + ncReceivableBillUpReqBOJson);
        NcReceivableBillUpRspBO ncReceivableBillUpRspBO = this.ncReceivableBillUpService.receivableBillUp(ncReceivableBillUpReqBO);
        if (ncReceivableBillUpRspBO.getRespCode().equals("8888")) {
            throw new PfscExtBusinessException("0001", ncReceivableBillUpRspBO.getRespDesc());
        }
    }
}

