/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQueryOutstockInfoService;
import com.tydic.pfsc.api.busi.bo.BusiQueryOutstockInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryOutstockInfoRspBO;
import com.tydic.pfsc.api.busi.bo.SaleOrderDetailInfoRspBO;
import com.tydic.pfsc.api.busi.vo.OutstockInfoVO;
import com.tydic.pfsc.base.PfscExtReqPageBaseBO;
import com.tydic.pfsc.dao.OutstockDetailMapper;
import com.tydic.pfsc.dao.OutstockInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.OutstockInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.QueryOutstockInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OutstockInfoStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQueryOutstockInfoService"})
public class BusiQueryOutstockInfoServiceImpl
implements BusiQueryOutstockInfoService {
    private final OutstockInfoMapper outstockInfoMapper;
    private final OrganizationInfoService organizationInfoService;
    private final EnumsService enumsService;
    private final OutstockDetailMapper outstockDetailMapper;
    private final SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiQueryOutstockInfoServiceImpl(OutstockInfoMapper outstockInfoMapper, OrganizationInfoService organizationInfoService, EnumsService enumsService, OutstockDetailMapper outstockDetailMapper, SaleOrderInfoMapper saleOrderInfoMapper) {
        this.outstockInfoMapper = outstockInfoMapper;
        this.organizationInfoService = organizationInfoService;
        this.enumsService = enumsService;
        this.outstockDetailMapper = outstockDetailMapper;
        this.saleOrderInfoMapper = saleOrderInfoMapper;
    }

    @PostMapping(value={"queryOutstockInfo"})
    public BusiQueryOutstockInfoRspBO<OutstockInfoVO> queryOutstockInfo(@RequestBody BusiQueryOutstockInfoReqBO reqBO) {
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String defaultOrderBy = "t.OUTSTOCK_NO DESC";
        String tableName = "d_outstock_info";
        String orderBy = FscStringUtils.obtainOrderBy((PfscExtReqPageBaseBO)reqBO, tableName, defaultOrderBy);
        BusiQueryOutstockInfoRspBO rspPageBO = new BusiQueryOutstockInfoRspBO();
        QueryOutstockInfoVO queryOutstockInfoVO = new QueryOutstockInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryOutstockInfoVO);
        queryOutstockInfoVO.setCompanyOrg(reqBO.getCompanyId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<OutstockInfo> returnOutstockList = this.outstockInfoMapper.getListPage(queryOutstockInfoVO, (Page<Map<String, Object>>)page, orderBy);
        ArrayList<OutstockInfoVO> outstockVOList = new ArrayList<OutstockInfoVO>();
        for (OutstockInfo outstockInfoPO : returnOutstockList) {
            List<Long> inspectionIds;
            OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
            BeanUtils.copyProperties((Object)outstockInfoPO, (Object)outstockInfoVO);
            String purchaseName = this.organizationInfoService.queryOrgName(outstockInfoPO.getPurchaseNo());
            outstockInfoVO.setPurchaseName(purchaseName);
            String statusDesc = this.enumsService.getDescr(OutstockInfoStatus.getInstance(outstockInfoPO.getStatus()));
            outstockInfoVO.setStatusDesc(statusDesc);
            String sourceDesc = this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)outstockInfoPO.getSource()));
            outstockInfoVO.setSourceDescr(sourceDesc);
            outstockInfoVO.setBranchCompanyName(this.organizationInfoService.queryOrgName(outstockInfoPO.getBranchCompany()));
            LinkedList<SaleOrderDetailInfoRspBO> saleOrderDetailList = new LinkedList<SaleOrderDetailInfoRspBO>();
            if (!("0".equals(this.enumsService.queryShowOrderCodeSwitch()) && OrderSource.ELECTRIC_MARKET.getCode().equals(outstockInfoPO.getSource()) || CollectionUtils.isEmpty(inspectionIds = this.outstockDetailMapper.selectInspectionIdList(outstockInfoPO.getOutstockNo())))) {
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setInspectionIdList(inspectionIds);
                List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                    SaleOrderDetailInfoRspBO detailRspBO = new SaleOrderDetailInfoRspBO();
                    detailRspBO.setInspectionId(orderInfo.getInspectionId());
                    detailRspBO.setSaleOrderCode(orderInfo.getSaleOrderCode());
                    detailRspBO.setSaleOrderName(orderInfo.getSaleOrderName());
                    String supplierName = this.organizationInfoService.querySupplierName(outstockInfoPO.getSupplierNo());
                    if (supplierName != null) {
                        detailRspBO.setSupplierName(supplierName);
                    }
                    saleOrderDetailList.add(detailRspBO);
                }
            }
            outstockInfoVO.setSaleOrderDetailList(saleOrderDetailList);
            outstockInfoVO.setPurchaseProjectName(this.organizationInfoService.queryProjectName(outstockInfoPO.getPurchaseProjectId()).getAccountName());
            outstockVOList.add(outstockInfoVO);
        }
        rspPageBO.setRespCode("0000");
        rspPageBO.setRespDesc("\u51fa\u5e93\u5355\u67e5\u8be2\u6210\u529f");
        rspPageBO.setRows(outstockVOList);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

