/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQuerySaleOrderInfoService;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoItemRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoRspBO;
import com.tydic.pfsc.base.PfscExtRspPageBaseBO;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.DictionaryAtomService;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQuerySaleOrderInfoService"})
public class BusiQuerySaleOrderInfoServiceImpl
implements BusiQuerySaleOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiQuerySaleOrderInfoServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQuerySaleOrderInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private DictionaryAtomService dictionaryAtomService;
    private static final String IS_OPER_UNIT_NO = "0";
    private static final String IS_OPER_UNIT_YES = "1";

    @PostMapping(value={"query"})
    public BusiQuerySaleOrderInfoRspBO query(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new PfscExtBusinessException("18000", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (IS_OPER_UNIT_NO.equals(reqBO.getIsOperUnit()) && null == reqBO.getPurchaseNo()) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String saleOrderCode = reqBO.getSaleOrderCode();
        ArrayList<String> saleOrderCodeList = new ArrayList<String>();
        if (StringUtils.hasText((String)saleOrderCode)) {
            try {
                saleOrderCodeList.addAll(Arrays.asList(saleOrderCode.split(",")));
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        saleOrderInfoVO.setSource(OrderSource.CONSULT_PRICE_FRAME.getCode());
        saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (saleOrderInfoVO.getOrderDateEnd() != null) {
            try {
                String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
            }
            catch (ParseException e) {
                throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        if (!saleOrderCodeList.isEmpty()) {
            saleOrderInfoVO.setSaleOrderCodeList(saleOrderCodeList);
        }
        saleOrderInfoVO.setOrderBy("t.ORDER_ID DESC,t.INSPECTION_ID DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageJoin(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQuerySaleOrderInfoOrderRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            SaleItemInfoVO vo = new SaleItemInfoVO();
            vo.setInspectionId(saleOrderInfo.getInspectionId());
            List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
            ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                itemList.add(item);
            }
            BusiQuerySaleOrderInfoOrderRspBO order = new BusiQuerySaleOrderInfoOrderRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
            order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
            order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
            order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
            order.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)saleOrderInfo.getSource())));
            order.setItemInfos(itemList);
            try {
                order.setPurchaseProjectName(this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new PfscExtBusinessException("18000", "\u8c03\u7528\u4f1a\u5458\u3010UmcQryEnterpriseAccountDetailAbilityService\u3011\u5f02\u5e38");
            }
            orderList.add(order);
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    @PostMapping(value={"queryQuerySaleOrderInfo"})
    public PfscExtRspPageBaseBO<BusiQuerySaleOrderInfoRspBO> queryQuerySaleOrderInfo(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        PfscExtRspPageBaseBO rspPage = new PfscExtRspPageBaseBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            if (saleOrderInfoVO.getOrderDateEnd() != null) {
                try {
                    String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                    saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
                }
                catch (ParseException e) {
                    throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
                }
            }
            saleOrderInfoVO.setOrderBy("t.CREATE_TIME DESC");
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            saleOrderInfoVO.setOrderCategory("2");
            log.error("saleOrderInfoVO=" + saleOrderInfoVO);
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPage(saleOrderInfoVO, (Page<Map<String, Object>>)page);
            log.error("saleOrderInfoList=" + saleOrderInfoList);
            ArrayList<BusiQuerySaleOrderInfoRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoRspBO>();
            BigDecimal totalAmt = new BigDecimal(0);
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                BigDecimal addAmt;
                BusiQuerySaleOrderInfoRspBO busiQuerySaleOrderInfoRspBO = new BusiQuerySaleOrderInfoRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQuerySaleOrderInfoRspBO);
                SaleItemInfoVO vo = new SaleItemInfoVO();
                vo.setInspectionId(saleOrderInfo.getInspectionId());
                vo.setOrderId(saleOrderInfo.getOrderId());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
                ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                    BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                    item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                    item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                    item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                    itemList.add(item);
                }
                busiQuerySaleOrderInfoRspBO.setItemInfos(itemList);
                if (busiQuerySaleOrderInfoRspBO.getPayStatus() != null) {
                    if (busiQuerySaleOrderInfoRspBO.getPayStatus().equals("00")) {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u672a\u4ed8\u6b3e");
                    } else if (busiQuerySaleOrderInfoRspBO.getPayStatus().equals("01")) {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u4ed8\u6b3e\u786e\u8ba4\u4e2d");
                    } else if (busiQuerySaleOrderInfoRspBO.getPayStatus().equals("02")) {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u5df2\u4ed8\u6b3e");
                    } else if (busiQuerySaleOrderInfoRspBO.getPayStatus().equals("03")) {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u8d85\u65f6\u5f85\u4ed8\u6b3e");
                    } else {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u5df2\u53d6\u6d88");
                    }
                }
                if (busiQuerySaleOrderInfoRspBO.getLatestPayDate() != null) {
                    busiQuerySaleOrderInfoRspBO.setPayTypeStr("\u6388\u4fe1\u652f\u4ed8");
                } else {
                    busiQuerySaleOrderInfoRspBO.setPayTypeStr("\u5728\u7ebf\u652f\u4ed8");
                }
                if (saleOrderInfo.getLatestPayDate() != null) {
                    String endYear;
                    Date endDate = new Date();
                    int outDays = 0;
                    SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
                    String startYear = yearFormat.format(saleOrderInfo.getLatestPayDate());
                    if (startYear.equals(endYear = yearFormat.format(endDate))) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(saleOrderInfo.getLatestPayDate());
                        int startDay = calendar.get(6);
                        calendar.setTime(endDate);
                        int endDay = calendar.get(6);
                        outDays = endDay - startDay;
                        if (outDays > 0) {
                            busiQuerySaleOrderInfoRspBO.setOutDays(Integer.valueOf(outDays));
                        }
                    } else {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        long startDateTime = dateFormat.parse(dateFormat.format(saleOrderInfo.getLatestPayDate())).getTime();
                        long endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
                        BigDecimal outDaysB = new BigDecimal(endDateTime).subtract(new BigDecimal(startDateTime));
                        outDays = outDaysB.intValue();
                        busiQuerySaleOrderInfoRspBO.setOutDays(Integer.valueOf(outDays));
                    }
                }
                totalAmt = addAmt = totalAmt.add(saleOrderInfo.getOrderAmt());
                orderList.add(busiQuerySaleOrderInfoRspBO);
            }
            for (BusiQuerySaleOrderInfoRspBO busiQuerySaleOrderInfoRspBO : orderList) {
                busiQuerySaleOrderInfoRspBO.setTotalAmt(totalAmt);
            }
            rspPage.setRows(orderList);
            rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspPage;
    }

    @PostMapping(value={"queryTimeOutSaleOrder"})
    public BusiQuerySaleOrderInfoRspBO queryTimeOutSaleOrder(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        BusiQuerySaleOrderInfoRspBO busiQuerySaleOrderInfoRspBO = new BusiQuerySaleOrderInfoRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            saleOrderInfoVO.setOrderCategory("2");
            SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.queryTimeOutSaleOrder(saleOrderInfoVO);
            if (saleOrderInfo != null) {
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQuerySaleOrderInfoRspBO);
                if (saleOrderInfo.getLatestPayDate() != null) {
                    String endYear;
                    Date endDate = new Date();
                    int outDays = 0;
                    SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
                    String startYear = yearFormat.format(saleOrderInfo.getLatestPayDate());
                    if (startYear.equals(endYear = yearFormat.format(endDate))) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(saleOrderInfo.getLatestPayDate());
                        int startDay = calendar.get(6);
                        calendar.setTime(endDate);
                        int endDay = calendar.get(6);
                        outDays = endDay - startDay;
                        if (outDays > 0) {
                            busiQuerySaleOrderInfoRspBO.setOutDays(Integer.valueOf(outDays));
                        }
                    } else {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        long startDateTime = dateFormat.parse(dateFormat.format(saleOrderInfo.getLatestPayDate())).getTime();
                        long endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
                        BigDecimal outDaysB = new BigDecimal(endDateTime).subtract(new BigDecimal(startDateTime));
                        outDays = outDaysB.intValue();
                        busiQuerySaleOrderInfoRspBO.setOutDays(Integer.valueOf(outDays));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return busiQuerySaleOrderInfoRspBO;
    }

    @PostMapping(value={"queryQuerySaleOrderInfoCount"})
    public BusiQuerySaleOrderInfoRspBO queryQuerySaleOrderInfoCount(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        log.error("BusiQuerySaleOrderInfoReqBO==" + reqBO);
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        try {
            String saleOrderCode = reqBO.getSaleOrderCode();
            ArrayList<String> saleOrderCodeList = new ArrayList<String>();
            if (StringUtils.hasText((String)saleOrderCode)) {
                try {
                    saleOrderCodeList.addAll(Arrays.asList(saleOrderCode.split(",")));
                }
                catch (Exception e) {
                    throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
            }
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            if (!saleOrderCodeList.isEmpty()) {
                saleOrderInfoVO.setSaleOrderCodeList(saleOrderCodeList);
            }
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            log.error("\u5165\u53c2\u4e3a" + saleOrderInfoVO.getCount());
            saleOrderInfoVO.setOrderCategory("2");
            SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.getListPageCount(saleOrderInfoVO);
            if (saleOrderInfo != null) {
                log.error("\u67e5\u8be2\u7684\u6570\u91cf\u4e3a" + saleOrderInfo.getCount());
                rspBO.setCount(saleOrderInfo.getCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }
}

