/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiSubmitInvoiceInfoService;
import com.tydic.pfsc.api.busi.bo.BusiSubmitInvoiceInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiSubmitInvoiceInfoRspBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.enums.InvoiceStatus;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.PayableStatus2;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiSubmitInvoiceInfoService"})
public class BusiSubmitInvoiceInfoServiceImpl
implements BusiSubmitInvoiceInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSubmitInvoiceInfoServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    @PostMapping(value={"submitInvoiceInfo"})
    public BusiSubmitInvoiceInfoRspBO submitInvoiceInfo(@RequestBody BusiSubmitInvoiceInfoReqBO busiSubmitInvoiceInfoReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u6838\u5bf9\u7b7e\u6536\u670d\u52a1\u5165\u53c2=" + busiSubmitInvoiceInfoReqBO);
        }
        BusiSubmitInvoiceInfoRspBO rspBO = new BusiSubmitInvoiceInfoRspBO();
        String notificationNo = busiSubmitInvoiceInfoReqBO.getNotificationNo();
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7(notifycationNo)\u5fc5\u987b\u8f93\u5165");
        }
        if (null == busiSubmitInvoiceInfoReqBO.getSignMode()) {
            throw new PfscExtBusinessException("0001", "\u64cd\u4f5c\u7c7b\u578b\u5fc5\u987b\u8f93\u5165");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        if (bill == null) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355,\u901a\u77e5\u5355\u53f7=" + notificationNo);
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7" + notificationNo + "\u4e0d\u5b58\u5728!");
        }
        String billSta = bill.getInvoiceStatus();
        NotificationInvoiceStatus nowSta = NotificationInvoiceStatus.getInstance(billSta);
        if (nowSta == null) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u901a\u77e5\u5355\u7684\u72b6\u6001\u6570\u636e\u5f02\u5e38,\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u5355\u72b6\u6001=" + billSta);
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u901a\u77e5\u5355" + notificationNo + "\u72b6\u6001\u6570\u636e\u5f02\u5e38,\u65e0\u6548\u7684\u53d1\u7968\u72b6\u6001\u503c");
        }
        if (NotificationInvoiceStatus.SUBMITED != nowSta && busiSubmitInvoiceInfoReqBO.getSignMode() == 1) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u901a\u77e5\u5355\u7684\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6279(01),\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u5355\u72b6\u6001=" + billSta);
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u901a\u77e5\u5355" + notificationNo + "\u72b6\u6001\u4e0d\u6b63\u786e,\u53ea\u6709\u5f85\u5ba1\u6279\u72b6\u6001\u624d\u53ef\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c");
        }
        logger.debug("\u51c6\u5907\u66f4\u65b0\u5f00\u7968\u901a\u77e5\u5355\u7684\u72b6\u6001\u4e3a\u5f85\u5ba1\u6279(01),\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
        BillNotificationInfo forUpdate = new BillNotificationInfo();
        forUpdate.setNotificationNo(bill.getNotificationNo());
        forUpdate.setVerifyPersonId(busiSubmitInvoiceInfoReqBO.getUserId());
        forUpdate.setVerifyPersonName(busiSubmitInvoiceInfoReqBO.getName());
        forUpdate.setSignDate(new Date());
        if (busiSubmitInvoiceInfoReqBO.getSignMode() == 1) {
            forUpdate.setInvoiceStatus(NotificationInvoiceStatus.RECEIVED.getCode());
            forUpdate.setPayableStatus(PayableStatus2.NO_APPLY.getCode());
        } else if (busiSubmitInvoiceInfoReqBO.getSignMode() == 0) {
            forUpdate.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED_FAIL.getCode());
            forUpdate.setInvoiceResult(busiSubmitInvoiceInfoReqBO.getInvoiceResult());
        }
        this.billNotificationInfoMapper.updateByPrimaryKeySelective(forUpdate);
        logger.debug("\u51c6\u5907\u66f4\u65b0\u53d1\u7968\u7684\u72b6\u6001\u4e3a\u5df2\u6838\u5bf9(03),\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
        PayInvoiceInfo updInvoice = new PayInvoiceInfo();
        updInvoice.setNotificationNo(bill.getNotificationNo());
        if (busiSubmitInvoiceInfoReqBO.getSignMode() == 1) {
            updInvoice.setInvoiceStatus(InvoiceStatus.CHECKED.getCode());
        } else if (busiSubmitInvoiceInfoReqBO.getSignMode() == 0) {
            updInvoice.setInvoiceStatus(InvoiceStatus.SUBMITED_FAIL.getCode());
        }
        this.payInvoiceInfoMapper.updateInvoiceStatus(updInvoice);
        rspBO.setRemark("\u53d1\u7968\u6536\u7968\u5b8c\u6210");
        return rspBO;
    }
}

