/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.InvoiceReturnInvalidInvoiceService;
import com.tydic.pfsc.api.busi.bo.InvoiceReturnInvalidInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.InvoiceReturnInvalidInvoiceRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.vo.BillApplyInfoVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.atour.api.BillInfoUploadExternalService;
import com.tydic.pfsc.external.atour.api.bo.BillInfoUploadExtReqBO;
import com.tydic.pfsc.external.atour.api.bo.MessageBO;
import com.tydic.pfsc.external.atour.api.bo.SalesBillMainBO;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.InvoiceReturnAtomService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.InvoiceReturnInvalidInvoiceService"})
public class InvoiceReturnInvalidInvoiceServiceImpl
implements InvoiceReturnInvalidInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnInvalidInvoiceServiceImpl.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private InvoiceReturnAtomService invoiceReturnAtomService;
    @Autowired
    private BillInfoUploadExternalService billInfoUploadExternalService;

    @PostMapping(value={"process"})
    public InvoiceReturnInvalidInvoiceRspBO process(@RequestBody InvoiceReturnInvalidInvoiceReqBO reqBO) {
        Collection<String> applyNo1s;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4f5c\u5e9f\u53d1\u7968\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        InvoiceReturnInvalidInvoiceRspBO rspBO = new InvoiceReturnInvalidInvoiceRspBO();
        List billNos = reqBO.getBillNos();
        if (CollectionUtils.isEmpty((Collection)billNos)) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        InvoiceReturnVO vo = new InvoiceReturnVO();
        vo.setBillNos(billNos);
        List<InvoiceReturn> invoiceReturns = this.invoiceReturnMapper.selectListBy(vo);
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            if (!InvoiceReturnStatus.TO_RETURN.getCode().equals(invoiceReturn.getStatus())) {
                throw new PfscExtBusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f" + this.enumsService.getDescr(InvoiceReturnStatus.TO_RETURN));
            }
            String applyNo1 = invoiceReturn.getApplyNo1();
            applyNo1s = FscStringUtils.string2List(applyNo1, ",");
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            billApplyInfoVO.setApplyNoList((List<String>)applyNo1s);
            List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
            for (BillApplyInfo apply : applys) {
                if (InvoiceClasses.PAPER_INVOICE.getCode().equals(apply.getInvoiceClasses())) continue;
                throw new PfscExtBusinessException("0001", "\u53ea\u80fd\u4f5c\u5e9f\u7eb8\u8d28\u53d1\u7968");
            }
        }
        InvoiceReturnDetailVO invoiceReturnDetailVO = new InvoiceReturnDetailVO();
        invoiceReturnDetailVO.setBillNos(billNos);
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(invoiceReturnDetailVO);
        ArrayList<String> invoiceNo1s = new ArrayList<String>();
        applyNo1s = new HashSet();
        for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
            invoiceNo1s.add(invoiceReturnDetail.getInvoiceNo1());
            applyNo1s.add(invoiceReturnDetail.getApplyNo1());
        }
        for (String applyNo1 : applyNo1s) {
            BillInfoUploadExtReqBO uploadExtReqBO = new BillInfoUploadExtReqBO();
            uploadExtReqBO.setBusinessBillType("AR");
            uploadExtReqBO.setSystemOrig("YD");
            uploadExtReqBO.setStatus(Integer.valueOf(0));
            ArrayList<MessageBO> message = new ArrayList<MessageBO>();
            MessageBO messageBO = new MessageBO();
            SalesBillMainBO billMainBO = new SalesBillMainBO();
            billMainBO.setSalesbillNo(applyNo1);
            billMainBO.setSalesbillType("AR\u5355");
            messageBO.setSalesBillMain(billMainBO);
            message.add(messageBO);
            uploadExtReqBO.setMessage(message);
            this.billInfoUploadExternalService.billInfoUpload(uploadExtReqBO);
        }
        for (String billNo : billNos) {
            InvoiceReturn record = new InvoiceReturn();
            record.setBillNo(billNo);
            record.setStatus(InvoiceReturnStatus.RETURNING.getCode());
            record.setProcessUser(reqBO.getUsername());
            record.setProcessDate(new Date());
            this.invoiceReturnMapper.updateByPrimaryKeySelective(record);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

