/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.utils;

import com.tydic.pfsc.base.PfscExtReqPageBaseBO;
import com.tydic.pfsc.dao.FieldMappingMapper;
import com.tydic.pfsc.dao.po.FieldMapping;
import com.tydic.pfsc.utils.AntiSqlInjectionManage;
import com.tydic.pfsc.utils.SpringApplicationContext;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FscStringUtils {
    private static final Logger logger = LoggerFactory.getLogger(FscStringUtils.class);

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return String.valueOf(object);
    }

    public static String simplifyAddrdesc(String province, String city, String county, String town, String addrDesc) {
        String defaultTown;
        if (addrDesc.contains(province)) {
            addrDesc = addrDesc.replace(province + "\u7701", "").replace(province + "\u5e02", "").replace(province, "");
        }
        if (addrDesc.contains(city)) {
            addrDesc = addrDesc.replace(city + "\u5e02", "").replace(city + "\u533a", "").replace(city + "\u53bf", "").replace(city, "");
        }
        if (addrDesc.contains(county)) {
            addrDesc = addrDesc.replace(county + "\u5e02", "").replace(county + "\u533a", "").replace(county + "\u53bf", "").replace(county + "\u9547", "").replace(county, "");
        }
        if (addrDesc.contains(town)) {
            addrDesc = addrDesc.replace(town + "\u53bf", "").replace(town + "\u9547", "").replace(town + "\u4e61", "").replace(town, "");
        }
        if (!addrDesc.contains(town) && !(defaultTown = "0").equals(town)) {
            addrDesc = town + addrDesc;
        }
        if (!addrDesc.contains(county)) {
            addrDesc = county + addrDesc;
        }
        if (!addrDesc.contains(city)) {
            addrDesc = city + addrDesc;
        }
        if (!addrDesc.contains(province)) {
            addrDesc = province + addrDesc;
        }
        return addrDesc;
    }

    public static List<String> string2List(String string, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (!org.springframework.util.StringUtils.hasText((String)string)) {
            return result;
        }
        if (!org.springframework.util.StringUtils.hasText((String)separator)) {
            separator = ",";
        }
        String[] array = string.split(separator);
        result.addAll(Arrays.asList(array));
        return result;
    }

    public static <E> String list2String(List<E> list, String separator) {
        StringBuilder result = new StringBuilder();
        if (CollectionUtils.isEmpty(list)) {
            return result.toString();
        }
        if (!org.springframework.util.StringUtils.hasText((String)separator)) {
            separator = ",";
        }
        for (E e : list) {
            result.append(e).append(separator);
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String obtainOrderBy(PfscExtReqPageBaseBO reqBO, String tableName, String defaultOrderBy) {
        StringBuilder orderBy = new StringBuilder();
        String sortName = reqBO.getSortName();
        String sortOrder = reqBO.getSortOrder();
        if (StringUtils.isNotBlank((String)sortName) && StringUtils.isNotBlank((String)sortOrder) && !AntiSqlInjectionManage.sqlValidate(sortName) && !AntiSqlInjectionManage.sqlValidate(sortOrder)) {
            FieldMappingMapper fieldMappingMapper = SpringApplicationContext.getBean(FieldMappingMapper.class);
            FieldMapping fieldMapping = fieldMappingMapper.selectByPrimaryKey(tableName, sortName);
            orderBy.append(" ").append(fieldMapping != null ? fieldMapping.getColumnName() : sortName).append(" ").append(sortOrder);
        }
        if (orderBy.length() == 0) {
            if (StringUtils.isNotBlank((String)defaultOrderBy)) {
                return defaultOrderBy;
            }
            return null;
        }
        return orderBy.toString();
    }

    public static String cutStringByByte(String source, String charsetName, int byteLength) {
        if (StringUtils.isBlank((String)source)) {
            source = "";
        }
        if (StringUtils.isBlank((String)charsetName)) {
            charsetName = "GBK";
        }
        try {
            byte[] bytes = source.getBytes(charsetName);
            if (bytes.length > byteLength) {
                bytes = Arrays.copyOf(bytes, byteLength);
                source = new String(bytes, charsetName);
                source = source.substring(0, source.length() - 1);
            }
        }
        catch (UnsupportedEncodingException e) {
            source = "";
            logger.error("\u5b57\u7b26\u4e32\u64cd\u4f5c\u51fa\u9519", (Throwable)e);
        }
        return source;
    }

    public static String[] getCutStrByByte(String str1, String str2, String charsetName, int byteLength) {
        if (StringUtils.isBlank((String)str1)) {
            str1 = "";
        }
        if (StringUtils.isBlank((String)str2)) {
            str2 = "";
        }
        try {
            byte[] totalBytes = (str1 + str2).getBytes(charsetName);
            if (totalBytes.length > byteLength) {
                byte[] str1Bytes = str1.getBytes(charsetName);
                if (str1Bytes.length >= byteLength) {
                    str1 = FscStringUtils.cutStringByByte(str1, charsetName, byteLength);
                    str2 = "";
                } else {
                    str2 = FscStringUtils.cutStringByByte(str2, charsetName, byteLength - str1Bytes.length);
                }
            }
        }
        catch (Exception e) {
            str1 = "";
            str2 = "";
            logger.error("\u5b57\u7b26\u4e32\u64cd\u4f5c\u51fa\u9519", (Throwable)e);
        }
        return new String[]{str1, str2};
    }
}

