/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiAfterSaleProcessService;
import com.tydic.pfsc.api.busi.bo.BusiAfterSaleProcessReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.AfterSaleDetailMapper;
import com.tydic.pfsc.dao.AfterSaleMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.AfterSale;
import com.tydic.pfsc.dao.vo.AfterSaleVO;
import com.tydic.pfsc.enums.AfterSaleProcessStatus;
import com.tydic.pfsc.service.atom.EnumsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAfterSaleProcessServiceImpl
implements BusiAfterSaleProcessService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAfterSaleProcessServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private AfterSaleMapper afterSaleMapper;
    @Autowired
    private AfterSaleDetailMapper afterSaleDetailMapper;
    @Autowired
    BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public PfscExtRspBaseBO process(BusiAfterSaleProcessReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u552e\u540e\u6d88\u606f\u5904\u7406\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        Long inspectionId = reqBO.getInspectionId();
        AfterSaleVO afterSaleVO = new AfterSaleVO();
        afterSaleVO.setInspectionId(inspectionId);
        ArrayList<String> processStatusList = new ArrayList<String>();
        processStatusList.add(AfterSaleProcessStatus.NO_PROCESS.getCode());
        processStatusList.add(AfterSaleProcessStatus.PROCESS_FAILED.getCode());
        afterSaleVO.setProcessStatusList(processStatusList);
        afterSaleVO.setOrderBy(" INSPECTION_ID ASC,MESSAGE_TYPE ASC");
        List<AfterSale> afterSales = this.afterSaleMapper.selectList(afterSaleVO);
        for (AfterSale afterSale : afterSales) {
            try {
                this.processItem(afterSale);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u552e\u540e\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
        return new PfscExtRspBaseBO();
    }

    private void processItem(AfterSale afterSale) {
    }

    private void saveProcessStatus(AfterSale afterSale, String processStatus, String processRemark) {
        AfterSaleVO afterSaleVO = new AfterSaleVO();
        afterSaleVO.setSeq(afterSale.getSeq());
        afterSaleVO.setProcessStatus(processStatus);
        processRemark = StringUtils.hasText((String)processRemark) && processRemark.length() > 500 ? processRemark.substring(0, 500) : processRemark;
        afterSaleVO.setProcessRemark(processRemark);
        afterSaleVO.setUpdateDate(new Date());
        this.afterSaleMapper.updateProcessStatus(afterSaleVO);
    }
}

