/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.api.supplier.service.QueryContractSupplierService;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfsc.api.busi.BusiAddCreditLineService;
import com.tydic.pfsc.api.busi.BusiApplyPayService;
import com.tydic.pfsc.api.busi.bo.BusiApplyPayServiceReqBO;
import com.tydic.pfsc.api.busi.bo.BusiApplyPayServiceRspBO;
import com.tydic.pfsc.constants.FscCommonConstants;
import com.tydic.pfsc.dao.ApplyDetailMapper;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.PayableDetailMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.UocOrdBusiOperRecordMapper;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.UocOrdBusiOperRecord;
import com.tydic.pfsc.enums.ApplyPayStatus2;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.PayableStatus2;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.FscWfStartAtomService;
import com.tydic.pfsc.service.atom.PayableService;
import com.tydic.uac.ability.UacAutoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiApplyPayService"})
public class BusiApplyPayServiceImpl
implements BusiApplyPayService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyPayServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableService payableService;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BusiAddCreditLineService busiAddCreditLineService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private QueryContractSupplierService queryContractSupplierService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private UacAutoTaskAuditCreateAbilityService uacAutoTaskAuditCreateAbilityService;
    @Autowired
    private UocOrdBusiOperRecordMapper uocOrdBusiOperRecordMapper;

    @PostMapping(value={"applyPay"})
    public BusiApplyPayServiceRspBO applyPay(@RequestBody BusiApplyPayServiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        BusiApplyPayServiceRspBO rspBO = new BusiApplyPayServiceRspBO();
        if (!StringUtils.hasText((String)reqBO.getSupplierName())) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getReceiptAcctNo())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getRecAcctName())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getPayChannel())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = reqBO.getNotificationNos();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Long payno = this.billSNService.getSn(BillType.PAY_APPLICATION);
            logger.info("\u6d41\u6c34\u53f7\uff1a" + payno);
            ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)applyPayInfoPO);
            applyPayInfoPO.setPayAmt(reqBO.getPayAmt());
            applyPayInfoPO.setPayno(payno.toString());
            applyPayInfoPO.setApplyDate(new Date());
            applyPayInfoPO.setOperatorId(reqBO.getUserId());
            applyPayInfoPO.setPayStatus(ApplyPayStatus2.PENDING_APPROVAL.getCode());
            applyPayInfoPO.setCompanyId(reqBO.getCompanyId());
            applyPayInfoPO.setCompanyName(reqBO.getCompanyName());
            applyPayInfoPO.setPayChannel(reqBO.getPayChannel());
            applyPayInfoPO.setPayVoucher(reqBO.getPayVoucher());
            applyPayInfoPO.setPayVoucherName(reqBO.getPayVoucherName());
            applyPayInfoPO.setRemark(reqBO.getRemark());
            applyPayInfoPO.setSupplierNo(reqBO.getSupplierId().toString());
            applyPayInfoPO.setSupplierName(reqBO.getSupplierName());
            this.applyPayInfoMapper.insert(applyPayInfoPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (String notification : list) {
                    BillNotificationInfo record = new BillNotificationInfo();
                    record.setNotificationNo(notification);
                    record.setPayableStatus(PayableStatus2.APPLIED.getCode());
                    record.setPayNo(payno.toString());
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(record);
                }
            }
            this.createAudit(reqBO, payno);
            this.recordProcessInfo(payno, reqBO);
            rspBO.setPayNo(payno.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u63d0\u4ea4\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6838\u5931\u8d25\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63d0\u4ea4\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6838\u6210\u529f\uff01");
        return rspBO;
    }

    private void createAudit(BusiApplyPayServiceReqBO reqBO, Long payno) {
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        noTaskAuditCreateReqBO.setCreateOperName(reqBO.getName());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setUsername(reqBO.getName());
        infoReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6279\u5165\u53c2\uff1apayno\uff1a" + payno + "| reqBO: " + reqBO.toString());
        noTaskAuditCreateReqBO.setProcDefKey("FSC_APPLY_PAY_APPROVAL");
        infoReqBO.setRemark("\u4ed8\u6b3e\u7533\u8bf7\u521b\u5efa\u5ba1\u6279");
        HashMap<String, BigDecimal> variables = new HashMap<String, BigDecimal>();
        variables.put("amountFlag", reqBO.getPayAmt());
        noTaskAuditCreateReqBO.setVariables(variables);
        infoReqBO.setOrderId(payno);
        infoReqBO.setObjType(FscCommonConstants.OBJ_TYPE.FSC_APPLY_PAY_APPROVAL);
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(FscCommonConstants.OBJ_TYPE.FSC_APPLY_PAY_APPROVAL);
        approvalObjBO.setObjId(String.valueOf(payno));
        ArrayList<ApprovalObjBO> objBOS = new ArrayList<ApprovalObjBO>(1);
        objBOS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBOS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBOS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBOS);
        logger.debug("\u5ba1\u6279\u521b\u5efa\u5165\u53c2\uff1a{}", (Object)(JSON.toJSONString((Object)noTaskAuditCreateReqBO) + ": variables" + JSON.toJSONString((Object)noTaskAuditCreateReqBO.getVariables())));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacAutoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u8c03\u7528\u5ba1\u6279\u521b\u5efa\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        ApplyPayInfoPO payInfoPO = new ApplyPayInfoPO();
        payInfoPO.setPayno(payno.toString());
        payInfoPO.setStepId(uacNoTaskAuditCreateRspBO.getStepId());
        payInfoPO.setOperatorId(reqBO.getUserId());
        payInfoPO.setPayStatus(ApplyPayStatus2.PENDING.getCode());
        this.applyPayInfoMapper.updateStatus(payInfoPO);
        logger.debug("\u5ba1\u6279\u521b\u5efa\u5b8c\u6210\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
    }

    private void recordProcessInfo(Long payno, BusiApplyPayServiceReqBO reqBO) {
        UocOrdBusiOperRecord record = new UocOrdBusiOperRecord();
        record.setRecordType(FscCommonConstants.OBJ_TYPE.FSC_APPLY_PAY_APPROVAL);
        record.setOrderId(payno);
        record.setObjId(payno);
        record.setObjType(FscCommonConstants.OBJ_TYPE.FSC_APPLY_PAY_APPROVAL);
        record.setCreateTime(new Date());
        record.setDealTime(new Date());
        record.setDealOperId(reqBO.getUserId() + "");
        record.setDealOperName(reqBO.getName());
        record.setDealDeptId(reqBO.getOrgId() + "");
        record.setDealDeptName(reqBO.getOrgName() + "");
        record.setDealCompId(reqBO.getCompanyId() + "");
        record.setDealCompName(reqBO.getCompanyName());
        record.setDealTypeId("1");
        record.setDealName("\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b");
        record.setDealDesc("\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7");
        this.uocOrdBusiOperRecordMapper.insertSelective(record);
    }
}

