/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.deal.impl;

import com.tydic.pfsc.api.deal.QueryPayInvoiceDetailService;
import com.tydic.pfsc.api.deal.bo.PayInvoiceDetailBO;
import com.tydic.pfsc.api.deal.bo.PayInvoiceInfoBO;
import com.tydic.pfsc.api.deal.bo.PayItemInfoBO;
import com.tydic.pfsc.api.deal.bo.QueryPayInvoiceDetailReqBO;
import com.tydic.pfsc.api.deal.bo.QueryPayInvoiceDetailRspBO;
import com.tydic.pfsc.dao.PayInvoiceDetailMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.PayInvoiceDetail;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.deal.QueryPayInvoiceDetailService"})
public class QueryPayInvoiceDetailServiceImpl
implements QueryPayInvoiceDetailService {
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"selectBySomeConditions"})
    public QueryPayInvoiceDetailRspBO selectBySomeConditions(@RequestBody QueryPayInvoiceDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayItemInfoBO payItemInfo = reqBO.getPayItemInfo();
        PayInvoiceDetailBO payInvoiceDetailBO = new PayInvoiceDetailBO();
        PayInvoiceDetail payDetailsInfo = this.payInvoiceDetailMapper.selectBySomeConditions(payItemInfo.getItemNo(), payItemInfo.getInspectionId(), payItemInfo.getInvoiceNoSet());
        BeanUtils.copyProperties((Object)payDetailsInfo, (Object)payInvoiceDetailBO);
        QueryPayInvoiceDetailRspBO rspBO = new QueryPayInvoiceDetailRspBO();
        rspBO.setPayInvoiceDetailBO(payInvoiceDetailBO);
        return rspBO;
    }

    @PostMapping(value={"deleteByInvoiceNo"})
    public QueryPayInvoiceDetailRspBO deleteByInvoiceNo(@RequestBody QueryPayInvoiceDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayInvoiceInfoBO iv = reqBO.getPayInvoiceInfoBO();
        int result = this.payInvoiceDetailMapper.deleteByInvoiceNo(iv.getInvoiceCode(), iv.getInvoiceNo(), iv.getInvoiceDate());
        QueryPayInvoiceDetailRspBO rspBO = new QueryPayInvoiceDetailRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"insertByBatch"})
    public QueryPayInvoiceDetailRspBO insertByBatch(@RequestBody QueryPayInvoiceDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List newIvDetails = reqBO.getNewIvDetails();
        ArrayList<PayInvoiceDetail> list = new ArrayList<PayInvoiceDetail>();
        if (null != newIvDetails && newIvDetails.size() > 0) {
            for (PayInvoiceDetailBO bo : newIvDetails) {
                PayInvoiceDetail detail = new PayInvoiceDetail();
                BeanUtils.copyProperties((Object)bo, (Object)detail);
                list.add(detail);
            }
        }
        this.payInvoiceDetailMapper.insertByBatch(list);
        QueryPayInvoiceDetailRspBO rspBO = new QueryPayInvoiceDetailRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"selectByInvoiceNo"})
    public QueryPayInvoiceDetailRspBO selectByInvoiceNo(@RequestBody QueryPayInvoiceDetailReqBO reqBO) {
        if (null == reqBO && null == reqBO.getInvoiceNo()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PayInvoiceDetail> payDetailsInfo = this.payInvoiceDetailMapper.selectByInvoiceNo(reqBO.getInvoiceNo().toString(), reqBO.getNotificationNo());
        ArrayList<PayInvoiceDetailBO> list = new ArrayList<PayInvoiceDetailBO>();
        if (null != payDetailsInfo && payDetailsInfo.size() > 0) {
            for (PayInvoiceDetail bo : payDetailsInfo) {
                PayPurchaseOrderInfo payPurchaseOrderInfo;
                PayInvoiceDetailBO detail = new PayInvoiceDetailBO();
                BeanUtils.copyProperties((Object)bo, (Object)detail);
                if (null != bo.getOrderId() && null != bo.getInspectionId() && null != (payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(bo.getOrderId(), bo.getInspectionId()))) {
                    detail.setPurchaseOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
                    detail.setInspectionCode(payPurchaseOrderInfo.getInspectionCode());
                }
                list.add(detail);
            }
        }
        QueryPayInvoiceDetailRspBO rspBO = new QueryPayInvoiceDetailRspBO();
        rspBO.setInvoiceDetailBOS(list);
        return rspBO;
    }
}

