/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.utils;

import com.tydic.pfsc.utils.FscStringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class AmountUtils {
    private static final String NORMAL_FORMAT = "###,###.00";
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";

    public static String format(BigDecimal amount) {
        if (amount == null) {
            return "";
        }
        DecimalFormat decimalFormat = new DecimalFormat(NORMAL_FORMAT);
        String result = decimalFormat.format(amount);
        if (result.startsWith(".")) {
            result = "0" + result;
        } else if (result.startsWith("-.")) {
            result = new StringBuilder(result).insert(1, "0").toString();
        }
        return result;
    }

    public static String formatWithoutPointAndComma(BigDecimal amount) {
        if (amount == null) {
            return "";
        }
        String result = AmountUtils.format(amount);
        result = result.replaceAll(",", "");
        if (amount.compareTo(amount.setScale(0, 1)) == 0) {
            result = result.substring(0, result.indexOf("."));
        }
        return result;
    }

    public static String upper(BigDecimal amount) {
        if (amount == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int signum = amount.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = amount.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (scale <= 0L) {
            sb.append(CN_FULL);
        }
        return sb.toString();
    }

    public static BigDecimal calcTaxRate(BigDecimal taxAmt, BigDecimal notTaxAmt) {
        if (taxAmt == null || notTaxAmt == null || notTaxAmt.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxAmt.divide(notTaxAmt, 2, 4);
    }

    public static String calcTaxRateEndWithPercentage(BigDecimal taxAmt, BigDecimal notTaxAmt) {
        BigDecimal taxRate = AmountUtils.calcTaxRate(taxAmt, notTaxAmt).multiply(new BigDecimal(100)).setScale(0);
        return FscStringUtils.valueOf(taxRate) + "%";
    }
}

