/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.utils;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileUploadUtil {
    private static final String BASE_UPLOAD_PATH = "fsc";
    @Resource
    FileClient fileClient;
    private static String fileType;
    private static FileClient fileClients;
    private static String bucketName;
    private static String endPoint;
    private static String fastdfsTrackerServers;
    private static String fastdfsHttpTrackerHttpPort;

    @Value(value="${plugin.file.type}")
    public void setFileType(String fileType) {
        FileUploadUtil.fileType = fileType;
    }

    @Value(value="${oss.bucketName}")
    public void setBucketName(String bucketName) {
        FileUploadUtil.bucketName = bucketName;
    }

    @Value(value="${oss.endpoint}")
    public void setEndPoint(String endPoint) {
        FileUploadUtil.endPoint = endPoint;
    }

    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    public void setFastdfsHttpTrackerHttpPort(String fastdfsHttpTrackerHttpPort) {
        FileUploadUtil.fastdfsHttpTrackerHttpPort = fastdfsHttpTrackerHttpPort;
    }

    @Value(value="${fastdfs.trackerServers:}")
    public void setFastdfsTrackerServers(String fastdfsTrackerServers) {
        FileUploadUtil.fastdfsTrackerServers = fastdfsTrackerServers;
    }

    @PostConstruct
    public void init() {
        fileClients = this.fileClient;
    }

    public static String uploadFileToOss(InputStream inputStream, String fileName) {
        String ossFileName = fileClients.uploadFileByInputStream(BASE_UPLOAD_PATH, fileName, inputStream);
        StringBuffer strBuf = new StringBuffer();
        if ("OSS".equals(fileType)) {
            strBuf.append("http://");
            strBuf.append(bucketName);
            strBuf.append(".");
            strBuf.append(endPoint);
            strBuf.append("/");
            strBuf.append(ossFileName);
        } else if ("FASTDFS".equals(fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)ossFileName);
            strBuf.append(fastdfsTrackerServers.substring(0, fastdfsTrackerServers.indexOf(":") + 1));
            strBuf.append(fastdfsHttpTrackerHttpPort);
            strBuf.append("/");
            strBuf.append(fastdfsFileInfo.getGroupName());
            strBuf.append("/");
            strBuf.append(fastdfsFileInfo.getFileName());
        } else {
            throw new PfscExtBusinessException("0001", "\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return strBuf.toString();
    }
}

