/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.tydic.pfsc.dao.MainAcctInfoMapper;
import com.tydic.pfsc.dao.po.MainAcctInfo;
import com.tydic.pfsc.dao.po.SubAcctInfo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.MainAccountService;
import com.tydic.pfsc.service.atom.SubAccountService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mainAccountService")
public class MainAccountServiceImpl
implements MainAccountService {
    private static final Logger logger = LoggerFactory.getLogger(MainAccountService.class);
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private MainAcctInfoMapper mainAcctInfoMapper;

    @Override
    public List<MainAcctInfo> listAccount(MainAcctInfo mainAcctInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u6240\u6709\u4e3b\u8d26\u6237\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        List<MainAcctInfo> mainAcctList = this.mainAcctInfoMapper.selectByConditions(mainAcctInfo);
        return mainAcctList;
    }

    @Override
    public MainAcctInfo addAccount(MainAcctInfo mainAcctInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6dfb\u52a0\u4e3b\u8d26\u6237\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        MainAcctInfo mainAcct = new MainAcctInfo();
        mainAcct.setSource(mainAcctInfo.getSource());
        mainAcct.setOrgId(mainAcctInfo.getOrgId());
        List<MainAcctInfo> mainAcctList = this.mainAcctInfoMapper.selectByConditions(mainAcct);
        if (!mainAcctList.isEmpty()) {
            logger.error("\u673a\u6784\u53f7\uff1a" + mainAcctInfo.getOrgId() + "\u548c\u6765\u6e90\uff1a" + mainAcctInfo.getSource() + "\u5df2\u5b58\u5728\u4e3b\u8d26\u53f7\uff1a" + mainAcctList.get(0).getMainAcctNo());
            throw new PfscExtBusinessException("18002", "\u8be5\u673a\u6784\u53f7\u548c\u6765\u6e90\u5df2\u5b58\u5728\u76f8\u540c\u4e3b\u8d26\u53f7");
        }
        mainAcct = new MainAcctInfo();
        mainAcct.setMainAcctNo(mainAcctInfo.getMainAcctNo());
        List<MainAcctInfo> anthorMainAcctList = this.mainAcctInfoMapper.selectByConditions(mainAcct);
        if (!anthorMainAcctList.isEmpty()) {
            logger.error("\u8f93\u5165\u7684\u4e3b\u8d26\u53f7\u5df2\u5b58\u5728\uff1a" + mainAcctInfo.getMainAcctNo());
            throw new PfscExtBusinessException("18002", "\u8f93\u5165\u7684\u4e3b\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        this.mainAcctInfoMapper.insert(mainAcctInfo);
        return mainAcctInfo;
    }

    @Override
    public MainAcctInfo loadAccount(MainAcctInfo mainAcctInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u52a0\u8f7d\u4e3b\u8d26\u6237\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        if (mainAcctInfo.getOrgId() == null && mainAcctInfo.getMainAcctNo() == null && mainAcctInfo.getSource() == null) {
            return null;
        }
        List<MainAcctInfo> mainAcctList = null;
        if (mainAcctInfo.getMainAcctNo() != null || mainAcctInfo.getOrgId() != null && mainAcctInfo.getSource() != null) {
            mainAcctList = this.mainAcctInfoMapper.selectByConditions(mainAcctInfo);
            if (mainAcctList.isEmpty()) {
                return null;
            }
            return mainAcctList.get(0);
        }
        return null;
    }

    @Override
    public MainAcctInfo ModifyAccount(MainAcctInfo mainAcctInfo) {
        MainAcctInfo oldAcc;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4fee\u6539\u4e3b\u8d26\u6237\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        if ((oldAcc = this.mainAcctInfoMapper.selectByPrimaryKey(mainAcctInfo.getOrgId(), mainAcctInfo.getSource())) == null) {
            logger.error("\u4e3b\u8d26\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new PfscExtBusinessException("18001", "\u4e3b\u8d26\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MainAcctInfo newMainAcc = this.mainAcctInfoMapper.selectByMainAcc(mainAcctInfo.getMainAcctNo());
        if (!oldAcc.getMainAcctNo().equals(mainAcctInfo.getMainAcctNo())) {
            SubAcctInfo subAcctInfo = new SubAcctInfo();
            subAcctInfo.setMainAcctNo(oldAcc.getMainAcctNo());
            if (!this.subAccountService.listSubAccount(subAcctInfo).isEmpty()) {
                logger.error("\u4e3b\u8d26\u53f7\u4e0b\u5df2\u6709\u5b50\u8d26\u6237\uff0c\u4e0d\u53ef\u4fee\u6539");
                throw new PfscExtBusinessException("18002", "\u4e3b\u8d26\u53f7\u4e0b\u5df2\u6709\u5b50\u8d26\u6237\uff0c\u4e0d\u53ef\u4fee\u6539");
            }
            if (!newMainAcc.getOrgId().equals(mainAcctInfo.getOrgId()) || !newMainAcc.getSource().equals(mainAcctInfo.getSource())) {
                logger.error("\u6b64\u8d26\u6237\u5df2\u5728\u5176\u4ed6\u6e20\u9053\u5b58\u5728");
                throw new PfscExtBusinessException("18002", "\u6b64\u8d26\u6237\u5df2\u5728\u5176\u4ed6\u6e20\u9053\u5b58\u5728\uff0c\u4e0d\u53ef\u4fee\u6539");
            }
        }
        newMainAcc.setMainAcctName(mainAcctInfo.getMainAcctName());
        newMainAcc.setMainAcctNo(mainAcctInfo.getMainAcctNo());
        this.mainAcctInfoMapper.updateByPrimaryKeySelective(newMainAcc);
        return newMainAcc;
    }
}

