/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.comb.impl;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfsc.api.busi.BusiExportInSummaryBillService;
import com.tydic.pfsc.api.busi.QueryEntryTotalInfoService;
import com.tydic.pfsc.api.busi.bo.BusiEntryTotalInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiExportInSummaryBillRspBO;
import com.tydic.pfsc.api.busi.bo.InSummaryBO;
import com.tydic.pfsc.api.busi.bo.QueryEntryTotalInfoReqBO;
import com.tydic.pfsc.api.busi.vo.PayInvoiceInfoVO;
import com.tydic.pfsc.api.comb.FscExportInSummaryBillCombService;
import com.tydic.pfsc.api.comb.bo.FscExportInSummaryBillCombReqBO;
import com.tydic.pfsc.api.comb.bo.FscExportReceiptInfoCombRspBO;
import com.tydic.pfsc.common.ExcelFile;
import com.tydic.pfsc.config.FscProperties;
import com.tydic.pfsc.utils.FileUploadUtil;
import com.tydic.pfsc.utils.FscCommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.comb.FscExportInSummaryBillCombService"})
public class FscExportInSummaryBillCombServiceImpl
implements FscExportInSummaryBillCombService {
    private static final Logger log = LoggerFactory.getLogger(FscExportInSummaryBillCombServiceImpl.class);
    @Resource
    FileClient fileClient;
    @Autowired
    private FscProperties fscProperties;
    private static final String BASE_UPLOAD_PATH = "fsc";
    private String[] sheetNames = new String[]{"\u5165\u5e93\u6c47\u603b\u5355"};
    private String[][] ivDetailOutMap = new String[][]{{"applyNo", "B", "S"}, {"purchaseOrderCode", "C", "S"}, {"purchaseName", "D", "S"}, {"supplierName", "E", "S"}, {"invoiceTypeDescr", "F", "S"}, {"invoiceNo", "G", "S"}, {"notTaxAmt", "H", "S"}, {"taxRate", "I", "S"}, {"taxAmt", "J", "S"}, {"amt", "K", "S"}};
    @Autowired
    private QueryEntryTotalInfoService queryEntryTotalInfoService;
    @Autowired
    private BusiExportInSummaryBillService busiExportInSummaryBillService;

    @PostMapping(value={"exportData"})
    public FscExportReceiptInfoCombRspBO exportData(@RequestBody FscExportInSummaryBillCombReqBO reqBo) {
        FscExportReceiptInfoCombRspBO retBO = new FscExportReceiptInfoCombRspBO();
        QueryEntryTotalInfoReqBO queryEntryTotalInfoReqBO = new QueryEntryTotalInfoReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryEntryTotalInfoReqBO);
        List respList = null;
        try {
            log.debug("--\u8bfb\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u6570\u636e\u5bfc\u51faExcel,reqBo=" + reqBo);
            BusiEntryTotalInfoRspBO notifiInvoiceList = this.queryEntryTotalInfoService.queryListPage(queryEntryTotalInfoReqBO);
            if (null == notifiInvoiceList) {
                retBO.setRespCode("18000");
                retBO.setRespDesc("\u83b7\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u6570\u636e\u5931\u8d25");
                return retBO;
            }
            respList = notifiInvoiceList.getRows();
            log.debug("Excel\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa,\u8bfb\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u8fd4\u56de,respList=" + respList);
        }
        catch (Exception e) {
            log.error("\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            retBO.setRespCode("18000");
            retBO.setRespDesc("\u83b7\u53d6\u5165\u5e93\u6c47\u603b\u5355\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return retBO;
        }
        if (respList == null) {
            retBO.setRespCode("0000");
            retBO.setRespDesc("\u67e5\u8be2\u7269\u8d44\u6c47\u603b\u5355\u65e0\u8bb0\u5f55");
            return retBO;
        }
        List inSummaryBOList = null;
        BusiExportInSummaryBillRspBO busiExportInSummaryBillRspBO = null;
        try {
            busiExportInSummaryBillRspBO = this.busiExportInSummaryBillService.export(respList);
            inSummaryBOList = busiExportInSummaryBillRspBO.getRows();
            log.debug("Excel\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa,\u8bfb\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u8fd4\u56de,inSummaryBOList=" + inSummaryBOList);
        }
        catch (Exception e) {
            log.error("\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            retBO.setRespCode("18000");
            retBO.setRespDesc("\u83b7\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa\u6570\u636e\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return retBO;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ExcelFile excel = new ExcelFile();
        int sheetIdx = 0;
        Object[] cellFormat = new String[1];
        excel.createSheet(this.sheetNames[sheetIdx]);
        Object[] headerTitle = new String[]{"\u5e8f\u53f7", "\u6c47\u603b\u5355\u5355\u53f7", "\u8ba2\u5355\u7f16\u53f7", "\u91c7\u8d2d\u5355\u4f4d", "\u4f9b\u5e94\u5546", "\u53d1\u7968\u7c7b\u578b", "\u53d1\u7968\u53f7\u7801", "\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d", "\u7a0e\u7387", "\u7a0e\u989d", "\u4ef7\u7a0e\u5408\u8ba1"};
        cellFormat = new String[headerTitle.length];
        excel.setArrayValueByNames(cellFormat, ",C,,\u9ed1\u4f53:10", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx, headerTitle, 16);
        excel.setArrayValueByNames(cellFormat, "S,CV,", new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setColumnsWidth(sheetIdx, new Integer[]{10, 25, 25, 25, 25, 30, 30, 20, 10, 20, 20});
        if (inSummaryBOList != null) {
            Object[] fieldsData = new String[headerTitle.length];
            int start = 1;
            for (int i = 0; i < inSummaryBOList.size(); ++i) {
                for (PayInvoiceInfoVO payInvoiceInfoVO : ((InSummaryBO)inSummaryBOList.get(i)).getPayInvoiceInfoVOs()) {
                    for (int j = 0; j < this.ivDetailOutMap.length; ++j) {
                        String fieldName = this.ivDetailOutMap[j][0];
                        String cellName = this.ivDetailOutMap[j][1];
                        int idx = ExcelFile.cellNameToIndex((String)cellName);
                        fieldsData[0] = i + 1 + "";
                        fieldsData[idx] = idx <= 5 ? this.getProp(inSummaryBOList.get(i), fieldName) : this.getProp(payInvoiceInfoVO, fieldName);
                    }
                    excel.addRow(sheetIdx, fieldsData, 16);
                }
                if (((InSummaryBO)inSummaryBOList.get(i)).getPayInvoiceInfoVOs().size() > 1) {
                    for (int k = 0; k <= 5; ++k) {
                        excel.mergeCell(0, start, k, start + ((InSummaryBO)inSummaryBOList.get(i)).getPayInvoiceInfoVOs().size() - 1, k);
                    }
                }
                start += ((InSummaryBO)inSummaryBOList.get(i)).getPayInvoiceInfoVOs().size();
                log.debug("EXCEL\u5bfc\u51fa\u6570\u636e:" + Arrays.toString(fieldsData));
            }
            for (int j = 0; j < this.ivDetailOutMap.length; ++j) {
                String cellName = this.ivDetailOutMap[j][1];
                fieldsData[0] = "\u5408\u8ba1";
                if (cellName.equals("H")) {
                    fieldsData[7] = busiExportInSummaryBillRspBO.getNotTaxAmtSum();
                }
                if (cellName.equals("I")) {
                    fieldsData[8] = "\u2014\u2014\u2014\u2014";
                }
                if (cellName.equals("J")) {
                    fieldsData[9] = busiExportInSummaryBillRspBO.getTaxAmtSum();
                }
                if (!cellName.equals("K")) continue;
                fieldsData[10] = busiExportInSummaryBillRspBO.getAmtSum();
            }
            excel.addRow(sheetIdx, fieldsData, 16);
            excel.mergeCell(0, start, 0, start, 6);
        }
        try {
            excel.getWorkBook().write((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        excel.close();
        String fileName = this.sheetNames[0] + ".xls";
        InputStream inputStream = null;
        try {
            inputStream = FscCommonUtils.outputStreamToInputStream((OutputStream)out);
            if (null != inputStream) {
                String ossurl = FileUploadUtil.uploadFileToOss(inputStream, fileName);
                retBO.setUrl(ossurl);
                log.debug("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4fdd\u5b58\u5230\u8def\u5f84(" + retBO.getUrl() + ")\u4e2d");
                retBO.setRespCode("0000");
                retBO.setRespDesc("\u4e0a\u4f20\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
            retBO.setRespCode("18000");
            retBO.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
            return retBO;
        }
        return retBO;
    }

    private Object getProp(Object bean, String name) {
        String v = null;
        try {
            v = org.apache.commons.beanutils.BeanUtils.getProperty((Object)bean, (String)name);
            return v;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bfb\u53d6Bean\u5c5e\u6027\u5230Excel\u6570\u636e\u5217\u5931\u8d25,name=" + name, (Throwable)e);
            return null;
        }
    }
}

