/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom;

import com.tydic.pfsc.api.busi.vo.ElecAllowRefundItemVO;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.PayItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.ElecRefundOprType;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="elecRefundService")
public class ElecRefundService {
    private static final Logger logger = LoggerFactory.getLogger(ElecRefundService.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    public void operate(ElecRefundOprType opr, String saleOrdId, String inspId, String purchaseNo, String operUnitNo, List<ElecAllowRefundItemVO> items) {
        if (opr == ElecRefundOprType.APPLY) {
            this.checkRefundItems(items, true, false);
            this.apply(saleOrdId, inspId, purchaseNo, operUnitNo, items);
        } else if (opr == ElecRefundOprType.REJECT || opr == ElecRefundOprType.CANCEL) {
            this.checkRefundItems(items, false, false);
            this.refundProcess(opr, saleOrdId, inspId, purchaseNo, operUnitNo, items);
        } else if (opr == ElecRefundOprType.ACCEPT) {
            this.checkRefundItems(items, true, true);
            this.refundProcess(opr, saleOrdId, inspId, purchaseNo, operUnitNo, items);
        }
    }

    private void apply(String saleOrdId, String inspId, String purchaseNo, String operUnitNo, List<ElecAllowRefundItemVO> items) {
        this.matchAllowRefundItems(saleOrdId, inspId, purchaseNo, operUnitNo, items, true, false);
        this.updateItemsWithLock(items);
    }

    private void checkRefundItems(List<ElecAllowRefundItemVO> items, boolean needCheckCount, boolean needCheckAmt) {
        if (items == null || items.size() == 0) {
            throw new PfscExtBusinessException("0001", "\u672a\u53d1\u73b0\u9700\u7533\u8bf7\u9000\u8d27\u7684\u5546\u54c1\u6570\u636e(refundItems)");
        }
        for (ElecAllowRefundItemVO itm : items) {
            if (!StringUtils.hasText((String)itm.getSkuId()) && !StringUtils.hasText((String)itm.getSaleItemNo())) {
                throw new PfscExtBusinessException("0001", "\u672a\u53d1\u73b0\u9700\u7533\u8bf7\u9000\u8d27\u7684\u5546\u54c1(skuId)");
            }
            if (needCheckCount && (itm.getRefundCount() == null || itm.getRefundCount().compareTo(BigDecimal.ZERO) <= 0)) {
                throw new PfscExtBusinessException("0001", "\u7533\u8bf7\u9000\u8d27\u6570\u91cf\u5fc5\u987b\u8f93\u5165(refundCount)");
            }
            if (!needCheckAmt || itm.getRefundTotAmt() != null && itm.getRefundTotAmt().compareTo(BigDecimal.ZERO) > 0) continue;
            throw new PfscExtBusinessException("0001", "\u7533\u8bf7\u9000\u8d27\u91d1\u989d\u5fc5\u987b\u8f93\u5165(refundTotAmt)");
        }
    }

    public List<SaleItemInfoVO> queryAllowRefundItems(String saleOrdId, String inspId, String purchaseNo, String operUnitNo, boolean refundStateOnly) {
        SaleItemInfoVO param = new SaleItemInfoVO();
        param.setOrderId(Long.valueOf(saleOrdId));
        param.setInspectionId(Long.valueOf(inspId));
        param.setPurchaseNo(Long.valueOf(purchaseNo));
        param.setOperUnitNo(Long.valueOf(operUnitNo));
        if (refundStateOnly) {
            param.setItemStatus("'07'");
            param.setPayItemStatus("'07'");
        } else {
            param.setItemStatus("'00','07'");
            param.setPayItemStatus("'00','07'");
        }
        return this.saleItemInfoMapper.querySaleJoinPurchaseItems(param);
    }

    private List<ElecAllowRefundItemVO> matchAllowRefundItems(String saleOrdId, String inspId, String purchaseNo, String operUnitNo, List<ElecAllowRefundItemVO> items, boolean needCheckCount, boolean refundStateOnly) {
        List<SaleItemInfoVO> datas = this.queryAllowRefundItems(saleOrdId, inspId, purchaseNo, operUnitNo, refundStateOnly);
        Long compare = null;
        for (ElecAllowRefundItemVO itm : items) {
            compare = StringUtils.hasText((String)itm.getSaleItemNo()) ? Long.valueOf(itm.getSaleItemNo()) : Long.valueOf(itm.getSkuId());
            boolean found = false;
            for (SaleItemInfoVO vo : datas) {
                if (!vo.getSkuId().equals(compare) && !vo.getItemNo().equals(compare)) continue;
                if (vo.getPaySeq() == null) {
                    logger.error("\u4e13\u533a\u9000\u8d27\u64cd\u4f5c\u5931\u8d25,\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6,\u9500\u552e\u660e\u7ec6=" + vo);
                    throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25,\u5546\u54c1\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u627e\u4e0d\u5230\u91c7\u8d2d\u9a8c\u6536\u5355");
                }
                if (needCheckCount && vo.getQuantity().compareTo(itm.getRefundCount()) < 0) {
                    logger.error("\u4e13\u533a\u9000\u8d27\u64cd\u4f5c\u5931\u8d25,\u8d85\u51fa\u5269\u4f59\u6570\u91cf,orderId=" + saleOrdId + ",inspId=" + inspId + ",sku=" + vo.getSkuName());
                    throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25,\u5546\u54c1\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
                }
                itm.setLinkSaleItem((Object)vo);
                found = true;
                break;
            }
            if (found) continue;
            logger.error("\u64cd\u4f5c\u5931\u8d25,\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u6216\u8005\u5546\u54c1\u4e0d\u5b58\u5728,orderId=" + saleOrdId + ",inspId=" + inspId + ",skuId=" + compare);
            throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25,\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u6216\u8005\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        return items;
    }

    private void updateItemsWithLock(List<ElecAllowRefundItemVO> items) {
        SaleItemInfoVO saleUpdate = new SaleItemInfoVO();
        PayItemInfoVO payUpdate = new PayItemInfoVO();
        for (ElecAllowRefundItemVO itm : items) {
            SaleItemInfoVO vo = (SaleItemInfoVO)itm.getLinkSaleItem();
            saleUpdate.setSeq(vo.getSeq());
            saleUpdate.setOrderId(vo.getOrderId());
            saleUpdate.setInspectionId(vo.getInspectionId());
            saleUpdate.setOldLockCount(vo.getRefundLock());
            saleUpdate.setOldItemStatus(vo.getItemStatus());
            saleUpdate.setItemStatus(null);
            if ("00".equals(vo.getItemStatus())) {
                saleUpdate.setItemStatus("07");
            }
            saleUpdate.setRefundLock(vo.getRefundLock() + 1);
            int cnt = this.saleItemInfoMapper.updateRefundLock(saleUpdate);
            logger.debug("\u4e13\u533a\u9000\u8d27\u7533\u8bf7,\u9500\u552e\u8ba2\u5355\u9501\u66f4\u65b0\u6570\u91cf=" + cnt + ",param" + saleUpdate);
            if (cnt == 0) {
                throw new PfscExtBusinessException("18006", "\u9000\u8d27\u7533\u8bf7\u5931\u8d25,\u5546\u54c1\u7684\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u5316,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c");
            }
            payUpdate.setSeq(vo.getPaySeq());
            if (!"00".equals(vo.getPayItemStatus())) continue;
            payUpdate.setItemStatus("07");
            cnt = this.payItemInfoMapper.updateForRefund(payUpdate);
            logger.debug("\u4e13\u533a\u9000\u8d27\u7533\u8bf7,\u91c7\u8d2d\u660e\u7ec6\u72b6\u6001\u66f4\u65b0\u6570\u91cf=" + cnt + ",param" + payUpdate);
            if (cnt != 0) continue;
            throw new PfscExtBusinessException("18006", "\u9000\u8d27\u7533\u8bf7\u5931\u8d25,\u5546\u54c1\u53ef\u80fd\u5df2\u505a\u5f00\u7968\u5904\u7406,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c");
        }
    }

    private void refundProcess(ElecRefundOprType opr, String saleOrdId, String inspId, String purchaseNo, String operUnitNo, List<ElecAllowRefundItemVO> items) {
        this.matchAllowRefundItems(saleOrdId, inspId, purchaseNo, operUnitNo, items, false, true);
        int cnt = 0;
        int newLockCount = 0;
        boolean removeItem = false;
        boolean needUpdatePay = false;
        ArrayList<String> removeItemList = new ArrayList<String>();
        SaleItemInfoVO saleUpdate = new SaleItemInfoVO();
        PayItemInfoVO payUpdate = new PayItemInfoVO();
        for (ElecAllowRefundItemVO itm : items) {
            SaleItemInfoVO vo = (SaleItemInfoVO)itm.getLinkSaleItem();
            saleUpdate = new SaleItemInfoVO();
            payUpdate = new PayItemInfoVO();
            saleUpdate.setOldLockCount(vo.getRefundLock());
            saleUpdate.setOldItemStatus(vo.getItemStatus());
            saleUpdate.setSeq(vo.getSeq());
            saleUpdate.setRefundLock(vo.getRefundLock() - 1);
            saleUpdate.setOrderId(vo.getOrderId());
            saleUpdate.setInspectionId(vo.getInspectionId());
            removeItem = false;
            needUpdatePay = false;
            newLockCount = saleUpdate.getRefundLock();
            if (opr == ElecRefundOprType.ACCEPT) {
                needUpdatePay = true;
                saleUpdate.setQuantity(vo.getQuantity().subtract(itm.getRefundCount()));
                saleUpdate.setAmount(vo.getAmount().subtract(itm.getRefundTotAmt()));
                if (saleUpdate.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
                    if (newLockCount > 0) {
                        logger.info("\u63a5\u53d7\u9000\u8d27\u5931\u8d25,\u6570\u91cf\u5c06\u9000\u5b8c,\u4f46\u662f\u9501\u6570\u91cf\u8fd8\u6709,\u5269\u4f59\u9501\u6570\u91cf=" + newLockCount + ",item=" + saleUpdate);
                        throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25,\u7533\u8bf7\u9000\u8d27\u7684\u6279\u6b21\u4e0e\u5b9e\u9645\u9700\u9000\u8d27\u6570\u91cf\u4e0d\u5339\u914d");
                    }
                    if (saleUpdate.getAmount().compareTo(BigDecimal.ZERO) != 0) {
                        logger.info("\u63a5\u53d7\u9000\u8d27\u5931\u8d25,\u6570\u91cf\u9000\u5b8c,\u4f46\u662f\u91d1\u989d\u4e0d\u4e3a\u96f6,\u91d1\u989d=" + saleUpdate.getAmount() + ",item=" + saleUpdate);
                        throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25,\u7533\u8bf7\u9000\u8d27\u7684\u6279\u6b21\u4e0e\u5b9e\u9645\u9700\u9000\u8d27\u91d1\u989d\u4e0d\u5339\u914d");
                    }
                    removeItem = true;
                }
            }
            if (newLockCount == 0) {
                saleUpdate.setItemStatus(OrderStatus.NO_APPLY.getCode());
                payUpdate.setItemStatus(OrderStatus.NO_APPLY.getCode());
                needUpdatePay = true;
            }
            if (removeItem) {
                cnt = this.saleItemInfoMapper.deleteWithLock(saleUpdate);
                removeItemList.add("\u4e13\u533a\u9000\u8d27,\u5220\u9664\u5546\u54c1\u660e\u7ec6=" + vo);
            } else {
                cnt = this.saleItemInfoMapper.updateRefundLock(saleUpdate);
            }
            logger.debug("\u4e13\u533a\u9000\u8d27\u5904\u7406(" + opr.getDescr() + "),\u9500\u552e\u660e\u7ec6\u66f4\u65b0\u6570\u91cf=" + cnt + ",param=" + saleUpdate);
            if (cnt == 0) {
                throw new PfscExtBusinessException("18006", "\u64cd\u4f5c\u5931\u8d25,\u5546\u54c1\u7684\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u5316,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c");
            }
            if (needUpdatePay) {
                this.saleItemInfoMapper.freshSumForRefund(saleUpdate);
                SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.getModelByPrimaryKey(vo.getOrderId(), vo.getInspectionId());
                if (saleOrderInfo != null && saleOrderInfo.getOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
                    SaleOrderInfo saleOrder = new SaleOrderInfo();
                    saleOrder.setInspectionId(vo.getInspectionId());
                    saleOrder.setOrderStatus(OrderStatus.INVALID.getCode());
                    this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrder);
                }
            }
            payUpdate.setSeq(vo.getPaySeq());
            payUpdate.setOrderId(vo.getPurchaseOrderId());
            payUpdate.setInspectionId(vo.getInspectionId());
            if (opr == ElecRefundOprType.ACCEPT) {
                payUpdate.setQuantity(vo.getPayQuantity().subtract(itm.getRefundCount()));
                if (payUpdate.getQuantity().compareTo(saleUpdate.getQuantity()) != 0) {
                    logger.info("\u4e13\u533a\u9000\u8d27\u5931\u8d25,\u79fb\u9664\u660e\u7ec6\u540e,\u91c7\u8d2d\u9a8c\u6536\u4e0e\u9500\u552e\u9a8c\u6536\u5269\u4f59\u6570\u91cf\u4e0d\u4e00\u81f4,\u91c7\u8d2d\u6570\u91cf=" + payUpdate.getQuantity() + ",\u9500\u552e\u6570\u91cf=" + saleUpdate.getQuantity() + ",vo=" + vo);
                    throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25,\u9500\u552e\u9a8c\u6536\u5355\u548c\u91c7\u8d2d\u9a8c\u6536\u5355\u7684\u5269\u4f59\u6570\u91cf\u4e0d\u4e00\u81f4.");
                }
            }
            if (!needUpdatePay) continue;
            cnt = removeItem ? this.payItemInfoMapper.deleteForRefund(payUpdate) : this.payItemInfoMapper.updateForRefund(payUpdate);
            logger.debug("\u4e13\u533a\u9000\u8d27\u5904\u7406(" + opr.getDescr() + "),\u91c7\u8d2d\u660e\u7ec6\u66f4\u65b0\u6570\u91cf=" + cnt + ",param" + payUpdate);
            if (cnt == 0) {
                throw new PfscExtBusinessException("18006", "\u64cd\u4f5c\u5931\u8d25,\u5546\u54c1\u53ef\u80fd\u5df2\u505a\u5f00\u7968\u5904\u7406,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c");
            }
            this.payItemInfoMapper.freshSumForRefund(payUpdate);
            PayPurchaseOrderInfo payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(vo.getPurchaseOrderId(), vo.getInspectionId());
            if (payPurchaseOrderInfo == null || payPurchaseOrderInfo.getOrderAmt().compareTo(BigDecimal.ZERO) != 0) continue;
            PayPurchaseOrderInfo payPurchaseOrder = new PayPurchaseOrderInfo();
            payPurchaseOrder.setInspectionId(vo.getInspectionId());
            payPurchaseOrder.setOrderStatus(OrderStatus.INVALID.getCode());
            this.payPurchaseOrderInfoMapper.updateBy(payPurchaseOrder);
        }
        logger.debug("\u4e13\u533a\u9000\u8d27\u64cd\u4f5c\u5b8c\u6210(" + opr.getDescr() + "),saleOrd=" + saleOrdId + ",inspId=" + inspId + ",items=" + items);
        if (removeItemList.size() > 0) {
            for (String txt : removeItemList) {
                logger.debug(txt);
            }
        }
    }
}

