/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiElecRefundApplyService;
import com.tydic.pfsc.api.busi.bo.BusiElecRefundApplyReqBO;
import com.tydic.pfsc.api.busi.bo.BusiElecRefundApplyRspBO;
import com.tydic.pfsc.enums.ElecRefundOprType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.ElecRefundService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiElecRefundApplyServiceImpl
implements BusiElecRefundApplyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiElecRefundApplyServiceImpl.class);
    @Autowired
    private ElecRefundService elecRefundService;

    public BusiElecRefundApplyRspBO applyRefund(BusiElecRefundApplyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7535\u529b\u4e13\u533a\u9000\u8d27\u7533\u8bf7,reqBo=" + reqBO);
        }
        String operUnitNo = reqBO.getOperUnitNo();
        String purchaseNo = reqBO.getPurchaseNo();
        if (!StringUtils.hasText((String)operUnitNo)) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u673a\u6784\u65e0\u6548(operUnitNo)");
        }
        if (!StringUtils.hasText((String)purchaseNo)) {
            throw new PfscExtBusinessException("0001", "\u65e0\u6cd5\u786e\u5b9a\u91c7\u8d2d\u5355\u4f4d\u7684\u673a\u6784(purchaseNo)");
        }
        String saleOrdId = reqBO.getSaleOrderId();
        String inspId = reqBO.getInspectionId();
        if (!StringUtils.hasText((String)saleOrdId)) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u53f7\u5fc5\u987b\u8f93\u5165(saleOrderId)");
        }
        if (!StringUtils.hasText((String)inspId)) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7\u5fc5\u987b\u8f93\u5165(inspectionId)");
        }
        if (reqBO.getRefundItems() == null || reqBO.getRefundItems().size() == 0) {
            throw new PfscExtBusinessException("0001", "\u672a\u53d1\u73b0\u9700\u7533\u8bf7\u9000\u8d27\u7684\u5546\u54c1\u6570\u636e(refundItems)");
        }
        this.elecRefundService.operate(ElecRefundOprType.APPLY, saleOrdId, inspId, purchaseNo, operUnitNo, reqBO.getRefundItems());
        return new BusiElecRefundApplyRspBO();
    }
}

