/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.order.extend.ability.saleorder.PebExtSalesSingleDetailsListQueryAbilityService;
import com.tydic.pfsc.api.busi.BusiQuerySaleOrderInfoService;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoItemRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoRspBO;
import com.tydic.pfsc.base.PfscExtRspPageBaseBO;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.DictionaryAtomService;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.umcext.ability.org.UmcGetOrgPurchasingUnitListAbilityService;
import com.tydic.umcext.ability.org.bo.UmcGetOrgPurchasingUnitListAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcGetOrgPurchasingUnitListAbilityRspBO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQuerySaleOrderInfoService"})
public class BusiQuerySaleOrderInfoServiceImpl
implements BusiQuerySaleOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiQuerySaleOrderInfoServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQuerySaleOrderInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private DictionaryAtomService dictionaryAtomService;
    @Autowired
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private UmcGetOrgPurchasingUnitListAbilityService umcGetOrgPurchasingUnitListAbilityService;
    private static final String IS_OPER_UNIT_NO = "0";
    private static final String IS_OPER_UNIT_YES = "1";

    @PostMapping(value={"query"})
    public BusiQuerySaleOrderInfoRspBO query(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String saleOrderCode = reqBO.getSaleOrderCode();
        ArrayList<String> saleOrderCodeList = new ArrayList<String>();
        if (StringUtils.hasText((String)saleOrderCode)) {
            try {
                saleOrderCodeList.addAll(Arrays.asList(saleOrderCode.split(",")));
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        saleOrderInfoVO.setSource(OrderSource.CONSULT_PRICE_FRAME.getCode());
        saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (saleOrderInfoVO.getOrderDateEnd() != null) {
            try {
                String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
            }
            catch (ParseException e) {
                throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        if (!saleOrderCodeList.isEmpty()) {
            saleOrderInfoVO.setSaleOrderCodeList(saleOrderCodeList);
        }
        saleOrderInfoVO.setOrderBy("t.ORDER_ID DESC,t.INSPECTION_ID DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageJoin(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQuerySaleOrderInfoOrderRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            SaleItemInfoVO vo = new SaleItemInfoVO();
            vo.setInspectionId(saleOrderInfo.getInspectionId());
            List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
            ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                if (null != saleItemInfo.getSaleUnitPrice()) {
                    item.setSaleUnitPriceStr(saleItemInfo.getSaleUnitPrice().setScale(2, 1).toString());
                }
                if (null != saleItemInfo.getAmount()) {
                    item.setAmountStr(saleItemInfo.getAmount().setScale(2, 1).toString());
                }
                itemList.add(item);
            }
            BusiQuerySaleOrderInfoOrderRspBO order = new BusiQuerySaleOrderInfoOrderRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
            order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
            order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
            order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
            if (null != order.getOrderAmt()) {
                order.setOrderAmtStr(order.getOrderAmt().setScale(2, 1).toString());
            }
            order.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)saleOrderInfo.getSource())));
            order.setItemInfos(itemList);
            orderList.add(order);
            orgIds.add(saleOrderInfo.getPurchaseProjectId());
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            UmcGetOrgPurchasingUnitListAbilityReqBO umcGetOrgPurchasingUnitListAbilityReqBO = new UmcGetOrgPurchasingUnitListAbilityReqBO();
            umcGetOrgPurchasingUnitListAbilityReqBO.setOrgIds(orgIds);
            umcGetOrgPurchasingUnitListAbilityReqBO.setPageNo(Integer.valueOf(-1));
            umcGetOrgPurchasingUnitListAbilityReqBO.setPageSize(Integer.valueOf(-1));
            UmcGetOrgPurchasingUnitListAbilityRspBO umcGetOrgPurchasingUnitListAbilityRspBO = this.umcGetOrgPurchasingUnitListAbilityService.getOrgPurchasingUnitList(umcGetOrgPurchasingUnitListAbilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)umcGetOrgPurchasingUnitListAbilityRspBO.getRows())) {
                HashMap orgMap = new HashMap();
                umcGetOrgPurchasingUnitListAbilityRspBO.getRows().forEach(purchasingUnitBO -> orgMap.put(purchasingUnitBO.getOrgId(), purchasingUnitBO.getOrgName()));
                orderList.forEach(busiQuerySaleOrderInfoOrderRspBO -> {
                    if (null != busiQuerySaleOrderInfoOrderRspBO.getPurchaseProjectId()) {
                        busiQuerySaleOrderInfoOrderRspBO.setPurchaseProjectName((String)orgMap.get(busiQuerySaleOrderInfoOrderRspBO.getPurchaseProjectId()));
                    }
                });
            }
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    @PostMapping(value={"queryQuerySaleOrderInfo"})
    public PfscExtRspPageBaseBO<BusiQuerySaleOrderInfoRspBO> queryQuerySaleOrderInfo(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        PfscExtRspPageBaseBO rspPage = new PfscExtRspPageBaseBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            if (saleOrderInfoVO.getOrderDateEnd() != null) {
                try {
                    String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                    saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
                }
                catch (ParseException e) {
                    throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
                }
            }
            saleOrderInfoVO.setOrderBy("t.CREATE_TIME DESC");
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            saleOrderInfoVO.setOrderCategory("2");
            log.error("saleOrderInfoVO=" + saleOrderInfoVO);
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPage(saleOrderInfoVO, (Page<Map<String, Object>>)page);
            log.error("saleOrderInfoList=" + saleOrderInfoList);
            ArrayList<BusiQuerySaleOrderInfoRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoRspBO>();
            BigDecimal totalAmt = new BigDecimal(0);
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                BigDecimal addAmt;
                BusiQuerySaleOrderInfoRspBO busiQuerySaleOrderInfoRspBO = new BusiQuerySaleOrderInfoRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQuerySaleOrderInfoRspBO);
                BigDecimal orderAmount = saleOrderInfo.getOrderAmt();
                BigDecimal setScale = orderAmount.setScale(2, 4);
                DecimalFormat decimalFormat = new DecimalFormat("0.00#");
                String strVal = decimalFormat.format(setScale);
                busiQuerySaleOrderInfoRspBO.setOrderAmtStr(strVal);
                SaleItemInfoVO vo = new SaleItemInfoVO();
                vo.setInspectionId(saleOrderInfo.getInspectionId());
                vo.setOrderId(saleOrderInfo.getOrderId());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
                ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                    BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                    BigDecimal saleUnitPrice = saleItemInfo.getSaleUnitPrice();
                    BigDecimal setScale2 = saleUnitPrice.setScale(2, 4);
                    DecimalFormat decimalFormat2 = new DecimalFormat("0.00#");
                    String strVal2 = decimalFormat2.format(setScale2);
                    item.setSaleUnitPriceStr(strVal2);
                    BigDecimal amount = saleItemInfo.getAmount();
                    BigDecimal setScale3 = amount.setScale(2, 4);
                    DecimalFormat decimalFormat3 = new DecimalFormat("0.00#");
                    String strVal3 = decimalFormat3.format(setScale3);
                    item.setAmountStr(strVal3);
                    item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                    item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                    item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                    itemList.add(item);
                }
                busiQuerySaleOrderInfoRspBO.setItemInfos(itemList);
                if (busiQuerySaleOrderInfoRspBO.getPayStatus() != null) {
                    if (busiQuerySaleOrderInfoRspBO.getPayStatus().equals("00")) {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u672a\u4ed8\u6b3e");
                    } else if (busiQuerySaleOrderInfoRspBO.getPayStatus().equals("01")) {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u4ed8\u6b3e\u786e\u8ba4\u4e2d");
                    } else if (busiQuerySaleOrderInfoRspBO.getPayStatus().equals("02")) {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u5df2\u4ed8\u6b3e");
                    } else if (busiQuerySaleOrderInfoRspBO.getPayStatus().equals("03")) {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u8d85\u65f6\u5f85\u4ed8\u6b3e");
                    } else {
                        busiQuerySaleOrderInfoRspBO.setPayStatusStr("\u5df2\u53d6\u6d88");
                    }
                }
                if (busiQuerySaleOrderInfoRspBO.getLatestPayDate() != null) {
                    busiQuerySaleOrderInfoRspBO.setPayTypeStr("\u6388\u4fe1\u652f\u4ed8");
                } else if ("07".equals(busiQuerySaleOrderInfoRspBO.getPayType())) {
                    busiQuerySaleOrderInfoRspBO.setPayTypeStr("\u7ebf\u4e0b\u652f\u4ed8");
                } else {
                    busiQuerySaleOrderInfoRspBO.setPayTypeStr("\u5728\u7ebf\u652f\u4ed8");
                }
                if (saleOrderInfo.getLatestPayDate() != null) {
                    String endYear;
                    Date endDate = new Date();
                    int outDays = 0;
                    SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
                    String startYear = yearFormat.format(saleOrderInfo.getLatestPayDate());
                    if (startYear.equals(endYear = yearFormat.format(endDate))) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(saleOrderInfo.getLatestPayDate());
                        int startDay = calendar.get(6);
                        calendar.setTime(endDate);
                        int endDay = calendar.get(6);
                        outDays = endDay - startDay;
                        if (outDays > 0) {
                            busiQuerySaleOrderInfoRspBO.setOutDays(Integer.valueOf(outDays));
                        }
                    } else {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        long startDateTime = dateFormat.parse(dateFormat.format(saleOrderInfo.getLatestPayDate())).getTime();
                        long endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
                        BigDecimal outDaysB = new BigDecimal(endDateTime).subtract(new BigDecimal(startDateTime));
                        long mss = outDaysB.abs().longValue();
                        outDays = (int)mss / 86400000;
                        busiQuerySaleOrderInfoRspBO.setOutDays(Integer.valueOf(Math.abs(outDays)));
                    }
                }
                totalAmt = addAmt = totalAmt.add(saleOrderInfo.getOrderAmt());
                orderList.add(busiQuerySaleOrderInfoRspBO);
            }
            for (BusiQuerySaleOrderInfoRspBO busiQuerySaleOrderInfoRspBO : orderList) {
                busiQuerySaleOrderInfoRspBO.setTotalAmt(totalAmt);
            }
            rspPage.setRows(orderList);
            rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspPage;
    }

    @PostMapping(value={"queryQuerySaleOrderInfoInspection"})
    public PfscExtRspPageBaseBO<BusiQuerySaleOrderInfoRspBO> queryQuerySaleOrderInfoInspection(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        PfscExtRspPageBaseBO rspPage = new PfscExtRspPageBaseBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            if (saleOrderInfoVO.getOrderDateEnd() != null) {
                try {
                    String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                    saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
                }
                catch (ParseException e) {
                    throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
                }
            }
            saleOrderInfoVO.setOrderBy("t.ORDER_DATE DESC");
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            saleOrderInfoVO.setOrderCategory(IS_OPER_UNIT_NO);
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPage(saleOrderInfoVO, (Page<Map<String, Object>>)page);
            ArrayList<BusiQuerySaleOrderInfoRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoRspBO>();
            BigDecimal totalAmt = new BigDecimal(0);
            ArrayList<Long> orderIdList = new ArrayList<Long>();
            if (saleOrderInfoList == null || saleOrderInfoList.size() == 0) {
                return rspPage;
            }
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                orderIdList.add(saleOrderInfo.getOrderId());
            }
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                SaleOrderInfo saleOrderInfo2 = new SaleOrderInfo();
                saleOrderInfo2.setOrderId(saleOrderInfo.getOrderId());
                saleOrderInfo2.setOrderCategory("2");
                SaleOrderInfo modelBy = this.saleOrderInfoMapper.getModelBy(saleOrderInfo2);
                BusiQuerySaleOrderInfoRspBO busiQuerySaleOrderInfoRspBO = new BusiQuerySaleOrderInfoRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQuerySaleOrderInfoRspBO);
                if (modelBy != null) {
                    busiQuerySaleOrderInfoRspBO.setPayTime(modelBy.getPayTime());
                    busiQuerySaleOrderInfoRspBO.setPayStatus(modelBy.getPayStatus());
                    busiQuerySaleOrderInfoRspBO.setOrderAmtOld(modelBy.getOrderAmtOld());
                    busiQuerySaleOrderInfoRspBO.setPayno(modelBy.getPayno());
                    busiQuerySaleOrderInfoRspBO.setLatestPayDate(modelBy.getLatestPayDate());
                }
                if (busiQuerySaleOrderInfoRspBO.getOrderStatus() != null) {
                    if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("00")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u672a\u63d0\u4ea4");
                    } else if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("01")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u5df2\u63d0\u4ea4");
                    } else if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("02")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u5df2\u5f00\u7968");
                    } else if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("03")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u5df2\u6536\u7968");
                    } else if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("04")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u5df2\u9000\u7968");
                    } else if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("07")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u9000\u8d27\u4e2d");
                    } else if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("08")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u552e\u540e\u4e2d");
                    } else if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("98")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u6302\u8d77");
                    } else if (busiQuerySaleOrderInfoRspBO.getOrderStatus().equals("99")) {
                        busiQuerySaleOrderInfoRspBO.setOrderStatusStr("\u4f5c\u5e9f");
                    }
                }
                orderList.add(busiQuerySaleOrderInfoRspBO);
            }
            log.error("orderList=" + orderList);
            rspPage.setRows(orderList);
            rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspPage;
    }

    @PostMapping(value={"queryTimeOutSaleOrder"})
    public BusiQuerySaleOrderInfoRspBO queryTimeOutSaleOrder(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        BusiQuerySaleOrderInfoRspBO busiQuerySaleOrderInfoRspBO = new BusiQuerySaleOrderInfoRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            saleOrderInfoVO.setOrderCategory("2");
            SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.queryTimeOutSaleOrder(saleOrderInfoVO);
            if (saleOrderInfo != null) {
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQuerySaleOrderInfoRspBO);
                if (saleOrderInfo.getLatestPayDate() != null) {
                    String endYear;
                    Date endDate = new Date();
                    int outDays = 0;
                    SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
                    String startYear = yearFormat.format(saleOrderInfo.getLatestPayDate());
                    if (startYear.equals(endYear = yearFormat.format(endDate))) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(saleOrderInfo.getLatestPayDate());
                        int startDay = calendar.get(6);
                        calendar.setTime(endDate);
                        int endDay = calendar.get(6);
                        outDays = endDay - startDay;
                        if (outDays > 0) {
                            busiQuerySaleOrderInfoRspBO.setOutDays(Integer.valueOf(outDays));
                        }
                    } else {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        long startDateTime = dateFormat.parse(dateFormat.format(saleOrderInfo.getLatestPayDate())).getTime();
                        long endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
                        BigDecimal outDaysB = new BigDecimal(endDateTime).subtract(new BigDecimal(startDateTime));
                        long mss = outDaysB.longValue();
                        outDays = (int)mss / 86400000;
                        busiQuerySaleOrderInfoRspBO.setOutDays(Integer.valueOf(Math.abs(outDays)));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return busiQuerySaleOrderInfoRspBO;
    }

    @PostMapping(value={"queryQuerySaleOrderInfoCount"})
    public BusiQuerySaleOrderInfoRspBO queryQuerySaleOrderInfoCount(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        log.error("BusiQuerySaleOrderInfoReqBO==" + reqBO);
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        try {
            String saleOrderCode = reqBO.getSaleOrderCode();
            ArrayList<String> saleOrderCodeList = new ArrayList<String>();
            if (StringUtils.hasText((String)saleOrderCode)) {
                try {
                    saleOrderCodeList.addAll(Arrays.asList(saleOrderCode.split(",")));
                }
                catch (Exception e) {
                    throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
            }
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            if (!saleOrderCodeList.isEmpty()) {
                saleOrderInfoVO.setSaleOrderCodeList(saleOrderCodeList);
            }
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            log.error("\u5165\u53c2\u4e3a" + saleOrderInfoVO.getCount());
            saleOrderInfoVO.setOrderCategory("2");
            SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.getListPageCount(saleOrderInfoVO);
            if (saleOrderInfo != null) {
                log.error("\u67e5\u8be2\u7684\u6570\u91cf\u4e3a" + saleOrderInfo.getCount());
                rspBO.setCount(saleOrderInfo.getCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }
}

