/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.enums;

import com.tydic.pfsc.enums.BaseEnums;

public enum PayMode implements BaseEnums
{
    ONLINE_PAY("1", "\u5728\u7ebf\u652f\u4ed8"),
    OFFLINE_PAY("2", "\u7ebf\u4e0b\u652f\u4ed8"),
    SHOUXIN_PAY("3", "\u6388\u4fe1\u652f\u4ed8");

    private String groupName = "PS_PAY_TYPE";
    private String code;
    private String codeDescr;

    private PayMode(String code, String codeDescr) {
        this.code = code;
        this.codeDescr = codeDescr;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeDescr() {
        return this.codeDescr;
    }

    public static PayMode getInstance(String code) {
        for (PayMode o : PayMode.values()) {
            if (!o.getCode().equals(code)) continue;
            return o;
        }
        return null;
    }

    public String getCodeAsString() {
        return this.code;
    }

    public String getDescr() {
        return this.codeDescr;
    }
}

