/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom;

import com.tydic.pfsc.dao.MainAcctInfoMapper;
import com.tydic.pfsc.dao.po.MainAcctInfo;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.SubAccountServiceType;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AccountAtomService {
    @Autowired
    private MainAcctInfoMapper mainAcctInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public String obtainSubAccountName4Purchase(String mainAcctNo, Long projectId) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)mainAcctNo) && projectId != null) {
            MainAcctInfo mainAcctInfo = this.mainAcctInfoMapper.selectByMainAcc(mainAcctNo);
            String sourceDescr = OrderSource.getInstance((String)mainAcctInfo.getSource()).getDescr();
            String projectName = this.organizationInfoService.queryProjectName(projectId).getAccountName();
            sb.append(sourceDescr).append(projectName);
        }
        return sb.toString();
    }

    public String obtainSubAccountName4Oper(String mainAcctNo, Integer serviceType) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)mainAcctNo) && serviceType != null) {
            MainAcctInfo mainAcctInfo = this.mainAcctInfoMapper.selectByMainAcc(mainAcctNo);
            String operUnitName = this.organizationInfoService.queryOrgName(mainAcctInfo.getOrgId());
            String sourceDescr = OrderSource.getInstance((String)mainAcctInfo.getSource()).getDescr();
            String serviceTypeDescr = SubAccountServiceType.getInstance(serviceType).getDescr();
            sb.append(operUnitName).append(sourceDescr).append(serviceTypeDescr);
        }
        return sb.toString();
    }
}

