/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfsc.api.busi.vo.OrderInfoVO;
import com.tydic.pfsc.dao.SupplierInfoMapper;
import com.tydic.pfsc.dao.po.SupplierInfo;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BusiNotificationSplitService;
import com.tydic.pfsc.service.atom.EnumsService;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiNotificationSplitServiceImpl
implements BusiNotificationSplitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiNotificationSplitServiceImpl.class);
    private static final String GROUPWAY_NOSPLIT = "noSplitGroup";
    private static final String GROUPWAY_PURUNIT = "purchaseUnitGroup";
    private static final String GROUPWAY_ORDER = "orderGroup";
    private SupplierInfoMapper supplierInfoMapper;
    private EnumsService enumsService;

    @Autowired
    public BusiNotificationSplitServiceImpl(SupplierInfoMapper supplierInfoMapper, EnumsService enumsService) {
        this.supplierInfoMapper = supplierInfoMapper;
        this.enumsService = enumsService;
    }

    @Override
    public List<List<OrderInfoVO>> getSplitResult(List<OrderInfoVO> orderInfos, Integer maxOrderNumber, String groupWay, BigDecimal maxOrderAmt) {
        LinkedList<List<OrderInfoVO>> orderInfosList = null;
        List<List<OrderInfoVO>> orderInfosVal = null;
        if (GROUPWAY_NOSPLIT.equals(groupWay)) {
            orderInfosVal = this.noSplitGroupWay(orderInfos, maxOrderNumber, maxOrderAmt);
        } else if (GROUPWAY_PURUNIT.equals(groupWay)) {
            orderInfosVal = this.purchaseUnitGroupWay(orderInfos, maxOrderNumber, maxOrderAmt);
        } else if (GROUPWAY_ORDER.equals(groupWay)) {
            orderInfosVal = this.orderGroupWay(orderInfos);
        }
        if (!CollectionUtils.isEmpty(orderInfosVal)) {
            LOGGER.debug("\u5206\u7ec4\u65b9\u5f0f" + groupWay + "\u5bf9\u5e94\u7684\u62c6\u5206\u7ed3\u679c\u4e3a:" + JSON.toJSONString(orderInfosVal));
            orderInfosList = new LinkedList<List<OrderInfoVO>>();
            for (List<OrderInfoVO> list : orderInfosVal) {
                if (CollectionUtils.isEmpty(list)) continue;
                orderInfosList.add(list);
            }
        }
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> noSplitGroupWay(List<OrderInfoVO> orderInfos, Integer maxOrderNumber, BigDecimal maxOrderAmt) {
        List<List<OrderInfoVO>> orderInfosList = this.splitByBase(orderInfos);
        orderInfosList = this.splitByMaxOrderNumber(orderInfosList, maxOrderNumber, maxOrderAmt);
        if (this.enumsService.splitBySupplierInvoiceLimit().booleanValue()) {
            orderInfosList = this.splitBySupInvLimit(orderInfosList);
        }
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> purchaseUnitGroupWay(List<OrderInfoVO> orderInfos, Integer maxOrderNumber, BigDecimal maxOrderAmt) {
        List<List<OrderInfoVO>> orderInfosList = this.splitByBase(orderInfos);
        orderInfosList = this.splitByPurchaseUnit(orderInfosList);
        orderInfosList = this.splitByMaxOrderNumber(orderInfosList, maxOrderNumber, maxOrderAmt);
        if (this.enumsService.splitBySupplierInvoiceLimit().booleanValue()) {
            orderInfosList = this.splitBySupInvLimit(orderInfosList);
        }
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> orderGroupWay(List<OrderInfoVO> orderInfos) {
        LinkedList<List<OrderInfoVO>> orderInfosList = new LinkedList<List<OrderInfoVO>>();
        for (OrderInfoVO orderInfoVO : orderInfos) {
            LinkedList<OrderInfoVO> orderInfoForSingleInvoice = new LinkedList<OrderInfoVO>();
            orderInfoForSingleInvoice.add(orderInfoVO);
            orderInfosList.add(orderInfoForSingleInvoice);
        }
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> splitByBase(List<OrderInfoVO> orderInfos) {
        LinkedList<List<OrderInfoVO>> orderInfosList = new LinkedList<List<OrderInfoVO>>();
        orderInfosList.add(orderInfos);
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> splitBySupplier(List<List<OrderInfoVO>> orderInfosList) {
        LinkedList<List<OrderInfoVO>> orderInfosSplitList = new LinkedList<List<OrderInfoVO>>();
        HashMap supplierMap = new HashMap(orderInfosList.size() + 1);
        for (List<OrderInfoVO> list : orderInfosList) {
            for (OrderInfoVO orderInfoVO : list) {
                if (supplierMap.containsKey(orderInfoVO.getSupplierNo())) {
                    ((List)supplierMap.get(orderInfoVO.getSupplierNo())).add(orderInfoVO);
                    continue;
                }
                LinkedList<OrderInfoVO> newOrderInfoList = new LinkedList<OrderInfoVO>();
                newOrderInfoList.add(orderInfoVO);
                supplierMap.put(orderInfoVO.getSupplierNo(), newOrderInfoList);
            }
        }
        for (Map.Entry entry : supplierMap.entrySet()) {
            orderInfosSplitList.add((List<OrderInfoVO>)entry.getValue());
        }
        return orderInfosSplitList;
    }

    private List<List<OrderInfoVO>> splitBySupInvLimit(List<List<OrderInfoVO>> orderInfosList) {
        LinkedList<List<OrderInfoVO>> orderInfosSplitList = new LinkedList<List<OrderInfoVO>>();
        for (List<OrderInfoVO> orderInfoVoList : orderInfosList) {
            BigDecimal totalAmt = BigDecimal.ZERO;
            Long supplierNo = null;
            String source = null;
            for (OrderInfoVO orderInfoVO : orderInfoVoList) {
                totalAmt = totalAmt.add(orderInfoVO.getOrderAmt());
                supplierNo = orderInfoVO.getSupplierNo();
                source = orderInfoVO.getSource();
            }
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(supplierNo);
                if (null == supplierInfo) {
                    throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u5f00\u7968\u9650\u989d\u914d\u7f6e\u8868\uff0c\u4f9b\u5e94\u5546ID:" + supplierNo + "\u627e\u4e0d\u5230\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f");
                }
                if (supplierInfo.getSupInvLimit().compareTo(totalAmt) < 0 && orderInfoVoList.size() > 1) {
                    LinkedList<OrderInfoVO> orderInfoForSingle = new LinkedList<OrderInfoVO>();
                    BigDecimal sumAmtForLoop = BigDecimal.ZERO;
                    for (OrderInfoVO orderInfoVO : orderInfoVoList) {
                        if ((sumAmtForLoop = sumAmtForLoop.add(orderInfoVO.getOrderAmt())).compareTo(supplierInfo.getSupInvLimit()) > 0) {
                            orderInfosSplitList.add(orderInfoForSingle);
                            orderInfoForSingle = new LinkedList();
                            sumAmtForLoop = BigDecimal.ZERO.add(orderInfoVO.getOrderAmt());
                        }
                        orderInfoForSingle.add(orderInfoVO);
                    }
                    orderInfosSplitList.add(orderInfoForSingle);
                    continue;
                }
                orderInfosSplitList.add(orderInfoVoList);
                continue;
            }
            orderInfosSplitList.add(orderInfoVoList);
        }
        return orderInfosSplitList;
    }

    private List<List<OrderInfoVO>> splitByMaxOrderNumber(List<List<OrderInfoVO>> orderInfosList, Integer maxOrderNumber, BigDecimal maxOrderAmt) {
        LinkedList<List<OrderInfoVO>> orderInfosSplitList = new LinkedList<List<OrderInfoVO>>();
        for (List<OrderInfoVO> orderInfoVoList : orderInfosList) {
            LinkedList<OrderInfoVO> minOrderInfoForSingle = new LinkedList<OrderInfoVO>();
            BigDecimal amt = BigDecimal.ZERO;
            for (OrderInfoVO orderInfoVO : orderInfoVoList) {
                if ((amt = amt.add(orderInfoVO.getOrderAmt())).compareTo(maxOrderAmt.multiply(new BigDecimal("10000"))) > 0 || minOrderInfoForSingle.size() >= maxOrderNumber) {
                    if (!CollectionUtils.isEmpty(minOrderInfoForSingle)) {
                        orderInfosSplitList.add(minOrderInfoForSingle);
                    }
                    minOrderInfoForSingle = new LinkedList();
                    amt = orderInfoVO.getOrderAmt();
                }
                minOrderInfoForSingle.add(orderInfoVO);
            }
            orderInfosSplitList.add(minOrderInfoForSingle);
        }
        return orderInfosSplitList;
    }

    private List<List<OrderInfoVO>> splitByPurchaseUnit(List<List<OrderInfoVO>> orderInfosList) {
        LinkedList<List<OrderInfoVO>> orderInfosSplitList = new LinkedList<List<OrderInfoVO>>();
        LinkedList valList = new LinkedList();
        for (List<OrderInfoVO> list : orderInfosList) {
            HashMap purUnitMap = new HashMap(list.size() + 1);
            for (OrderInfoVO orderInfoVO : list) {
                if (purUnitMap.containsKey(orderInfoVO.getPurchaseProjectId())) {
                    ((List)purUnitMap.get(orderInfoVO.getPurchaseProjectId())).add(orderInfoVO);
                    continue;
                }
                LinkedList<OrderInfoVO> newOrderInfoVOList = new LinkedList<OrderInfoVO>();
                newOrderInfoVOList.add(orderInfoVO);
                purUnitMap.put(orderInfoVO.getPurchaseProjectId(), newOrderInfoVOList);
            }
            valList.add(purUnitMap);
        }
        for (Map map : valList) {
            for (Map.Entry entry : map.entrySet()) {
                orderInfosSplitList.add((List<OrderInfoVO>)entry.getValue());
            }
        }
        return orderInfosSplitList;
    }
}

