/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfsc.api.busi.BusiApplyMailRemailService;
import com.tydic.pfsc.api.busi.bo.BusiApplyMailRemailReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.InvoiceMailSentStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.utils.FscStringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiApplyMailRemailService"})
public class BusiApplyMailRemailServiceImpl
implements BusiApplyMailRemailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyMailRemailServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Resource(name="logisticsCenterIdSeq")
    private OrderSequence logisticsCenterIdSeqService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    @PostMapping(value={"process"})
    public PfscExtRspBaseBO process(@RequestBody BusiApplyMailRemailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8865\u6253\u91cd\u53d1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderName())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderProv())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u4eba\u6240\u5c5e\u7701\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderCity())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u4eba\u6240\u5c5e\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderAddr())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderPhone())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mailTicketNos = reqBO.getMailTicketNos();
        if (mailTicketNos == null || mailTicketNos.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setMailTicketNos(reqBO.getMailTicketNos());
            List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                map.put(saleInvoiceInfo.getMailTicketNo(), saleInvoiceInfo.getApplyNo());
            }
            for (String oldMailTicketNo : mailTicketNos) {
                List<SaleInvoiceMailInfo> expressInfos = this.saleInvoiceMailInfoMapper.selectByExpressNo(oldMailTicketNo);
                if (expressInfos.isEmpty()) {
                    throw new PfscExtBusinessException("18001", "\u5feb\u9012\u5355\u53f7:" + oldMailTicketNo + "\u5f55\u5165\u4e0d\u6b63\u786e");
                }
                SaleInvoiceMailInfo firstExpressInfo = expressInfos.get(0);
                if (InvoiceMailSentStatus.NOT_SENT.getCode().equals(firstExpressInfo.getMailStatus())) continue;
                throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + oldMailTicketNo + "\u72b6\u6001\u4e3a" + InvoiceMailSentStatus.getInstance(firstExpressInfo.getMailStatus().toString()).getDescr() + "\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
        }
        catch (Exception e) {
            logger.debug("\u8865\u6253\u91cd\u53d1\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u53d6\u6d88\u91cd\u53d1\u5931\u8d25", e);
        }
        return new PfscExtRspBaseBO();
    }

    private void cancelAndRemail(SaleInvoiceMailInfo oldMail, BusiApplyMailRemailReqBO reqBO, String applyNo) {
        BillApplyInfo applyInfoPO = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        String province = FscStringUtils.valueOf(applyInfoPO.getProvince());
        String city = FscStringUtils.valueOf(applyInfoPO.getCity());
        String county = FscStringUtils.valueOf(applyInfoPO.getCounty());
        String town = FscStringUtils.valueOf(applyInfoPO.getTown());
        String addrDesc = FscStringUtils.valueOf(applyInfoPO.getAddrDesc());
        String addressStr = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
        Long outLogisticsOrderId = 0L;
        try {
            outLogisticsOrderId = this.logisticsCenterIdSeqService.nextId();
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8ba2\u5355\u6dfb\u52a0\u5931\u8d25:" + e.toString());
        }
        this.saleInvoiceMailInfoMapper.deleteByPrimaryKey(oldMail.getMailTicketNo());
        SaleInvoiceMailInfo newMail = new SaleInvoiceMailInfo();
        BeanUtils.copyProperties((Object)oldMail, (Object)newMail);
        newMail.setMailStatus(InvoiceMailSentStatus.NOT_SENT.getCode());
        newMail.setJdAssignStatus(null);
        newMail.setFailReason(null);
        newMail.setCreateUser(reqBO.getSenderName());
        newMail.setCreateDate(new Date());
        this.saleInvoiceMailInfoMapper.insert(newMail);
        SaleInvoiceInfoVO updateInvoiceVO = new SaleInvoiceInfoVO();
        this.saleInvoiceInfoMapper.updateBy(updateInvoiceVO);
    }
}

