/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiCancelBillApplyInfoDlzqService;
import com.tydic.pfsc.api.busi.bo.BusiCancelBillApplyInfoDlzqReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.BillApplyInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiCancelBillApplyInfoDlzqService"})
public class BusiCancelBillApplyInfoDlzqServiceImpl
implements BusiCancelBillApplyInfoDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelBillApplyInfoDlzqServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    @PostMapping(value={"update"})
    public PfscExtRspBaseBO update(@RequestBody BusiCancelBillApplyInfoDlzqReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u529b\u4e13\u533a)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List applyNoList = reqBO.getApplyNoList();
        if (applyNoList == null || applyNoList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
        for (BillApplyInfo apply : applys) {
            if (!BillStatus.NO_APPLY.getCode().equals(apply.getBillStatus())) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f" + BillStatus.NO_APPLY.getDescr());
            }
            if (reqBO.getCompanyId().equals(apply.getOperUnitNo())) continue;
            throw new PfscExtBusinessException("18000", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
        }
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        billApplyInfoVO.setBillStatus(BillStatus.NO_APPLY.getCode());
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setBillStatus(BillStatus.CANCEL_APPLY.getCode());
        this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo);
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setApplyNoList(applyNoList);
        List<Long> inspectionIdList = this.saleItemInfoMapper.selectDistinctInspectionId(saleItemInfoVO);
        if (!inspectionIdList.isEmpty()) {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setInspectionIdList(inspectionIdList);
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setApplyNo(null);
            saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            this.saleOrderInfoMapper.cancelBillApplyInfo(saleOrderInfoVO, saleOrderInfo);
        }
        saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setApplyNoList(applyNoList);
        SaleItemInfo saleItemInfo = new SaleItemInfo();
        saleItemInfo.setApplyNo(null);
        saleItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
        this.saleItemInfoMapper.cancelBillApplyInfo(saleItemInfoVO, saleItemInfo);
        return new PfscExtRspBaseBO();
    }
}

