/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiOrderPushBillApplyStatusService;
import com.tydic.pfsc.api.busi.bo.OrderPushBillApplyStatusReqBO;
import com.tydic.pfsc.api.busi.bo.OrderPushBillApplyStatusRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemApplyInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemApplyInfoVO;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiOrderPushBillApplyStatusService"})
public class BusiOrderPushBillApplyStatusServiceImpl
implements BusiOrderPushBillApplyStatusService {
    private static final Logger log = LoggerFactory.getLogger(BusiOrderPushBillApplyStatusServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @PostMapping(value={"orderPushBillApplyStatus"})
    public OrderPushBillApplyStatusRspBO orderPushBillApplyStatus(@RequestBody OrderPushBillApplyStatusReqBO orderPushBillApplyStatusReqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u552e\u540e\u8fc7\u7a0b\u8ba2\u5355\u5411\u7ed3\u7b97\u63a8\u9001\u7533\u8bf7\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + orderPushBillApplyStatusReqBO.toString());
        }
        if (null == orderPushBillApplyStatusReqBO.getInspectionId()) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPushBillApplyStatusReqBO.getAfterSaleStatus()) {
            throw new PfscExtBusinessException("0001", "\u552e\u540e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderPushBillApplyStatusRspBO rspBO = null;
        try {
            rspBO = new OrderPushBillApplyStatusRspBO();
            SaleItemApplyInfoVO saleItemApplyInfoVO = new SaleItemApplyInfoVO();
            saleItemApplyInfoVO.setInspectionId(Long.parseLong(orderPushBillApplyStatusReqBO.getInspectionId()));
            String applyNo = this.saleOrderInfoMapper.getApplyNoByInspectionId(Long.parseLong(orderPushBillApplyStatusReqBO.getInspectionId()));
            if (applyNo != null && applyNo != "") {
                BillApplyInfo record = new BillApplyInfo();
                record.setApplyNo(applyNo);
                record.setAfterSaleStatus(orderPushBillApplyStatusReqBO.getAfterSaleStatus().toString());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(record);
            } else {
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setInspectionId(Long.parseLong(orderPushBillApplyStatusReqBO.getInspectionId()));
                this.saleOrderInfoMapper.deleteBy(saleOrderInfo);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u552e\u540e\u8fc7\u7a0b\u8ba2\u5355\u5411\u7ed3\u7b97\u63a8\u9001\u7533\u8bf7\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38" + e);
            throw new PfscExtBusinessException("18001", "\u552e\u540e\u8fc7\u7a0b\u8ba2\u5355\u5411\u7ed3\u7b97\u63a8\u9001\u7533\u8bf7\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38" + e);
        }
        return rspBO;
    }
}

