/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.FscPayApplyRetryService;
import com.tydic.pfsc.api.busi.bo.FscPayApplyRetryReqBO;
import com.tydic.pfsc.api.busi.bo.FscPayApplyRetryRspBO;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.DicDictionaryMapper;
import com.tydic.pfsc.dao.bo.DicDictionaryPO;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.BillNotificationInfoExt;
import com.tydic.pfsc.enums.ApplyPayStatus2;
import com.tydic.pfsc.enums.PayChannel;
import com.tydic.pfsc.external.zjpt.api.ZjptPayBillUpService;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpReqBO;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpRspBO;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpServiceReqBO;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpServiceRspBO;
import com.tydic.umcext.ability.org.UmcACompanyInfoDetailAbilityService;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceReqBO;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceRspBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.FscPayApplyRetryService"})
public class FscPayApplyRetryServiceImpl
implements FscPayApplyRetryService {
    private static final Logger log = LoggerFactory.getLogger(FscPayApplyRetryServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ZjptPayBillUpService zjptPayBillUpService;
    @Autowired
    private UmcACompanyInfoDetailAbilityService umcACompanyInfoDetailAbilityService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;

    @PostMapping(value={"dealPayApplyRetry"})
    public FscPayApplyRetryRspBO dealPayApplyRetry(@RequestBody FscPayApplyRetryReqBO reqBO) {
        FscPayApplyRetryRspBO rspBO = new FscPayApplyRetryRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayNo())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u652f\u4ed8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayStatus())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u652f\u4ed8\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayno(reqBO.getPayNo());
        applyPayInfoPO.setPayStatus(reqBO.getPayStatus());
        ApplyPayInfoPO applyPayInfoPOResult = this.applyPayInfoMapper.getModelBy2(applyPayInfoPO);
        if (applyPayInfoPOResult == null) {
            rspBO.setRespCode("18001");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u5355\u53f7\u4e3a[" + reqBO.getPayNo() + "]\u7684\u8bb0\u5f55");
            return rspBO;
        }
        try {
            Long purchaserCompanyId = 0L;
            BillNotificationInfoExt billNotificationInfoExt = new BillNotificationInfoExt();
            billNotificationInfoExt.setPayNo(reqBO.getPayNo());
            List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.selectForPage(billNotificationInfoExt);
            if (billNotificationInfos != null && billNotificationInfos.size() > 0) {
                purchaserCompanyId = billNotificationInfos.get(0).getPurchaseCompanyId();
            }
            UmcACompanyInfoDetailAbilityServiceReqBO umcACompanyInfoDetailAbilityServiceReqBO = new UmcACompanyInfoDetailAbilityServiceReqBO();
            umcACompanyInfoDetailAbilityServiceReqBO.setCompanyId(purchaserCompanyId);
            log.error("getDetailACompanyInfo\u65b9\u6cd5\u5165\u53c2==" + umcACompanyInfoDetailAbilityServiceReqBO);
            UmcACompanyInfoDetailAbilityServiceRspBO detailACompanyInfo = this.umcACompanyInfoDetailAbilityService.getDetailACompanyInfo(umcACompanyInfoDetailAbilityServiceReqBO);
            log.error("detailACompanyInfo\u65b9\u6cd5\u51fa\u53c2==" + detailACompanyInfo);
            ZjptPayBillUpServiceReqBO zjptPayBillUpServiceReqBO = new ZjptPayBillUpServiceReqBO();
            ArrayList<ZjptPayBillUpReqBO> zjptPayBillUpReqBOS = new ArrayList<ZjptPayBillUpReqBO>();
            ZjptPayBillUpReqBO zjptPayBillUpReqBO = new ZjptPayBillUpReqBO();
            zjptPayBillUpReqBO.setDataSource("MRP");
            zjptPayBillUpReqBO.setSerialNoErp(reqBO.getPayNo());
            zjptPayBillUpReqBO.setAmt(applyPayInfoPOResult.getPayAmt());
            DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
            dicDictionaryPO.setPCode("ATOUR_COMPANY_INFO");
            dicDictionaryPO.setCode(purchaserCompanyId.toString());
            DicDictionaryPO dicDictionaryPOResult = this.dicDictionaryMapper.getModelByCondition(dicDictionaryPO);
            if (null != dicDictionaryPOResult) {
                zjptPayBillUpReqBO.setCorpCode(dicDictionaryPOResult.getTitle());
            }
            zjptPayBillUpReqBO.setPayerAccNo(detailACompanyInfo.getBankAccount());
            zjptPayBillUpReqBO.setPayeeAccNo(applyPayInfoPOResult.getReceiptAcctNo());
            zjptPayBillUpReqBO.setPayeeAccName(applyPayInfoPOResult.getRecAcctName());
            zjptPayBillUpReqBO.setPayeeCode(applyPayInfoPOResult.getBankLineCode());
            zjptPayBillUpReqBO.setVoucherType("0");
            zjptPayBillUpReqBO.setIsforindividual("0");
            zjptPayBillUpReqBO.setAbs(reqBO.getPayNo());
            if (PayChannel.OFFLINE.getCode().equals(applyPayInfoPOResult.getPayChannel())) {
                zjptPayBillUpReqBO.setPurpose(reqBO.getPayNo());
            }
            zjptPayBillUpReqBOS.add(zjptPayBillUpReqBO);
            zjptPayBillUpServiceReqBO.setZjptPayBillUpReqBOS(zjptPayBillUpReqBOS);
            ZjptPayBillUpServiceRspBO zjptPayBillUpServiceRspBO = this.zjptPayBillUpService.payBillUp(zjptPayBillUpServiceReqBO);
            if (zjptPayBillUpServiceRspBO != null && zjptPayBillUpServiceRspBO.getZjptPayBillUpRspBOS() != null) {
                List zjptPayBillUpRspBOS = zjptPayBillUpServiceRspBO.getZjptPayBillUpRspBOS();
                ZjptPayBillUpRspBO zjptPayBillUpRspBO = (ZjptPayBillUpRspBO)zjptPayBillUpRspBOS.get(0);
                if ("1".equals(zjptPayBillUpRspBO.getStatus())) {
                    ApplyPayInfoPO payInfoPO = new ApplyPayInfoPO();
                    payInfoPO.setPayno(reqBO.getPayNo());
                    payInfoPO.setPayStatus(ApplyPayStatus2.PAY_FAILED.getCode());
                    payInfoPO.setReasons(zjptPayBillUpRspBO.getMessage());
                    this.applyPayInfoMapper.updateStatus(payInfoPO);
                } else if ("2".equals(zjptPayBillUpRspBO.getStatus())) {
                    ApplyPayInfoPO payInfoPO = new ApplyPayInfoPO();
                    payInfoPO.setPayno(reqBO.getPayNo());
                    payInfoPO.setPayStatus(ApplyPayStatus2.PAYING.getCode());
                    this.applyPayInfoMapper.updateStatusRetZjptReason(payInfoPO);
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25\u91cd\u8bd5\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25\u91cd\u8bd5\u5f02\u5e38\uff01");
        }
        return rspBO;
    }
}

