/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.PayQryCheckingService;
import com.tydic.pfsc.api.busi.bo.PayQryCheckingReqBO;
import com.tydic.pfsc.api.busi.bo.PayQryCheckingRspBO;
import com.tydic.pfsc.api.busi.vo.PayCheckingVO;
import com.tydic.pfsc.dao.InquiryCheckingMapper;
import com.tydic.pfsc.dao.po.PayCheckingRst;
import com.tydic.pfsc.dao.vo.PayCheckingRstVO;
import com.tydic.pfsc.enums.InquiryPayPass;
import com.tydic.pfsc.enums.InquiryPaymentStatus;
import com.tydic.pfsc.enums.InquiryTransState;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayQryCheckingServiceImpl
implements PayQryCheckingService {
    private static final Logger logger = LoggerFactory.getLogger(PayQryCheckingServiceImpl.class);
    @Autowired
    private InquiryCheckingMapper inquiryCheckingMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;

    public PayQryCheckingRspBO<PayCheckingVO> queryChecking(PayQryCheckingReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5bf9\u8d26\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e13\u4e1a\u516c\u53f8\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PayCheckingRstVO record = new PayCheckingRstVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        if (null != reqBO.getStartDate() && !"".equals(reqBO.getStartDate())) {
            try {
                Date startDate = sdf.parse(reqBO.getStartDate());
                record.setStartDate(startDate);
            }
            catch (Exception e) {
                logger.error("\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                throw new PfscExtBusinessException("0001", "\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (null != reqBO.getEndDate() && !"".equals(reqBO.getEndDate())) {
            try {
                Date endDate = sdf.parse(reqBO.getEndDate());
                record.setEndDate(endDate);
            }
            catch (Exception e) {
                logger.error("\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                throw new PfscExtBusinessException("0001", "\u5165\u53c2\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (null != reqBO.getStartDate() && !"".equals(reqBO.getStartDate()) && null != reqBO.getEndDate() && !"".equals(reqBO.getEndDate()) && record.getStartDate().after(record.getEndDate())) {
            throw new PfscExtBusinessException("0001", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65e5\u671f!");
        }
        record.setOperUnitNo(reqBO.getCompanyId());
        record.setSupplierId(reqBO.getSupplierId());
        record.setInquiryNo(reqBO.getInquiryNo());
        record.setCheckingRst(reqBO.getCheckingRst());
        PayQryCheckingRspBO payQryCheckingRspBO = new PayQryCheckingRspBO();
        LinkedList<PayCheckingVO> rspBOs = new LinkedList<PayCheckingVO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<PayCheckingRst> payCheckingResultInfos = this.inquiryCheckingMapper.queryListPage(record, (Page<Map<String, Object>>)page);
        for (PayCheckingRst po : payCheckingResultInfos) {
            PayCheckingVO vo = new PayCheckingVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            String supplierName = this.organizationInfoService.querySupplierName(po.getSupplierId());
            vo.setSupplierName(supplierName);
            vo.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(po.getPayPass())));
            vo.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(po.getPaymentStatus())));
            vo.setTransStateDesc(this.enumsService.getDescr(InquiryTransState.getInstance(po.getTransState())));
            rspBOs.add(vo);
        }
        payQryCheckingRspBO.setRows(rspBOs);
        payQryCheckingRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        payQryCheckingRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        payQryCheckingRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return payQryCheckingRspBO;
    }
}

