/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.QueryPayableDetailByIdService;
import com.tydic.pfsc.api.busi.bo.QueryPayableDetailByIdReqBO;
import com.tydic.pfsc.api.busi.bo.QueryPayableDetailByIdRspBO;
import com.tydic.pfsc.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayableDetailMapper;
import com.tydic.pfsc.dao.SupplierInfoMapper;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.enums.PayChannel;
import com.tydic.pfsc.enums.PayableStatus2;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrderService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.QueryPayableDetailByIdService"})
public class QueryPayableDetailByIdServiceImpl
implements QueryPayableDetailByIdService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayableDetailByIdServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    @PostMapping(value={"queryById"})
    public QueryPayableDetailByIdRspBO queryById(@RequestBody QueryPayableDetailByIdReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6\u8868\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        QueryPayableDetailByIdRspBO rspBO = new QueryPayableDetailByIdRspBO();
        List idList = reqBO.getIds();
        LinkedList<BillNotificationInfoVO> voList = new LinkedList<BillNotificationInfoVO>();
        if (null == idList || idList.size() <= 0) {
            ApplyPayInfoPO applyPayInfoPO;
            BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
            billNotificationInfo.setPayNo(reqBO.getPayNo());
            List<BillNotificationInfo> list = this.billNotificationInfoMapper.selectList(billNotificationInfo);
            if (!CollectionUtils.isEmpty(list)) {
                for (BillNotificationInfo billNotificationInfo1 : list) {
                    idList.add(billNotificationInfo1.getNotificationNo());
                }
            }
            if (null != (applyPayInfoPO = this.applyPayInfoMapper.getModelById(reqBO.getPayNo()))) {
                rspBO.setPayChannel(applyPayInfoPO.getPayChannel());
                if (PayChannel.OFFLINE.getCode().equals(applyPayInfoPO.getPayChannel())) {
                    rspBO.setPayChannelStr(PayChannel.OFFLINE.getDescr());
                } else if (PayChannel.NC.getCode().equals(applyPayInfoPO.getPayChannel())) {
                    rspBO.setPayChannelStr(PayChannel.NC.getDescr());
                }
                if (null != applyPayInfoPO.getRemark() && !"".equals(applyPayInfoPO.getRemark())) {
                    rspBO.setRemark(applyPayInfoPO.getRemark());
                }
                rspBO.setBankLineCode(applyPayInfoPO.getBankLineCode());
            }
        }
        for (String id : idList) {
            BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(id);
            if (billNotificationInfo == null) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u5355\u53f7:" + id + "\uff0c\u5728\u5f00\u7968\u901a\u77e5\u5355\u8be6\u60c5\u67e5\u8be2\u4e2d\u65e0\u5339\u914d\u7ed3\u679c");
            }
            logger.debug("\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f\uff1a" + billNotificationInfo.toString());
            UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
            umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(billNotificationInfo.getSupplierNo());
            UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
            if (null != umcQrySupplierInfoDetailAbilityRspBO) {
                String supplierName;
                String bankName;
                String bankAccountName;
                String bankAcct = umcQrySupplierInfoDetailAbilityRspBO.getBankAccount();
                if (null != bankAcct && !"".equals(bankAcct)) {
                    rspBO.setBankAcct(bankAcct);
                }
                if (null != (bankAccountName = umcQrySupplierInfoDetailAbilityRspBO.getBankAccountName()) && !"".equals(bankAccountName)) {
                    rspBO.setRecieverAcctName(bankAccountName);
                }
                if (null != (bankName = umcQrySupplierInfoDetailAbilityRspBO.getBankName()) && !"".equals(bankName)) {
                    rspBO.setOpenBank(bankName);
                }
                if (null != (supplierName = umcQrySupplierInfoDetailAbilityRspBO.getSupplierName()) && !"".equals(supplierName)) {
                    rspBO.setSupplierName(supplierName);
                }
                rspBO.setSupplierId(billNotificationInfo.getSupplierNo().toString());
            }
            BillNotificationInfoVO vo = new BillNotificationInfoVO();
            BeanUtils.copyProperties((Object)billNotificationInfo, (Object)vo);
            vo.setPayNo(billNotificationInfo.getPayNo());
            if (PayableStatus2.NO_APPLY.getCode().equals(vo.getPayableStatus())) {
                vo.setPayableStatusStr(PayableStatus2.NO_APPLY.getDescr());
            } else {
                vo.setPayableStatusStr(PayableStatus2.APPLIED.getDescr());
            }
            if (null != vo.getPayableAmt()) {
                vo.setPayableAmtStr(vo.getPayableAmt().setScale(2, 1).toString());
            }
            if (null != vo.getAdvanceAmt()) {
                vo.setAdvanceAmtStr(vo.getAdvanceAmt().setScale(2, 1).toString());
            }
            voList.add(vo);
        }
        rspBO.setList(voList);
        return rspBO;
    }

    @PostMapping(value={"queryByPayInfo"})
    public QueryPayableDetailByIdRspBO queryByPayInfo(@RequestBody QueryPayableDetailByIdReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u652f\u4ed8\u5355\u4ed8\u6b3e\u7533\u8bf7\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getIds())) {
            throw new PfscExtBusinessException("18001", "\u652f\u4ed8\u5355\u4ed8\u6b3e\u7533\u8bf7\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayableDetailByIdRspBO rspBO = new QueryPayableDetailByIdRspBO();
        List idList = reqBO.getIds();
        HashSet purchaseOrderIdsSet = new HashSet();
        ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(reqBO.getPayNo());
        if (applyPayInfoPO == null) {
            throw new PfscExtBusinessException("18000", "\u65e0\u5bf9\u5e94\u652f\u4ed8\u5355");
        }
        UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
        umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(applyPayInfoPO.getSupplierId());
        UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
        if (null != umcQrySupplierInfoDetailAbilityRspBO) {
            String bankName;
            String bankAccountName;
            String bankAcct = umcQrySupplierInfoDetailAbilityRspBO.getBankAccount();
            if (null != bankAcct && !"".equals(bankAcct)) {
                rspBO.setBankAcct(bankAcct);
            }
            if (null != (bankAccountName = umcQrySupplierInfoDetailAbilityRspBO.getBankAccountName()) && !"".equals(bankAccountName)) {
                rspBO.setRecieverAcctName(bankAccountName);
            }
            if (null != (bankName = umcQrySupplierInfoDetailAbilityRspBO.getBankName()) && !"".equals(bankName)) {
                rspBO.setOpenBank(bankName);
            }
        }
        rspBO.setSupplierName(applyPayInfoPO.getSupplierName());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

