/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.deal.impl;

import com.tydic.pfsc.api.deal.QueryPayOrderInfoCountService;
import com.tydic.pfsc.api.deal.bo.QueryPayOrderInfoCountReqBO;
import com.tydic.pfsc.api.deal.bo.QueryPayOrderInfoCountRspBO;
import com.tydic.pfsc.dao.PayOrderInfoMapper;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.deal.QueryPayOrderInfoCountService"})
public class QueryPayOrderInfoCountServiceImpl
implements QueryPayOrderInfoCountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPayOrderInfoCountServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;

    @PostMapping(value={"queryPayOrderInfoCount"})
    public QueryPayOrderInfoCountRspBO queryPayOrderInfoCount(@RequestBody QueryPayOrderInfoCountReqBO queryPayOrderInfoReqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5165\u53c2\uff1a" + queryPayOrderInfoReqBO);
        }
        if (null == queryPayOrderInfoReqBO.getSupplierId()) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayOrderInfoCountRspBO rspBO = new QueryPayOrderInfoCountRspBO();
        try {
            Integer count = this.payOrderInfoMapper.selectCountForSup(queryPayOrderInfoReqBO.getSupplierId());
            if (null != count) {
                rspBO.setPayOrderCount(count);
            } else {
                rspBO.setPayOrderCount(Integer.valueOf(0));
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5f85\u529e\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f85\u529e\u670d\u52a1\u5931\u8d25");
        }
        return rspBO;
    }
}

