/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.pay.impl;

import com.tydic.payment.pay.ability.PayProAbleQueryOrderStatusAbilityService;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.pfsc.api.busi.BusiUpdateApplyPayInfoService;
import com.tydic.pfsc.api.busi.bo.AddApplyPayInfoFscReqBo;
import com.tydic.pfsc.api.pay.PayReturnInfoService;
import com.tydic.pfsc.api.pay.bo.PayReturnInfoReqBO;
import com.tydic.pfsc.api.pay.bo.PayReturnInfoRspBO;
import com.tydic.pfsc.dao.PaymentFlowInfoMapper;
import com.tydic.pfsc.dao.PaymentLogMapper;
import com.tydic.pfsc.dao.po.PaymentFlowInfo;
import com.tydic.pfsc.dao.po.PaymentLog;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.Date;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.pay.PayReturnInfoService"})
public class PayReturnInfoServiceImpl
implements PayReturnInfoService {
    private static final Logger logger = LoggerFactory.getLogger(PayReturnInfoServiceImpl.class);
    @Autowired
    private PayProAbleQueryOrderStatusAbilityService payProAbleQueryOrderStatusAbilityService;
    @Value(value="${publicKey}")
    private String publicKey;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private BusiUpdateApplyPayInfoService busiUpdateApplyPayInfoService;

    @PostMapping(value={"payReturnInfo"})
    public PayReturnInfoRspBO payReturnInfo(@RequestBody PayReturnInfoReqBO reqBO) {
        PayReturnInfoRspBO rspBO = new PayReturnInfoRspBO();
        if (null == reqBO.getBusiCode()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u7cfb\u7edf\u7f16\u7801[busiCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContent()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u52a0\u5bc6\u5185\u5bb9[content]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String content = reqBO.getContent();
            String retStr = PayCenterUtils.deCode((String)content, (String)this.publicKey);
            this.savelog("PayReturnInfoService", reqBO.toString(), retStr);
            JSONObject jsonObject = JSONObject.fromObject((Object)retStr);
            if (null != jsonObject) {
                String outOrderId = jsonObject.getString("outOrderId");
                String resultCode = jsonObject.getString("resultCode");
                String resultMsg = jsonObject.getString("resultMsg");
                String payNotifyTransId = jsonObject.getString("payNotifyTransId");
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                paymentFlowInfo.setOutOrderId(outOrderId);
                paymentFlowInfo.setPaymentStatus(resultCode);
                paymentFlowInfo.setOrderRemark(resultMsg);
                paymentFlowInfo.setResultJson(retStr);
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
                AddApplyPayInfoFscReqBo addApplyPayInfoFscReqBo = new AddApplyPayInfoFscReqBo();
                addApplyPayInfoFscReqBo.setPayno(outOrderId);
                addApplyPayInfoFscReqBo.setPaySerialNo(outOrderId);
                addApplyPayInfoFscReqBo.setUnionPaySerialNo(payNotifyTransId);
                try {
                    this.busiUpdateApplyPayInfoService.updateApplyPayInfo(addApplyPayInfoFscReqBo);
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u4fee\u6539\u652f\u4ed8\u5355\u72b6\u6001\u5931\u8d25\uff1a" + e);
                }
            }
            rspBO.setResultCode("SUCCESS");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25,\uff1a" + e);
            this.savelog("PayReturnInfoService", reqBO.toString(), reqBO.getContent());
            throw new PfscExtBusinessException("18000", "\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25:" + e);
        }
        return rspBO;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

