/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.zm.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.zm.BillApplyInfoListService;
import com.tydic.pfsc.api.zm.bo.BillInfoAndOrderInfoReqBO;
import com.tydic.pfsc.api.zm.bo.BillInfoAndOrderInfoRspBO;
import com.tydic.pfsc.api.zm.bo.OrderInfoBO;
import com.tydic.pfsc.api.zm.vo.BillInfoAndOrderInfoVO;
import com.tydic.pfsc.api.zm.vo.OrderInfoVO11;
import com.tydic.pfsc.base.PfscExtRspPageBaseBO;
import com.tydic.pfsc.dao.SaleBillInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.enums.BillStatus1;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.ReconciliationStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.zm.BillApplyInfoListService"})
public class BillApplyInfoListServiceImpl
implements BillApplyInfoListService {
    private static final Logger logger = LoggerFactory.getLogger(BillApplyInfoListServiceImpl.class);
    @Autowired
    private SaleBillInfoMapper saleBillInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    @PostMapping(value={"queryZmBillInfo"})
    public PfscExtRspPageBaseBO<BillInfoAndOrderInfoRspBO> queryZmBillInfo(@RequestBody BillInfoAndOrderInfoReqBO billInfoAndOrderInfoReqBO) {
        Page page = new Page(billInfoAndOrderInfoReqBO.getPageNo() < 1 ? 1 : billInfoAndOrderInfoReqBO.getPageNo(), billInfoAndOrderInfoReqBO.getPageSize() < 1 ? 10 : billInfoAndOrderInfoReqBO.getPageSize());
        PfscExtRspPageBaseBO rsp = new PfscExtRspPageBaseBO();
        ArrayList<BillInfoAndOrderInfoRspBO> billInfoAndOrderInfoRspBOS = new ArrayList<BillInfoAndOrderInfoRspBO>();
        try {
            List<BillInfoAndOrderInfoVO> billInfoAndOrderInfoVOS = this.saleBillInfoMapper.selectByBillStatus(billInfoAndOrderInfoReqBO, (Page<Map<String, Object>>)page);
            logger.error("\u67e5\u8be2\u8d26\u5355\u5217\u8868" + billInfoAndOrderInfoVOS.toString());
            String dd = "";
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (null != billInfoAndOrderInfoVOS) {
                for (BillInfoAndOrderInfoVO billInfoAndOrderInfoVO : billInfoAndOrderInfoVOS) {
                    ArrayList<OrderInfoBO> orderInfoBOS = new ArrayList<OrderInfoBO>();
                    BillInfoAndOrderInfoRspBO billInfoAndOrderInfoRspBO = new BillInfoAndOrderInfoRspBO();
                    BeanUtils.copyProperties((Object)billInfoAndOrderInfoVO, (Object)billInfoAndOrderInfoRspBO);
                    logger.debug("\u8d26\u5355\uff1a" + billInfoAndOrderInfoRspBO.toString());
                    dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(billInfoAndOrderInfoVO.getBillDate().toString()));
                    billInfoAndOrderInfoRspBO.setBillDate(dd);
                    billInfoAndOrderInfoRspBO.setBillStatus(BillStatus1.getInstance(billInfoAndOrderInfoRspBO.getBillStatus()).getDescr());
                    String projectName = this.organizationInfoService.queryProjectName((long)Long.valueOf(billInfoAndOrderInfoVO.getPurchaseProjectId())).getAccountName();
                    billInfoAndOrderInfoRspBO.setPurchaseProjectName(projectName);
                    List<OrderInfoVO11> orderInfoVO11s = this.saleBillInfoMapper.selectOrderSale2(billInfoAndOrderInfoVO.getBillNo());
                    logger.debug("\u8d26\u5355billNo:" + billInfoAndOrderInfoVO.getBillNo() + "\u67e5\u8be2\u5230\u7684\u8ba2\u5355\uff1a" + orderInfoVO11s.size());
                    for (OrderInfoVO11 orderInfoVO : orderInfoVO11s) {
                        OrderInfoBO orderInfoBO = new OrderInfoBO();
                        BeanUtils.copyProperties((Object)orderInfoVO, (Object)orderInfoBO);
                        dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(orderInfoVO.getOrderCreateDate().toString()));
                        orderInfoBO.setOrderCreateDate(dd);
                        orderInfoBO.setUpstreamNotificationStatus(NotificationInvoiceStatus.getInstance(orderInfoBO.getUpstreamNotificationStatus()).getCodeDescr());
                        orderInfoBO.setUpstreamReconciliationStatus(ReconciliationStatus.getInstance(String.valueOf(orderInfoVO.getUpstreamReconciliationStatus())).getDescr());
                        orderInfoBOS.add(orderInfoBO);
                    }
                    billInfoAndOrderInfoRspBO.setOrderInfoVOS(orderInfoBOS);
                    billInfoAndOrderInfoRspBOS.add(billInfoAndOrderInfoRspBO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8d26\u5355\u5217\u8868\u5931\u8d25" + e, (Throwable)e);
            rsp.setRespDesc("\u5931\u8d25");
            rsp.setRespCode("18000");
            rsp.setRows(billInfoAndOrderInfoRspBOS);
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u67e5\u8be2\u8d26\u5355\u5217\u8868\u5931\u8d25");
        }
        rsp.setRows(billInfoAndOrderInfoRspBOS);
        rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rsp.setPageNo(Integer.valueOf(page.getPageNo()));
        rsp.setTotal(Integer.valueOf(page.getTotalPages()));
        rsp.setRespDesc("\u6210\u529f");
        rsp.setRespCode("0000");
        return rsp;
    }
}

