/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.pec.ability.bo.PebDealOrderBO;
import com.tydic.order.pec.bo.order.PebOrderApprovalReqBO;
import com.tydic.order.pec.bo.order.PebOrderApprovalRspBO;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.pfsc.api.busi.BatchApprovalApplyPayService;
import com.tydic.pfsc.api.busi.BusiFscExternalSystemLogService;
import com.tydic.pfsc.api.busi.bo.BatchApprovalApplyPayReqBO;
import com.tydic.pfsc.api.busi.bo.BatchApprovalApplyPayRspBO;
import com.tydic.pfsc.api.busi.bo.DeptBO;
import com.tydic.pfsc.constants.FscCommonConstants;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.DicDictionaryMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.PaymentLogMapper;
import com.tydic.pfsc.dao.ReceivableBillUpMapper;
import com.tydic.pfsc.dao.UocOrdBusiOperRecordMapper;
import com.tydic.pfsc.dao.bo.DicDictionaryPO;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.BillNotificationInfoExt;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.PaymentLog;
import com.tydic.pfsc.dao.po.ReceivableBillUpPO;
import com.tydic.pfsc.dao.po.UocOrdBusiOperRecord;
import com.tydic.pfsc.enums.ApplyPayStatus2;
import com.tydic.pfsc.enums.PayChannel;
import com.tydic.pfsc.enums.PayableStatus2;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.nc.api.NcPaymentNoteBillUpService;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpItemBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpReqBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpRspBO;
import com.tydic.pfsc.external.zjpt.api.ZjptPayBillUpService;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpReqBO;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpRspBO;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpServiceReqBO;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpServiceRspBO;
import com.tydic.pfsc.utils.MidDataPool;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.umcext.ability.org.UmcACompanyInfoDetailAbilityService;
import com.tydic.umcext.ability.org.UmcYdEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceReqBO;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcYdEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BatchApprovalApplyPayService"})
public class BatchApprovalApplyPayServiceImpl
implements BatchApprovalApplyPayService {
    private static final Logger log = LoggerFactory.getLogger(BatchApprovalApplyPayServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BatchApprovalApplyPayServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private NcPaymentNoteBillUpService ncPaymentNoteBillUpService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private UmcYdEnterpriseOrgQueryAbilityService umcYdEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcACompanyInfoDetailAbilityService umcACompanyInfoDetailAbilityService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UocOrdBusiOperRecordMapper uocOrdBusiOperRecordMapper;
    @Autowired
    private ZjptPayBillUpService zjptPayBillUpService;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private Environment prop;
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;
    @Autowired
    private ReceivableBillUpMapper receivableBillUpMapper;
    @Autowired
    private BusiFscExternalSystemLogService busiFscExternalSystemLogService;

    @PostMapping(value={"batchApprovalApplyPay"})
    public BatchApprovalApplyPayRspBO batchApprovalApplyPay(@RequestBody BatchApprovalApplyPayReqBO reqBO) {
        BatchApprovalApplyPayRspBO rspBO = new BatchApprovalApplyPayRspBO();
        if (null == reqBO.getFlag()) {
            throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPayNos())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ApplyPayInfoPO> list = this.applyPayInfoMapper.getModelByIds(reqBO.getPayNos());
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u672a\u67e5\u627e\u5230\u76f8\u5173\u4ed8\u6b3e\u7533\u8bf7\u5355");
            return rspBO;
        }
        List payStatus = list.stream().map(ApplyPayInfoPO::getPayStatus).collect(Collectors.toList());
        long count = payStatus.stream().distinct().count();
        logger.debug("222======" + count);
        if (count > 1L) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e0d\u4e00\u81f4");
        }
        try {
            Integer flag = reqBO.getFlag();
            logger.debug("\u5ba1\u6279\u6807\u8bc6\uff1a" + flag);
            logger.debug("\u9a73\u56de\u539f\u56e0=====" + reqBO.getReason());
            if (2 == flag) {
                String payNo = (String)reqBO.getPayNos().get(0);
                logger.debug("\u91cd\u65b0\u53d1\u8d77\u5f00\u59cb==payNo\uff1a" + payNo);
                ApplyPayInfoPO applyPayPO = this.applyPayInfoMapper.getModelById(payNo);
                if (null != applyPayPO && ApplyPayStatus2.REJECT.getCode().equals(applyPayPO.getPayStatus())) {
                    ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
                    applyPayInfoPO.setPayno(payNo);
                    applyPayInfoPO.setApplyDate(new Date());
                    applyPayInfoPO.setOperatorId(reqBO.getUserId());
                    applyPayInfoPO.setPayStatus(ApplyPayStatus2.PENDING_APPROVAL.getCode());
                    applyPayInfoPO.setCompanyId(reqBO.getCompanyId());
                    applyPayInfoPO.setCompanyName(reqBO.getCompanyName());
                    this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                    flag = 0;
                    reqBO.setReason("\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7");
                    logger.debug("\u91cd\u65b0\u53d1\u8d77\u7ed3\u675f==" + reqBO.getReason());
                } else {
                    throw new PfscExtBusinessException("18000", "\u53ea\u6709\u5ba1\u6838\u9a73\u56de\u72b6\u6001\u624d\u80fd\u91cd\u65b0\u53d1\u8d77");
                }
            }
            PebOrderApprovalRspBO approvalRspBO = new PebOrderApprovalRspBO();
            PebOrderApprovalReqBO approvalReqBO = new PebOrderApprovalReqBO();
            approvalReqBO.setAuditResult(flag);
            approvalReqBO.setOperId(reqBO.getUserId().toString());
            approvalReqBO.setUserId(reqBO.getUserId());
            approvalReqBO.setOperDept(reqBO.getOrgId().toString());
            approvalReqBO.setCompanyId(reqBO.getCompanyId());
            approvalReqBO.setCompanyName(reqBO.getCompanyName());
            approvalReqBO.setUsername(reqBO.getMemNickName());
            approvalReqBO.setApprovalRemark(reqBO.getReason());
            ArrayList<PebDealOrderBO> orderApprovalList = new ArrayList<PebDealOrderBO>();
            for (ApplyPayInfoPO payInfoPO : list) {
                PebDealOrderBO pebDealOrderBO = new PebDealOrderBO();
                pebDealOrderBO.setStepId(payInfoPO.getStepId());
                pebDealOrderBO.setOrderId(Long.valueOf(payInfoPO.getPayno()));
                pebDealOrderBO.setSaleVoucherId(Long.valueOf(payInfoPO.getPayno()));
                orderApprovalList.add(pebDealOrderBO);
            }
            approvalReqBO.setOrderApprovalList(orderApprovalList);
            this.audit(approvalReqBO, approvalRspBO, reqBO.getFlag());
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6279\u5931\u8d25\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u64cd\u4f5c\u6210\u529f\uff01");
        return rspBO;
    }

    private void paymentNoteBillUp(ApplyPayInfoPO appo) {
        log.error("\u751f\u6210\u4ed8\u6b3e\u5355");
        BillNotificationInfoExt billNotificationInfoExt = new BillNotificationInfoExt();
        billNotificationInfoExt.setPayNo(appo.getPayno());
        List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.selectForPage(billNotificationInfoExt);
        if (billNotificationInfos != null && billNotificationInfos.size() > 0) {
            for (BillNotificationInfo bio : billNotificationInfos) {
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setNotificationNo(bio.getNotificationNo());
                log.error(payPurchaseOrderInfo.toString());
                List<PayPurchaseOrderInfo> payPurchaseOrderInfoList2 = this.payPurchaseOrderInfoMapper.getList2(payPurchaseOrderInfo);
                if (payPurchaseOrderInfoList2 == null || payPurchaseOrderInfoList2.size() <= 0) continue;
                for (PayPurchaseOrderInfo poo : payPurchaseOrderInfoList2) {
                    UmcACompanyInfoDetailAbilityServiceReqBO umcACompanyInfoDetailAbilityServiceReqBO = new UmcACompanyInfoDetailAbilityServiceReqBO();
                    umcACompanyInfoDetailAbilityServiceReqBO.setCompanyId(poo.getPurchaseCompanyId());
                    log.error("getDetailACompanyInfo\u65b9\u6cd5\u5165\u53c2==" + umcACompanyInfoDetailAbilityServiceReqBO);
                    UmcACompanyInfoDetailAbilityServiceRspBO detailACompanyInfo = this.umcACompanyInfoDetailAbilityService.getDetailACompanyInfo(umcACompanyInfoDetailAbilityServiceReqBO);
                    log.error("detailACompanyInfo\u65b9\u6cd5\u51fa\u53c2==" + detailACompanyInfo);
                    NcPaymentNoteBillUpReqBO ncPaymentNoteBillUpReqBO = new NcPaymentNoteBillUpReqBO();
                    NcPaymentNoteBillUpBO ncPaymentNoteBillUpBO = new NcPaymentNoteBillUpBO();
                    ArrayList<NcPaymentNoteBillUpItemBO> ncPaymentNoteBillUpItemBOS = new ArrayList<NcPaymentNoteBillUpItemBO>();
                    ncPaymentNoteBillUpReqBO.setId(appo.getPayno());
                    UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = new UmcQrySupplierInfoDetailAbilityRspBO();
                    String supplierCode = "";
                    String outsideOnlineRetailersPower = "";
                    String replaceSupplierCode = "";
                    try {
                        UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
                        umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(poo.getSupplierNo());
                        log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u8be6\u60c5\u5165\u53c2" + umcQrySupplierInfoDetailAbilityReqBO);
                        umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
                        log.error("\u8c03\u7528\u4f9b\u5e94\u5546\u8be6\u60c5\u51fa\u53c2" + umcQrySupplierInfoDetailAbilityRspBO);
                        supplierCode = umcQrySupplierInfoDetailAbilityRspBO.getSupplierCode();
                        outsideOnlineRetailersPower = umcQrySupplierInfoDetailAbilityRspBO.getOutsideOnlineRetailersPower();
                        replaceSupplierCode = null;
                        if (supplierCode != null) {
                            replaceSupplierCode = supplierCode.replace("NC-", "");
                        }
                    }
                    catch (Exception e) {
                        log.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u8be6\u60c5\u62a5\u9519===================================");
                    }
                    UmcYdEnterpriseOrgQueryAbilityReqBO umcYdEnterpriseOrgQueryAbilityReqBO = new UmcYdEnterpriseOrgQueryAbilityReqBO();
                    umcYdEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(poo.getPurchaseNo());
                    log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u5165\u53c2" + umcYdEnterpriseOrgQueryAbilityReqBO);
                    UmcYdEnterpriseOrgDetailAbilityRspBO umcYdEnterpriseOrgDetailAbilityRspBO = this.umcYdEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcYdEnterpriseOrgQueryAbilityReqBO);
                    log.debug("\u8c03\u7528queryEnterpriseOrgByDetail\u51fa\u53c2" + umcYdEnterpriseOrgDetailAbilityRspBO);
                    String orgTypeNC = "";
                    if (umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                        orgTypeNC = umcYdEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTypeNc();
                    }
                    String pk_deptid = null;
                    String saleCompanyCode = "";
                    String saleCompanyId = String.valueOf(poo.getPurchaseCompanyId());
                    DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
                    dicDictionaryPO.setPCode("ATOUR_COMPANY_INFO");
                    dicDictionaryPO.setCode(saleCompanyId);
                    DicDictionaryPO dicDictionaryPOResult = this.dicDictionaryMapper.getModelByCondition(dicDictionaryPO);
                    if (null != dicDictionaryPOResult) {
                        saleCompanyCode = dicDictionaryPOResult.getTitle();
                    }
                    log.error("\u8c03\u7528nc\u89c6\u56fe\u5f00\u59cb======================");
                    log.error("\u7532\u65b9\u62ac\u5934\u7f16\u7801saleCompanyCode==" + saleCompanyCode);
                    List saleCompanyIdList = MidDataPool.getJdbcTemplatePre().query("select orgcode,orgname,deptcode,deptname from v_b2b_dept where orgcode ='" + saleCompanyCode + "';", (RowMapper)new BeanPropertyRowMapper(DeptBO.class));
                    if (saleCompanyIdList != null && saleCompanyIdList.size() > 0) {
                        log.error("saleCompanyIdList.size" + saleCompanyIdList.size());
                        for (DeptBO dbo : saleCompanyIdList) {
                            if (!dbo.getDeptcode().equals(dicDictionaryPOResult.getDescrip())) continue;
                            pk_deptid = dbo.getDeptcode();
                        }
                    }
                    log.error("\u8c03\u7528nc\u89c6\u56fe\u7ed3\u675f======================");
                    Date d = new Date();
                    System.out.println(d);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String dateNowStr = sdf.format(d);
                    ncPaymentNoteBillUpBO.setBilldate(dateNowStr);
                    ncPaymentNoteBillUpBO.setBillmaker("B2B");
                    ncPaymentNoteBillUpBO.setCreator("B2B");
                    ncPaymentNoteBillUpBO.setBillstatus(0);
                    ncPaymentNoteBillUpBO.setIsinit("N");
                    ncPaymentNoteBillUpBO.setIsreded("N");
                    ncPaymentNoteBillUpBO.setLocal_money(poo.getOrderAmt());
                    ncPaymentNoteBillUpBO.setMoney(poo.getOrderAmt());
                    ncPaymentNoteBillUpBO.setObjtype(1);
                    ncPaymentNoteBillUpBO.setPk_tradetype("F3-Cxx-03");
                    ncPaymentNoteBillUpBO.setPk_billtype("F3");
                    ncPaymentNoteBillUpBO.setPk_balatype("3");
                    ncPaymentNoteBillUpBO.setPk_currtype("CNY");
                    ncPaymentNoteBillUpBO.setPk_deptid(pk_deptid);
                    ncPaymentNoteBillUpBO.setPk_group("000");
                    ncPaymentNoteBillUpBO.setPk_org(saleCompanyCode);
                    ncPaymentNoteBillUpBO.setSrc_syscode(0);
                    ncPaymentNoteBillUpBO.setSyscode(0);
                    ncPaymentNoteBillUpBO.setPayaccount(detailACompanyInfo.getBankAccount());
                    ncPaymentNoteBillUpBO.setRecaccount(appo.getReceiptAcctNo());
                    if (appo.getRemark() != null) {
                        ncPaymentNoteBillUpBO.setDef10(appo.getRemark());
                    } else {
                        ncPaymentNoteBillUpBO.setDef10("");
                    }
                    ncPaymentNoteBillUpBO.setDef6(appo.getPayno());
                    ncPaymentNoteBillUpBO.setSupplier(replaceSupplierCode);
                    List<PayItemInfo> payItemInfoList = this.payItemInfoMapper.selectByNotifNoAndOrderId(bio.getNotificationNo(), poo.getOrderId(), poo.getInspectionId());
                    if (payItemInfoList != null && payItemInfoList.size() > 0) {
                        for (PayItemInfo pif : payItemInfoList) {
                            NcPaymentNoteBillUpItemBO ncPaymentNoteBillUpItemBO = new NcPaymentNoteBillUpItemBO();
                            ncPaymentNoteBillUpItemBO.setLocal_money_bal(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setLocal_money_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setLocal_notax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setMoney_bal(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setMoney_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setObjtype(1);
                            ncPaymentNoteBillUpItemBO.setGlobaldebit(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGlobalnotax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGroupdebit(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setGroupnotax_de(pif.getAmount());
                            ncPaymentNoteBillUpItemBO.setPk_currtype("CNY");
                            ncPaymentNoteBillUpItemBO.setPk_deptid(pk_deptid);
                            ncPaymentNoteBillUpItemBO.setPk_org(saleCompanyCode);
                            ncPaymentNoteBillUpItemBO.setPk_tradetype("F3-Cxx-03");
                            ncPaymentNoteBillUpItemBO.setSett_org(saleCompanyCode);
                            ncPaymentNoteBillUpItemBO.setPrepay("0");
                            ncPaymentNoteBillUpItemBO.setPk_balatype("3");
                            if (umcQrySupplierInfoDetailAbilityRspBO != null) {
                                ncPaymentNoteBillUpItemBO.setSupplier(replaceSupplierCode);
                            } else {
                                ncPaymentNoteBillUpItemBO.setSupplier("");
                            }
                            ncPaymentNoteBillUpItemBO.setPayaccount(detailACompanyInfo.getBankAccount());
                            ncPaymentNoteBillUpItemBO.setRecaccount(appo.getReceiptAcctNo());
                            ncPaymentNoteBillUpItemBO.setScomment(appo.getPayno());
                            ncPaymentNoteBillUpItemBO.setPk_recpaytype("01");
                            ncPaymentNoteBillUpItemBO.setDef2(poo.getInspectionCode());
                            if (outsideOnlineRetailersPower != null) {
                                if (outsideOnlineRetailersPower.equals("1")) {
                                    ncPaymentNoteBillUpItemBO.setDef27("02");
                                } else if (outsideOnlineRetailersPower.equals("2")) {
                                    ncPaymentNoteBillUpItemBO.setDef27("01");
                                }
                            }
                            if ("03".equals(orgTypeNC)) {
                                ncPaymentNoteBillUpItemBO.setDef28("02");
                            } else {
                                ncPaymentNoteBillUpItemBO.setDef28(orgTypeNC);
                            }
                            BigDecimal getAmount = pif.getAmount();
                            if (getAmount != null && getAmount.compareTo(BigDecimal.ZERO) != 0) {
                                ncPaymentNoteBillUpItemBOS.add(ncPaymentNoteBillUpItemBO);
                                continue;
                            }
                            this.busiFscExternalSystemLogService.addLogRecord("04", "0", JSON.toJSONString((Object)ncPaymentNoteBillUpItemBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "", "\u4ed8\u6b3e\u5355\u63a8NC,\u5546\u54c1\u91d1\u989d\u4e3a0\u8fc7\u6ee4");
                        }
                    }
                    ncPaymentNoteBillUpReqBO.setBillHead(ncPaymentNoteBillUpBO);
                    ncPaymentNoteBillUpReqBO.setItem(ncPaymentNoteBillUpItemBOS);
                    String ncPaymentNoteBillUpReqBOJson = JSONArray.toJSON((Object)ncPaymentNoteBillUpReqBO).toString();
                    log.error("\u4ed8\u6b3e\u5355json=====" + ncPaymentNoteBillUpReqBOJson);
                    BigDecimal orderAmt = poo.getOrderAmt();
                    if (orderAmt != null && orderAmt.compareTo(BigDecimal.ZERO) != 0) {
                        NcPaymentNoteBillUpRspBO ncPaymentNoteBillUpRspBO = this.ncPaymentNoteBillUpService.paymentNoteBillUp(ncPaymentNoteBillUpReqBO);
                        this.resultCacheFaill(ncPaymentNoteBillUpReqBO, ncPaymentNoteBillUpRspBO);
                        continue;
                    }
                    this.busiFscExternalSystemLogService.addLogRecord("04", "0", JSON.toJSONString((Object)ncPaymentNoteBillUpReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "", "\u4ed8\u6b3e\u5355\u63a8NC,\u8ba2\u5355\u91d1\u989d\u4e3a0\u8fc7\u6ee4");
                    log.debug("\u8ba2\u5355\u91d1\u989d\u4e3a\u96f6\uff0c\u672a\u63a8\u9001NC:{}", (Object)JSON.toJSONString((Object)ncPaymentNoteBillUpReqBO));
                }
            }
        }
    }

    private void resultCacheFaill(NcPaymentNoteBillUpReqBO ncPaymentNoteBillUpReqBO, NcPaymentNoteBillUpRspBO ncPaymentNoteBillUpRspBO) {
        ReceivableBillUpPO receivableBillUpPO = new ReceivableBillUpPO();
        receivableBillUpPO.setOrderId(System.currentTimeMillis());
        receivableBillUpPO.setInspectionId(System.currentTimeMillis() * 100L + (long)new Double((Math.random() * 9.0 + 1.0) * Math.pow(10.0, 2.0)).intValue());
        receivableBillUpPO.setCreateTime(new Date());
        receivableBillUpPO.setTag("30");
        receivableBillUpPO.setPushStatus("0");
        receivableBillUpPO.setNcReceivableBillUpJson(JSON.toJSONString((Object)ncPaymentNoteBillUpReqBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        if (ncPaymentNoteBillUpRspBO.getRespCode().equals("8888")) {
            log.error("\u63a8\u9001\u4ed8\u6b3e\u5355\u62a5\u9519================================================");
            receivableBillUpPO.setResultMessage("\u8fde\u63a5nc\u5931\u8d25\uff1a" + ncPaymentNoteBillUpRspBO.getRespDesc());
            int count = this.receivableBillUpMapper.insert(receivableBillUpPO);
            log.debug("\u63d2\u5165count\uff1a{}", (Object)count);
        } else if (ncPaymentNoteBillUpRspBO.getRespCode().equals("-31202")) {
            receivableBillUpPO.setResultMessage(JSON.toJSONString((Object)ncPaymentNoteBillUpRspBO));
            int count = this.receivableBillUpMapper.insert(receivableBillUpPO);
            log.debug("\u63d2\u5165count\uff1a{}", (Object)count);
        } else if (ncPaymentNoteBillUpRspBO.getRespCode().equals("1")) {
            log.debug("\u63a8\u9001\u6210\u529f\uff01{}", (Object)ncPaymentNoteBillUpRspBO.getResultdescription());
        } else {
            this.busiFscExternalSystemLogService.addLogRecord("04", "0", JSON.toJSONString((Object)receivableBillUpPO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSON.toJSONString((Object)ncPaymentNoteBillUpRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "\u4ed8\u6b3e\u5355\u63a8NC,\u672a\u77e5\u8fd4\u56de\u7801\u65e5\u5fd7");
            log.debug("\u672a\u5904\u7406\u72b6\u6001\u7801,\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)ncPaymentNoteBillUpRspBO));
        }
    }

    private void audit(PebOrderApprovalReqBO reqBO, PebOrderApprovalRspBO rspBO, int flag) {
        logger.debug("\u5ba1\u6279\u63a5\u53e3\u5165\u53c21===" + reqBO.getOrderApprovalList().toString());
        List orderApprovalList = reqBO.getOrderApprovalList();
        Map<String, List<PebDealOrderBO>> map = orderApprovalList.stream().collect(Collectors.groupingBy(PebDealOrderBO::getStepId));
        logger.debug("\u5ba1\u6279\u63a5\u53e3\u5165\u53c22===" + map.toString());
        for (String key : map.keySet()) {
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            uacNoTaskAuditOrderAuditReqBO.setStepId(key);
            uacNoTaskAuditOrderAuditReqBO.setAuditResult(reqBO.getAuditResult());
            uacNoTaskAuditOrderAuditReqBO.setOperId(reqBO.getOperId());
            uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getMemNickName());
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApprovalRemark());
            uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOperDept());
            uacNoTaskAuditOrderAuditReqBO.setObjType(FscCommonConstants.OBJ_TYPE.FSC_APPLY_PAY_APPROVAL);
            ArrayList<Long> objIds = new ArrayList<Long>();
            HashMap<String, Number> variables = new HashMap<String, Number>();
            for (PebDealOrderBO id : map.get(key)) {
                objIds.add(id.getSaleVoucherId());
                ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(id.getOrderId().toString());
                variables.put("amountFlag", applyPayInfoPO.getPayAmt());
                variables.put("approvalResult", reqBO.getAuditResult());
            }
            uacNoTaskAuditOrderAuditReqBO.setVariables(variables);
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
            logger.debug("\u5ba1\u6279\u63a5\u53e3\u5165\u53c23===" + uacNoTaskAuditOrderAuditReqBO.toString());
            UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
            if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
                throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
            }
            logger.debug("\u5ba1\u6279\u63a5\u53e3\u51fa\u53c24===" + uacNoTaskAuditOrderAuditRspBO.toString());
            this.dealSuccess(map.get(key), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish(), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId(), reqBO, rspBO, flag);
        }
    }

    private void dealSuccess(List<PebDealOrderBO> list, boolean finish, String stepId, PebOrderApprovalReqBO reqBO, PebOrderApprovalRspBO rspBO, int flag) {
        ArrayList result = new ArrayList();
        for (PebDealOrderBO pebDealOrderBO : list) {
            ApplyPayInfoPO applyPayInfoPO;
            if (finish) {
                if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
                    applyPayInfoPO = new ApplyPayInfoPO();
                    applyPayInfoPO.setPayno(pebDealOrderBO.getOrderId().toString());
                    applyPayInfoPO.setPayStatus(ApplyPayStatus2.REJECT.getCode());
                    applyPayInfoPO.setReasons(reqBO.getApprovalRemark());
                    this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                } else {
                    String pushNcFlag = this.prop.getProperty("IF_PUSH_NC_FLAG");
                    if ("1".equals(pushNcFlag)) {
                        ApplyPayInfoPO applyPayInfoPO2 = new ApplyPayInfoPO();
                        applyPayInfoPO2.setPayno(pebDealOrderBO.getOrderId().toString());
                        applyPayInfoPO2.setPayStatus(ApplyPayStatus2.APPROVED.getCode());
                        this.applyPayInfoMapper.updateStatus(applyPayInfoPO2);
                        ApplyPayInfoPO payInfoPO = this.applyPayInfoMapper.getModelById(pebDealOrderBO.getOrderId().toString());
                        if (ApplyPayStatus2.APPROVED.getCode().equals(payInfoPO.getPayStatus()) && PayChannel.NC.getCode().equals(payInfoPO.getPayChannel())) {
                            this.paymentNoteBillUp(payInfoPO);
                            ApplyPayInfoPO applyPayInfoPO1 = new ApplyPayInfoPO();
                            applyPayInfoPO1.setPayno(payInfoPO.getPayno());
                            applyPayInfoPO1.setPayStatus(ApplyPayStatus2.PAID.getCode());
                            this.applyPayInfoMapper.updateStatus(applyPayInfoPO1);
                        }
                    } else {
                        this.pushZjptPayBillUp(pebDealOrderBO.getOrderId().toString());
                    }
                }
                BillNotificationInfo record = new BillNotificationInfo();
                record.setPayNo(pebDealOrderBO.getOrderId().toString());
                record.setPayableStatus(PayableStatus2.APPLIED.getCode());
                this.billNotificationInfoMapper.updateByPrimaryKeySelective(record);
            } else {
                applyPayInfoPO = new ApplyPayInfoPO();
                applyPayInfoPO.setPayno(pebDealOrderBO.getOrderId().toString());
                if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
                    applyPayInfoPO.setPayStatus(ApplyPayStatus2.REJECT.getCode());
                    applyPayInfoPO.setReasons(reqBO.getApprovalRemark());
                }
                applyPayInfoPO.setPayno(pebDealOrderBO.getOrderId().toString());
                applyPayInfoPO.setStepId(stepId);
                this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
            }
            rspBO.setOrderApprovalList(result);
            this.recordProcessInfo(pebDealOrderBO, reqBO, flag);
        }
    }

    private void recordProcessInfo(PebDealOrderBO pebDealOrderBO, PebOrderApprovalReqBO reqBO, int flag) {
        UocOrdBusiOperRecord record = new UocOrdBusiOperRecord();
        record.setRecordType(PebExtConstant.RecordType.ONE);
        record.setOrderId(pebDealOrderBO.getOrderId());
        record.setObjId(pebDealOrderBO.getOrderId());
        record.setObjType(FscCommonConstants.OBJ_TYPE.FSC_APPLY_PAY_APPROVAL);
        record.setCreateTime(new Date());
        record.setDealTime(new Date());
        record.setDealOperId(String.valueOf(reqBO.getUserId()));
        record.setDealOperName(reqBO.getUsername());
        record.setDealDeptId(reqBO.getOrgIdIn() + "");
        record.setDealDeptName(reqBO.getOrgName() + "");
        record.setDealCompId(reqBO.getCompanyId() + "");
        record.setDealCompName(reqBO.getCompanyName());
        record.setDealTypeId(PebExtConstant.RecordType.ONE + "");
        record.setDealName("\u4ed8\u6b3e\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b");
        if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
            record.setDealDesc("\u5ba1\u6279\u9a73\u56de");
            record.setDealReason(reqBO.getApprovalRemark());
        } else if (2 == flag) {
            record.setDealDesc("\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7");
        } else {
            record.setDealDesc("\u5ba1\u6279\u901a\u8fc7");
        }
        this.uocOrdBusiOperRecordMapper.insertSelective(record);
    }

    private void pushZjptPayBillUp(String payNo) {
        ApplyPayInfoPO payInfoPO = this.applyPayInfoMapper.getModelById(payNo);
        ZjptPayBillUpServiceReqBO zjptPayBillUpServiceReqBO = new ZjptPayBillUpServiceReqBO();
        ZjptPayBillUpServiceRspBO zjptPayBillUpServiceRspBO = null;
        try {
            Long purchaserCompanyId = 0L;
            BillNotificationInfoExt billNotificationInfoExt = new BillNotificationInfoExt();
            billNotificationInfoExt.setPayNo(payNo);
            List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.selectForPage(billNotificationInfoExt);
            if (billNotificationInfos != null && billNotificationInfos.size() > 0) {
                purchaserCompanyId = billNotificationInfos.get(0).getPurchaseCompanyId();
            }
            UmcACompanyInfoDetailAbilityServiceReqBO umcACompanyInfoDetailAbilityServiceReqBO = new UmcACompanyInfoDetailAbilityServiceReqBO();
            umcACompanyInfoDetailAbilityServiceReqBO.setCompanyId(purchaserCompanyId);
            log.error("getDetailACompanyInfo\u65b9\u6cd5\u5165\u53c2==" + umcACompanyInfoDetailAbilityServiceReqBO);
            UmcACompanyInfoDetailAbilityServiceRspBO detailACompanyInfo = this.umcACompanyInfoDetailAbilityService.getDetailACompanyInfo(umcACompanyInfoDetailAbilityServiceReqBO);
            log.error("detailACompanyInfo\u65b9\u6cd5\u51fa\u53c2==" + detailACompanyInfo);
            ArrayList<ZjptPayBillUpReqBO> zjptPayBillUpReqBOS = new ArrayList<ZjptPayBillUpReqBO>();
            ZjptPayBillUpReqBO zjptPayBillUpReqBO = new ZjptPayBillUpReqBO();
            zjptPayBillUpReqBO.setDataSource("MRP");
            zjptPayBillUpReqBO.setSerialNoErp(payNo);
            zjptPayBillUpReqBO.setAmt(payInfoPO.getPayAmt());
            DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
            dicDictionaryPO.setPCode("ATOUR_COMPANY_INFO");
            dicDictionaryPO.setCode(purchaserCompanyId.toString());
            DicDictionaryPO dicDictionaryPOResult = this.dicDictionaryMapper.getModelByCondition(dicDictionaryPO);
            if (null != dicDictionaryPOResult) {
                zjptPayBillUpReqBO.setCorpCode(dicDictionaryPOResult.getTitle());
            }
            zjptPayBillUpReqBO.setPayerAccNo(detailACompanyInfo.getBankAccount());
            zjptPayBillUpReqBO.setPayeeAccNo(payInfoPO.getReceiptAcctNo());
            zjptPayBillUpReqBO.setPayeeAccName(payInfoPO.getRecAcctName());
            zjptPayBillUpReqBO.setPayeeCode(payInfoPO.getBankLineCode());
            zjptPayBillUpReqBO.setVoucherType("0");
            zjptPayBillUpReqBO.setIsforindividual("0");
            zjptPayBillUpReqBO.setAbs(payNo);
            if (PayChannel.OFFLINE.getCode().equals(payInfoPO.getPayChannel())) {
                zjptPayBillUpReqBO.setPurpose(payNo);
            }
            zjptPayBillUpReqBOS.add(zjptPayBillUpReqBO);
            zjptPayBillUpServiceReqBO.setZjptPayBillUpReqBOS(zjptPayBillUpReqBOS);
            zjptPayBillUpServiceRspBO = this.zjptPayBillUpService.payBillUp(zjptPayBillUpServiceReqBO);
            this.savelog("FscZjptPayBillUpService-1", JSONObject.toJSONString((Object)zjptPayBillUpReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)zjptPayBillUpServiceRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            log.info("\u63a8\u9001\u4ed8\u6b3e\u5355\u5230\u8d44\u91d1\u5e73\u53f0\u8fd4\u56de\u53c2\u6570\uff1a" + JSON.toJSONString((Object)zjptPayBillUpServiceRspBO));
            if (zjptPayBillUpServiceRspBO != null && !CollectionUtils.isEmpty((Collection)zjptPayBillUpServiceRspBO.getZjptPayBillUpRspBOS())) {
                ZjptPayBillUpRspBO zjptPayBillUpRspBO = (ZjptPayBillUpRspBO)zjptPayBillUpServiceRspBO.getZjptPayBillUpRspBOS().get(0);
                if ("1".equals(zjptPayBillUpRspBO.getStatus())) {
                    ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
                    applyPayInfoPO.setPayno(payNo);
                    applyPayInfoPO.setPayStatus(ApplyPayStatus2.PAY_FAILED.getCode());
                    this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                } else if ("2".equals(zjptPayBillUpRspBO.getStatus())) {
                    ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
                    applyPayInfoPO.setPayno(payNo);
                    applyPayInfoPO.setPayStatus(ApplyPayStatus2.PAYING.getCode());
                    this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4ed8\u6b3e\u5355\u5230\u8d44\u91d1\u5e73\u53f0\u5f02\u5e38\uff1a" + e);
            this.savelog("FscZjptPayBillUpService-1", JSONObject.toJSONString((Object)zjptPayBillUpServiceReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString(zjptPayBillUpServiceRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

