/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiAddBillApplyInfoDlzqService;
import com.tydic.pfsc.api.busi.bo.BusiAddBillApplyInfoDlzqReqBO;
import com.tydic.pfsc.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfsc.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiAddBillApplyInfoDlzqService"})
public class BusiAddBillApplyInfoDlzqServiceImpl
implements BusiAddBillApplyInfoDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddBillApplyInfoDlzqServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    @PostMapping(value={"add"})
    public PfscExtRspBaseBO add(@RequestBody BusiAddBillApplyInfoDlzqReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u529b\u4e13\u533a\u7b49)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && (reqBO.getOperUnitNo() == null || reqBO.getOperUnitNo() <= 0L)) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u3010operUnitNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List seqNos = reqBO.getSeqNos();
        if (seqNos == null || seqNos.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5546\u54c1ID\u3010seqNos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        if (invoiceInfo == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)invoiceInfo.getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e2d\u7684\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mailAddrInfo == null) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)mailAddrInfo.getName())) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setSeqList(seqNos);
        saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(saleItemInfoVO);
        if (seqNos.size() != saleItemInfoList.size()) {
            throw new PfscExtBusinessException("18000", "\u5546\u54c1\u660e\u7ec6\u7684\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u5e76\u52fe\u9009");
        }
        SaleOrderInfo order = new SaleOrderInfo();
        order.setInspectionId(saleItemInfoList.get(0).getInspectionId());
        order = this.saleOrderInfoMapper.getModelBy(order);
        String source = order.getSource();
        if ("1".equals(reqBO.getIsOperUnit()) && !reqBO.getCompanyId().equals(order.getOperUnitNo())) {
            throw new PfscExtBusinessException("0001", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
        }
        if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
            HashSet<Long> inspectionIds = new HashSet<Long>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                inspectionIds.add(saleItemInfo.getInspectionId());
            }
            saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setInspectionIdList(new ArrayList<Long>(inspectionIds));
            saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            int total = this.saleItemInfoMapper.selectCount(saleItemInfoVO);
            if (saleItemInfoList.size() < total) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7684\u5546\u54c1\u660e\u7ec6\u5fc5\u987b\u5168\u9009");
            }
        }
        HashSet<Long> inspectionIdSet = new HashSet<Long>();
        BigDecimal amt = BigDecimal.ZERO;
        Long orderId = null;
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            amt = amt.add(saleItemInfo.getAmount());
            if (!inspectionIdSet.contains(saleItemInfo.getInspectionId())) {
                inspectionIdSet.add(saleItemInfo.getInspectionId());
            }
            if (!OrderSource.ELECTRIC_AREA.getCode().equals(order.getSource()) && !OrderSource.COAL_AREA.getCode().equals(order.getSource())) continue;
            if (orderId != null && !orderId.equals(saleItemInfo.getOrderId())) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u5141\u8bb8\u591a\u4e2a\u8ba2\u5355\u4e00\u8d77\u7533\u8bf7\u5f00\u7968");
            }
            orderId = saleItemInfo.getOrderId();
        }
        this.invoiceApply(reqBO, seqNos, invoiceInfo, mailAddrInfo, saleItemInfoList, order, inspectionIdSet, amt);
        return new PfscExtRspBaseBO();
    }

    private void invoiceApply(BusiAddBillApplyInfoDlzqReqBO reqBO, List<Long> seqNos, InvoiceHeaderVO invoiceInfo, InvoiceMailAddrInfoVO mailAddrInfo, List<SaleItemInfo> saleItemInfoList, SaleOrderInfo order, Set<Long> inspectionIdSet, BigDecimal amt) {
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setSeqList(seqNos);
        saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        SaleItemInfo saleItemInfo = new SaleItemInfo();
        String applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
        saleItemInfo.setApplyNo(applyNo);
        saleItemInfo.setItemStatus(OrderStatus.APPLIED.getCode());
        this.saleItemInfoMapper.updateByCondition(saleItemInfoVO, saleItemInfo);
        for (Long inspectionId : inspectionIdSet) {
            saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setInspectionId(inspectionId);
            saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            int count = this.saleItemInfoMapper.selectCount(saleItemInfoVO);
            String newOrderStatus = OrderStatus.NO_APPLY.getCode();
            if (count == 0) {
                newOrderStatus = OrderStatus.APPLIED.getCode();
            }
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setInspectionId(inspectionId);
            saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            SaleOrderInfo newSaleOrderInfo = new SaleOrderInfo();
            newSaleOrderInfo.setOrderStatus(newOrderStatus);
            this.saleOrderInfoMapper.updateByCondition(saleOrderInfoVO, newSaleOrderInfo);
        }
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setInvoiceType(String.valueOf(invoiceInfo.getInvoiceType()));
        billApplyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
        billApplyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
        billApplyInfo.setAddr(invoiceInfo.getAddress());
        billApplyInfo.setPhone(invoiceInfo.getPhone());
        billApplyInfo.setBankName(invoiceInfo.getBank());
        billApplyInfo.setBankAcctNo(invoiceInfo.getAccount());
        billApplyInfo.setName(mailAddrInfo.getName());
        billApplyInfo.setProvince(mailAddrInfo.getProvince());
        billApplyInfo.setCity(mailAddrInfo.getCity());
        billApplyInfo.setCounty(mailAddrInfo.getCounty());
        billApplyInfo.setTown("0".equals(mailAddrInfo.getTown()) ? null : mailAddrInfo.getTown());
        billApplyInfo.setProvId(mailAddrInfo.getProvId());
        billApplyInfo.setCityId(mailAddrInfo.getCityId());
        billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
        billApplyInfo.setTownId(mailAddrInfo.getTownId());
        billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
        billApplyInfo.setMobile(mailAddrInfo.getTel());
        billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
        billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
        billApplyInfo.setApplyNo(applyNo);
        billApplyInfo.setApplyDate(new Date());
        billApplyInfo.setAmt(amt);
        billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
        billApplyInfo.setUserId(reqBO.getUserId());
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setInspectionId(saleItemInfoList.get(0).getInspectionId());
        saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        if (OrderSource.CONSULT_PRICE.getCode().equals(saleOrderInfo.getSource()) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(saleOrderInfo.getSource())) {
            billApplyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
        } else {
            billApplyInfo.setSource(saleOrderInfo.getSource());
            billApplyInfo.setSupplierNo(saleOrderInfo.getSupplierNo());
            billApplyInfo.setSupplierName(saleOrderInfo.getSupplierName());
        }
        billApplyInfo.setPurchaseNo(saleOrderInfo.getPurchaseNo());
        billApplyInfo.setPurchaseName(saleOrderInfo.getPurchaseName());
        billApplyInfo.setPurchaseProjectId(saleOrderInfo.getPurchaseProjectId());
        billApplyInfo.setOperUnitNo(saleOrderInfo.getOperUnitNo());
        billApplyInfo.setOperUnitName(saleOrderInfo.getOperUnitName());
        billApplyInfo.setBranchCompany(saleOrderInfo.getBranchCompany());
        billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ORDER.getCode());
        billApplyInfo.setProfessionalDepartId(order.getProfessionalDepartId());
        billApplyInfo.setServiceDepartId(order.getServiceDepartId());
        billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
        this.billApplyInfoMapper.insert(billApplyInfo);
    }
}

