/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiNotificationInvoiceListService;
import com.tydic.pfsc.api.busi.bo.BusiNotificationInvoiceListReqBO;
import com.tydic.pfsc.api.busi.bo.BusiNotificationInvoiceListRspBO;
import com.tydic.pfsc.api.busi.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.pfsc.api.busi.vo.InvoiceAttchVO;
import com.tydic.pfsc.api.busi.vo.NotificationInvoiceInfoVO;
import com.tydic.pfsc.api.busi.vo.NotificationInvoiceVO;
import com.tydic.pfsc.base.PfscExtReqPageBaseBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfoExt;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfsc.dao.vo.Statis;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.PurchaseSaleType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.utils.BusinessUtils;
import com.tydic.pfsc.utils.DatesUtils;
import com.tydic.pfsc.utils.FscStringUtils;
import com.tydic.umcext.ability.org.UmcYdEnterpriseOrgQueryAbilityService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiNotificationInvoiceListService"})
public class BusiNotificationInvoiceListServiceImpl
implements BusiNotificationInvoiceListService {
    private static final Logger logger = LoggerFactory.getLogger(BusiNotificationInvoiceListServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private UmcYdEnterpriseOrgQueryAbilityService UmcYdEnterpriseOrgQueryAbilityService;

    @PostMapping(value={"notifiInvoiceList"})
    public BusiNotificationInvoiceListRspBO notifiInvoiceList(@RequestBody BusiNotificationInvoiceListReqBO reqBO) {
        String notificationNo;
        List<NotificationInvoiceVO> list;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1\u5165\u53c2:" + reqBO);
        }
        BusiNotificationInvoiceListRspBO resp = new BusiNotificationInvoiceListRspBO();
        resp.setRows(new ArrayList());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if ("1".equals(reqBO.getImportFlag())) {
            String orderBy = " t3.SEQ asc";
            BillNotificationInfoExt notificationInfoExt = new BillNotificationInfoExt();
            notificationInfoExt.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
            notificationInfoExt.setOrderBy(orderBy);
            notificationInfoExt.setNotificationNos(reqBO.getNotificationNos());
            list = this.billNotificationInfoMapper.selectNotificationImportInfoForPage(notificationInfoExt, (Page<Map<String, Object>>)page);
        } else {
            String source;
            String invoiceStatus;
            Long companyId = reqBO.getCompanyId();
            if (companyId == null) {
                throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u9519\u8bef");
            }
            Long operUnitNo = reqBO.getOperUnitNo();
            notificationNo = reqBO.getNotificationNo();
            operUnitNo = BusinessUtils.judgeOperUnitNo(operUnitNo, companyId, false);
            Long supNo = reqBO.getSupplierNo();
            String invoiceNo = reqBO.getInvoiceNo();
            if (StringUtils.hasText((String)invoiceNo)) {
                List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByInvoiceNo(invoiceNo);
                if (invoices.size() > 0) {
                    notificationNo = invoices.get(0).getNotificationNo();
                } else {
                    resp.setTotal(Integer.valueOf(0));
                    resp.setRecordsTotal(Integer.valueOf(0));
                    resp.setPageNo(Integer.valueOf(1));
                    return resp;
                }
            }
            if ((invoiceStatus = reqBO.getInvoiceStatus()) != null && invoiceStatus.length() == 0) {
                invoiceStatus = null;
            }
            if (!StringUtils.hasText((String)(source = reqBO.getSource()))) {
                source = OrderSource.CONSULT_PRICE_FRAME.getCode();
            }
            String invoiceType = reqBO.getInvoiceType();
            Long purchaserId = null;
            BillNotificationInfoExt extInfo = new BillNotificationInfoExt();
            BeanUtils.copyProperties((Object)reqBO, (Object)extInfo);
            extInfo.setNotificationNo(notificationNo);
            if (StringUtils.hasText((String)invoiceType)) {
                extInfo.setInvoceType(Integer.valueOf(invoiceType));
            }
            extInfo.setInvoiceStatus(invoiceStatus);
            extInfo.setSupplierNo(supNo);
            extInfo.setSource(reqBO.getSource());
            extInfo.setFromApplyDate(reqBO.getFromDate());
            extInfo.setToApplyDate(reqBO.getToDate());
            extInfo.setSignStartDate(reqBO.getSignStartDate());
            extInfo.setSignEndDate(reqBO.getSignEndDate());
            extInfo.setInvoiceDateStart(reqBO.getInvoiceDateStart());
            extInfo.setInvoiceDateEnd(reqBO.getInvoiceDateEnd());
            String defaultOrderBy = " APPLY_DATE desc,NOTIFICATION_NO desc ";
            String tableName = "d_bill_notification_info";
            String orderBy = FscStringUtils.obtainOrderBy((PfscExtReqPageBaseBO)reqBO, tableName, defaultOrderBy);
            extInfo.setOrderBy(orderBy);
            extInfo.setUserId(purchaserId);
            list = this.billNotificationInfoMapper.selectForPageAndFilter(extInfo, (Page<Map<String, Object>>)page);
        }
        for (NotificationInvoiceVO inf : list) {
            NotificationInvoiceStatus nis;
            InvoiceType vt;
            NotificationInvoiceInfoVO vo = new NotificationInvoiceInfoVO();
            BeanUtils.copyProperties((Object)inf, (Object)vo);
            vo.setSignDate(inf.getEntryDate());
            notificationNo = inf.getNotificationNo();
            List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
            vo.setInvoiceNos("");
            if (invoices.size() > 0) {
                ArrayList<InvoiceAttchVO> attchVOSlist = new ArrayList<InvoiceAttchVO>();
                StringBuilder ivs = new StringBuilder();
                for (PayInvoiceInfo invoice : invoices) {
                    InvoiceAttchVO voattch = new InvoiceAttchVO();
                    ivs.append(",").append(invoice.getInvoiceNo());
                    vo.setInvoiceDate(invoice.getInvoiceDate());
                    vo.setImportDate(invoice.getCreateDate());
                    voattch.setInvoiceCode(invoice.getInvoiceCode());
                    voattch.setInvoiceNo(invoice.getInvoiceNo());
                    voattch.setElectronicInvoiceName(null == invoice.getElectronicInvoiceName() ? "" : invoice.getElectronicInvoiceName());
                    voattch.setElectronicInvoiceUrl(null == invoice.getElectronicInvoiceUrl() ? "" : invoice.getElectronicInvoiceUrl());
                    attchVOSlist.add(voattch);
                }
                vo.setInoviceAttch(JSON.toJSONString(attchVOSlist));
                vo.setInvoiceNos(ivs.deleteCharAt(0).toString());
            }
            vo.setDrawerName(this.userInfoService.queryUserNameByUserId(inf.getUserId()));
            if (!StringUtils.isEmpty((Object)inf.getVerifyPersonId())) {
                vo.setReceiver(this.userInfoService.queryNickNameByUserId(inf.getVerifyPersonId()));
            }
            if ((vt = InvoiceType.getInstance(vo.getInvoceType())) != null) {
                vo.setInvoiceTypeDescr(vt.getDescr());
            }
            if ((nis = NotificationInvoiceStatus.getInstance(vo.getInvoiceStatus())) != null) {
                vo.setInvoiceStatusDescr(nis.getDescr());
            }
            vo.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)vo.getSource())));
            LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
            LinkedList<String> purchaseOrderNameList = new LinkedList<String>();
            LinkedList<String> invoiceNoList = new LinkedList<String>();
            PayPurchaseOrderInfoVO purchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            purchaseOrderInfoVO.setNotificationNo(vo.getNotificationNo());
            List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(purchaseOrderInfoVO);
            PurchaseOrderDetailInfoRspBO detailRspBO = null;
            Long purchaseProjectId = null;
            for (PayPurchaseOrderInfo purchaseOrder : purchaseOrderInfos) {
                purchaseProjectId = purchaseOrder.getPurchaseProjectId();
                detailRspBO = new PurchaseOrderDetailInfoRspBO();
                detailRspBO.setPurchaseOrderCode(purchaseOrder.getPurchaseOrderCode());
                detailRspBO.setInspectionId(purchaseOrder.getInspectionId());
                detailRspBO.setRecvDate(purchaseOrder.getRecvDate());
                purchaseOrderDetailList.add(detailRspBO);
                purchaseOrderNameList.add(purchaseOrder.getPurchaseOrderName());
            }
            vo.setPurchaseProjectName(this.organizationInfoService.queryProjectName(purchaseProjectId).getAccountName());
            List<PayInvoiceInfo> allInvoices = this.payInvoiceInfoMapper.selectByNotifyNo(vo.getNotificationNo());
            StringBuilder sb = new StringBuilder();
            for (PayInvoiceInfo payInvoiceInfo : allInvoices) {
                if (!StringUtils.isEmpty((Object)sb.toString()) && sb.toString().split(",").length >= 5) {
                    invoiceNoList.add(sb.toString().substring(0, sb.length() - 1));
                    sb.delete(0, sb.length());
                    sb.append(payInvoiceInfo.getInvoiceNo()).append(",");
                    continue;
                }
                sb.append(payInvoiceInfo.getInvoiceNo()).append(",");
            }
            vo.setTicketDays(DatesUtils.obtainDaysBetween(vo.getApplyDate(), vo.getImportDate()));
            vo.setSignDays(DatesUtils.obtainDaysBetween(vo.getImportDate(), vo.getSignDate()));
            if (sb.length() >= 1) {
                invoiceNoList.add(sb.toString().substring(0, sb.length() - 1));
            }
            PurchaseSaleType purchaseSaleTypeEnum = PurchaseSaleType.getInstance(inf.getPurchaseSaleType());
            vo.setPurchaseSaleTypeStr(this.enumsService.getDescr(purchaseSaleTypeEnum));
            vo.setPurchaseSaleType(inf.getPurchaseSaleType());
            vo.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(vo.getProfessionalDepartId()));
            vo.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(vo.getServiceDepartId()));
            vo.setBranchCompanyName(this.organizationInfoService.queryOrgName(inf.getBranchCompany()));
            vo.setPurchaseOrderCodeList(purchaseOrderDetailList);
            vo.setPurchaseOrderNameList(purchaseOrderNameList);
            vo.setInvoiceNoList(invoiceNoList);
            Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(vo.getNotificationNo());
            if (null != ivStatis) {
                vo.setSumInvoiceAmt(ivStatis.getTotAmt());
                if (null != ivStatis.getTotAmt()) {
                    vo.setSumInvoiceAmtStr(ivStatis.getTotAmt().setScale(2, 1).toString());
                }
            }
            if (null != vo.getAmt()) {
                vo.setAmtStr(vo.getAmt().setScale(2, 1).toString());
            }
            resp.getRows().add(vo);
        }
        resp.setTotal(Integer.valueOf(page.getTotalPages()));
        resp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        resp.setPageNo(Integer.valueOf(page.getPageNo()));
        return resp;
    }
}

