/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfsc.aop.annotation.FscDuplicateCommitLimit;
import com.tydic.pfsc.api.busi.BusiNotificationService;
import com.tydic.pfsc.api.busi.NotificationSendRequestService;
import com.tydic.pfsc.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfsc.api.busi.bo.BusiNotificationRspBO;
import com.tydic.pfsc.api.busi.bo.NotificationSendRequestReqBO;
import com.tydic.pfsc.api.busi.vo.OrderInfoVO;
import com.tydic.pfsc.api.busi.vo.OrderItemVO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.DBillNotificationPayItemInfoMapper;
import com.tydic.pfsc.dao.DBillNotificationPayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfoExt;
import com.tydic.pfsc.dao.po.DBillNotificationPayItemInfoPO;
import com.tydic.pfsc.dao.po.DBillNotificationPayPurchaseOrderInfoPO;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.vo.PayItemInfoVO;
import com.tydic.pfsc.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.BusiNotificationSplitService;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiNotificationService"})
public class BusiNotificationServiceImpl
implements BusiNotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiNotificationServiceImpl.class);
    private static final String SELECT_ALL_YES = "Y";
    private static final String SELECT_ALL_NO = "N";
    private static final String GROUPWAY_NOSPLIT = "noSplitGroup";
    private static final String GROUPWAY_PURUNIT = "purchaseUnitGroup";
    private static final String GROUPWAY_ORDER = "orderGroup";
    private static final String MAX_ORDER_AMT = "500";
    private static final Integer MAX_ORDER_NUM = 300;
    private PayItemInfoMapper payItemInfoMapper;
    private BillNotificationInfoMapper billNotificationInfoMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private BillSNService billSNService;
    private BusiNotificationSplitService busiNotificationSplitService;
    private NotificationSendRequestService notificationSendRequestService;
    @Resource(name="billNotificationBatchNoSeq")
    private OrderSequence billNotificationBatchNoSeq;
    @Autowired
    private DBillNotificationPayPurchaseOrderInfoMapper billNotificationPayPurchaseOrderInfoMapper;
    @Autowired
    private DBillNotificationPayItemInfoMapper billNotificationPayItemInfoMapper;
    private Sequence sequence = Sequence.getInstance();

    @Autowired
    public BusiNotificationServiceImpl(PayItemInfoMapper payItemInfoMapper, BillNotificationInfoMapper billNotificationInfoMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, BillSNService billSNService, BusiNotificationSplitService busiNotificationSplitService, NotificationSendRequestService notificationSendRequestService) {
        this.payItemInfoMapper = payItemInfoMapper;
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.billSNService = billSNService;
        this.busiNotificationSplitService = busiNotificationSplitService;
        this.notificationSendRequestService = notificationSendRequestService;
    }

    @FscDuplicateCommitLimit(toast="\u8bf7\u4e0d\u8981\u8fde\u7eed\u70b9\u51fb\u53d1\u8d77\u5f00\u7968\u7533\u8bf7")
    @PostMapping(value={"makeNotify"})
    public BusiNotificationRspBO makeNotify(@RequestBody BusiNotificationReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getMaxOrderNumber() || reqBO.getMaxOrderNumber() <= 0) {
            throw new PfscExtBusinessException("0001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u8ba2\u5355\u6570[maxOrderNumber]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getMaxOrderAmt())) {
            throw new PfscExtBusinessException("0001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u91d1\u989d[maxOrderAmt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getGroupWay()) {
            throw new PfscExtBusinessException("0001", "\u5206\u7ec4\u65b9\u5f0f[groupWay]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfo() || !StringUtils.hasText((String)reqBO.getInvoiceInfo().getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        this.checkMakeNotify(reqBO);
        List<OrderInfoVO> orderInfos = new LinkedList();
        String isProfessionalOrgExt = reqBO.getIsProfessionalOrgExt();
        if ("2".equals(isProfessionalOrgExt)) {
            reqBO.setSupplierNo(reqBO.getSupId());
        }
        if (null == reqBO.getSupplierNo()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u7f16\u53f7[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSelectAllFlag()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u662f\u5426\u5168\u9009\u6807\u8bc6[selectAllFlag]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String groupWay = reqBO.getGroupWay();
        if (!(GROUPWAY_NOSPLIT.equals(groupWay) || GROUPWAY_PURUNIT.equals(groupWay) || GROUPWAY_ORDER.equals(groupWay))) {
            throw new PfscExtBusinessException("0001", "\u5206\u7ec4\u65b9\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!SELECT_ALL_YES.equalsIgnoreCase(reqBO.getSelectAllFlag()) && !SELECT_ALL_NO.equalsIgnoreCase(reqBO.getSelectAllFlag())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5168\u9009\u6807\u8bc6[selectAllFlag]\u53ea\u80fd\u8f93\u5165Y\u6216N");
        }
        if (SELECT_ALL_YES.equalsIgnoreCase(reqBO.getSelectAllFlag())) {
            PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            payPurchaseOrderInfoVO.setSource(reqBO.getSource());
            payPurchaseOrderInfoVO.setPurchaseOrderCode(reqBO.getPurchaseOrderCode());
            payPurchaseOrderInfoVO.setExtOrderId(reqBO.getExtOrderId());
            payPurchaseOrderInfoVO.setSupplierNo(reqBO.getSupplierNo());
            payPurchaseOrderInfoVO.setOrderDateStart(reqBO.getOrderDateStart());
            payPurchaseOrderInfoVO.setOrderDateEnd(reqBO.getOrderDateEnd());
            payPurchaseOrderInfoVO.setRecvDateStart(reqBO.getRecvDateStart());
            payPurchaseOrderInfoVO.setOrderCodes(reqBO.getOrderCodes());
            payPurchaseOrderInfoVO.setRecvDateEnd(reqBO.getRecvDateEnd());
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(reqBO.getSource())) {
                payPurchaseOrderInfoVO.setReconcilitionStatus(reqBO.getReconcilitionStatus());
            }
            payPurchaseOrderInfoVO.setOrderBy("orderAmt asc");
            payPurchaseOrderInfoVO.setPurchaserId(reqBO.getPurchaserId());
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(reqBO.getSource())) {
                payPurchaseOrderInfoVO.setPurchaseSaleType(reqBO.getPurchaseSaleType());
            }
            if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                payPurchaseOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
                payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getPurchaseNo());
            } else {
                payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getPurchaserId());
            }
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListExt(payPurchaseOrderInfoVO);
            if (payPurchaseOrderInfoPOs.isEmpty()) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
            }
            orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
        } else if (SELECT_ALL_NO.equalsIgnoreCase(reqBO.getSelectAllFlag())) {
            if (null == reqBO.getOrderInfos()) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u975e\u5168\u9009\u65f6\uff0c\u8ba2\u5355\u5217\u8868\u4e0d\u5f97\u4e3a\u7a7a");
            }
            orderInfos = reqBO.getOrderInfos();
        }
        if (CollectionUtils.isEmpty(orderInfos)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8ba2\u5355");
        }
        PayPurchaseOrderInfo payPurchaseOrderInfo = null;
        for (OrderInfoVO orderInfoVO : orderInfos) {
            payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(Long.valueOf(orderInfoVO.getOrderId()), Long.valueOf(orderInfoVO.getInspectionId()));
            if (payPurchaseOrderInfo == null || payPurchaseOrderInfo.getInspectionAccessoryId() == null) {
                throw new PfscExtBusinessException("0001", "\u5b58\u5728\u672a\u4e0a\u4f20\u7b7e\u6536\u4fe1\u606f\u7684\u9a8c\u6536\u5355\uff0c\u8bf7\u4e0a\u4f20\u7b7e\u6536\u5355\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
            }
            orderInfoVO.setOrderAmt(payPurchaseOrderInfo.getOrderAmt());
            if (null == payPurchaseOrderInfo.getSettleAmt() || payPurchaseOrderInfo.getSettleAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355[" + orderInfoVO.getInspectionCode() + "]\u7ed3\u7b97\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u5f00\u7968");
            }
            orderInfoVO.setPayableAmt(payPurchaseOrderInfo.getSettleAmt());
            orderInfoVO.setAdvanceAmt(payPurchaseOrderInfo.getOrderAmt().subtract(payPurchaseOrderInfo.getSettleAmt()));
        }
        String purchaseCompanyName = payPurchaseOrderInfo.getPurchaseCompanyName();
        Long purchaseCompanyId = payPurchaseOrderInfo.getPurchaseCompanyId();
        Long producerId = payPurchaseOrderInfo.getProducerId();
        payPurchaseOrderInfo.getPurchaserId();
        String purchaseSaleType = ((OrderInfoVO)orderInfos.get(0)).getPurchaseSaleType();
        Integer maxOrderNumber = reqBO.getMaxOrderNumber();
        if (maxOrderNumber > MAX_ORDER_NUM) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4e00\u5f20\u5f00\u7968\u901a\u77e5\u5355\u6700\u5927\u5141\u8bb8\u8ba2\u5355\u6570\u91cf\u4e3a300\u6761");
        }
        BigDecimal maxOrderAmt = new BigDecimal(reqBO.getMaxOrderAmt());
        if (maxOrderAmt.compareTo(new BigDecimal(MAX_ORDER_AMT)) > 0) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4e00\u5f20\u5f00\u7968\u901a\u77e5\u5355\u6700\u5927\u5141\u8bb8\u5f00\u7968\u91d1\u989d\u4e3a500\u4e07\u5143");
        }
        Long OperUnitNo = payPurchaseOrderInfo.getOperUnitNo();
        String OperUnitName = payPurchaseOrderInfo.getOperUnitName();
        List<List<OrderInfoVO>> invoices = this.busiNotificationSplitService.getSplitResult(orderInfos, maxOrderNumber, groupWay, maxOrderAmt);
        LinkedList<BillNotificationInfoExt> notifications = new LinkedList<BillNotificationInfoExt>();
        String batchNo = this.generateSeqNoFormated(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        StringBuilder sb = new StringBuilder();
        for (List<OrderInfoVO> singleInvoice : invoices) {
            List<PayItemInfo> payItemInfos;
            BigDecimal sumAmt = BigDecimal.ZERO;
            BigDecimal advanceAmt = BigDecimal.ZERO;
            BigDecimal payableAmt = BigDecimal.ZERO;
            for (OrderInfoVO orderInfoVO : singleInvoice) {
                sumAmt = sumAmt.add(orderInfoVO.getOrderAmt());
                advanceAmt = advanceAmt.add(orderInfoVO.getAdvanceAmt());
                payableAmt = payableAmt.add(orderInfoVO.getPayableAmt());
            }
            Date now = new Date();
            String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
            sb.append(",").append(notifyNo);
            BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
            notifyInfo.setNotificationNo(notifyNo);
            notifyInfo.setAmt(payableAmt);
            notifyInfo.setApplyDate(now);
            notifyInfo.setOperNo(OperUnitNo);
            notifyInfo.setOperName(OperUnitName);
            notifyInfo.setSource(String.valueOf(reqBO.getSource()));
            notifyInfo.setSupplierNo(reqBO.getSupplierNo());
            notifyInfo.setUserId(reqBO.getUserId());
            notifyInfo.setDrawerName(reqBO.getName());
            notifyInfo.setSupplierName(reqBO.getSupName());
            notifyInfo.setAddr(reqBO.getInvoiceInfo().getAddress());
            notifyInfo.setBankAccNo(reqBO.getInvoiceInfo().getAccount());
            notifyInfo.setBankName(reqBO.getInvoiceInfo().getBank());
            notifyInfo.setInvoceName(reqBO.getInvoiceInfo().getInvoiceTitle());
            notifyInfo.setInvoceType(reqBO.getInvoiceInfo().getInvoiceType());
            notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.NO_SUBMITED.getCode());
            notifyInfo.setPhone(reqBO.getInvoiceInfo().getPhone());
            notifyInfo.setTaxNo(reqBO.getInvoiceInfo().getTaxpayerId());
            if (null != reqBO.getMailAddrInfo()) {
                notifyInfo.setAddrDesc(reqBO.getMailAddrInfo().getAddrDesc());
                notifyInfo.setProvince(reqBO.getMailAddrInfo().getProvince());
                notifyInfo.setCity(reqBO.getMailAddrInfo().getCity());
                notifyInfo.setCounty(reqBO.getMailAddrInfo().getCounty());
                notifyInfo.setTown(reqBO.getMailAddrInfo().getTown());
                notifyInfo.setProvId(reqBO.getMailAddrInfo().getProvId());
                notifyInfo.setCityId(reqBO.getMailAddrInfo().getCityId());
                notifyInfo.setCountyId(reqBO.getMailAddrInfo().getCountyId());
                notifyInfo.setTownId(reqBO.getMailAddrInfo().getTownId());
                notifyInfo.setCompany(reqBO.getMailAddrInfo().getCompany());
                notifyInfo.setMobile(reqBO.getMailAddrInfo().getTel());
                notifyInfo.setTel(reqBO.getMailAddrInfo().getSpecialPlane());
                notifyInfo.setName(reqBO.getMailAddrInfo().getName());
                notifyInfo.setPostCode(reqBO.getMailAddrInfo().getPostCode());
            }
            notifyInfo.setBatchNo(batchNo);
            notifyInfo.setPurchaseSaleType(purchaseSaleType);
            notifyInfo.setStartOrgId(String.valueOf(reqBO.getOrgId()));
            notifyInfo.setIsPay(1);
            notifyInfo.setPurchaseCompanyId(purchaseCompanyId);
            notifyInfo.setPurchaseCompanyName(purchaseCompanyName);
            notifyInfo.setProducerId(producerId);
            notifyInfo.setAdvanceAmt(advanceAmt);
            notifyInfo.setPayableAmt(payableAmt);
            int insert = this.billNotificationInfoMapper.insert(notifyInfo);
            if (insert < 1) {
                throw new PfscExtBusinessException("18000", "\u751f\u6210\u5f00\u7968\u901a\u77e5\u4fe1\u606f\u5f02\u5e38");
            }
            LinkedList<String> orderIdCombStr = new LinkedList<String>();
            for (OrderInfoVO singleOrder : singleInvoice) {
                orderIdCombStr.add(singleOrder.getExtOrderId());
                PayPurchaseOrderInfo payOrderInfo = new PayPurchaseOrderInfo();
                payOrderInfo.setOrderId(Long.valueOf(singleOrder.getOrderId()));
                payOrderInfo.setInspectionId(Long.valueOf(singleOrder.getInspectionId()));
                payOrderInfo.setNotificationNo(notifyNo);
                payOrderInfo.setOrderStatus(OrderStatus.APPLIED.getCode());
                payOrderInfo.setPayModel(reqBO.getPayModel());
                int update = this.payPurchaseOrderInfoMapper.updateByPKUnsent(payOrderInfo);
                if (update < 1) {
                    throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
                }
                PayItemInfo item = new PayItemInfo();
                item.setOrderId(Long.valueOf(singleOrder.getOrderId()));
                item.setInspectionId(Long.valueOf(singleOrder.getInspectionId()));
                item.setNotificationNo(notifyNo);
                item.setItemStatus(OrderStatus.APPLIED.getCode());
                int update1 = this.payItemInfoMapper.updateByPKUnsent(item);
                if (update1 >= 1) continue;
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
            }
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notifyNo);
            if (CollectionUtils.isEmpty(payPurchaseOrderInfos)) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
            }
            ArrayList<DBillNotificationPayPurchaseOrderInfoPO> dBillNotificationPayPurchaseOrderInfoPoList = new ArrayList<DBillNotificationPayPurchaseOrderInfoPO>();
            payPurchaseOrderInfos.forEach(purchaseOrderInfo -> {
                DBillNotificationPayPurchaseOrderInfoPO dBillNotificationPayPurchaseOrderInfoPo = new DBillNotificationPayPurchaseOrderInfoPO();
                dBillNotificationPayPurchaseOrderInfoPo.setId(this.sequence.nextId());
                dBillNotificationPayPurchaseOrderInfoPo.setParentOrderId(purchaseOrderInfo.getParentOrderId());
                dBillNotificationPayPurchaseOrderInfoPo.setOrderId(purchaseOrderInfo.getOrderId());
                dBillNotificationPayPurchaseOrderInfoPo.setInspectionId(purchaseOrderInfo.getInspectionId());
                dBillNotificationPayPurchaseOrderInfoPo.setInspectionCode(purchaseOrderInfo.getInspectionCode());
                dBillNotificationPayPurchaseOrderInfoPo.setRecvDate(purchaseOrderInfo.getRecvDate());
                dBillNotificationPayPurchaseOrderInfoPo.setOrderDate(purchaseOrderInfo.getOrderDate());
                dBillNotificationPayPurchaseOrderInfoPo.setOrderAmt(purchaseOrderInfo.getOrderAmt());
                dBillNotificationPayPurchaseOrderInfoPo.setSupplierNo(purchaseOrderInfo.getSupplierNo());
                dBillNotificationPayPurchaseOrderInfoPo.setSupplierName(purchaseOrderInfo.getSupplierName());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseNo(purchaseOrderInfo.getPurchaseNo());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseName(purchaseOrderInfo.getPurchaseName());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseProjectId(purchaseOrderInfo.getPurchaseProjectId());
                dBillNotificationPayPurchaseOrderInfoPo.setOperUnitNo(purchaseOrderInfo.getOperUnitNo());
                dBillNotificationPayPurchaseOrderInfoPo.setBranchCompany(purchaseOrderInfo.getBranchCompany());
                dBillNotificationPayPurchaseOrderInfoPo.setProfessionalDepartId(purchaseOrderInfo.getProfessionalDepartId());
                dBillNotificationPayPurchaseOrderInfoPo.setServiceDepartId(purchaseOrderInfo.getServiceDepartId());
                dBillNotificationPayPurchaseOrderInfoPo.setOperUnitName(purchaseOrderInfo.getOperUnitName());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaserId(purchaseOrderInfo.getPurchaserId());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaserName(purchaseOrderInfo.getPurchaserName());
                dBillNotificationPayPurchaseOrderInfoPo.setOrderType(purchaseOrderInfo.getOrderType());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseSaleType(purchaseOrderInfo.getPurchaseSaleType());
                dBillNotificationPayPurchaseOrderInfoPo.setOrderStatus(OrderStatus.APPLIED.getCode());
                dBillNotificationPayPurchaseOrderInfoPo.setOrderStatus2(purchaseOrderInfo.getOrderStatus2());
                dBillNotificationPayPurchaseOrderInfoPo.setReconciliationStatus(Integer.valueOf(purchaseOrderInfo.getReconcilitionStatus()));
                dBillNotificationPayPurchaseOrderInfoPo.setNotificationNo(notifyNo);
                dBillNotificationPayPurchaseOrderInfoPo.setSource(purchaseOrderInfo.getSource());
                dBillNotificationPayPurchaseOrderInfoPo.setExtOrderId(purchaseOrderInfo.getExtOrderId());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseOrderCode(purchaseOrderInfo.getPurchaseOrderCode());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseOrderName(purchaseOrderInfo.getPurchaseOrderName());
                dBillNotificationPayPurchaseOrderInfoPo.setPlaAgreementCode(purchaseOrderInfo.getPlaAgreementCode());
                dBillNotificationPayPurchaseOrderInfoPo.setRemark(purchaseOrderInfo.getRemark());
                dBillNotificationPayPurchaseOrderInfoPo.setPayType(purchaseOrderInfo.getPayType());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaserOrgId(purchaseOrderInfo.getPurchaserOrgId());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaserOrgName(purchaseOrderInfo.getPurchaserOrgName());
                dBillNotificationPayPurchaseOrderInfoPo.setInvoiceType(purchaseOrderInfo.getInvoiceType());
                dBillNotificationPayPurchaseOrderInfoPo.setInvoiceId(purchaseOrderInfo.getInvoiceId());
                dBillNotificationPayPurchaseOrderInfoPo.setInvoceName(purchaseOrderInfo.getInvoceName());
                dBillNotificationPayPurchaseOrderInfoPo.setTaxNo(purchaseOrderInfo.getTaxNo());
                dBillNotificationPayPurchaseOrderInfoPo.setAddr(purchaseOrderInfo.getAddr());
                dBillNotificationPayPurchaseOrderInfoPo.setPhone(purchaseOrderInfo.getPhone());
                dBillNotificationPayPurchaseOrderInfoPo.setBankName(purchaseOrderInfo.getBankName());
                dBillNotificationPayPurchaseOrderInfoPo.setBankAcctNo(purchaseOrderInfo.getBankAcctNo());
                dBillNotificationPayPurchaseOrderInfoPo.setName(purchaseOrderInfo.getName());
                dBillNotificationPayPurchaseOrderInfoPo.setProvince(purchaseOrderInfo.getProvince());
                dBillNotificationPayPurchaseOrderInfoPo.setCity(purchaseOrderInfo.getCity());
                dBillNotificationPayPurchaseOrderInfoPo.setCounty(purchaseOrderInfo.getCounty());
                dBillNotificationPayPurchaseOrderInfoPo.setTown(purchaseOrderInfo.getTown());
                dBillNotificationPayPurchaseOrderInfoPo.setProvId(purchaseOrderInfo.getProvId());
                dBillNotificationPayPurchaseOrderInfoPo.setCityId(purchaseOrderInfo.getCityId());
                dBillNotificationPayPurchaseOrderInfoPo.setCountyId(purchaseOrderInfo.getCountyId());
                dBillNotificationPayPurchaseOrderInfoPo.setTownId(purchaseOrderInfo.getTownId());
                dBillNotificationPayPurchaseOrderInfoPo.setAddrDesc(purchaseOrderInfo.getAddrDesc());
                dBillNotificationPayPurchaseOrderInfoPo.setPostCode(purchaseOrderInfo.getPostCode());
                dBillNotificationPayPurchaseOrderInfoPo.setMobile(purchaseOrderInfo.getMobile());
                dBillNotificationPayPurchaseOrderInfoPo.setTel(purchaseOrderInfo.getTel());
                dBillNotificationPayPurchaseOrderInfoPo.setReceiveInvoicePhone(purchaseOrderInfo.getReceiveInvoicePhone());
                dBillNotificationPayPurchaseOrderInfoPo.setReceiveInvoiceEmail(purchaseOrderInfo.getReceiveInvoiceEmail());
                dBillNotificationPayPurchaseOrderInfoPo.setAddrId(purchaseOrderInfo.getAddrId());
                dBillNotificationPayPurchaseOrderInfoPo.setPayStatus(purchaseOrderInfo.getPayStatus());
                dBillNotificationPayPurchaseOrderInfoPo.setPayModel(reqBO.getPayModel());
                dBillNotificationPayPurchaseOrderInfoPo.setBusiModel(purchaseOrderInfo.getBusiModel());
                dBillNotificationPayPurchaseOrderInfoPo.setOrderCategory(purchaseOrderInfo.getOrderCategory());
                dBillNotificationPayPurchaseOrderInfoPo.setInspectionAccessoryId(purchaseOrderInfo.getInspectionAccessoryId());
                dBillNotificationPayPurchaseOrderInfoPo.setOrderDealServiceFee(purchaseOrderInfo.getOrderDealServiceFee());
                dBillNotificationPayPurchaseOrderInfoPo.setPayOrderCode(purchaseOrderInfo.getPayOrderCode());
                dBillNotificationPayPurchaseOrderInfoPo.setPayOrderId(purchaseOrderInfo.getPayOrderId());
                dBillNotificationPayPurchaseOrderInfoPo.setIsPayFlag(purchaseOrderInfo.getIsPayFlag());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseCompanyId(purchaseOrderInfo.getPurchaseCompanyId());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseCompanyName(purchaseOrderInfo.getPurchaseCompanyName());
                dBillNotificationPayPurchaseOrderInfoPo.setNoInvoiceAmt(purchaseOrderInfo.getNoInvoiceAmt());
                dBillNotificationPayPurchaseOrderInfoPo.setInvoicedAmt(purchaseOrderInfo.getInvoicedAmt());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseOrderId(purchaseOrderInfo.getPurchaseOrderId());
                dBillNotificationPayPurchaseOrderInfoPo.setPurchaseVoucherId(purchaseOrderInfo.getPurchaseVoucherId());
                dBillNotificationPayPurchaseOrderInfoPo.setProducerId(purchaseOrderInfo.getProducerId());
                dBillNotificationPayPurchaseOrderInfoPo.setSupplierCode(purchaseOrderInfo.getSupplierCode());
                dBillNotificationPayPurchaseOrderInfoPo.setSettleAmt(purchaseOrderInfo.getSettleAmt());
                dBillNotificationPayPurchaseOrderInfoPoList.add(dBillNotificationPayPurchaseOrderInfoPo);
            });
            if (!CollectionUtils.isEmpty(dBillNotificationPayPurchaseOrderInfoPoList)) {
                this.billNotificationPayPurchaseOrderInfoMapper.insertBatch(dBillNotificationPayPurchaseOrderInfoPoList);
            }
            if (CollectionUtils.isEmpty(payItemInfos = this.payItemInfoMapper.selectByNotifNo(notifyNo))) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
            }
            ArrayList<DBillNotificationPayItemInfoPO> dBillNotificationPayItemInfoPoList = new ArrayList<DBillNotificationPayItemInfoPO>();
            payItemInfos.forEach(payItemInfo -> {
                DBillNotificationPayItemInfoPO billNotificationPayItemInfoPo = new DBillNotificationPayItemInfoPO();
                billNotificationPayItemInfoPo.setSeq(this.sequence.nextId());
                billNotificationPayItemInfoPo.setOrderId(payItemInfo.getOrderId());
                billNotificationPayItemInfoPo.setInspectionId(payItemInfo.getInspectionId());
                billNotificationPayItemInfoPo.setItemNo(payItemInfo.getItemNo());
                billNotificationPayItemInfoPo.setSkuId(payItemInfo.getSkuId());
                billNotificationPayItemInfoPo.setItemName(payItemInfo.getItemName());
                billNotificationPayItemInfoPo.setNotificationNo(notifyNo);
                billNotificationPayItemInfoPo.setSpec(payItemInfo.getSpec());
                billNotificationPayItemInfoPo.setModel(payItemInfo.getModel());
                billNotificationPayItemInfoPo.setFigureNo(payItemInfo.getFigureNo());
                billNotificationPayItemInfoPo.setPurchaseUnitPrice(payItemInfo.getPurchaseUnitPrice());
                billNotificationPayItemInfoPo.setPurchaseUnitPriceSale(payItemInfo.getPurchaseUnitPriceSale());
                billNotificationPayItemInfoPo.setSaleUnitPrice(payItemInfo.getSaleUnitPrice());
                billNotificationPayItemInfoPo.setUnitId(payItemInfo.getUnitId());
                billNotificationPayItemInfoPo.setUnitName(payItemInfo.getUnitName());
                billNotificationPayItemInfoPo.setUnitNameSale(payItemInfo.getUnitNameSale());
                billNotificationPayItemInfoPo.setQuantity(payItemInfo.getQuantity());
                billNotificationPayItemInfoPo.setQuantitySale(payItemInfo.getQuantitySale());
                billNotificationPayItemInfoPo.setTaxRate(payItemInfo.getTaxRate());
                billNotificationPayItemInfoPo.setTaxAmt(payItemInfo.getTaxAmt());
                billNotificationPayItemInfoPo.setUntaxAmt(payItemInfo.getUntaxAmt());
                billNotificationPayItemInfoPo.setAmount(payItemInfo.getAmount());
                billNotificationPayItemInfoPo.setInvoiceNo(payItemInfo.getInvoiceNo());
                billNotificationPayItemInfoPo.setInvoiceCode(payItemInfo.getInvoiceCode());
                billNotificationPayItemInfoPo.setItemStatus(OrderStatus.APPLIED.getCode());
                billNotificationPayItemInfoPo.setPurchaseOrderCode(payItemInfo.getPurchaseOrderCode());
                billNotificationPayItemInfoPo.setSettleRate(payItemInfo.getSettleRate());
                billNotificationPayItemInfoPo.setCommDealServiceFee(payItemInfo.getCommDealServiceFee());
                billNotificationPayItemInfoPo.setExtSkuId(payItemInfo.getExtSkuId());
                billNotificationPayItemInfoPo.setCommDealServiceFeeRate(payItemInfo.getCommDealServiceFeeRate());
                billNotificationPayItemInfoPo.setIsPayFlag(payItemInfo.getIsPayFlag());
                billNotificationPayItemInfoPo.setSettleFlag(payItemInfo.getSettleFlag());
                dBillNotificationPayItemInfoPoList.add(billNotificationPayItemInfoPo);
            });
            if (!CollectionUtils.isEmpty(dBillNotificationPayItemInfoPoList)) {
                this.billNotificationPayItemInfoMapper.insertBatch(dBillNotificationPayItemInfoPoList);
            }
            notifyInfo.setOrderIds(orderIdCombStr);
            notifications.add(notifyInfo);
        }
        BusiNotificationRspBO rspBO = new BusiNotificationRspBO();
        rspBO.setBatchNo(batchNo);
        rspBO.setNotificationNo(sb.deleteCharAt(0).toString());
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(reqBO.getSource())) {
            NotificationSendRequestReqBO notificationSendRequestReqBO = new NotificationSendRequestReqBO();
            notificationSendRequestReqBO.setBatchNo(batchNo);
            this.notificationSendRequestService.processPushInfo(notificationSendRequestReqBO);
        }
        return rspBO;
    }

    private void checkMakeNotify(BusiNotificationReqBO reqBO) {
        ArrayList orderInfos = new ArrayList(reqBO.getOrderInfos());
        if (orderInfos != null && orderInfos.size() > 0) {
            ArrayList inspectionCodeList = new ArrayList();
            orderInfos.forEach(item -> {
                PayPurchaseOrderInfo poinfo = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(Long.valueOf(item.getOrderId()), Long.valueOf(item.getInspectionId()));
                if (!OrderStatus.NO_APPLY.getCode().equals(poinfo.getOrderStatus())) {
                    inspectionCodeList.add(poinfo.getInspectionCode());
                }
            });
            if (inspectionCodeList.size() > 0) {
                throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355 " + JSON.toJSONString(inspectionCodeList) + " \u72b6\u6001\u4e0d\u662f\u5df2\u63d0\u4ea4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
            }
        }
    }

    private List<OrderInfoVO> moveOrderInfosToVO(List<PayPurchaseOrderInfo> orderInfos) {
        LinkedList<OrderInfoVO> infos = new LinkedList<OrderInfoVO>();
        for (PayPurchaseOrderInfo singleInfo : orderInfos) {
            OrderInfoVO singleVO = new OrderInfoVO();
            singleVO.setConfirmDate(singleInfo.getRecvDate());
            singleVO.setInspectionId(String.valueOf(singleInfo.getInspectionId()));
            singleVO.setLastConfirmDate(singleInfo.getRecvDate());
            singleVO.setOrderAmt(singleInfo.getOrderAmt());
            singleVO.setOrderCreateDate(singleInfo.getOrderDate());
            singleVO.setOrderCreator(singleInfo.getPurchaserName());
            singleVO.setOrderId(String.valueOf(singleInfo.getOrderId()));
            singleVO.setExtOrderId(singleInfo.getExtOrderId());
            singleVO.setOrderStatus(singleInfo.getOrderStatus());
            singleVO.setOrderType(singleInfo.getOrderType());
            singleVO.setPurchaseNo(singleInfo.getPurchaseNo());
            singleVO.setPurchaseProjectId(singleInfo.getPurchaseProjectId());
            singleVO.setPurchaseOrderCode(singleInfo.getPurchaseOrderCode());
            singleVO.setSupplierNo(singleInfo.getSupplierNo());
            singleVO.setPurchaseSaleType(singleInfo.getPurchaseSaleType());
            singleVO.setSource(singleInfo.getSource());
            PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
            payItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            payItemInfoVO.setInspectionId(singleInfo.getInspectionId());
            List<PayItemInfo> itemInfos = this.payItemInfoMapper.selectBy(payItemInfoVO);
            if (itemInfos.isEmpty()) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\uff1a" + singleInfo.getPurchaseOrderCode() + "\u6ca1\u6709\u5546\u54c1\u660e\u7ec6");
            }
            BigDecimal advanceAmt = BigDecimal.ZERO;
            BigDecimal payableAmt = BigDecimal.ZERO;
            LinkedList<OrderItemVO> itemVOs = new LinkedList<OrderItemVO>();
            for (PayItemInfo itemInfo : itemInfos) {
                OrderItemVO vo = new OrderItemVO();
                vo.setItemName(itemInfo.getItemName());
                vo.setSpec(itemInfo.getSpec());
                vo.setModel(itemInfo.getModel());
                vo.setUnit(itemInfo.getUnitName());
                vo.setUnitId(itemInfo.getUnitId());
                vo.setQuantity(itemInfo.getQuantity());
                vo.setSalePrice(itemInfo.getPurchaseUnitPrice());
                vo.setSumTaxPrice(itemInfo.getUntaxAmt().add(itemInfo.getTaxAmt()));
                itemVOs.add(vo);
                if ("1".equals(itemInfo.getSettleFlag())) {
                    advanceAmt.add(itemInfo.getAmount());
                    continue;
                }
                payableAmt.add(itemInfo.getAmount());
            }
            singleVO.setItemList(itemVOs);
            singleVO.setAdvanceAmt(advanceAmt);
            singleVO.setPayableAmt(payableAmt);
            infos.add(singleVO);
        }
        return infos;
    }

    private String generateSeqNoFormated(String prefix) {
        String withoutPrefix;
        prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        int lengthWithoutPrefix = 12 - prefix.length();
        try {
            withoutPrefix = String.format("%0" + lengthWithoutPrefix + "d", this.billNotificationBatchNoSeq.nextId());
        }
        catch (SQLException e) {
            LOGGER.debug("\u751f\u6210\u5e8f\u5217\u53f7\u5f02\u5e38" + e);
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u6279\u6b21\u53f7\u5f02\u5e38");
        }
        return prefix + withoutPrefix;
    }
}

