/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiOrderInfoCancelHisService;
import com.tydic.pfsc.api.busi.bo.BusiOrderInfoCancelHisReqBO;
import com.tydic.pfsc.api.busi.bo.BusiOrderInfoCancelHisRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoItemRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.OrderInfoCancelHisMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.OrderInfoCancelHisPO;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleOrderPayStatus;
import com.tydic.pfsc.enums.SaleOrderPayType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiOrderInfoCancelHisService"})
public class BusiOrderInfoCancelHisServiceImpl
implements BusiOrderInfoCancelHisService {
    private static final Logger log = LoggerFactory.getLogger(BusiOrderInfoCancelHisServiceImpl.class);
    @Autowired
    private OrderInfoCancelHisMapper orderInfoCancelHisMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    @PostMapping(value={"querySaleOrderInfoFromHis"})
    public BusiOrderInfoCancelHisRspBO querySaleOrderInfoFromHis(@RequestBody BusiOrderInfoCancelHisReqBO reqBO) {
        log.info("\u5df2\u53d6\u6d88\u7533\u8bf7\u5355\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)this.toJSONString(reqBO));
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e3a\u7a7a");
        }
        BusiOrderInfoCancelHisRspBO boicHisRspBO = new BusiOrderInfoCancelHisRspBO();
        if (StringUtils.hasText((String)reqBO.getApplyNo())) {
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(reqBO.getApplyNo());
            log.debug("\u5df2\u53d6\u6d88\u7533\u8bf7\u5355\u67e5\u8be2\u3002\u7533\u8bf7\u5355\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)this.toJSONString(billApplyInfo));
            ArrayList<BusiQuerySaleOrderInfoOrderRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
            if (billApplyInfo != null && BillStatus.CANCEL_APPLY.getCode().equals(billApplyInfo.getBillStatus())) {
                Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
                boicHisRspBO.setTotal(Integer.valueOf(1));
                boicHisRspBO.setRecordsTotal(Integer.valueOf(0));
                boicHisRspBO.setPageNo(Integer.valueOf(1));
                List<OrderInfoCancelHisPO> orderInfoCancelHisPOS = this.orderInfoCancelHisMapper.selectByApplyNo(reqBO.getApplyNo(), (Page<Map<String, Object>>)page);
                for (OrderInfoCancelHisPO hisPo : orderInfoCancelHisPOS) {
                    SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.getModelByPrimaryKey(hisPo.getOrderId(), hisPo.getInspectionId());
                    SaleItemInfoVO vo = new SaleItemInfoVO();
                    vo.setInspectionId(saleOrderInfo.getInspectionId());
                    List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
                    ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
                    for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                        BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                        BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                        item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                        item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                        item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                        if (null != saleItemInfo.getSaleUnitPrice()) {
                            item.setSaleUnitPriceStr(saleItemInfo.getSaleUnitPrice().setScale(2, 1).toString());
                        }
                        if (null != saleItemInfo.getAmount()) {
                            item.setAmountStr(saleItemInfo.getAmount().setScale(2, 1).toString());
                        }
                        itemList.add(item);
                    }
                    BusiQuerySaleOrderInfoOrderRspBO order = new BusiQuerySaleOrderInfoOrderRspBO();
                    BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
                    order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
                    order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
                    order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
                    order.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)saleOrderInfo.getSource())));
                    order.setItemInfos(itemList);
                    if (saleOrderInfo.getPayType() != null) {
                        order.setPayTypeStr(SaleOrderPayType.getInstance(saleOrderInfo.getPayType()).getDescr());
                    }
                    if (saleOrderInfo.getPayStatus() != null) {
                        order.setPayStatusStr(SaleOrderPayStatus.getInstance(saleOrderInfo.getPayStatus()).getDescr());
                    }
                    try {
                        order.setPurchaseProjectName(this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                        throw new PfscExtBusinessException("18000", "\u8c03\u7528\u4f1a\u5458\u3010UmcQryEnterpriseAccountDetailAbilityService\u3011\u5f02\u5e38");
                    }
                    orderList.add(order);
                }
                boicHisRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
                boicHisRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
                boicHisRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
                boicHisRspBO.setRows(orderList);
                boicHisRspBO.setRespCode("0000");
                log.debug("\u5df2\u53d6\u6d88\u7533\u8bf7\u5355\u67e5\u8be2\u51fa\u53c2:{}", (Object)this.toJSONString(boicHisRspBO));
                return boicHisRspBO;
            }
            boicHisRspBO.setRespCode("18000");
            boicHisRspBO.setRespDesc("\u4e0d\u662f\u5df2\u53d6\u6d88\u7c7b\u578b");
        } else {
            boicHisRspBO.setRespCode("18000");
            boicHisRspBO.setRespDesc("\u7533\u8bf7\u53f7\u4e3a\u7a7a");
        }
        return boicHisRspBO;
    }

    private <T> String toJSONString(T entity) {
        return JSON.toJSONString(entity, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]);
    }
}

