/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQryNotificationListSelfUseService;
import com.tydic.pfsc.api.busi.bo.BusiQryNotificationListReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQryNotificationListSelfUseReqBO;
import com.tydic.pfsc.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfsc.base.PfscExtRspPageBaseBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.EntryInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.EntryInfoPO;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.PurchaseSaleType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.AntiSqlInjectionManage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQryNotificationListSelfUseService"})
public class BusiQryNotificationListSelfUseServiceImpl
implements BusiQryNotificationListSelfUseService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNotificationListSelfUseServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EntryInfoMapper entryInfoMapper;

    @PostMapping(value={"query"})
    public PfscExtRspPageBaseBO<BillNotificationInfoVO> query(@RequestBody BusiQryNotificationListSelfUseReqBO reqBO) {
        logger.info("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-Session\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setOperUnitNo(null);
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " APPLY_DATE desc,NOTIFICATION_NO desc";
        }
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        LinkedList<BillNotificationInfoVO> result = new LinkedList<BillNotificationInfoVO>();
        try {
            reqBO.setPurchaseSaleType(PurchaseSaleType.SELFUSE.getCode());
            BusiQryNotificationListReqBO billNotifReqBO = new BusiQryNotificationListReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)billNotifReqBO);
            List<BillNotificationInfo> resultPO = this.billNotificationInfoMapper.getListPage(billNotifReqBO, true, (Page<Map<String, Object>>)page, orderBy);
            for (BillNotificationInfo notifyInfo : resultPO) {
                BillNotificationInfoVO resultVO = new BillNotificationInfoVO();
                BeanUtils.copyProperties((Object)notifyInfo, (Object)resultVO);
                resultVO.setNotifInvoiceStatus(notifyInfo.getInvoiceStatus());
                NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(resultVO.getNotifInvoiceStatus());
                resultVO.setNotifInvoiceStatusStr(this.enumsService.getDescr(notifInvoiceEnum));
                String supplierStr = this.organizationInfoService.querySupplierName(resultVO.getSupplierNo());
                resultVO.setSupplierName(supplierStr);
                PurchaseSaleType purchaseSaleTypeEnum = PurchaseSaleType.getInstance(resultVO.getPurchaseSaleType());
                resultVO.setPurchaseSaleTypeStr(this.enumsService.getDescr(purchaseSaleTypeEnum));
                if ("03".equals(notifyInfo.getInvoiceStatus())) {
                    EntryInfoPO entryInfoPO;
                    EntryInfoPO entryInfo = new EntryInfoPO();
                    entryInfo.setNotificationNo(notifyInfo.getNotificationNo());
                    entryInfo.setPurchaseId(notifyInfo.getSupplierNo());
                    List<EntryInfoPO> list = this.entryInfoMapper.getModelListBy(entryInfo);
                    if (list != null && list.size() > 0 && (entryInfoPO = list.get(0)) != null) {
                        resultVO.setSignDate(entryInfoPO.getEntryDate());
                    }
                }
                result.add(resultVO);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
        }
        rspPageBO.setRows(result);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

